/*********************************************************************/
/* from regdef.v by regdef2h auto-generated C-header file            */
/* please see the regdef.html file for detailed register description */
/*********************************************************************/

#ifndef __regdef_NX50_h
#define __regdef_NX50_h


/* ===================================================================== */

/* Area of ARMiTCM_hidden_memarea */

/* ===================================================================== */

#define Addr_NX50_ARMiTCM_hidden_memarea 0x00000000U

/* ===================================================================== */

/* AREA sram0_ahbls0_start4 */
/* Area of sram0_ahbls0_mirror_nitcm */

/* ===================================================================== */

#define Addr_NX50_sram0_ahbls0_mirror_nitcm 0x00000000U

/* --------------------------------------------------------------------- */
/* Register intram0_base_start4 */
/* => internal SRAM AHBL slave 0 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/*    Offset 0x0 is ROM Boot-vector */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram0_base_start4                       0x00000004U
#define Adr_NX50_sram0_ahbls0_mirror_nitcm_intram0_base_start4 0x00000004U
#define Adr_NX50_intram0_base_start4                           0x00000004U

/* --------------------------------------------------------------------- */
/* Register intram0_end_start4 */
/* => internal SRAM AHBL slave 0 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram0_end_start4                       0x00007FFCU
#define Adr_NX50_sram0_ahbls0_mirror_nitcm_intram0_end_start4 0x00007FFCU
#define Adr_NX50_intram0_end_start4                           0x00007FFCU


/* ===================================================================== */

/* Area of iTCM */

/* ===================================================================== */

#define Addr_NX50_iTCM 0x00000000U

/* --------------------------------------------------------------------- */
/* Register iTCM_base */
/* => ARM instruction Tightly Coupled Memory start address */
/*    Area size: 8kB */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_iTCM_base  0x00000000U
#define Adr_NX50_iTCM_iTCM_base 0x00000000U
#define Adr_NX50_iTCM_base      0x00000000U

/* --------------------------------------------------------------------- */
/* Register iTCM_end */
/* => ARM instruction Tightly Coupled Memory end address */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_iTCM_end  0x00001FFCU
#define Adr_NX50_iTCM_iTCM_end 0x00001FFCU
#define Adr_NX50_iTCM_end      0x00001FFCU


/* ===================================================================== */

/* AREA sram1_ahbls1 */
/* Area of sram1_ahbls1_mirror_nitcm, sram1_ahbls1, sram1_ahbls1_mirror_nbuf */

/* ===================================================================== */

#define Addr_NX50_sram1_ahbls1_mirror_nitcm 0x00008000U
#define Addr_NX50_sram1_ahbls1              0x08008000U
#define NX50_NETX_MEM_INTRN_SRAM1_AREA      0x08008000U
#define Addr_NX50_sram1_ahbls1_mirror_nbuf  0x10008000U

/* --------------------------------------------------------------------- */
/* Register intram1_base */
/* => internal SRAM AHBL slave 1 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram1_base                       0x00000000U
#define Adr_NX50_sram1_ahbls1_mirror_nitcm_intram1_base 0x00008000U
#define Adr_NX50_sram1_ahbls1_intram1_base              0x08008000U
#define Adr_NX50_sram1_ahbls1_mirror_nbuf_intram1_base  0x10008000U

/* --------------------------------------------------------------------- */
/* Register intram1_end */
/* => internal SRAM AHBL slave 1 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram1_end                       0x00007FFCU
#define Adr_NX50_sram1_ahbls1_mirror_nitcm_intram1_end 0x0000FFFCU
#define Adr_NX50_sram1_ahbls1_intram1_end              0x0800FFFCU
#define Adr_NX50_sram1_ahbls1_mirror_nbuf_intram1_end  0x1000FFFCU


/* ===================================================================== */

/* AREA sram2_ahbls2 */
/* Area of sram2_ahbls2_mirror_nitcm, sram2_ahbls2, sram2_ahbls2_mirror_nbuf */

/* ===================================================================== */

#define Addr_NX50_sram2_ahbls2_mirror_nitcm 0x00010000U
#define Addr_NX50_sram2_ahbls2              0x08010000U
#define NX50_NETX_MEM_INTRN_SRAM2_AREA      0x08010000U
#define Addr_NX50_sram2_ahbls2_mirror_nbuf  0x10010000U

/* --------------------------------------------------------------------- */
/* Register intram2_base */
/* => internal SRAM AHBL slave 2 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram2_base                       0x00000000U
#define Adr_NX50_sram2_ahbls2_mirror_nitcm_intram2_base 0x00010000U
#define Adr_NX50_sram2_ahbls2_intram2_base              0x08010000U
#define Adr_NX50_sram2_ahbls2_mirror_nbuf_intram2_base  0x10010000U

/* --------------------------------------------------------------------- */
/* Register intram2_end */
/* => internal SRAM AHBL slave 2 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram2_end                       0x00007FFCU
#define Adr_NX50_sram2_ahbls2_mirror_nitcm_intram2_end 0x00017FFCU
#define Adr_NX50_sram2_ahbls2_intram2_end              0x08017FFCU
#define Adr_NX50_sram2_ahbls2_mirror_nbuf_intram2_end  0x10017FFCU


/* ===================================================================== */

/* Area of ahbls4_mirror_nitcm */

/* ===================================================================== */

#define Addr_NX50_ahbls4_mirror_nitcm 0x00200000U

/* ===================================================================== */

/* AREA boot_rom */
/* Area of boot_rom_mirror_nitcm, boot_rom, boot_rom_mirror_nbuf, boot_rom_mirror_hi */

/* ===================================================================== */

#define Addr_NX50_boot_rom_mirror_nitcm 0x00200000U
#define Addr_NX50_boot_rom              0x08200000U
#define NX50_NETX_MEM_BOOT_ROM_AREA     0x08200000U
#define Addr_NX50_boot_rom_mirror_nbuf  0x10200000U
#define Addr_NX50_boot_rom_mirror_hi    0xFF200000U

/* --------------------------------------------------------------------- */
/* Register boot_rom_base */
/* => internal ROM start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    ROM-content will be mirrored any 64kB between 0x00200000 and 0x002ffffc or mirrored AHBL_s4-areas */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_boot_rom_base                   0x00000000U
#define Adr_NX50_boot_rom_mirror_nitcm_boot_rom_base 0x00200000U
#define Adr_NX50_boot_rom_boot_rom_base              0x08200000U
#define Adr_NX50_boot_rom_mirror_nbuf_boot_rom_base  0x10200000U
#define Adr_NX50_boot_rom_mirror_hi_boot_rom_base    0xFF200000U

/* --------------------------------------------------------------------- */
/* Register boot_rom_end */
/* => internal ROM end address */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_boot_rom_end                   0x0000FFFCU
#define Adr_NX50_boot_rom_mirror_nitcm_boot_rom_end 0x0020FFFCU
#define Adr_NX50_boot_rom_boot_rom_end              0x0820FFFCU
#define Adr_NX50_boot_rom_mirror_nbuf_boot_rom_end  0x1020FFFCU
#define Adr_NX50_boot_rom_mirror_hi_boot_rom_end    0xFF20FFFCU


/* ===================================================================== */

/* Area of ARMdTCM_hidden_memarea */

/* ===================================================================== */

#define Addr_NX50_ARMdTCM_hidden_memarea 0x04000000U

/* ===================================================================== */

/* Area of dTCM */

/* ===================================================================== */

#define Addr_NX50_dTCM              0x04000000U
#define NX50_NETX_MEM_DATA_TCM_AREA 0x04000000U

/* --------------------------------------------------------------------- */
/* Register dTCM_base */
/* => ARM data Tightly Coupled Memory start address */
/*    Area size: 8kB */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dTCM_base  0x00000000U
#define Adr_NX50_dTCM_dTCM_base 0x04000000U
#define Adr_NX50_dTCM_base      0x04000000U

/* --------------------------------------------------------------------- */
/* Register dTCM_end */
/* => ARM data Tightly Coupled Memory end address */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dTCM_end  0x00001FFCU
#define Adr_NX50_dTCM_dTCM_end 0x04001FFCU
#define Adr_NX50_dTCM_end      0x04001FFCU


/* ===================================================================== */

/* Area of ARM_buf_memarea */

/* ===================================================================== */

#define Addr_NX50_ARM_buf_memarea 0x08000000U

/* ===================================================================== */

/* AREA sram0_ahbls0 */
/* Area of sram0_ahbls0, sram0_ahbls0_mirror_nbuf */

/* ===================================================================== */

#define Addr_NX50_sram0_ahbls0             0x08000000U
#define NX50_NETX_MEM_INTRN_SRAM0_AREA     0x08000000U
#define Addr_NX50_sram0_ahbls0_mirror_nbuf 0x10000000U

/* --------------------------------------------------------------------- */
/* Register intram0_base */
/* => internal SRAM AHBL slave 0 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/*    Offset 0x0 is ROM Boot-vector */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram0_base                      0x00000000U
#define Adr_NX50_sram0_ahbls0_intram0_base             0x08000000U
#define Adr_NX50_sram0_ahbls0_mirror_nbuf_intram0_base 0x10000000U

/* --------------------------------------------------------------------- */
/* Register intram0_end */
/* => internal SRAM AHBL slave 0 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_intram0_end                      0x00007FFCU
#define Adr_NX50_sram0_ahbls0_intram0_end             0x08007FFCU
#define Adr_NX50_sram0_ahbls0_mirror_nbuf_intram0_end 0x10007FFCU


/* ===================================================================== */

/* Area of ahbls4 */

/* ===================================================================== */

#define Addr_NX50_ahbls4 0x08200000U

/* ===================================================================== */

/* Area of intlogic_ahbls5_mirror_buf */

/* ===================================================================== */

#define Addr_NX50_intlogic_ahbls5_mirror_buf 0x0C000000U

/* ===================================================================== */

/* Area of ARM_nbuf_memarea */

/* ===================================================================== */

#define Addr_NX50_ARM_nbuf_memarea 0x10000000U

/* ===================================================================== */

/* Area of ahbls4_mirror_nbuf */

/* ===================================================================== */

#define Addr_NX50_ahbls4_mirror_nbuf 0x10200000U

/* ===================================================================== */

/* Area of ARM_nbuf_regarea */

/* ===================================================================== */

#define Addr_NX50_ARM_nbuf_regarea 0x18000000U

/* ===================================================================== */

/* Area of intlogic_ahbls5 */

/* ===================================================================== */

#define Addr_NX50_intlogic_ahbls5 0x1C000000U

/* ===================================================================== */

/* Area of asic_ctrl */

/* ===================================================================== */

#define Addr_NX50_asic_ctrl 0x1C000000U
#define NX50_NETX_CTRL_AREA 0x1C000000U

/* --------------------------------------------------------------------- */
/* Register io_status */
/* => Bondout Out Option Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_status       0x00000000U
#define Adr_NX50_asic_ctrl_io_status 0x1C000000U
#define Adr_NX50_io_status           0x1C000000U

#define MSK_NX50_io_status_bond_option     0x00000007U
#define SRT_NX50_io_status_bond_option     0
#define MSK_NX50_io_status_quick_count     0x00000008U
#define SRT_NX50_io_status_quick_count     3
#define MSK_NX50_io_status_arm100          0x00000010U
#define SRT_NX50_io_status_arm100          4
#define MSK_NX50_io_status_pll_bypass      0x00000020U
#define SRT_NX50_io_status_pll_bypass      5
#define MSK_NX50_io_status_arm_crashdetect 0x00000040U
#define SRT_NX50_io_status_arm_crashdetect 6
#define MSK_NX50_io_status_TEST            0x00000080U
#define SRT_NX50_io_status_TEST            7

enum {
	BFW_NX50_io_status_bond_option     = 3,  /* [2:0] */
	BFW_NX50_io_status_quick_count     = 1,  /* [3] */
	BFW_NX50_io_status_arm100          = 1,  /* [4] */
	BFW_NX50_io_status_pll_bypass      = 1,  /* [5] */
	BFW_NX50_io_status_arm_crashdetect = 1,  /* [6] */
	BFW_NX50_io_status_TEST            = 1,  /* [7] */
	BFW_NX50_io_status_reserved1       = 24  /* [31:8] */
};

typedef struct NX50_IO_STATUS_BIT_Ttag {
	unsigned int bond_option     : BFW_NX50_io_status_bond_option;     /* fixed to 3'b111 in netX50                                                                                              */
	unsigned int quick_count     : BFW_NX50_io_status_quick_count;     /* Testmode 'quick_count' is activated by external pins                                                                   */
	                                                                   /* -> diverse internal counters count faster (RTC-clock-divider, PLL-stby-controller,...)                                 */
	unsigned int arm100          : BFW_NX50_io_status_arm100;          /* Testmode 'arm100' is activated by external pins                                                                        */
	                                                                   /* -> ARM926 runs on system frequency (100MHz) instead of double system frequency (200MHz)                                */
	unsigned int pll_bypass      : BFW_NX50_io_status_pll_bypass;      /* Testmode 'pll_bypass' is activated by external pins                                                                    */
	                                                                   /* -> 400MHz-PLL is bypassed, PLL output is unused, 400MHz-Clocks (clk400, clk400_2sdram) is directly connected to XTALIN */
	unsigned int arm_crashdetect : BFW_NX50_io_status_arm_crashdetect; /* arm_crashdetect_cpclken (netX50 only). For HSoCT Simulation purpose only!!!                                            */
	unsigned int TEST            : BFW_NX50_io_status_TEST;            /* sampled netx TEST input for Productiontest purpose                                                                     */
	unsigned int reserved1       : BFW_NX50_io_status_reserved1;       /* reserved                                                                                                               */
} NX50_IO_STATUS_BIT_T;

typedef union {
	unsigned int         val;
	NX50_IO_STATUS_BIT_T bf;
} NX50_IO_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register io_config */
/* => IO Config Register: */
/*    Selects of output pin multiplexing. */
/*    See Excel pinning sheet for details. */
/*    Selects can only be activated, if appropriate bit of io_config_mask is set. */
/*    Bits will be reset according to the io_config_mask-register register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_config       0x00000004U
#define Adr_NX50_asic_ctrl_io_config 0x1C000004U
#define Adr_NX50_io_config           0x1C000004U
#define DFLT_VAL_NX50_io_config      0x00000000U

#define MSK_NX50_io_config_sel_xm0_tx         0x00000001U
#define SRT_NX50_io_config_sel_xm0_tx         0
#define DFLT_VAL_NX50_io_config_sel_xm0_tx    0x00000000U
#define MSK_NX50_io_config_sel_xm1_tx         0x00000002U
#define SRT_NX50_io_config_sel_xm1_tx         1
#define DFLT_VAL_NX50_io_config_sel_xm1_tx    0x00000000U
#define MSK_NX50_io_config_sel_fb0_clk_a      0x00000004U
#define SRT_NX50_io_config_sel_fb0_clk_a      2
#define DFLT_VAL_NX50_io_config_sel_fb0_clk_a 0x00000000U
#define MSK_NX50_io_config_sel_fb0_clk_b      0x00000008U
#define SRT_NX50_io_config_sel_fb0_clk_b      3
#define DFLT_VAL_NX50_io_config_sel_fb0_clk_b 0x00000000U
#define MSK_NX50_io_config_sel_fb1_clk_a      0x00000010U
#define SRT_NX50_io_config_sel_fb1_clk_a      4
#define DFLT_VAL_NX50_io_config_sel_fb1_clk_a 0x00000000U
#define MSK_NX50_io_config_sel_fb1_clk_b      0x00000020U
#define SRT_NX50_io_config_sel_fb1_clk_b      5
#define DFLT_VAL_NX50_io_config_sel_fb1_clk_b 0x00000000U
#define MSK_NX50_io_config_sel_fo0            0x00000040U
#define SRT_NX50_io_config_sel_fo0            6
#define DFLT_VAL_NX50_io_config_sel_fo0       0x00000000U
#define MSK_NX50_io_config_sel_fo1            0x00000080U
#define SRT_NX50_io_config_sel_fo1            7
#define DFLT_VAL_NX50_io_config_sel_fo1       0x00000000U
#define MSK_NX50_io_config_sel_xm0_eclk       0x00000100U
#define SRT_NX50_io_config_sel_xm0_eclk       8
#define DFLT_VAL_NX50_io_config_sel_xm0_eclk  0x00000000U
#define MSK_NX50_io_config_sel_xm1_eclk       0x00000200U
#define SRT_NX50_io_config_sel_xm1_eclk       9
#define DFLT_VAL_NX50_io_config_sel_xm1_eclk  0x00000000U
#define MSK_NX50_io_config_sel_i2c_mmio       0x00000400U
#define SRT_NX50_io_config_sel_i2c_mmio       10
#define DFLT_VAL_NX50_io_config_sel_i2c_mmio  0x00000000U
#define MSK_NX50_io_config_sel_etm            0x00800000U
#define SRT_NX50_io_config_sel_etm            23
#define DFLT_VAL_NX50_io_config_sel_etm       0x00000000U
#define MSK_NX50_io_config_sel_ext_phy0       0x20000000U
#define SRT_NX50_io_config_sel_ext_phy0       29
#define DFLT_VAL_NX50_io_config_sel_ext_phy0  0x00000000U
#define MSK_NX50_io_config_sel_ext_phy1       0x40000000U
#define SRT_NX50_io_config_sel_ext_phy1       30
#define DFLT_VAL_NX50_io_config_sel_ext_phy1  0x00000000U
#define MSK_NX50_io_config_if_select_n        0x80000000U
#define SRT_NX50_io_config_if_select_n        31
#define DFLT_VAL_NX50_io_config_if_select_n   0x00000000U

enum {
	BFW_NX50_io_config_sel_xm0_tx    = 1,  /* [0] */
	BFW_NX50_io_config_sel_xm1_tx    = 1,  /* [1] */
	BFW_NX50_io_config_sel_fb0_clk_a = 1,  /* [2] */
	BFW_NX50_io_config_sel_fb0_clk_b = 1,  /* [3] */
	BFW_NX50_io_config_sel_fb1_clk_a = 1,  /* [4] */
	BFW_NX50_io_config_sel_fb1_clk_b = 1,  /* [5] */
	BFW_NX50_io_config_sel_fo0       = 1,  /* [6] */
	BFW_NX50_io_config_sel_fo1       = 1,  /* [7] */
	BFW_NX50_io_config_sel_xm0_eclk  = 1,  /* [8] */
	BFW_NX50_io_config_sel_xm1_eclk  = 1,  /* [9] */
	BFW_NX50_io_config_sel_i2c_mmio  = 1,  /* [10] */
	BFW_NX50_io_config_reserved1     = 12, /* [22:11] */
	BFW_NX50_io_config_sel_etm       = 1,  /* [23] */
	BFW_NX50_io_config_reserved2     = 5,  /* [28:24] */
	BFW_NX50_io_config_sel_ext_phy0  = 1,  /* [29] */
	BFW_NX50_io_config_sel_ext_phy1  = 1,  /* [30] */
	BFW_NX50_io_config_if_select_n   = 1   /* [31] */
};

typedef struct NX50_IO_CONFIG_BIT_Ttag {
	unsigned int sel_xm0_tx    : BFW_NX50_io_config_sel_xm0_tx;    /* select pad for xMAC0 tx-bitstream direct output (s. pinning table) */
	unsigned int sel_xm1_tx    : BFW_NX50_io_config_sel_xm1_tx;    /* select pad for xMAC1 tx-bitstream direct output (s. pinning table) */
	unsigned int sel_fb0_clk_a : BFW_NX50_io_config_sel_fb0_clk_a; /* select pad for fieldbus-clk0 at position a (s. pinning table)      */
	unsigned int sel_fb0_clk_b : BFW_NX50_io_config_sel_fb0_clk_b; /* select pad for fieldbus-clk0 at position b (s. pinning table)      */
	unsigned int sel_fb1_clk_a : BFW_NX50_io_config_sel_fb1_clk_a; /* select pad for fieldbus-clk1 at position a (s. pinning table)      */
	unsigned int sel_fb1_clk_b : BFW_NX50_io_config_sel_fb1_clk_b; /* select pad for fieldbus-clk1 at position b (s. pinning table)      */
	unsigned int sel_fo0       : BFW_NX50_io_config_sel_fo0;       /* select Fiber Optics of PHY0:                                       */
	                                                               /* 1: use Fiber Optics of PHY0                                        */
	unsigned int sel_fo1       : BFW_NX50_io_config_sel_fo1;       /* select Fiber Optics of PHY1:                                       */
	                                                               /* 1: use Fiber Optics of PHY1                                        */
	unsigned int sel_xm0_eclk  : BFW_NX50_io_config_sel_xm0_eclk;  /* select pad for xMAC0 eclk (s. pinning table)                       */
	unsigned int sel_xm1_eclk  : BFW_NX50_io_config_sel_xm1_eclk;  /* select pad for xMAC1 eclk (s. pinning table)                       */
	unsigned int sel_i2c_mmio  : BFW_NX50_io_config_sel_i2c_mmio;  /* select pads for I2C                                                */
	                                                               /* 1: use I2C via MMIO pads (s. mmio table)                           */
	unsigned int reserved1     : BFW_NX50_io_config_reserved1;     /* reserved                                                           */
	unsigned int sel_etm       : BFW_NX50_io_config_sel_etm;       /* select pins for ETM9 (s. pinning table)                            */
	unsigned int reserved2     : BFW_NX50_io_config_reserved2;     /* reserved                                                           */
	unsigned int sel_ext_phy0  : BFW_NX50_io_config_sel_ext_phy0;  /* external/internal PHY0 select:                                     */
	                                                               /* 1: use external PHY instead of internal PHY0 (s. mmio table)       */
	unsigned int sel_ext_phy1  : BFW_NX50_io_config_sel_ext_phy1;  /* external/internal PHY1 select:                                     */
	                                                               /* 1: use external PHY instead of internal PHY1 (s. mmio table)       */
	unsigned int if_select_n   : BFW_NX50_io_config_if_select_n;   /* inverted HIF interace-select signal:                               */
	                                                               /* 1: PCI-Mode                                                        */
} NX50_IO_CONFIG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_IO_CONFIG_BIT_T bf;
} NX50_IO_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register io_config_mask */
/* => IO Config Mask Register: */
/*    The IO_CFG_MASK register might be used to lock special IO configurations for restricted netX devices. \ */
/*    Any bit of the IO_CFG register can only be set, if the corresponding mask bit in the IO_CFG_MSK register is set either. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    The io_config-register will change according to this register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_config_mask       0x00000008U
#define Adr_NX50_asic_ctrl_io_config_mask 0x1C000008U
#define Adr_NX50_io_config_mask           0x1C000008U
#define DFLT_VAL_NX50_io_config_mask      0xe08007ffU

#define MSK_NX50_io_config_mask_sel_xm0_tx         0x00000001U
#define SRT_NX50_io_config_mask_sel_xm0_tx         0
#define DFLT_VAL_NX50_io_config_mask_sel_xm0_tx    0x00000001U
#define MSK_NX50_io_config_mask_sel_xm1_tx         0x00000002U
#define SRT_NX50_io_config_mask_sel_xm1_tx         1
#define DFLT_VAL_NX50_io_config_mask_sel_xm1_tx    0x00000002U
#define MSK_NX50_io_config_mask_sel_fb0_clk_a      0x00000004U
#define SRT_NX50_io_config_mask_sel_fb0_clk_a      2
#define DFLT_VAL_NX50_io_config_mask_sel_fb0_clk_a 0x00000004U
#define MSK_NX50_io_config_mask_sel_fb0_clk_b      0x00000008U
#define SRT_NX50_io_config_mask_sel_fb0_clk_b      3
#define DFLT_VAL_NX50_io_config_mask_sel_fb0_clk_b 0x00000008U
#define MSK_NX50_io_config_mask_sel_fb1_clk_a      0x00000010U
#define SRT_NX50_io_config_mask_sel_fb1_clk_a      4
#define DFLT_VAL_NX50_io_config_mask_sel_fb1_clk_a 0x00000010U
#define MSK_NX50_io_config_mask_sel_fb1_clk_b      0x00000020U
#define SRT_NX50_io_config_mask_sel_fb1_clk_b      5
#define DFLT_VAL_NX50_io_config_mask_sel_fb1_clk_b 0x00000020U
#define MSK_NX50_io_config_mask_sel_fo0            0x00000040U
#define SRT_NX50_io_config_mask_sel_fo0            6
#define DFLT_VAL_NX50_io_config_mask_sel_fo0       0x00000040U
#define MSK_NX50_io_config_mask_sel_fo1            0x00000080U
#define SRT_NX50_io_config_mask_sel_fo1            7
#define DFLT_VAL_NX50_io_config_mask_sel_fo1       0x00000080U
#define MSK_NX50_io_config_mask_sel_xm0_eclk       0x00000100U
#define SRT_NX50_io_config_mask_sel_xm0_eclk       8
#define DFLT_VAL_NX50_io_config_mask_sel_xm0_eclk  0x00000100U
#define MSK_NX50_io_config_mask_sel_xm1_eclk       0x00000200U
#define SRT_NX50_io_config_mask_sel_xm1_eclk       9
#define DFLT_VAL_NX50_io_config_mask_sel_xm1_eclk  0x00000200U
#define MSK_NX50_io_config_mask_sel_i2c_mmio       0x00000400U
#define SRT_NX50_io_config_mask_sel_i2c_mmio       10
#define DFLT_VAL_NX50_io_config_mask_sel_i2c_mmio  0x00000400U
#define MSK_NX50_io_config_mask_sel_etm            0x00800000U
#define SRT_NX50_io_config_mask_sel_etm            23
#define DFLT_VAL_NX50_io_config_mask_sel_etm       0x00800000U
#define MSK_NX50_io_config_mask_sel_ext_phy0       0x20000000U
#define SRT_NX50_io_config_mask_sel_ext_phy0       29
#define DFLT_VAL_NX50_io_config_mask_sel_ext_phy0  0x20000000U
#define MSK_NX50_io_config_mask_sel_ext_phy1       0x40000000U
#define SRT_NX50_io_config_mask_sel_ext_phy1       30
#define DFLT_VAL_NX50_io_config_mask_sel_ext_phy1  0x40000000U
#define MSK_NX50_io_config_mask_if_select_n        0x80000000U
#define SRT_NX50_io_config_mask_if_select_n        31
#define DFLT_VAL_NX50_io_config_mask_if_select_n   0x80000000U

enum {
	BFW_NX50_io_config_mask_sel_xm0_tx    = 1,  /* [0] */
	BFW_NX50_io_config_mask_sel_xm1_tx    = 1,  /* [1] */
	BFW_NX50_io_config_mask_sel_fb0_clk_a = 1,  /* [2] */
	BFW_NX50_io_config_mask_sel_fb0_clk_b = 1,  /* [3] */
	BFW_NX50_io_config_mask_sel_fb1_clk_a = 1,  /* [4] */
	BFW_NX50_io_config_mask_sel_fb1_clk_b = 1,  /* [5] */
	BFW_NX50_io_config_mask_sel_fo0       = 1,  /* [6] */
	BFW_NX50_io_config_mask_sel_fo1       = 1,  /* [7] */
	BFW_NX50_io_config_mask_sel_xm0_eclk  = 1,  /* [8] */
	BFW_NX50_io_config_mask_sel_xm1_eclk  = 1,  /* [9] */
	BFW_NX50_io_config_mask_sel_i2c_mmio  = 1,  /* [10] */
	BFW_NX50_io_config_mask_reserved1     = 12, /* [22:11] */
	BFW_NX50_io_config_mask_sel_etm       = 1,  /* [23] */
	BFW_NX50_io_config_mask_reserved2     = 5,  /* [28:24] */
	BFW_NX50_io_config_mask_sel_ext_phy0  = 1,  /* [29] */
	BFW_NX50_io_config_mask_sel_ext_phy1  = 1,  /* [30] */
	BFW_NX50_io_config_mask_if_select_n   = 1   /* [31] */
};

typedef struct NX50_IO_CONFIG_MASK_BIT_Ttag {
	unsigned int sel_xm0_tx    : BFW_NX50_io_config_mask_sel_xm0_tx;    /* mask of select pad for xMAC0 tx-bitstream direct output (s. pinning.xls) */
	unsigned int sel_xm1_tx    : BFW_NX50_io_config_mask_sel_xm1_tx;    /* mask of select pad for xMAC1 tx-bitstream direct output (s. pinning.xls) */
	unsigned int sel_fb0_clk_a : BFW_NX50_io_config_mask_sel_fb0_clk_a; /* mask of select pad for fieldbus-clk0 at position a (s. pinning.xls)      */
	unsigned int sel_fb0_clk_b : BFW_NX50_io_config_mask_sel_fb0_clk_b; /* mask of select pad for fieldbus-clk0 at position b (s. pinning.xls)      */
	unsigned int sel_fb1_clk_a : BFW_NX50_io_config_mask_sel_fb1_clk_a; /* mask of select pad for fieldbus-clk1 at position a (s. pinning.xls)      */
	unsigned int sel_fb1_clk_b : BFW_NX50_io_config_mask_sel_fb1_clk_b; /* mask of select pad for fieldbus-clk1 at position b (s. pinning.xls)      */
	unsigned int sel_fo0       : BFW_NX50_io_config_mask_sel_fo0;       /* mask of select outputs for Fiber Optics of PHY0                          */
	unsigned int sel_fo1       : BFW_NX50_io_config_mask_sel_fo1;       /* mask of select outputs for Fiber Optics of PHY1                          */
	unsigned int sel_xm0_eclk  : BFW_NX50_io_config_mask_sel_xm0_eclk;  /* mask of select pad for xMAC0 eclk (s. pinning.xls)                       */
	unsigned int sel_xm1_eclk  : BFW_NX50_io_config_mask_sel_xm1_eclk;  /* mask of select pad for xMAC1 eclk (s. pinning.xls)                       */
	unsigned int sel_i2c_mmio  : BFW_NX50_io_config_mask_sel_i2c_mmio;  /* mask of select I2C via MMIOs instead of dedicated I2C_SDA/I2C_SCL-pads   */
	unsigned int reserved1     : BFW_NX50_io_config_mask_reserved1;     /* reserved                                                                 */
	unsigned int sel_etm       : BFW_NX50_io_config_mask_sel_etm;       /* mask of select pins for ETM9 of ARM926                                   */
	unsigned int reserved2     : BFW_NX50_io_config_mask_reserved2;     /* reserved                                                                 */
	unsigned int sel_ext_phy0  : BFW_NX50_io_config_mask_sel_ext_phy0;  /* mask of select external instead of internal PHY0                         */
	unsigned int sel_ext_phy1  : BFW_NX50_io_config_mask_sel_ext_phy1;  /* mask of select external instead of internal PHY1                         */
	unsigned int if_select_n   : BFW_NX50_io_config_mask_if_select_n;   /* mask of inverted HIF if-select signal:                                   */
} NX50_IO_CONFIG_MASK_BIT_T;

typedef union {
	unsigned int              val;
	NX50_IO_CONFIG_MASK_BIT_T bf;
} NX50_IO_CONFIG_MASK_T;

/* --------------------------------------------------------------------- */
/* Register reset_ctrl */
/* => Reset Control Register: */
/*    This register controls the reset functions of the netX chip and indicates the reset state. The reset state */
/*    shows which resets have occurred, allowing the firmware to detect which resets were active. In order to */
/*    determine the source of the last reset, the firmware should evaluate and reset these bits during its start */
/*    sequence. After a power on reset, the RESET_CTRL register is cleared completely. */
/*     */
/*    This register is NOT protected by the netX access key mechanism yet. To keep software compatible */
/*    for later netX versions, read-write-accesskey-procedure should be done before accessing this register anyhow as followed: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/*    It is recomended to dummy-read another ASIC_CTRL-register (e.g. io_status) to avoid this address area being unprotected after */
/*    read-write-accesskey-procedure was done for reset_ctrl-register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_reset_ctrl       0x0000000CU
#define Adr_NX50_asic_ctrl_reset_ctrl 0x1C00000CU
#define Adr_NX50_reset_ctrl           0x1C00000CU
#define DFLT_VAL_NX50_reset_ctrl      0x00000000U

#define MSK_NX50_reset_ctrl_RES_IN                0x00000001U
#define SRT_NX50_reset_ctrl_RES_IN                0
#define DFLT_VAL_NX50_reset_ctrl_RES_IN           0x00000000U
#define MSK_NX50_reset_ctrl_RES_WDOG              0x00000002U
#define SRT_NX50_reset_ctrl_RES_WDOG              1
#define DFLT_VAL_NX50_reset_ctrl_RES_WDOG         0x00000000U
#define MSK_NX50_reset_ctrl_RES_HOST              0x00000004U
#define SRT_NX50_reset_ctrl_RES_HOST              2
#define DFLT_VAL_NX50_reset_ctrl_RES_HOST         0x00000000U
#define MSK_NX50_reset_ctrl_RES_FIRMWARE          0x00000008U
#define SRT_NX50_reset_ctrl_RES_FIRMWARE          3
#define DFLT_VAL_NX50_reset_ctrl_RES_FIRMWARE     0x00000000U
#define MSK_NX50_reset_ctrl_RES_XPEC0             0x00000010U
#define SRT_NX50_reset_ctrl_RES_XPEC0             4
#define DFLT_VAL_NX50_reset_ctrl_RES_XPEC0        0x00000000U
#define MSK_NX50_reset_ctrl_RES_XPEC1             0x00000020U
#define SRT_NX50_reset_ctrl_RES_XPEC1             5
#define DFLT_VAL_NX50_reset_ctrl_RES_XPEC1        0x00000000U
#define MSK_NX50_reset_ctrl_DIS_RES_XPEC0         0x00010000U
#define SRT_NX50_reset_ctrl_DIS_RES_XPEC0         16
#define DFLT_VAL_NX50_reset_ctrl_DIS_RES_XPEC0    0x00000000U
#define MSK_NX50_reset_ctrl_DIS_RES_XPEC1         0x00020000U
#define SRT_NX50_reset_ctrl_DIS_RES_XPEC1         17
#define DFLT_VAL_NX50_reset_ctrl_DIS_RES_XPEC1    0x00000000U
#define MSK_NX50_reset_ctrl_FIRMWARE_STATUS0      0x00100000U
#define SRT_NX50_reset_ctrl_FIRMWARE_STATUS0      20
#define DFLT_VAL_NX50_reset_ctrl_FIRMWARE_STATUS0 0x00000000U
#define MSK_NX50_reset_ctrl_FIRMWARE_STATUS1      0x00200000U
#define SRT_NX50_reset_ctrl_FIRMWARE_STATUS1      21
#define DFLT_VAL_NX50_reset_ctrl_FIRMWARE_STATUS1 0x00000000U
#define MSK_NX50_reset_ctrl_FIRMWARE_STATUS2      0x00400000U
#define SRT_NX50_reset_ctrl_FIRMWARE_STATUS2      22
#define DFLT_VAL_NX50_reset_ctrl_FIRMWARE_STATUS2 0x00000000U
#define MSK_NX50_reset_ctrl_FIRMWARE_STATUS3      0x00800000U
#define SRT_NX50_reset_ctrl_FIRMWARE_STATUS3      23
#define DFLT_VAL_NX50_reset_ctrl_FIRMWARE_STATUS3 0x00000000U
#define MSK_NX50_reset_ctrl_RES_REQ_FIRMWARE      0x01000000U
#define SRT_NX50_reset_ctrl_RES_REQ_FIRMWARE      24
#define DFLT_VAL_NX50_reset_ctrl_RES_REQ_FIRMWARE 0x00000000U
#define MSK_NX50_reset_ctrl_RES_REQ_OUT           0x02000000U
#define SRT_NX50_reset_ctrl_RES_REQ_OUT           25
#define DFLT_VAL_NX50_reset_ctrl_RES_REQ_OUT      0x00000000U
#define MSK_NX50_reset_ctrl_EN_RES_REQ_OUT        0x04000000U
#define SRT_NX50_reset_ctrl_EN_RES_REQ_OUT        26
#define DFLT_VAL_NX50_reset_ctrl_EN_RES_REQ_OUT   0x00000000U

enum {
	BFW_NX50_reset_ctrl_RES_IN           = 1,  /* [0] */
	BFW_NX50_reset_ctrl_RES_WDOG         = 1,  /* [1] */
	BFW_NX50_reset_ctrl_RES_HOST         = 1,  /* [2] */
	BFW_NX50_reset_ctrl_RES_FIRMWARE     = 1,  /* [3] */
	BFW_NX50_reset_ctrl_RES_XPEC0        = 1,  /* [4] */
	BFW_NX50_reset_ctrl_RES_XPEC1        = 1,  /* [5] */
	BFW_NX50_reset_ctrl_reserved1        = 10, /* [15:6] */
	BFW_NX50_reset_ctrl_DIS_RES_XPEC0    = 1,  /* [16] */
	BFW_NX50_reset_ctrl_DIS_RES_XPEC1    = 1,  /* [17] */
	BFW_NX50_reset_ctrl_reserved2        = 2,  /* [19:18] */
	BFW_NX50_reset_ctrl_FIRMWARE_STATUS0 = 1,  /* [20] */
	BFW_NX50_reset_ctrl_FIRMWARE_STATUS1 = 1,  /* [21] */
	BFW_NX50_reset_ctrl_FIRMWARE_STATUS2 = 1,  /* [22] */
	BFW_NX50_reset_ctrl_FIRMWARE_STATUS3 = 1,  /* [23] */
	BFW_NX50_reset_ctrl_RES_REQ_FIRMWARE = 1,  /* [24] */
	BFW_NX50_reset_ctrl_RES_REQ_OUT      = 1,  /* [25] */
	BFW_NX50_reset_ctrl_EN_RES_REQ_OUT   = 1,  /* [26] */
	BFW_NX50_reset_ctrl_reserved3        = 5   /* [31:27] */
};

typedef struct NX50_RESET_CTRL_BIT_Ttag {
	unsigned int RES_IN           : BFW_NX50_reset_ctrl_RES_IN;           /* reset from external pin, after reading write back a "1" to clear the status bit                 */
	unsigned int RES_WDOG         : BFW_NX50_reset_ctrl_RES_WDOG;         /* reset from System WDG, after reading write back a "1" to clear the status bit                   */
	unsigned int RES_HOST         : BFW_NX50_reset_ctrl_RES_HOST;         /* reset from Hostinterface, after reading write back a "1" to clear the status bit                */
	unsigned int RES_FIRMWARE     : BFW_NX50_reset_ctrl_RES_FIRMWARE;     /* reset from FIRMWARE (software reset), after reading write back a "1" to clear the status bit    */
	unsigned int RES_XPEC0        : BFW_NX50_reset_ctrl_RES_XPEC0;        /* reset from RES_XPEC0, after reading write back a "1" to clear the status bit                    */
	unsigned int RES_XPEC1        : BFW_NX50_reset_ctrl_RES_XPEC1;        /* reset from RES_XPEC1, after reading write back a "1" to clear the status bit                    */
	unsigned int reserved1        : BFW_NX50_reset_ctrl_reserved1;        /* reserved                                                                                        */
	unsigned int DIS_RES_XPEC0    : BFW_NX50_reset_ctrl_DIS_RES_XPEC0;    /* reset from RES_XPEC0 is disabled (read only)                                                    */
	unsigned int DIS_RES_XPEC1    : BFW_NX50_reset_ctrl_DIS_RES_XPEC1;    /* reset from RES_XPEC1 is disabled (read only)                                                    */
	unsigned int reserved2        : BFW_NX50_reset_ctrl_reserved2;        /* reserved                                                                                        */
	unsigned int FIRMWARE_STATUS0 : BFW_NX50_reset_ctrl_FIRMWARE_STATUS0; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS1 : BFW_NX50_reset_ctrl_FIRMWARE_STATUS1; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS2 : BFW_NX50_reset_ctrl_FIRMWARE_STATUS2; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS3 : BFW_NX50_reset_ctrl_FIRMWARE_STATUS3; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int RES_REQ_FIRMWARE : BFW_NX50_reset_ctrl_RES_REQ_FIRMWARE; /* (software reset) writing a "1" sets the reset request to reset the whole system (write only)    */
	unsigned int RES_REQ_OUT      : BFW_NX50_reset_ctrl_RES_REQ_OUT;      /* (software reset) programmable reset sets the reset on the external pin                          */
	unsigned int EN_RES_REQ_OUT   : BFW_NX50_reset_ctrl_EN_RES_REQ_OUT;   /* this bit enables the programmable reset                                                         */
	unsigned int reserved3        : BFW_NX50_reset_ctrl_reserved3;        /* reserved                                                                                        */
} NX50_RESET_CTRL_BIT_T;

typedef union {
	unsigned int          val;
	NX50_RESET_CTRL_BIT_T bf;
} NX50_RESET_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register phy_control */
/* => PHY Control Register: */
/*    This register contains all static connectors of the NEC Ethernet PHY. \ */
/*    Usually the PHY reads these values only during reset, which can be controlled by Bit31. \ */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/*    In total the programming sequence should be: */
/*     */
/*    a: read access key, write access key, write new value with bit phy_reset=1 */
/*    b: wait for proper reset of PHY(~100s) */
/*    c: read access key, write access key, write new value with bit phy_reset=0 */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_phy_control       0x00000010U
#define Adr_NX50_asic_ctrl_phy_control 0x1C000010U
#define Adr_NX50_phy_control           0x1C000010U
#define DFLT_VAL_NX50_phy_control      0x0000c060U

#define MSK_NX50_phy_control_phy_address           0x0000000fU
#define SRT_NX50_phy_control_phy_address           0
#define DFLT_VAL_NX50_phy_control_phy_address      0x00000000U
#define MSK_NX50_phy_control_phy0_mode             0x00000070U
#define SRT_NX50_phy_control_phy0_mode             4
#define DFLT_VAL_NX50_phy_control_phy0_mode        0x00000060U
#define MSK_NX50_phy_control_phy0_fxmode           0x00000080U
#define SRT_NX50_phy_control_phy0_fxmode           7
#define DFLT_VAL_NX50_phy_control_phy0_fxmode      0x00000000U
#define MSK_NX50_phy_control_phy0_automdix         0x00000100U
#define SRT_NX50_phy_control_phy0_automdix         8
#define DFLT_VAL_NX50_phy_control_phy0_automdix    0x00000000U
#define MSK_NX50_phy_control_phy0_np_msg_code      0x00000e00U
#define SRT_NX50_phy_control_phy0_np_msg_code      9
#define DFLT_VAL_NX50_phy_control_phy0_np_msg_code 0x00000000U
#define MSK_NX50_phy_control_phy0_enable           0x00001000U
#define SRT_NX50_phy_control_phy0_enable           12
#define DFLT_VAL_NX50_phy_control_phy0_enable      0x00000000U
#define MSK_NX50_phy_control_phy1_mode             0x0000e000U
#define SRT_NX50_phy_control_phy1_mode             13
#define DFLT_VAL_NX50_phy_control_phy1_mode        0x0000c000U
#define MSK_NX50_phy_control_phy1_fxmode           0x00010000U
#define SRT_NX50_phy_control_phy1_fxmode           16
#define DFLT_VAL_NX50_phy_control_phy1_fxmode      0x00000000U
#define MSK_NX50_phy_control_phy1_automdix         0x00020000U
#define SRT_NX50_phy_control_phy1_automdix         17
#define DFLT_VAL_NX50_phy_control_phy1_automdix    0x00000000U
#define MSK_NX50_phy_control_phy1_np_msg_code      0x001c0000U
#define SRT_NX50_phy_control_phy1_np_msg_code      18
#define DFLT_VAL_NX50_phy_control_phy1_np_msg_code 0x00000000U
#define MSK_NX50_phy_control_phy1_enable           0x00200000U
#define SRT_NX50_phy_control_phy1_enable           21
#define DFLT_VAL_NX50_phy_control_phy1_enable      0x00000000U
#define MSK_NX50_phy_control_phy_sim_byp           0x40000000U
#define SRT_NX50_phy_control_phy_sim_byp           30
#define DFLT_VAL_NX50_phy_control_phy_sim_byp      0x00000000U
#define MSK_NX50_phy_control_phy_reset             0x80000000U
#define SRT_NX50_phy_control_phy_reset             31
#define DFLT_VAL_NX50_phy_control_phy_reset        0x00000000U

enum {
	BFW_NX50_phy_control_phy_address      = 4, /* [3:0] */
	BFW_NX50_phy_control_phy0_mode        = 3, /* [6:4] */
	BFW_NX50_phy_control_phy0_fxmode      = 1, /* [7] */
	BFW_NX50_phy_control_phy0_automdix    = 1, /* [8] */
	BFW_NX50_phy_control_phy0_np_msg_code = 3, /* [11:9] */
	BFW_NX50_phy_control_phy0_enable      = 1, /* [12] */
	BFW_NX50_phy_control_phy1_mode        = 3, /* [15:13] */
	BFW_NX50_phy_control_phy1_fxmode      = 1, /* [16] */
	BFW_NX50_phy_control_phy1_automdix    = 1, /* [17] */
	BFW_NX50_phy_control_phy1_np_msg_code = 3, /* [20:18] */
	BFW_NX50_phy_control_phy1_enable      = 1, /* [21] */
	BFW_NX50_phy_control_reserved1        = 8, /* [29:22] */
	BFW_NX50_phy_control_phy_sim_byp      = 1, /* [30] */
	BFW_NX50_phy_control_phy_reset        = 1  /* [31] */
};

typedef struct NX50_PHY_CONTROL_BIT_Ttag {
	unsigned int phy_address      : BFW_NX50_phy_control_phy_address;      /* Bits 4:1 of PHY mdio-address.                         */
	                                                                       /* Bit0 defines 1st or 2nd internal PHY                  */
	unsigned int phy0_mode        : BFW_NX50_phy_control_phy0_mode;        /* PHY0 Mode:                                            */
	                                                                       /* 000: 10BASE-T Half Duplex, Auto Negotiation disabled. */
	unsigned int phy0_fxmode      : BFW_NX50_phy_control_phy0_fxmode;      /* PHY0 100BASE-FX mode (phy_mode must be 01x)           */
	unsigned int phy0_automdix    : BFW_NX50_phy_control_phy0_automdix;    /* PHY0 Enables AutoMDIX state machine                   */
	unsigned int phy0_np_msg_code : BFW_NX50_phy_control_phy0_np_msg_code; /* PHY0 Next Page Message Code (auto negotiation)        */
	unsigned int phy0_enable      : BFW_NX50_phy_control_phy0_enable;      /* PHY0 enable                                           */
	unsigned int phy1_mode        : BFW_NX50_phy_control_phy1_mode;        /* PHY1 Mode:                                            */
	                                                                       /* 000: 10BASE-T Half Duplex, Auto Negotiation disabled. */
	unsigned int phy1_fxmode      : BFW_NX50_phy_control_phy1_fxmode;      /* PHY1 100BASE-FX mode (phy_mode must be 01x)           */
	unsigned int phy1_automdix    : BFW_NX50_phy_control_phy1_automdix;    /* PHY1 Enables AutoMDIX state machine                   */
	unsigned int phy1_np_msg_code : BFW_NX50_phy_control_phy1_np_msg_code; /* PHY1 Next Page Message Code (auto negotiation)        */
	unsigned int phy1_enable      : BFW_NX50_phy_control_phy1_enable;      /* PHY1 enable                                           */
	unsigned int reserved1        : BFW_NX50_phy_control_reserved1;        /* reserved                                              */
	unsigned int phy_sim_byp      : BFW_NX50_phy_control_phy_sim_byp;      /* PHY Power up Bypass (only used for simulation issues) */
	                                                                       /* 0: normal                                             */
	unsigned int phy_reset        : BFW_NX50_phy_control_phy_reset;        /* Hardware reset for PHY                                */
	                                                                       /* 1: reset                                              */
} NX50_PHY_CONTROL_BIT_T;

typedef union {
	unsigned int           val;
	NX50_PHY_CONTROL_BIT_T bf;
} NX50_PHY_CONTROL_T;

/* --------------------------------------------------------------------- */
/* Register armclk_rate_mul_add */
/* => Rate Multiplier Add Value of System Clock: */
/*    This register might be used to change internal system frequency (200MHz of ARM and 100MHz of system). */
/*    Be careful when changing this value, as proper netX functionality is only qualified for the default value. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_armclk_rate_mul_add       0x00000014U
#define Adr_NX50_asic_ctrl_armclk_rate_mul_add 0x1C000014U
#define Adr_NX50_armclk_rate_mul_add           0x1C000014U
#define DFLT_VAL_NX50_armclk_rate_mul_add      0x00000100U

#define MSK_NX50_armclk_rate_mul_add_armclk_rate_mul_add      0x000001ffU
#define SRT_NX50_armclk_rate_mul_add_armclk_rate_mul_add      0
#define DFLT_VAL_NX50_armclk_rate_mul_add_armclk_rate_mul_add 0x00000100U

enum {
	BFW_NX50_armclk_rate_mul_add_armclk_rate_mul_add = 9,  /* [8:0] */
	BFW_NX50_armclk_rate_mul_add_reserved1           = 23  /* [31:9] */
};

typedef struct NX50_ARMCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int armclk_rate_mul_add : BFW_NX50_armclk_rate_mul_add_armclk_rate_mul_add; /* This value is added each clk400 cycle to armclk_rate_mul to generate armclk. */
	                                                                                     /* Change value according to formula:                                           */
	unsigned int reserved1           : BFW_NX50_armclk_rate_mul_add_reserved1;           /* reserved                                                                     */
} NX50_ARMCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_ARMCLK_RATE_MUL_ADD_BIT_T bf;
} NX50_ARMCLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register usbclk_rate_mul_add */
/* => Rate Multiplier Add Value of USB clock: */
/*    This register might be used to change internal system frequency (200MHz of ARM and 100MHz of system). */
/*    Be careful when changing this value, as proper netX functionality is only qualified for the default value. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_usbclk_rate_mul_add       0x00000018U
#define Adr_NX50_asic_ctrl_usbclk_rate_mul_add 0x1C000018U
#define Adr_NX50_usbclk_rate_mul_add           0x1C000018U
#define DFLT_VAL_NX50_usbclk_rate_mul_add      0x1eb851ecU

#define MSK_NX50_usbclk_rate_mul_add_unused                   0x0000ffffU
#define SRT_NX50_usbclk_rate_mul_add_unused                   0
#define DFLT_VAL_NX50_usbclk_rate_mul_add_unused              0x000051ecU
#define MSK_NX50_usbclk_rate_mul_add_usbclk_rate_mul_add      0xffff0000U
#define SRT_NX50_usbclk_rate_mul_add_usbclk_rate_mul_add      16
#define DFLT_VAL_NX50_usbclk_rate_mul_add_usbclk_rate_mul_add 0x1eb80000U

enum {
	BFW_NX50_usbclk_rate_mul_add_unused              = 16, /* [15:0] */
	BFW_NX50_usbclk_rate_mul_add_usbclk_rate_mul_add = 16  /* [31:16] */
};

typedef struct NX50_USBCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int unused              : BFW_NX50_usbclk_rate_mul_add_unused;              /* unused                                                                       */
	unsigned int usbclk_rate_mul_add : BFW_NX50_usbclk_rate_mul_add_usbclk_rate_mul_add; /* This value is added each clk400 cycle to usbclk_rate_mul to generate usbclk. */
	                                                                                     /* Change value according to formula:                                           */
} NX50_USBCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_USBCLK_RATE_MUL_ADD_BIT_T bf;
} NX50_USBCLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register fb0clk_rate_mul_add */
/* => Rate Multiplier Add Value: */
/*    Fieldbus0 clock is generated by internal 400MHz rate multiplier. \ */
/*    At some fieldbus-frequencies, this clock has less jitter, than the xMAC generated output clock. \ */
/*    xMAC fieldbus outputs (xm0_tx_out, xm1_tx_oe) can optionally (io_config-sel_xm0_eclk) be sampled by an extra register running on this clock, */
/*    resulting in jitter less fieldbus outputs. */
/*    Alternatively to this internally generated clock, an external clock (xm0_eclk) can be used to make xMAC outputs jitter free (clock_enable-fb0). \ */
/*    Using external clocks to resample xMAC outputs requires modified xMAC software. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/*     */
/*    ------------------------------------ */
/*    netX100/netX500 usage of this address: adcclk_rate_mul_add */
/*    ------------------------------------ */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_fb0clk_rate_mul_add       0x0000001CU
#define Adr_NX50_asic_ctrl_fb0clk_rate_mul_add 0x1C00001CU
#define Adr_NX50_fb0clk_rate_mul_add           0x1C00001CU
#define DFLT_VAL_NX50_fb0clk_rate_mul_add      0x01000000U

#define MSK_NX50_fb0clk_rate_mul_add_fb0clk_rate_mul_add      0xffffffffU
#define SRT_NX50_fb0clk_rate_mul_add_fb0clk_rate_mul_add      0
#define DFLT_VAL_NX50_fb0clk_rate_mul_add_fb0clk_rate_mul_add 0x01000000U

enum {
	BFW_NX50_fb0clk_rate_mul_add_fb0clk_rate_mul_add = 32  /* [31:0] */
};

typedef struct NX50_FB0CLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int fb0clk_rate_mul_add : BFW_NX50_fb0clk_rate_mul_add_fb0clk_rate_mul_add; /* This value is added each clk400 cycle to fb0clk_rate_mul to generate fb0clk. */
	                                                                                     /* Change value according to formula:                                           */
} NX50_FB0CLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_FB0CLK_RATE_MUL_ADD_BIT_T bf;
} NX50_FB0CLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register fb1clk_rate_mul_add */
/* => Rate Multiplier Add Value: */
/*    Fieldbus1 clock is generated by internal 400MHz rate multiplier. \ */
/*    At some fieldbus-frequencies, this clock has less jitter, than the xMAC generated output clock. \ */
/*    xMAC fieldbus outputs (xm1_tx_out, xm1_tx_oe) can optionally (io_config-sel_xm1_eclk) be sampled by an extra register running on this clock, */
/*    resulting in jitter less fieldbus outputs. */
/*    Alternatively to this internally generated clock, an external clock (xm1_eclk) can be used to make xMAC outputs jitter free (clock_enable-fb1). \ */
/*    Using external clocks to resample xMAC outputs requires modified xMAC software. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_fb1clk_rate_mul_add       0x00000020U
#define Adr_NX50_asic_ctrl_fb1clk_rate_mul_add 0x1C000020U
#define Adr_NX50_fb1clk_rate_mul_add           0x1C000020U
#define DFLT_VAL_NX50_fb1clk_rate_mul_add      0x01000000U

#define MSK_NX50_fb1clk_rate_mul_add_fb1clk_rate_mul_add      0xffffffffU
#define SRT_NX50_fb1clk_rate_mul_add_fb1clk_rate_mul_add      0
#define DFLT_VAL_NX50_fb1clk_rate_mul_add_fb1clk_rate_mul_add 0x01000000U

enum {
	BFW_NX50_fb1clk_rate_mul_add_fb1clk_rate_mul_add = 32  /* [31:0] */
};

typedef struct NX50_FB1CLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int fb1clk_rate_mul_add : BFW_NX50_fb1clk_rate_mul_add_fb1clk_rate_mul_add; /* This value is added each clk400 cycle to fb1clk_rate_mul to generate fb1clk. */
	                                                                                     /* Change value according to formula:                                           */
} NX50_FB1CLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_FB1CLK_RATE_MUL_ADD_BIT_T bf;
} NX50_FB1CLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register clock_enable */
/* => Global Clock Enable Register: */
/*    Use this registers to disable modules completely for power saving purposes. */
/*    Changes will only have effect if according bit in clock_enable_mask-register is set. \ */
/*    Bits will be reset according to the clock_enable_mask-register register, if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_clock_enable       0x00000024U
#define Adr_NX50_asic_ctrl_clock_enable 0x1C000024U
#define Adr_NX50_clock_enable           0x1C000024U
#define DFLT_VAL_NX50_clock_enable      0x00000d33U

#define MSK_NX50_clock_enable_xpec0      0x00000001U
#define SRT_NX50_clock_enable_xpec0      0
#define DFLT_VAL_NX50_clock_enable_xpec0 0x00000001U
#define MSK_NX50_clock_enable_xpec1      0x00000002U
#define SRT_NX50_clock_enable_xpec1      1
#define DFLT_VAL_NX50_clock_enable_xpec1 0x00000002U
#define MSK_NX50_clock_enable_xmac0      0x00000010U
#define SRT_NX50_clock_enable_xmac0      4
#define DFLT_VAL_NX50_clock_enable_xmac0 0x00000010U
#define MSK_NX50_clock_enable_xmac1      0x00000020U
#define SRT_NX50_clock_enable_xmac1      5
#define DFLT_VAL_NX50_clock_enable_xmac1 0x00000020U
#define MSK_NX50_clock_enable_hif        0x00000100U
#define SRT_NX50_clock_enable_hif        8
#define DFLT_VAL_NX50_clock_enable_hif   0x00000100U
#define MSK_NX50_clock_enable_fb0        0x00000400U
#define SRT_NX50_clock_enable_fb0        10
#define DFLT_VAL_NX50_clock_enable_fb0   0x00000400U
#define MSK_NX50_clock_enable_fb1        0x00000800U
#define SRT_NX50_clock_enable_fb1        11
#define DFLT_VAL_NX50_clock_enable_fb1   0x00000800U

enum {
	BFW_NX50_clock_enable_xpec0     = 1,  /* [0] */
	BFW_NX50_clock_enable_xpec1     = 1,  /* [1] */
	BFW_NX50_clock_enable_reserved1 = 2,  /* [3:2] */
	BFW_NX50_clock_enable_xmac0     = 1,  /* [4] */
	BFW_NX50_clock_enable_xmac1     = 1,  /* [5] */
	BFW_NX50_clock_enable_reserved2 = 2,  /* [7:6] */
	BFW_NX50_clock_enable_hif       = 1,  /* [8] */
	BFW_NX50_clock_enable_reserved3 = 1,  /* [9] */
	BFW_NX50_clock_enable_fb0       = 1,  /* [10] */
	BFW_NX50_clock_enable_fb1       = 1,  /* [11] */
	BFW_NX50_clock_enable_reserved4 = 20  /* [31:12] */
};

typedef struct NX50_CLOCK_ENABLE_BIT_Ttag {
	unsigned int xpec0     : BFW_NX50_clock_enable_xpec0;     /* enables clock for xPEC0                                      */
	unsigned int xpec1     : BFW_NX50_clock_enable_xpec1;     /* enables clock for xPEC1                                      */
	unsigned int reserved1 : BFW_NX50_clock_enable_reserved1; /* reserved                                                     */
	unsigned int xmac0     : BFW_NX50_clock_enable_xmac0;     /* enables clock for xMAC0                                      */
	unsigned int xmac1     : BFW_NX50_clock_enable_xmac1;     /* enables clock for xMAC1                                      */
	unsigned int reserved2 : BFW_NX50_clock_enable_reserved2; /* reserved                                                     */
	unsigned int hif       : BFW_NX50_clock_enable_hif;       /* enables clock for HIF                                        */
	unsigned int reserved3 : BFW_NX50_clock_enable_reserved3; /* reserved                                                     */
	unsigned int fb0       : BFW_NX50_clock_enable_fb0;       /* enables clock for fieldbus0:                                 */
	                                                          /* 1: use internally generated fb0clk to resample xMAC0 outputs */
	unsigned int fb1       : BFW_NX50_clock_enable_fb1;       /* enables clock for fieldbus1:                                 */
	                                                          /* 1: use internally generated fb1clk to resample xMAC1 outputs */
	unsigned int reserved4 : BFW_NX50_clock_enable_reserved4; /* reserved                                                     */
} NX50_CLOCK_ENABLE_BIT_T;

typedef union {
	unsigned int            val;
	NX50_CLOCK_ENABLE_BIT_T bf;
} NX50_CLOCK_ENABLE_T;

/* --------------------------------------------------------------------- */
/* Register clock_enable_mask */
/* => Global Clock Enable Mask Register: */
/*    allows to disable modules for different netX-versions */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    The clock_enable-register will change according to this register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_clock_enable_mask       0x00000028U
#define Adr_NX50_asic_ctrl_clock_enable_mask 0x1C000028U
#define Adr_NX50_clock_enable_mask           0x1C000028U
#define DFLT_VAL_NX50_clock_enable_mask      0x00000d33U

#define MSK_NX50_clock_enable_mask_xpec0      0x00000001U
#define SRT_NX50_clock_enable_mask_xpec0      0
#define DFLT_VAL_NX50_clock_enable_mask_xpec0 0x00000001U
#define MSK_NX50_clock_enable_mask_xpec1      0x00000002U
#define SRT_NX50_clock_enable_mask_xpec1      1
#define DFLT_VAL_NX50_clock_enable_mask_xpec1 0x00000002U
#define MSK_NX50_clock_enable_mask_xmac0      0x00000010U
#define SRT_NX50_clock_enable_mask_xmac0      4
#define DFLT_VAL_NX50_clock_enable_mask_xmac0 0x00000010U
#define MSK_NX50_clock_enable_mask_xmac1      0x00000020U
#define SRT_NX50_clock_enable_mask_xmac1      5
#define DFLT_VAL_NX50_clock_enable_mask_xmac1 0x00000020U
#define MSK_NX50_clock_enable_mask_hif        0x00000100U
#define SRT_NX50_clock_enable_mask_hif        8
#define DFLT_VAL_NX50_clock_enable_mask_hif   0x00000100U
#define MSK_NX50_clock_enable_mask_fb0        0x00000400U
#define SRT_NX50_clock_enable_mask_fb0        10
#define DFLT_VAL_NX50_clock_enable_mask_fb0   0x00000400U
#define MSK_NX50_clock_enable_mask_fb1        0x00000800U
#define SRT_NX50_clock_enable_mask_fb1        11
#define DFLT_VAL_NX50_clock_enable_mask_fb1   0x00000800U

enum {
	BFW_NX50_clock_enable_mask_xpec0     = 1,  /* [0] */
	BFW_NX50_clock_enable_mask_xpec1     = 1,  /* [1] */
	BFW_NX50_clock_enable_mask_reserved1 = 2,  /* [3:2] */
	BFW_NX50_clock_enable_mask_xmac0     = 1,  /* [4] */
	BFW_NX50_clock_enable_mask_xmac1     = 1,  /* [5] */
	BFW_NX50_clock_enable_mask_reserved2 = 2,  /* [7:6] */
	BFW_NX50_clock_enable_mask_hif       = 1,  /* [8] */
	BFW_NX50_clock_enable_mask_reserved3 = 1,  /* [9] */
	BFW_NX50_clock_enable_mask_fb0       = 1,  /* [10] */
	BFW_NX50_clock_enable_mask_fb1       = 1,  /* [11] */
	BFW_NX50_clock_enable_mask_reserved4 = 20  /* [31:12] */
};

typedef struct NX50_CLOCK_ENABLE_MASK_BIT_Ttag {
	unsigned int xpec0     : BFW_NX50_clock_enable_mask_xpec0;     /* 0: xPEC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC0               */
	unsigned int xpec1     : BFW_NX50_clock_enable_mask_xpec1;     /* 0: xPEC1 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC1               */
	unsigned int reserved1 : BFW_NX50_clock_enable_mask_reserved1; /* reserved                                                                                                */
	unsigned int xmac0     : BFW_NX50_clock_enable_mask_xmac0;     /* 0: xMAC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC0               */
	unsigned int xmac1     : BFW_NX50_clock_enable_mask_xmac1;     /* 0: xMAC1 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC1               */
	unsigned int reserved2 : BFW_NX50_clock_enable_mask_reserved2; /* reserved                                                                                                */
	unsigned int hif       : BFW_NX50_clock_enable_mask_hif;       /* 0: HIF is disabled  1: clock can be enabled/disabled by clock_enable-register for HIF                   */
	unsigned int reserved3 : BFW_NX50_clock_enable_mask_reserved3; /* reserved                                                                                                */
	unsigned int fb0       : BFW_NX50_clock_enable_mask_fb0;       /* 0: fieldbus0 clock is disabled  1: clock can be enabled/disabled by clock_enable-register for fieldbus0 */
	unsigned int fb1       : BFW_NX50_clock_enable_mask_fb1;       /* 0: fieldbus1 clock is disabled  1: clock can be enabled/disabled by clock_enable-register for fieldbus1 */
	unsigned int reserved4 : BFW_NX50_clock_enable_mask_reserved4; /* reserved                                                                                                */
} NX50_CLOCK_ENABLE_MASK_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_CLOCK_ENABLE_MASK_BIT_T bf;
} NX50_CLOCK_ENABLE_MASK_T;

/* --------------------------------------------------------------------- */
/* Register misc_asic_ctrl */
/* => Miscellaneous ASIC Control Register: */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_misc_asic_ctrl       0x0000002CU
#define Adr_NX50_asic_ctrl_misc_asic_ctrl 0x1C00002CU
#define Adr_NX50_misc_asic_ctrl           0x1C00002CU
#define DFLT_VAL_NX50_misc_asic_ctrl      0x00000001U

#define MSK_NX50_misc_asic_ctrl_arm_dbgen      0x00000001U
#define SRT_NX50_misc_asic_ctrl_arm_dbgen      0
#define DFLT_VAL_NX50_misc_asic_ctrl_arm_dbgen 0x00000001U

enum {
	BFW_NX50_misc_asic_ctrl_arm_dbgen = 1,  /* [0] */
	BFW_NX50_misc_asic_ctrl_reserved1 = 31  /* [31:1] */
};

typedef struct NX50_MISC_ASIC_CTRL_BIT_Ttag {
	unsigned int arm_dbgen : BFW_NX50_misc_asic_ctrl_arm_dbgen; /* 1: ARM debug features are enabled  */
	                                                            /* 0: ARM debug features are disabled */
	unsigned int reserved1 : BFW_NX50_misc_asic_ctrl_reserved1; /* reserved                           */
} NX50_MISC_ASIC_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX50_MISC_ASIC_CTRL_BIT_T bf;
} NX50_MISC_ASIC_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register exmem_priority_lock */
/* => External Memory Priority Control Mask Register: */
/*    Set bits to lock the registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl */
/*    in address area extmem_priority_ctrl. */
/*    allows to disable modules completely for power saving reasons */
/*    This register is lockable by netX locking algorithm. It will only be reset by Power on Reset (PORn), not by other system resets. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_exmem_priority_lock       0x00000030U
#define Adr_NX50_asic_ctrl_exmem_priority_lock 0x1C000030U
#define Adr_NX50_exmem_priority_lock           0x1C000030U
#define DFLT_VAL_NX50_exmem_priority_lock      0x00000000U

#define MSK_NX50_exmem_priority_lock_lock_HIF_priority      0x00000001U
#define SRT_NX50_exmem_priority_lock_lock_HIF_priority      0
#define DFLT_VAL_NX50_exmem_priority_lock_lock_HIF_priority 0x00000000U
#define MSK_NX50_exmem_priority_lock_lock_XC_priority       0x00000002U
#define SRT_NX50_exmem_priority_lock_lock_XC_priority       1
#define DFLT_VAL_NX50_exmem_priority_lock_lock_XC_priority  0x00000000U
#define MSK_NX50_exmem_priority_lock_lock_ARM_priority      0x00000020U
#define SRT_NX50_exmem_priority_lock_lock_ARM_priority      5
#define DFLT_VAL_NX50_exmem_priority_lock_lock_ARM_priority 0x00000000U
#define MSK_NX50_exmem_priority_lock_lock_DMA_priority      0x00000040U
#define SRT_NX50_exmem_priority_lock_lock_DMA_priority      6
#define DFLT_VAL_NX50_exmem_priority_lock_lock_DMA_priority 0x00000000U

enum {
	BFW_NX50_exmem_priority_lock_lock_HIF_priority = 1,  /* [0] */
	BFW_NX50_exmem_priority_lock_lock_XC_priority  = 1,  /* [1] */
	BFW_NX50_exmem_priority_lock_reserved1         = 3,  /* [4:2] */
	BFW_NX50_exmem_priority_lock_lock_ARM_priority = 1,  /* [5] */
	BFW_NX50_exmem_priority_lock_lock_DMA_priority = 1,  /* [6] */
	BFW_NX50_exmem_priority_lock_reserved2         = 25  /* [31:7] */
};

typedef struct NX50_EXMEM_PRIORITY_LOCK_BIT_Ttag {
	unsigned int lock_HIF_priority : BFW_NX50_exmem_priority_lock_lock_HIF_priority; /* 1 HIF settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked */
	unsigned int lock_XC_priority  : BFW_NX50_exmem_priority_lock_lock_XC_priority;  /* 1 XC settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked  */
	unsigned int reserved1         : BFW_NX50_exmem_priority_lock_reserved1;         /* reserved                                                                                            */
	unsigned int lock_ARM_priority : BFW_NX50_exmem_priority_lock_lock_ARM_priority; /* 1 ARM settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked */
	unsigned int lock_DMA_priority : BFW_NX50_exmem_priority_lock_lock_DMA_priority; /* 1 DMA settings in registers extmem_prio_timslot_ctrl and extmem_prio_accesstime_ctrl will be locked */
	unsigned int reserved2         : BFW_NX50_exmem_priority_lock_reserved2;         /* reserved                                                                                            */
} NX50_EXMEM_PRIORITY_LOCK_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_EXMEM_PRIORITY_LOCK_BIT_T bf;
} NX50_EXMEM_PRIORITY_LOCK_T;

/* --------------------------------------------------------------------- */
/* Register netx_version */
/* => netX Revision Register: */
/*    This register contains information about netX hardware and bootloader revision. */
/*    It will be written by bootloader software during boot.phase. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*     */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*     */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_version       0x00000034U
#define Adr_NX50_asic_ctrl_netx_version 0x1C000034U
#define Adr_NX50_netx_version           0x1C000034U
#define DFLT_VAL_NX50_netx_version      0x00000001U

#define MSK_NX50_netx_version_netx_version      0x000000ffU
#define SRT_NX50_netx_version_netx_version      0
#define DFLT_VAL_NX50_netx_version_netx_version 0x00000001U

enum {
	BFW_NX50_netx_version_netx_version = 8,  /* [7:0] */
	BFW_NX50_netx_version_reserved1    = 24  /* [31:8] */
};

typedef struct NX50_NETX_VERSION_BIT_Ttag {
	unsigned int netx_version : BFW_NX50_netx_version_netx_version; /* netX50 revision number:                        */
	                                                                /* netX50 revision number starts with "B" (0x42). */
	unsigned int reserved1    : BFW_NX50_netx_version_reserved1;    /* reserved                                       */
} NX50_NETX_VERSION_BIT_T;

typedef union {
	unsigned int            val;
	NX50_NETX_VERSION_BIT_T bf;
} NX50_NETX_VERSION_T;

/* --------------------------------------------------------------------- */
/* Register rom_wdg */
/* => netX ROM Watchdog: */
/*    Write to this register to reset rom-hide-watchdog, no access-key-protection. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_rom_wdg       0x00000038U
#define Adr_NX50_asic_ctrl_rom_wdg 0x1C000038U
#define Adr_NX50_rom_wdg           0x1C000038U
#define DFLT_VAL_NX50_rom_wdg      0x000001ffU

#define MSK_NX50_rom_wdg_rst_wdg      0xffffffffU
#define SRT_NX50_rom_wdg_rst_wdg      0
#define DFLT_VAL_NX50_rom_wdg_rst_wdg 0x000001ffU

enum {
	BFW_NX50_rom_wdg_rst_wdg = 32  /* [31:0] */
};

typedef struct NX50_ROM_WDG_BIT_Ttag {
	unsigned int rst_wdg : BFW_NX50_rom_wdg_rst_wdg; /* write here to reset rom-watchdog to 0x1ff                         */
	                                                 /* The watchdog will decrement with each positiv clk (100MHz) edge.  */
} NX50_ROM_WDG_BIT_T;

typedef union {
	unsigned int       val;
	NX50_ROM_WDG_BIT_T bf;
} NX50_ROM_WDG_T;

/* --------------------------------------------------------------------- */
/* Register asic_ctrl_access_key */
/* => ASIC Control Locking Access Key Register: */
/*    Writing to any register in the asic_ctrl or mmio_ctrl address area is only possible after */
/*    setting the correct key here to avoid unmeant changes e.g. by crashed software. */
/*    ---- */
/*    Changing a control register in the asic_ctrl or mmio_ctrl address area is only possible by the following sequence: */
/*    1.: Read out the Locking Access Key from this register. */
/*    2.: Write back this Locking Access Key to this register. */
/*    3.: Write desired value to the control register. */
/*    ---- */
/*    The Locking Access Key will become invalid after each access to any register in the asic_ctrl or mmio_ctrl address area */
/*    and has to be read out and set again for sequent accesses. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_asic_ctrl_access_key       0x00000070U
#define Adr_NX50_asic_ctrl_asic_ctrl_access_key 0x1C000070U
#define Adr_NX50_asic_ctrl_access_key           0x1C000070U
#define DFLT_VAL_NX50_asic_ctrl_access_key      0x00000000U

#define MSK_NX50_asic_ctrl_access_key_access_key      0x0000ffffU
#define SRT_NX50_asic_ctrl_access_key_access_key      0
#define DFLT_VAL_NX50_asic_ctrl_access_key_access_key 0x00000000U

enum {
	BFW_NX50_asic_ctrl_access_key_access_key = 16, /* [15:0] */
	BFW_NX50_asic_ctrl_access_key_reserved1  = 16  /* [31:16] */
};

typedef struct NX50_ASIC_CTRL_ACCESS_KEY_BIT_Ttag {
	unsigned int access_key : BFW_NX50_asic_ctrl_access_key_access_key; /* Locking Access Key for next write access. */
	unsigned int reserved1  : BFW_NX50_asic_ctrl_access_key_reserved1;  /* reserved                                  */
} NX50_ASIC_CTRL_ACCESS_KEY_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_ASIC_CTRL_ACCESS_KEY_BIT_T bf;
} NX50_ASIC_CTRL_ACCESS_KEY_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved00 */
/* => reserved address for netX locking purpose */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_lock_reserved00       0x00000074U
#define Adr_NX50_asic_ctrl_netx_lock_reserved00 0x1C000074U
#define Adr_NX50_netx_lock_reserved00           0x1C000074U

#define MSK_NX50_netx_lock_reserved00_lock 0xffffffffU
#define SRT_NX50_netx_lock_reserved00_lock 0

enum {
	BFW_NX50_netx_lock_reserved00_lock = 32  /* [31:0] */
};

typedef struct NX50_NETX_LOCK_RESERVED00_BIT_Ttag {
	unsigned int lock : BFW_NX50_netx_lock_reserved00_lock; /* locking purpose */
} NX50_NETX_LOCK_RESERVED00_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_NETX_LOCK_RESERVED00_BIT_T bf;
} NX50_NETX_LOCK_RESERVED00_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved01 */
/* => reserved address for netX locking purpose */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_lock_reserved01       0x00000078U
#define Adr_NX50_asic_ctrl_netx_lock_reserved01 0x1C000078U
#define Adr_NX50_netx_lock_reserved01           0x1C000078U

#define MSK_NX50_netx_lock_reserved01_lock 0xffffffffU
#define SRT_NX50_netx_lock_reserved01_lock 0

enum {
	BFW_NX50_netx_lock_reserved01_lock = 32  /* [31:0] */
};

typedef struct NX50_NETX_LOCK_RESERVED01_BIT_Ttag {
	unsigned int lock : BFW_NX50_netx_lock_reserved01_lock; /* locking purpose */
} NX50_NETX_LOCK_RESERVED01_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_NETX_LOCK_RESERVED01_BIT_T bf;
} NX50_NETX_LOCK_RESERVED01_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved_start */
/* => Reserved start address for netX locking purpose address area */
/*    Don't implement other registers at 0x80 .. 0xfc! */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_lock_reserved_start       0x00000080U
#define Adr_NX50_asic_ctrl_netx_lock_reserved_start 0x1C000080U
#define Adr_NX50_netx_lock_reserved_start           0x1C000080U

#define MSK_NX50_netx_lock_reserved_start_lock 0xffffffffU
#define SRT_NX50_netx_lock_reserved_start_lock 0

enum {
	BFW_NX50_netx_lock_reserved_start_lock = 32  /* [31:0] */
};

typedef struct NX50_NETX_LOCK_RESERVED_START_BIT_Ttag {
	unsigned int lock : BFW_NX50_netx_lock_reserved_start_lock; /* locking purpose */
} NX50_NETX_LOCK_RESERVED_START_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_NETX_LOCK_RESERVED_START_BIT_T bf;
} NX50_NETX_LOCK_RESERVED_START_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved_end */
/* => Reserved end address for netX locking purpose address area */
/*    Don't implement other registers at 0x80 .. 0xfc! */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_lock_reserved_end       0x000000FCU
#define Adr_NX50_asic_ctrl_netx_lock_reserved_end 0x1C0000FCU
#define Adr_NX50_netx_lock_reserved_end           0x1C0000FCU

#define MSK_NX50_netx_lock_reserved_end_lock 0xffffffffU
#define SRT_NX50_netx_lock_reserved_end_lock 0

enum {
	BFW_NX50_netx_lock_reserved_end_lock = 32  /* [31:0] */
};

typedef struct NX50_NETX_LOCK_RESERVED_END_BIT_Ttag {
	unsigned int lock : BFW_NX50_netx_lock_reserved_end_lock; /* locking purpose */
} NX50_NETX_LOCK_RESERVED_END_BIT_T;

typedef union {
	unsigned int                      val;
	NX50_NETX_LOCK_RESERVED_END_BIT_T bf;
} NX50_NETX_LOCK_RESERVED_END_T;


/* ===================================================================== */

/* Area of extmemctrl */

/* ===================================================================== */

#define Addr_NX50_extmemctrl 0x1C000100U

/* ===================================================================== */

/* Area of ext_asyncmem_ctrl */

/* ===================================================================== */

#define Addr_NX50_ext_asyncmem_ctrl  0x1C000100U
#define NX50_NETX_MEM_SRAM_CTRL_AREA 0x1C000100U

/* --------------------------------------------------------------------- */
/* Register extsram0_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem0 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_extsram0_ctrl               0x00000000U
#define Adr_NX50_ext_asyncmem_ctrl_extsram0_ctrl 0x1C000100U
#define Adr_NX50_extsram0_ctrl                   0x1C000100U
#define DFLT_VAL_NX50_extsram0_ctrl              0x0003033fU

#define MSK_NX50_extsram0_ctrl_WSExtMem0               0x0000003fU
#define SRT_NX50_extsram0_ctrl_WSExtMem0               0
#define DFLT_VAL_NX50_extsram0_ctrl_WSExtMem0          0x0000003fU
#define MSK_NX50_extsram0_ctrl_WSPrePauseExtMem0       0x00000300U
#define SRT_NX50_extsram0_ctrl_WSPrePauseExtMem0       8
#define DFLT_VAL_NX50_extsram0_ctrl_WSPrePauseExtMem0  0x00000300U
#define MSK_NX50_extsram0_ctrl_WSPostPauseExtMem0      0x00030000U
#define SRT_NX50_extsram0_ctrl_WSPostPauseExtMem0      16
#define DFLT_VAL_NX50_extsram0_ctrl_WSPostPauseExtMem0 0x00030000U
#define MSK_NX50_extsram0_ctrl_WidthExtMem0            0x03000000U
#define SRT_NX50_extsram0_ctrl_WidthExtMem0            24
#define DFLT_VAL_NX50_extsram0_ctrl_WidthExtMem0       0x00000000U

enum {
	BFW_NX50_extsram0_ctrl_WSExtMem0          = 6, /* [5:0] */
	BFW_NX50_extsram0_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX50_extsram0_ctrl_WSPrePauseExtMem0  = 2, /* [9:8] */
	BFW_NX50_extsram0_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX50_extsram0_ctrl_WSPostPauseExtMem0 = 2, /* [17:16] */
	BFW_NX50_extsram0_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX50_extsram0_ctrl_WidthExtMem0       = 2, /* [25:24] */
	BFW_NX50_extsram0_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX50_EXTSRAM0_CTRL_BIT_Ttag {
	unsigned int WSExtMem0          : BFW_NX50_extsram0_ctrl_WSExtMem0;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX50_extsram0_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem0  : BFW_NX50_extsram0_ctrl_WSPrePauseExtMem0;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX50_extsram0_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem0 : BFW_NX50_extsram0_ctrl_WSPostPauseExtMem0; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX50_extsram0_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem0       : BFW_NX50_extsram0_ctrl_WidthExtMem0;       /* Datapath width of ExtMem0 area                                       */
	unsigned int reserved4          : BFW_NX50_extsram0_ctrl_reserved4;          /* reserved                                                             */
} NX50_EXTSRAM0_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX50_EXTSRAM0_CTRL_BIT_T bf;
} NX50_EXTSRAM0_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram1_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem1 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_extsram1_ctrl               0x00000004U
#define Adr_NX50_ext_asyncmem_ctrl_extsram1_ctrl 0x1C000104U
#define Adr_NX50_extsram1_ctrl                   0x1C000104U
#define DFLT_VAL_NX50_extsram1_ctrl              0x0003033fU

#define MSK_NX50_extsram1_ctrl_WSExtMem1               0x0000003fU
#define SRT_NX50_extsram1_ctrl_WSExtMem1               0
#define DFLT_VAL_NX50_extsram1_ctrl_WSExtMem1          0x0000003fU
#define MSK_NX50_extsram1_ctrl_WSPrePauseExtMem1       0x00000300U
#define SRT_NX50_extsram1_ctrl_WSPrePauseExtMem1       8
#define DFLT_VAL_NX50_extsram1_ctrl_WSPrePauseExtMem1  0x00000300U
#define MSK_NX50_extsram1_ctrl_WSPostPauseExtMem1      0x00030000U
#define SRT_NX50_extsram1_ctrl_WSPostPauseExtMem1      16
#define DFLT_VAL_NX50_extsram1_ctrl_WSPostPauseExtMem1 0x00030000U
#define MSK_NX50_extsram1_ctrl_WidthExtMem1            0x03000000U
#define SRT_NX50_extsram1_ctrl_WidthExtMem1            24
#define DFLT_VAL_NX50_extsram1_ctrl_WidthExtMem1       0x00000000U

enum {
	BFW_NX50_extsram1_ctrl_WSExtMem1          = 6, /* [5:0] */
	BFW_NX50_extsram1_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX50_extsram1_ctrl_WSPrePauseExtMem1  = 2, /* [9:8] */
	BFW_NX50_extsram1_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX50_extsram1_ctrl_WSPostPauseExtMem1 = 2, /* [17:16] */
	BFW_NX50_extsram1_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX50_extsram1_ctrl_WidthExtMem1       = 2, /* [25:24] */
	BFW_NX50_extsram1_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX50_EXTSRAM1_CTRL_BIT_Ttag {
	unsigned int WSExtMem1          : BFW_NX50_extsram1_ctrl_WSExtMem1;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX50_extsram1_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem1  : BFW_NX50_extsram1_ctrl_WSPrePauseExtMem1;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX50_extsram1_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem1 : BFW_NX50_extsram1_ctrl_WSPostPauseExtMem1; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX50_extsram1_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem1       : BFW_NX50_extsram1_ctrl_WidthExtMem1;       /* Datapath width of ExtMem1 area                                       */
	unsigned int reserved4          : BFW_NX50_extsram1_ctrl_reserved4;          /* reserved                                                             */
} NX50_EXTSRAM1_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX50_EXTSRAM1_CTRL_BIT_T bf;
} NX50_EXTSRAM1_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram2_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem2 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_extsram2_ctrl               0x00000008U
#define Adr_NX50_ext_asyncmem_ctrl_extsram2_ctrl 0x1C000108U
#define Adr_NX50_extsram2_ctrl                   0x1C000108U
#define DFLT_VAL_NX50_extsram2_ctrl              0x0003033fU

#define MSK_NX50_extsram2_ctrl_WSExtMem2               0x0000003fU
#define SRT_NX50_extsram2_ctrl_WSExtMem2               0
#define DFLT_VAL_NX50_extsram2_ctrl_WSExtMem2          0x0000003fU
#define MSK_NX50_extsram2_ctrl_WSPrePauseExtMem2       0x00000300U
#define SRT_NX50_extsram2_ctrl_WSPrePauseExtMem2       8
#define DFLT_VAL_NX50_extsram2_ctrl_WSPrePauseExtMem2  0x00000300U
#define MSK_NX50_extsram2_ctrl_WSPostPauseExtMem2      0x00030000U
#define SRT_NX50_extsram2_ctrl_WSPostPauseExtMem2      16
#define DFLT_VAL_NX50_extsram2_ctrl_WSPostPauseExtMem2 0x00030000U
#define MSK_NX50_extsram2_ctrl_WidthExtMem2            0x03000000U
#define SRT_NX50_extsram2_ctrl_WidthExtMem2            24
#define DFLT_VAL_NX50_extsram2_ctrl_WidthExtMem2       0x00000000U

enum {
	BFW_NX50_extsram2_ctrl_WSExtMem2          = 6, /* [5:0] */
	BFW_NX50_extsram2_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX50_extsram2_ctrl_WSPrePauseExtMem2  = 2, /* [9:8] */
	BFW_NX50_extsram2_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX50_extsram2_ctrl_WSPostPauseExtMem2 = 2, /* [17:16] */
	BFW_NX50_extsram2_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX50_extsram2_ctrl_WidthExtMem2       = 2, /* [25:24] */
	BFW_NX50_extsram2_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX50_EXTSRAM2_CTRL_BIT_Ttag {
	unsigned int WSExtMem2          : BFW_NX50_extsram2_ctrl_WSExtMem2;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX50_extsram2_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem2  : BFW_NX50_extsram2_ctrl_WSPrePauseExtMem2;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX50_extsram2_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem2 : BFW_NX50_extsram2_ctrl_WSPostPauseExtMem2; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX50_extsram2_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem2       : BFW_NX50_extsram2_ctrl_WidthExtMem2;       /* Datapath width of ExtMem2 area                                       */
	unsigned int reserved4          : BFW_NX50_extsram2_ctrl_reserved4;          /* reserved                                                             */
} NX50_EXTSRAM2_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX50_EXTSRAM2_CTRL_BIT_T bf;
} NX50_EXTSRAM2_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram3_ctrl */
/* => This register exists physically, but corresponding MEM_MCS3_N-Signal is not connected externally. */
/*    Control Register for external bus interface and Waitstates for ExtMem3 chip select area */
/*    memory width coding like ARM-signals MAS / HSIZE[1:0]: */
/*        00=8bit */
/*        01=16bit */
/*        10=32bit */
/*        11=reserved */
/*    external addresses will be alligned (right shifted) according to the selected memory width */
/*        8 bit  -> no right shift of Aext */
/*        16 bit -> right shift Aext 1 bit */
/*        32 bit -> right shift Aext 2 bits */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_extsram3_ctrl               0x0000000CU
#define Adr_NX50_ext_asyncmem_ctrl_extsram3_ctrl 0x1C00010CU
#define Adr_NX50_extsram3_ctrl                   0x1C00010CU
#define DFLT_VAL_NX50_extsram3_ctrl              0x0003033fU

#define MSK_NX50_extsram3_ctrl_WSExtMem3               0x0000003fU
#define SRT_NX50_extsram3_ctrl_WSExtMem3               0
#define DFLT_VAL_NX50_extsram3_ctrl_WSExtMem3          0x0000003fU
#define MSK_NX50_extsram3_ctrl_WSPrePauseExtMem3       0x00000300U
#define SRT_NX50_extsram3_ctrl_WSPrePauseExtMem3       8
#define DFLT_VAL_NX50_extsram3_ctrl_WSPrePauseExtMem3  0x00000300U
#define MSK_NX50_extsram3_ctrl_WSPostPauseExtMem3      0x00030000U
#define SRT_NX50_extsram3_ctrl_WSPostPauseExtMem3      16
#define DFLT_VAL_NX50_extsram3_ctrl_WSPostPauseExtMem3 0x00030000U
#define MSK_NX50_extsram3_ctrl_WidthExtMem3            0x03000000U
#define SRT_NX50_extsram3_ctrl_WidthExtMem3            24
#define DFLT_VAL_NX50_extsram3_ctrl_WidthExtMem3       0x00000000U

enum {
	BFW_NX50_extsram3_ctrl_WSExtMem3          = 6, /* [5:0] */
	BFW_NX50_extsram3_ctrl_reserved1          = 2, /* [7:6] */
	BFW_NX50_extsram3_ctrl_WSPrePauseExtMem3  = 2, /* [9:8] */
	BFW_NX50_extsram3_ctrl_reserved2          = 6, /* [15:10] */
	BFW_NX50_extsram3_ctrl_WSPostPauseExtMem3 = 2, /* [17:16] */
	BFW_NX50_extsram3_ctrl_reserved3          = 6, /* [23:18] */
	BFW_NX50_extsram3_ctrl_WidthExtMem3       = 2, /* [25:24] */
	BFW_NX50_extsram3_ctrl_reserved4          = 6  /* [31:26] */
};

typedef struct NX50_EXTSRAM3_CTRL_BIT_Ttag {
	unsigned int WSExtMem3          : BFW_NX50_extsram3_ctrl_WSExtMem3;          /* Waitstates 0 - 63 cycles                                             */
	unsigned int reserved1          : BFW_NX50_extsram3_ctrl_reserved1;          /* reserved                                                             */
	unsigned int WSPrePauseExtMem3  : BFW_NX50_extsram3_ctrl_WSPrePauseExtMem3;  /* additional Waitstates for setuptime nCS,Aext to nOE,nWE 0 - 3 cycles */
	unsigned int reserved2          : BFW_NX50_extsram3_ctrl_reserved2;          /* reserved                                                             */
	unsigned int WSPostPauseExtMem3 : BFW_NX50_extsram3_ctrl_WSPostPauseExtMem3; /* additional Waitstates after access 0 - 3 cycles                      */
	unsigned int reserved3          : BFW_NX50_extsram3_ctrl_reserved3;          /* reserved                                                             */
	unsigned int WidthExtMem3       : BFW_NX50_extsram3_ctrl_WidthExtMem3;       /* Datapath width of ExtMem3 area                                       */
	unsigned int reserved4          : BFW_NX50_extsram3_ctrl_reserved4;          /* reserved                                                             */
} NX50_EXTSRAM3_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX50_EXTSRAM3_CTRL_BIT_T bf;
} NX50_EXTSRAM3_CTRL_T;


/* ===================================================================== */

/* Area of ext_sdram_ctrl */

/* ===================================================================== */

#define Addr_NX50_ext_sdram_ctrl      0x1C000140U
#define NX50_NETX_MEM_SDRAM_CTRL_AREA 0x1C000140U

/* --------------------------------------------------------------------- */
/* Register sdram_general_ctrl */
/* => Control Register for external SDRAM access. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sdram_general_ctrl            0x00000000U
#define Adr_NX50_ext_sdram_ctrl_sdram_general_ctrl 0x1C000140U
#define Adr_NX50_sdram_general_ctrl                0x1C000140U
#define DFLT_VAL_NX50_sdram_general_ctrl           0x01000001U

#define MSK_NX50_sdram_general_ctrl_banks                0x00000003U
#define SRT_NX50_sdram_general_ctrl_banks                0
#define DFLT_VAL_NX50_sdram_general_ctrl_banks           0x00000001U
#define MSK_NX50_sdram_general_ctrl_rows                 0x00000070U
#define SRT_NX50_sdram_general_ctrl_rows                 4
#define DFLT_VAL_NX50_sdram_general_ctrl_rows            0x00000000U
#define MSK_NX50_sdram_general_ctrl_columns              0x00000700U
#define SRT_NX50_sdram_general_ctrl_columns              8
#define DFLT_VAL_NX50_sdram_general_ctrl_columns         0x00000000U
#define MSK_NX50_sdram_general_ctrl_dbus32               0x00010000U
#define SRT_NX50_sdram_general_ctrl_dbus32               16
#define DFLT_VAL_NX50_sdram_general_ctrl_dbus32          0x00000000U
#define MSK_NX50_sdram_general_ctrl_sdram_pwdn           0x00020000U
#define SRT_NX50_sdram_general_ctrl_sdram_pwdn           17
#define DFLT_VAL_NX50_sdram_general_ctrl_sdram_pwdn      0x00000000U
#define MSK_NX50_sdram_general_ctrl_extclk_en            0x00040000U
#define SRT_NX50_sdram_general_ctrl_extclk_en            18
#define DFLT_VAL_NX50_sdram_general_ctrl_extclk_en       0x00000000U
#define MSK_NX50_sdram_general_ctrl_ctrl_en              0x00080000U
#define SRT_NX50_sdram_general_ctrl_ctrl_en              19
#define DFLT_VAL_NX50_sdram_general_ctrl_ctrl_en         0x00000000U
#define MSK_NX50_sdram_general_ctrl_refresh_mode         0x03000000U
#define SRT_NX50_sdram_general_ctrl_refresh_mode         24
#define DFLT_VAL_NX50_sdram_general_ctrl_refresh_mode    0x01000000U
#define MSK_NX50_sdram_general_ctrl_sdram_ready          0x40000000U
#define SRT_NX50_sdram_general_ctrl_sdram_ready          30
#define DFLT_VAL_NX50_sdram_general_ctrl_sdram_ready     0x00000000U
#define MSK_NX50_sdram_general_ctrl_refresh_request      0x80000000U
#define SRT_NX50_sdram_general_ctrl_refresh_request      31
#define DFLT_VAL_NX50_sdram_general_ctrl_refresh_request 0x00000000U

enum {
	BFW_NX50_sdram_general_ctrl_banks           = 2, /* [1:0] */
	BFW_NX50_sdram_general_ctrl_reserved1       = 2, /* [3:2] */
	BFW_NX50_sdram_general_ctrl_rows            = 3, /* [6:4] */
	BFW_NX50_sdram_general_ctrl_reserved2       = 1, /* [7] */
	BFW_NX50_sdram_general_ctrl_columns         = 3, /* [10:8] */
	BFW_NX50_sdram_general_ctrl_reserved3       = 5, /* [15:11] */
	BFW_NX50_sdram_general_ctrl_dbus32          = 1, /* [16] */
	BFW_NX50_sdram_general_ctrl_sdram_pwdn      = 1, /* [17] */
	BFW_NX50_sdram_general_ctrl_extclk_en       = 1, /* [18] */
	BFW_NX50_sdram_general_ctrl_ctrl_en         = 1, /* [19] */
	BFW_NX50_sdram_general_ctrl_reserved4       = 4, /* [23:20] */
	BFW_NX50_sdram_general_ctrl_refresh_mode    = 2, /* [25:24] */
	BFW_NX50_sdram_general_ctrl_reserved5       = 4, /* [29:26] */
	BFW_NX50_sdram_general_ctrl_sdram_ready     = 1, /* [30] */
	BFW_NX50_sdram_general_ctrl_refresh_request = 1  /* [31] */
};

typedef struct NX50_SDRAM_GENERAL_CTRL_BIT_Ttag {
	unsigned int banks           : BFW_NX50_sdram_general_ctrl_banks;           /* Bank address coding.                                                                              */
	                                                                            /* 00 : 2                                                                                            */
	unsigned int reserved1       : BFW_NX50_sdram_general_ctrl_reserved1;       /* reserved                                                                                          */
	unsigned int rows            : BFW_NX50_sdram_general_ctrl_rows;            /* Row address coding.                                                                               */
	                                                                            /* 000 : 2k  (A0..A10) (default)                                                                     */
	unsigned int reserved2       : BFW_NX50_sdram_general_ctrl_reserved2;       /* reserved                                                                                          */
	unsigned int columns         : BFW_NX50_sdram_general_ctrl_columns;         /* Column address coding.                                                                            */
	                                                                            /* 000 : 256 (A0..A7) (default)                                                                      */
	unsigned int reserved3       : BFW_NX50_sdram_general_ctrl_reserved3;       /* reserved                                                                                          */
	unsigned int dbus32          : BFW_NX50_sdram_general_ctrl_dbus32;          /* SDRAM data bus width                                                                              */
	                                                                            /* 0: SDRAM data bus is 16 bit wide.  (default)                                                      */
	unsigned int sdram_pwdn      : BFW_NX50_sdram_general_ctrl_sdram_pwdn;      /* SDRAM power down                                                                                  */
	                                                                            /* If this bit is set, the Controller will move SDRAM to power down self refresh mode (no data loss) */
	unsigned int extclk_en       : BFW_NX50_sdram_general_ctrl_extclk_en;       /* external SDRAM clock enable                                                                       */
	                                                                            /* 0: SDRAM clock disabled.  (default)                                                               */
	unsigned int ctrl_en         : BFW_NX50_sdram_general_ctrl_ctrl_en;         /*  SDRAM controller enable                                                                          */
	                                                                            /*  The sdram_timing_ctrl-register can only be changed while this bit is 0.                          */
	unsigned int reserved4       : BFW_NX50_sdram_general_ctrl_reserved4;       /* reserved                                                                                          */
	unsigned int refresh_mode    : BFW_NX50_sdram_general_ctrl_refresh_mode;    /* Refresh request generation mode.                                                                  */
	                                                                            /* Refresh generation has always lower priority than accesses on external memory interface.          */
	unsigned int reserved5       : BFW_NX50_sdram_general_ctrl_reserved5;       /* reserved                                                                                          */
	unsigned int sdram_ready     : BFW_NX50_sdram_general_ctrl_sdram_ready;     /* SDRAM ready.                                                                                      */
	                                                                            /* This bit is set to 1 if SDRAM is ready for access. If sdram_general_ctrl.ctrl_en == 0 or          */
	unsigned int refresh_request : BFW_NX50_sdram_general_ctrl_refresh_request; /* Refresh request flag.                                                                             */
	                                                                            /* Refresh generation has always lower priority than accesses on external memory interface.          */
} NX50_SDRAM_GENERAL_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_SDRAM_GENERAL_CTRL_BIT_T bf;
} NX50_SDRAM_GENERAL_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register sdram_timing_ctrl */
/* => Control Register for external SDRAM access. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sdram_timing_ctrl            0x00000004U
#define Adr_NX50_ext_sdram_ctrl_sdram_timing_ctrl 0x1C000144U
#define Adr_NX50_sdram_timing_ctrl                0x1C000144U
#define DFLT_VAL_NX50_sdram_timing_ctrl           0x0381f7f3U

#define MSK_NX50_sdram_timing_ctrl_t_RCD                  0x00000003U
#define SRT_NX50_sdram_timing_ctrl_t_RCD                  0
#define DFLT_VAL_NX50_sdram_timing_ctrl_t_RCD             0x00000003U
#define MSK_NX50_sdram_timing_ctrl_t_WR                   0x00000030U
#define SRT_NX50_sdram_timing_ctrl_t_WR                   4
#define DFLT_VAL_NX50_sdram_timing_ctrl_t_WR              0x00000030U
#define MSK_NX50_sdram_timing_ctrl_t_RP                   0x000000c0U
#define SRT_NX50_sdram_timing_ctrl_t_RP                   6
#define DFLT_VAL_NX50_sdram_timing_ctrl_t_RP              0x000000c0U
#define MSK_NX50_sdram_timing_ctrl_t_RAS                  0x00000700U
#define SRT_NX50_sdram_timing_ctrl_t_RAS                  8
#define DFLT_VAL_NX50_sdram_timing_ctrl_t_RAS             0x00000700U
#define MSK_NX50_sdram_timing_ctrl_t_RFC                  0x0000f000U
#define SRT_NX50_sdram_timing_ctrl_t_RFC                  12
#define DFLT_VAL_NX50_sdram_timing_ctrl_t_RFC             0x0000f000U
#define MSK_NX50_sdram_timing_ctrl_t_REFI                 0x00030000U
#define SRT_NX50_sdram_timing_ctrl_t_REFI                 16
#define DFLT_VAL_NX50_sdram_timing_ctrl_t_REFI            0x00010000U
#define MSK_NX50_sdram_timing_ctrl_mem_sdclk_phase        0x00700000U
#define SRT_NX50_sdram_timing_ctrl_mem_sdclk_phase        20
#define DFLT_VAL_NX50_sdram_timing_ctrl_mem_sdclk_phase   0x00000000U
#define MSK_NX50_sdram_timing_ctrl_mem_sdclk_ssneg        0x00800000U
#define SRT_NX50_sdram_timing_ctrl_mem_sdclk_ssneg        23
#define DFLT_VAL_NX50_sdram_timing_ctrl_mem_sdclk_ssneg   0x00800000U
#define MSK_NX50_sdram_timing_ctrl_data_sample_phase      0x07000000U
#define SRT_NX50_sdram_timing_ctrl_data_sample_phase      24
#define DFLT_VAL_NX50_sdram_timing_ctrl_data_sample_phase 0x03000000U
#define MSK_NX50_sdram_timing_ctrl_bypass_neg_delay       0x10000000U
#define SRT_NX50_sdram_timing_ctrl_bypass_neg_delay       28
#define DFLT_VAL_NX50_sdram_timing_ctrl_bypass_neg_delay  0x00000000U

enum {
	BFW_NX50_sdram_timing_ctrl_t_RCD             = 2, /* [1:0] */
	BFW_NX50_sdram_timing_ctrl_reserved1         = 2, /* [3:2] */
	BFW_NX50_sdram_timing_ctrl_t_WR              = 2, /* [5:4] */
	BFW_NX50_sdram_timing_ctrl_t_RP              = 2, /* [7:6] */
	BFW_NX50_sdram_timing_ctrl_t_RAS             = 3, /* [10:8] */
	BFW_NX50_sdram_timing_ctrl_reserved2         = 1, /* [11] */
	BFW_NX50_sdram_timing_ctrl_t_RFC             = 4, /* [15:12] */
	BFW_NX50_sdram_timing_ctrl_t_REFI            = 2, /* [17:16] */
	BFW_NX50_sdram_timing_ctrl_reserved3         = 2, /* [19:18] */
	BFW_NX50_sdram_timing_ctrl_mem_sdclk_phase   = 3, /* [22:20] */
	BFW_NX50_sdram_timing_ctrl_mem_sdclk_ssneg   = 1, /* [23] */
	BFW_NX50_sdram_timing_ctrl_data_sample_phase = 3, /* [26:24] */
	BFW_NX50_sdram_timing_ctrl_reserved4         = 1, /* [27] */
	BFW_NX50_sdram_timing_ctrl_bypass_neg_delay  = 1, /* [28] */
	BFW_NX50_sdram_timing_ctrl_reserved5         = 3  /* [31:29] */
};

typedef struct NX50_SDRAM_TIMING_CTRL_BIT_Ttag {
	unsigned int t_RCD             : BFW_NX50_sdram_timing_ctrl_t_RCD;             /* ACTIVE to READ or WRITE time (RAS to CAS, clk = t_RCD)                                       */
	                                                                               /* This value will be also taken as t_RRD (ACTIVE bank A to ACTIVE bank B time)                 */
	unsigned int reserved1         : BFW_NX50_sdram_timing_ctrl_reserved1;         /* reserved                                                                                     */
	unsigned int t_WR              : BFW_NX50_sdram_timing_ctrl_t_WR;              /* Write recovery time (last write data to PRECHARGE)                                           */
	                                                                               /* 00 : 1 clk                                                                                   */
	unsigned int t_RP              : BFW_NX50_sdram_timing_ctrl_t_RP;              /* Precharge command period time (PRECHARGE to next command)                                    */
	                                                                               /* 00 : 1 clk                                                                                   */
	unsigned int t_RAS             : BFW_NX50_sdram_timing_ctrl_t_RAS;             /* ACTIVE to PRECHARGE command time (clk = t_RAS + 3)                                           */
	                                                                               /* 000 :  3 clks                                                                                */
	unsigned int reserved2         : BFW_NX50_sdram_timing_ctrl_reserved2;         /* reserved                                                                                     */
	unsigned int t_RFC             : BFW_NX50_sdram_timing_ctrl_t_RFC;             /* REFRESH to next command time (clk = tRFC + 4)                                                */
	                                                                               /* 0000 :  4 clks                                                                               */
	unsigned int t_REFI            : BFW_NX50_sdram_timing_ctrl_t_REFI;            /* Average periodic refresh interval (3.90 us * 2^t_REFI                                        */
	                                                                               /* 00 :   3.90 us                                                                               */
	unsigned int reserved3         : BFW_NX50_sdram_timing_ctrl_reserved3;         /* reserved                                                                                     */
	unsigned int mem_sdclk_phase   : BFW_NX50_sdram_timing_ctrl_mem_sdclk_phase;   /* MEM_SDCLK phase shift.                                                                       */
	                                                                               /* 0..5: adjustable phase-shift for external SDRAM clock depending on external capacitive       */
	unsigned int mem_sdclk_ssneg   : BFW_NX50_sdram_timing_ctrl_mem_sdclk_ssneg;   /* MEM_SDCLK start sample with negative clk400 edge for MEM_SDCLK phase shift                   */
	                                                                               /* 1: clk_memsig will be sampled for MEM_SDCLK-generation internally first on negedge of clk400 */
	unsigned int data_sample_phase : BFW_NX50_sdram_timing_ctrl_data_sample_phase; /* Data sample clock phase shift.                                                               */
	                                                                               /* 0..5: adjustable phase-shift for data sampling SDRAM loopback clock (clk_sdloopback)         */
	unsigned int reserved4         : BFW_NX50_sdram_timing_ctrl_reserved4;         /* reserved                                                                                     */
	unsigned int bypass_neg_delay  : BFW_NX50_sdram_timing_ctrl_bypass_neg_delay;  /* Bypass data sample clock phase shift.                                                        */
	                                                                               /* 0: use phase shifted (negative delayed) SDRAM loopback clock for data sampling.              */
	unsigned int reserved5         : BFW_NX50_sdram_timing_ctrl_reserved5;         /* reserved                                                                                     */
} NX50_SDRAM_TIMING_CTRL_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_SDRAM_TIMING_CTRL_BIT_T bf;
} NX50_SDRAM_TIMING_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register sdram_mr */
/* => Mode Register for all SDRAM device types and Extended Mode Register for DDR/DDR2-SDRAM-devices. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us */
/*    SDRAM memory initialisation procedure. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sdram_mr            0x00000008U
#define Adr_NX50_ext_sdram_ctrl_sdram_mr 0x1C000148U
#define Adr_NX50_sdram_mr                0x1C000148U
#define DFLT_VAL_NX50_sdram_mr           0x00000033U

#define MSK_NX50_sdram_mr_MR       0x00003fffU
#define SRT_NX50_sdram_mr_MR       0
#define DFLT_VAL_NX50_sdram_mr_MR  0x00000033U
#define MSK_NX50_sdram_mr_EMR      0x3fff0000U
#define SRT_NX50_sdram_mr_EMR      16
#define DFLT_VAL_NX50_sdram_mr_EMR 0x00000000U

enum {
	BFW_NX50_sdram_mr_MR        = 14, /* [13:0] */
	BFW_NX50_sdram_mr_reserved1 = 2,  /* [15:14] */
	BFW_NX50_sdram_mr_EMR       = 14, /* [29:16] */
	BFW_NX50_sdram_mr_reserved2 = 2   /* [31:30] */
};

typedef struct NX50_SDRAM_MR_BIT_Ttag {
	unsigned int MR        : BFW_NX50_sdram_mr_MR;        /* SDRAM Mode Register.                                                                        */
	                                                      /* CAS latency bits in modereg[6:4], only CL2 and CL3 are supported, not CL1; default is CL3   */
	unsigned int reserved1 : BFW_NX50_sdram_mr_reserved1; /* reserved                                                                                    */
	unsigned int EMR       : BFW_NX50_sdram_mr_EMR;       /* Extended Mode Register for DDR/DDR2 - SDRAM devices                                         */
	                                                      /* The following settings must not be changed because tey are not supported by the Controller: */
	unsigned int reserved2 : BFW_NX50_sdram_mr_reserved2; /* reserved                                                                                    */
} NX50_SDRAM_MR_BIT_T;

typedef union {
	unsigned int        val;
	NX50_SDRAM_MR_BIT_T bf;
} NX50_SDRAM_MR_T;

/* --------------------------------------------------------------------- */
/* Register sdram_emr2 */
/* => Extended Mode Registers EMR2 and EMR3 for DDR2 - SDRAM devices. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us */
/*    SDRAM memory initialisation procedure. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sdram_emr2            0x0000000CU
#define Adr_NX50_ext_sdram_ctrl_sdram_emr2 0x1C00014CU
#define Adr_NX50_sdram_emr2                0x1C00014CU
#define DFLT_VAL_NX50_sdram_emr2           0x00000000U

#define MSK_NX50_sdram_emr2_EMR2      0x00003fffU
#define SRT_NX50_sdram_emr2_EMR2      0
#define DFLT_VAL_NX50_sdram_emr2_EMR2 0x00000000U
#define MSK_NX50_sdram_emr2_EMR3      0x3fff0000U
#define SRT_NX50_sdram_emr2_EMR3      16
#define DFLT_VAL_NX50_sdram_emr2_EMR3 0x00000000U

enum {
	BFW_NX50_sdram_emr2_EMR2      = 14, /* [13:0] */
	BFW_NX50_sdram_emr2_reserved1 = 2,  /* [15:14] */
	BFW_NX50_sdram_emr2_EMR3      = 14, /* [29:16] */
	BFW_NX50_sdram_emr2_reserved2 = 2   /* [31:30] */
};

typedef struct NX50_SDRAM_EMR2_BIT_Ttag {
	unsigned int EMR2      : BFW_NX50_sdram_emr2_EMR2;      /* Extended Mode Register 2 for DDR2 - SDRAM devices                            */
	                                                        /* For further extensions. No Settings must be done, which affect non supported */
	unsigned int reserved1 : BFW_NX50_sdram_emr2_reserved1; /* reserved                                                                     */
	unsigned int EMR3      : BFW_NX50_sdram_emr2_EMR3;      /* Extended Mode Register 3 for DDR2 - SDRAM devices                            */
	                                                        /* For further extensions. No Settings must be done, which affect non supported */
	unsigned int reserved2 : BFW_NX50_sdram_emr2_reserved2; /* reserved                                                                     */
} NX50_SDRAM_EMR2_BIT_T;

typedef union {
	unsigned int          val;
	NX50_SDRAM_EMR2_BIT_T bf;
} NX50_SDRAM_EMR2_T;


/* ===================================================================== */

/* Area of extmem_priority_ctrl */

/* ===================================================================== */

#define Addr_NX50_extmem_priority_ctrl 0x1C000180U
#define NX50_NETX_MEM_PRIO_CTRL_AREA   0x1C000180U

/* --------------------------------------------------------------------- */
/* Register extmem_prio_timslot_ctrl */
/* =>  Memory interface master timeslot priority control register. */
/*     This register may be partially locked by the exmem_priority_lock-register in asic_ctrl-address area. */
/*     Note: */
/*     Any master can access in one timeslot ((ts_accessrate_mX*ts_length_mX)/64) + 1 times (i.e. at */
/*     maximum (ts_accessrate_mX)/64 bandwidth on external memory bus, ts_accessrate_mX is programmed */
/*     by extmem_prio_accesstime_ctrl-register). */
/*     Priority control will watch data accesses on external memory data bus (SDRAM and non SDRAM), */
/*     including pauses on non SDRAM-accesses, not including control commands to SDRAM. */
/*     Any master requesting more accesses will be forced to wait for the remaining timeslot. */
/*    -------------------------------------------------------- */
/*     Programmable timeslots are: */
/*        ts_length =  0 :             64 systen clock cycles (i.e  0.64us at 100MHz) */
/*        ts_length =  1 :            128 systen clock cycles (i.e  1.28us at 100MHz) */
/*        ts_length =  2 :            256 systen clock cycles (i.e  2.56us at 100MHz) */
/*        ts_length =  3 :            512 systen clock cycles (i.e  5.12us at 100MHz) */
/*        ts_length =  4 :           1024 systen clock cycles (i.e 10.24us at 100MHz) */
/*        ts_length =  5 :           2048 systen clock cycles (i.e 20.48us at 100MHz) */
/*        ts_length =  6 :           4096 systen clock cycles (i.e 40.96us at 100MHz) */
/*        ts_length =  7 :           8192 systen clock cycles (i.e 81.92us at 100MHz) */
/*    -------------------------------------------------------- */
/*     master channel m0: Host Bus Interface  (highest priority) */
/*     master channel m1: XC */
/*     master channel m2: ARM  channel (instruction and data) (lowest priority) */
/*     master channel m3: DMA-Controller */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_extmem_prio_timslot_ctrl                  0x00000000U
#define Adr_NX50_extmem_priority_ctrl_extmem_prio_timslot_ctrl 0x1C000180U
#define Adr_NX50_extmem_prio_timslot_ctrl                      0x1C000180U
#define DFLT_VAL_NX50_extmem_prio_timslot_ctrl                 0x00007777U

#define MSK_NX50_extmem_prio_timslot_ctrl_ts_length_HIF_mi      0x00000007U
#define SRT_NX50_extmem_prio_timslot_ctrl_ts_length_HIF_mi      0
#define DFLT_VAL_NX50_extmem_prio_timslot_ctrl_ts_length_HIF_mi 0x00000007U
#define MSK_NX50_extmem_prio_timslot_ctrl_ts_length_XC_mi       0x00000070U
#define SRT_NX50_extmem_prio_timslot_ctrl_ts_length_XC_mi       4
#define DFLT_VAL_NX50_extmem_prio_timslot_ctrl_ts_length_XC_mi  0x00000070U
#define MSK_NX50_extmem_prio_timslot_ctrl_ts_length_ARM_mi      0x00000700U
#define SRT_NX50_extmem_prio_timslot_ctrl_ts_length_ARM_mi      8
#define DFLT_VAL_NX50_extmem_prio_timslot_ctrl_ts_length_ARM_mi 0x00000700U
#define MSK_NX50_extmem_prio_timslot_ctrl_ts_length_DMA_mi      0x00007000U
#define SRT_NX50_extmem_prio_timslot_ctrl_ts_length_DMA_mi      12
#define DFLT_VAL_NX50_extmem_prio_timslot_ctrl_ts_length_DMA_mi 0x00007000U

enum {
	BFW_NX50_extmem_prio_timslot_ctrl_ts_length_HIF_mi = 3,  /* [2:0] */
	BFW_NX50_extmem_prio_timslot_ctrl_reserved1        = 1,  /* [3] */
	BFW_NX50_extmem_prio_timslot_ctrl_ts_length_XC_mi  = 3,  /* [6:4] */
	BFW_NX50_extmem_prio_timslot_ctrl_reserved2        = 1,  /* [7] */
	BFW_NX50_extmem_prio_timslot_ctrl_ts_length_ARM_mi = 3,  /* [10:8] */
	BFW_NX50_extmem_prio_timslot_ctrl_reserved3        = 1,  /* [11] */
	BFW_NX50_extmem_prio_timslot_ctrl_ts_length_DMA_mi = 3,  /* [14:12] */
	BFW_NX50_extmem_prio_timslot_ctrl_reserved4        = 17  /* [31:15] */
};

typedef struct NX50_EXTMEM_PRIO_TIMSLOT_CTRL_BIT_Ttag {
	unsigned int ts_length_HIF_mi : BFW_NX50_extmem_prio_timslot_ctrl_ts_length_HIF_mi; /* 0..7: the timeslot of master m0 is on external memory interface 64*2^ts_length_HIF_mi systen clock cycles */
	unsigned int reserved1        : BFW_NX50_extmem_prio_timslot_ctrl_reserved1;        /* reserved                                                                                                  */
	unsigned int ts_length_XC_mi  : BFW_NX50_extmem_prio_timslot_ctrl_ts_length_XC_mi;  /* 0..7: the timeslot of master m1 is on external memory interface 64*2^ts_length_XC_mi systen clock cycles  */
	unsigned int reserved2        : BFW_NX50_extmem_prio_timslot_ctrl_reserved2;        /* reserved                                                                                                  */
	unsigned int ts_length_ARM_mi : BFW_NX50_extmem_prio_timslot_ctrl_ts_length_ARM_mi; /* 0..7: the timeslot of master m2 is on external memory interface 64*2^ts_length_ARM_mi systen clock cycles */
	unsigned int reserved3        : BFW_NX50_extmem_prio_timslot_ctrl_reserved3;        /* reserved                                                                                                  */
	unsigned int ts_length_DMA_mi : BFW_NX50_extmem_prio_timslot_ctrl_ts_length_DMA_mi; /* 0..7: the timeslot of master m3 is on external memory interface 64*2^ts_length_DMA_mi systen clock cycles */
	unsigned int reserved4        : BFW_NX50_extmem_prio_timslot_ctrl_reserved4;        /* reserved                                                                                                  */
} NX50_EXTMEM_PRIO_TIMSLOT_CTRL_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_EXTMEM_PRIO_TIMSLOT_CTRL_BIT_T bf;
} NX50_EXTMEM_PRIO_TIMSLOT_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extmem_prio_accesstime_ctrl */
/* =>  Control Register for master channel accesses per timeslot on external meory interface. */
/*     This register may be partially locked by the exmem_priority_lock-register in asic_ctrl-address area. */
/*     For detailed priority controlling read note at extmem_prio_timslot_ctrl-register description. */
/*    -------------------------------------------------------- */
/*     master channel m0: Host Bus Interface  (highest priority) */
/*     master channel m1: XC */
/*     master channel m2: ARM channel (instruction and data) (lowest priority) */
/*     master channel m3: DMA-Controller */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_extmem_prio_accesstime_ctrl                  0x00000004U
#define Adr_NX50_extmem_priority_ctrl_extmem_prio_accesstime_ctrl 0x1C000184U
#define Adr_NX50_extmem_prio_accesstime_ctrl                      0x1C000184U
#define DFLT_VAL_NX50_extmem_prio_accesstime_ctrl                 0x00ffffffU

#define MSK_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi      0x0000003fU
#define SRT_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi      0
#define DFLT_VAL_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi 0x0000003fU
#define MSK_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi       0x00000fc0U
#define SRT_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi       6
#define DFLT_VAL_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi  0x00000fc0U
#define MSK_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_ARM_mi      0x0003f000U
#define SRT_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_ARM_mi      12
#define DFLT_VAL_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_ARM_mi 0x0003f000U
#define MSK_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_DMA_mi      0x00fc0000U
#define SRT_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_DMA_mi      18
#define DFLT_VAL_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_DMA_mi 0x00fc0000U

enum {
	BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi = 6, /* [5:0] */
	BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi  = 6, /* [11:6] */
	BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_ARM_mi = 6, /* [17:12] */
	BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_DMA_mi = 6, /* [23:18] */
	BFW_NX50_extmem_prio_accesstime_ctrl_reserved1            = 8  /* [31:24] */
};

typedef struct NX50_EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_Ttag {
	unsigned int ts_accessrate_HIF_mi : BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_HIF_mi; /* 0..63: master m0 is alowed to request ((ts_accessrate_HIF_mi*ts_length_HIF_mi)/64) + 1 accesses on external memory */
	unsigned int ts_accessrate_XC_mi  : BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_XC_mi;  /* 0..63: master m1 is alowed to request ((ts_accessrate_XC_mi*ts_length_XC_mi)/64) + 1 accesses on external memory   */
	unsigned int ts_accessrate_ARM_mi : BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_ARM_mi; /* 0..63: master m2 is alowed to request ((ts_accessrate_ARM_mi*ts_length_ARM_mi)/64) + 1 accesses on external memory */
	unsigned int ts_accessrate_DMA_mi : BFW_NX50_extmem_prio_accesstime_ctrl_ts_accessrate_DMA_mi; /* 0..63: master m3 is alowed to request ((ts_accessrate_DMA_mi*ts_length_DMA_mi)/64) + 1 accesses on external memory */
	unsigned int reserved1            : BFW_NX50_extmem_prio_accesstime_ctrl_reserved1;            /* reserved                                                                                                           */
} NX50_EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_T;

typedef union {
	unsigned int                           val;
	NX50_EXTMEM_PRIO_ACCESSTIME_CTRL_BIT_T bf;
} NX50_EXTMEM_PRIO_ACCESSTIME_CTRL_T;


/* ===================================================================== */

/* Area of watchdog */

/* ===================================================================== */

#define Addr_NX50_watchdog 0x1C000200U
#define NX50_NETX_WDG_AREA 0x1C000200U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl */
/* => netX System Watchdog Trigger Register. */
/*    The watchdog access code is generated by a pseudo random generator. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl      0x00000000U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl 0x1C000200U
#define Adr_NX50_netx_sys_wdg_ctrl          0x1C000200U
#define DFLT_VAL_NX50_netx_sys_wdg_ctrl     0x00000000U

#define MSK_NX50_netx_sys_wdg_ctrl_wdg_access_code            0x000fffffU
#define SRT_NX50_netx_sys_wdg_ctrl_wdg_access_code            0
#define DFLT_VAL_NX50_netx_sys_wdg_ctrl_wdg_access_code       0x00000000U
#define MSK_NX50_netx_sys_wdg_ctrl_irq_req_watchdog           0x01000000U
#define SRT_NX50_netx_sys_wdg_ctrl_irq_req_watchdog           24
#define DFLT_VAL_NX50_netx_sys_wdg_ctrl_irq_req_watchdog      0x00000000U
#define MSK_NX50_netx_sys_wdg_ctrl_wdg_counter_trigger_w      0x10000000U
#define SRT_NX50_netx_sys_wdg_ctrl_wdg_counter_trigger_w      28
#define DFLT_VAL_NX50_netx_sys_wdg_ctrl_wdg_counter_trigger_w 0x00000000U
#define MSK_NX50_netx_sys_wdg_ctrl_wdg_active_enable_w        0x20000000U
#define SRT_NX50_netx_sys_wdg_ctrl_wdg_active_enable_w        29
#define DFLT_VAL_NX50_netx_sys_wdg_ctrl_wdg_active_enable_w   0x00000000U
#define MSK_NX50_netx_sys_wdg_ctrl_write_enable               0x80000000U
#define SRT_NX50_netx_sys_wdg_ctrl_write_enable               31
#define DFLT_VAL_NX50_netx_sys_wdg_ctrl_write_enable          0x00000000U

enum {
	BFW_NX50_netx_sys_wdg_ctrl_wdg_access_code       = 20, /* [19:0] */
	BFW_NX50_netx_sys_wdg_ctrl_reserved1             = 4,  /* [23:20] */
	BFW_NX50_netx_sys_wdg_ctrl_irq_req_watchdog      = 1,  /* [24] */
	BFW_NX50_netx_sys_wdg_ctrl_reserved2             = 3,  /* [27:25] */
	BFW_NX50_netx_sys_wdg_ctrl_wdg_counter_trigger_w = 1,  /* [28] */
	BFW_NX50_netx_sys_wdg_ctrl_wdg_active_enable_w   = 1,  /* [29] */
	BFW_NX50_netx_sys_wdg_ctrl_reserved3             = 1,  /* [30] */
	BFW_NX50_netx_sys_wdg_ctrl_write_enable          = 1   /* [31] */
};

typedef struct NX50_NETX_SYS_WDG_CTRL_BIT_Ttag {
	unsigned int wdg_access_code       : BFW_NX50_netx_sys_wdg_ctrl_wdg_access_code;       /* Watchdog access code for triggering. A read access gives the next 16 bit code for trigger. */
	                                                                                       /* A write access with correct access code will trigger the watchdog counter.                 */
	unsigned int reserved1             : BFW_NX50_netx_sys_wdg_ctrl_reserved1;             /* reserved                                                                                   */
	unsigned int irq_req_watchdog      : BFW_NX50_netx_sys_wdg_ctrl_irq_req_watchdog;      /* IRQ request of watchdog, writing 1 deletes IRQ                                             */
	unsigned int reserved2             : BFW_NX50_netx_sys_wdg_ctrl_reserved2;             /* reserved                                                                                   */
	unsigned int wdg_counter_trigger_w : BFW_NX50_netx_sys_wdg_ctrl_wdg_counter_trigger_w; /* ???, write only register bit                                                               */
	unsigned int wdg_active_enable_w   : BFW_NX50_netx_sys_wdg_ctrl_wdg_active_enable_w;   /* ???, write only register bit                                                               */
	unsigned int reserved3             : BFW_NX50_netx_sys_wdg_ctrl_reserved3;             /* reserved                                                                                   */
	unsigned int write_enable          : BFW_NX50_netx_sys_wdg_ctrl_write_enable;          /* ???                                                                                        */
} NX50_NETX_SYS_WDG_CTRL_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_NETX_SYS_WDG_CTRL_BIT_T bf;
} NX50_NETX_SYS_WDG_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg */
/* => netX System Watchdog Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg      0x00000004U
#define Adr_NX50_watchdog_netx_sys_wdg 0x1C000204U
#define Adr_NX50_netx_sys_wdg          0x1C000204U

#define MSK_NX50_netx_sys_wdg_wdg_counter 0x0001ffffU
#define SRT_NX50_netx_sys_wdg_wdg_counter 0

enum {
	BFW_NX50_netx_sys_wdg_wdg_counter = 17, /* [16:0] */
	BFW_NX50_netx_sys_wdg_reserved1   = 15  /* [31:17] */
};

typedef struct NX50_NETX_SYS_WDG_BIT_Ttag {
	unsigned int wdg_counter : BFW_NX50_netx_sys_wdg_wdg_counter; /* Actual watchdog counter value */
	unsigned int reserved1   : BFW_NX50_netx_sys_wdg_reserved1;   /* reserved                      */
} NX50_NETX_SYS_WDG_BIT_T;

typedef union {
	unsigned int            val;
	NX50_NETX_SYS_WDG_BIT_T bf;
} NX50_NETX_SYS_WDG_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout */
/* => netX System Wachtdog Interrupt Timout Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout      0x00000008U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout 0x1C000208U
#define Adr_NX50_netx_sys_wdg_irq_timeout          0x1C000208U
#define DFLT_VAL_NX50_netx_sys_wdg_irq_timeout     0x00000000U

#define MSK_NX50_netx_sys_wdg_irq_timeout_wdg_irq_timeout      0x0000ffffU
#define SRT_NX50_netx_sys_wdg_irq_timeout_wdg_irq_timeout      0
#define DFLT_VAL_NX50_netx_sys_wdg_irq_timeout_wdg_irq_timeout 0x00000000U

enum {
	BFW_NX50_netx_sys_wdg_irq_timeout_wdg_irq_timeout = 16, /* [15:0] */
	BFW_NX50_netx_sys_wdg_irq_timeout_reserved1       = 16  /* [31:16] */
};

typedef struct NX50_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_Ttag {
	unsigned int wdg_irq_timeout : BFW_NX50_netx_sys_wdg_irq_timeout_wdg_irq_timeout; /* Watchdog interrupt timeout */
	unsigned int reserved1       : BFW_NX50_netx_sys_wdg_irq_timeout_reserved1;       /* reserved                   */
} NX50_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T bf;
} NX50_NETX_SYS_WDG_IRQ_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout */
/* => netX System Watchdog Reset Timeout Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout      0x0000000CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout 0x1C00020CU
#define Adr_NX50_netx_sys_wdg_res_timeout          0x1C00020CU
#define DFLT_VAL_NX50_netx_sys_wdg_res_timeout     0x00000000U

#define MSK_NX50_netx_sys_wdg_res_timeout_wdg_res_timeout      0x0000ffffU
#define SRT_NX50_netx_sys_wdg_res_timeout_wdg_res_timeout      0
#define DFLT_VAL_NX50_netx_sys_wdg_res_timeout_wdg_res_timeout 0x00000000U

enum {
	BFW_NX50_netx_sys_wdg_res_timeout_wdg_res_timeout = 16, /* [15:0] */
	BFW_NX50_netx_sys_wdg_res_timeout_reserved1       = 16  /* [31:16] */
};

typedef struct NX50_NETX_SYS_WDG_RES_TIMEOUT_BIT_Ttag {
	unsigned int wdg_res_timeout : BFW_NX50_netx_sys_wdg_res_timeout_wdg_res_timeout; /* Watchdog Reset Request Timeout */
	unsigned int reserved1       : BFW_NX50_netx_sys_wdg_res_timeout_reserved1;       /* reserved                       */
} NX50_NETX_SYS_WDG_RES_TIMEOUT_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_NETX_SYS_WDG_RES_TIMEOUT_BIT_T bf;
} NX50_NETX_SYS_WDG_RES_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror1 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror1      0x00000010U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror1 0x1C000210U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror1          0x1C000210U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror1 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror1      0x00000014U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror1 0x1C000214U
#define Adr_NX50_netx_sys_wdg_mirror1          0x1C000214U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror1 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror1      0x00000018U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror1 0x1C000218U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror1          0x1C000218U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror1 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror1      0x0000001CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror1 0x1C00021CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror1          0x1C00021CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror2 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror2      0x00000020U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror2 0x1C000220U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror2          0x1C000220U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror2 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror2      0x00000024U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror2 0x1C000224U
#define Adr_NX50_netx_sys_wdg_mirror2          0x1C000224U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror2 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror2      0x00000028U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror2 0x1C000228U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror2          0x1C000228U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror2 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror2      0x0000002CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror2 0x1C00022CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror2          0x1C00022CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror3 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror3      0x00000030U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror3 0x1C000230U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror3          0x1C000230U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror3 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror3      0x00000034U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror3 0x1C000234U
#define Adr_NX50_netx_sys_wdg_mirror3          0x1C000234U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror3 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror3      0x00000038U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror3 0x1C000238U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror3          0x1C000238U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror3 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror3      0x0000003CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror3 0x1C00023CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror3          0x1C00023CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror4 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror4      0x00000040U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror4 0x1C000240U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror4          0x1C000240U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror4 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror4      0x00000044U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror4 0x1C000244U
#define Adr_NX50_netx_sys_wdg_mirror4          0x1C000244U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror4 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror4      0x00000048U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror4 0x1C000248U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror4          0x1C000248U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror4 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror4      0x0000004CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror4 0x1C00024CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror4          0x1C00024CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror5 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror5      0x00000050U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror5 0x1C000250U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror5          0x1C000250U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror5 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror5      0x00000054U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror5 0x1C000254U
#define Adr_NX50_netx_sys_wdg_mirror5          0x1C000254U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror5 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror5      0x00000058U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror5 0x1C000258U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror5          0x1C000258U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror5 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror5      0x0000005CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror5 0x1C00025CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror5          0x1C00025CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror6 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror6      0x00000060U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror6 0x1C000260U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror6          0x1C000260U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror6 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror6      0x00000064U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror6 0x1C000264U
#define Adr_NX50_netx_sys_wdg_mirror6          0x1C000264U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror6 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror6      0x00000068U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror6 0x1C000268U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror6          0x1C000268U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror6 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror6      0x0000006CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror6 0x1C00026CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror6          0x1C00026CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror7 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror7      0x00000070U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror7 0x1C000270U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror7          0x1C000270U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror7 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror7      0x00000074U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror7 0x1C000274U
#define Adr_NX50_netx_sys_wdg_mirror7          0x1C000274U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror7 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror7      0x00000078U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror7 0x1C000278U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror7          0x1C000278U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror7 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror7      0x0000007CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror7 0x1C00027CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror7          0x1C00027CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror8 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror8      0x00000080U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror8 0x1C000280U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror8          0x1C000280U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror8 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror8      0x00000084U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror8 0x1C000284U
#define Adr_NX50_netx_sys_wdg_mirror8          0x1C000284U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror8 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror8      0x00000088U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror8 0x1C000288U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror8          0x1C000288U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror8 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror8      0x0000008CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror8 0x1C00028CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror8          0x1C00028CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror9 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror9      0x00000090U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror9 0x1C000290U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror9          0x1C000290U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror9 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror9      0x00000094U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror9 0x1C000294U
#define Adr_NX50_netx_sys_wdg_mirror9          0x1C000294U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror9 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror9      0x00000098U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror9 0x1C000298U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror9          0x1C000298U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror9 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror9      0x0000009CU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror9 0x1C00029CU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror9          0x1C00029CU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror10 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror10      0x000000A0U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror10 0x1C0002A0U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror10          0x1C0002A0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror10 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror10      0x000000A4U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror10 0x1C0002A4U
#define Adr_NX50_netx_sys_wdg_mirror10          0x1C0002A4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror10 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror10      0x000000A8U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror10 0x1C0002A8U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror10          0x1C0002A8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror10 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror10      0x000000ACU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror10 0x1C0002ACU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror10          0x1C0002ACU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror11 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror11      0x000000B0U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror11 0x1C0002B0U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror11          0x1C0002B0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror11 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror11      0x000000B4U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror11 0x1C0002B4U
#define Adr_NX50_netx_sys_wdg_mirror11          0x1C0002B4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror11 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror11      0x000000B8U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror11 0x1C0002B8U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror11          0x1C0002B8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror11 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror11      0x000000BCU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror11 0x1C0002BCU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror11          0x1C0002BCU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror12 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror12      0x000000C0U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror12 0x1C0002C0U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror12          0x1C0002C0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror12 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror12      0x000000C4U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror12 0x1C0002C4U
#define Adr_NX50_netx_sys_wdg_mirror12          0x1C0002C4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror12 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror12      0x000000C8U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror12 0x1C0002C8U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror12          0x1C0002C8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror12 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror12      0x000000CCU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror12 0x1C0002CCU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror12          0x1C0002CCU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror13 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror13      0x000000D0U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror13 0x1C0002D0U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror13          0x1C0002D0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror13 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror13      0x000000D4U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror13 0x1C0002D4U
#define Adr_NX50_netx_sys_wdg_mirror13          0x1C0002D4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror13 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror13      0x000000D8U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror13 0x1C0002D8U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror13          0x1C0002D8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror13 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror13      0x000000DCU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror13 0x1C0002DCU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror13          0x1C0002DCU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror14 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror14      0x000000E0U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror14 0x1C0002E0U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror14          0x1C0002E0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror14 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror14      0x000000E4U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror14 0x1C0002E4U
#define Adr_NX50_netx_sys_wdg_mirror14          0x1C0002E4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror14 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror14      0x000000E8U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror14 0x1C0002E8U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror14          0x1C0002E8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror14 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror14      0x000000ECU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror14 0x1C0002ECU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror14          0x1C0002ECU

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl_mirror15 */
/* => mirror of netx_sys_wdg_ctrl, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_ctrl_mirror15      0x000000F0U
#define Adr_NX50_watchdog_netx_sys_wdg_ctrl_mirror15 0x1C0002F0U
#define Adr_NX50_netx_sys_wdg_ctrl_mirror15          0x1C0002F0U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_mirror15 */
/* => mirror of netx_sys_wdg, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_mirror15      0x000000F4U
#define Adr_NX50_watchdog_netx_sys_wdg_mirror15 0x1C0002F4U
#define Adr_NX50_netx_sys_wdg_mirror15          0x1C0002F4U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout_mirror15 */
/* => mirror of netx_sys_wdg_irq_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_irq_timeout_mirror15      0x000000F8U
#define Adr_NX50_watchdog_netx_sys_wdg_irq_timeout_mirror15 0x1C0002F8U
#define Adr_NX50_netx_sys_wdg_irq_timeout_mirror15          0x1C0002F8U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout_mirror15 */
/* => mirror of netx_sys_wdg_res_timeout, DO NOT USE ! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_netx_sys_wdg_res_timeout_mirror15      0x000000FCU
#define Adr_NX50_watchdog_netx_sys_wdg_res_timeout_mirror15 0x1C0002FCU
#define Adr_NX50_netx_sys_wdg_res_timeout_mirror15          0x1C0002FCU


/* ===================================================================== */

/* Area of abort */

/* ===================================================================== */

#define Addr_NX50_abort      0x1C000300U
#define NX50_NETX_ABORT_AREA 0x1C000300U

/* ===================================================================== */

/* Area of gpio */

/* ===================================================================== */

#define Addr_NX50_gpio      0x1C000800U
#define NX50_NETX_GPIO_AREA 0x1C000800U

/* --------------------------------------------------------------------- */
/* Register gpio_cfg0 */
/* => GPIO pin 0 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg0  0x00000000U
#define Adr_NX50_gpio_gpio_cfg0 0x1C000800U
#define Adr_NX50_gpio_cfg0      0x1C000800U
#define DFLT_VAL_NX50_gpio_cfg0 0x00000000U

#define MSK_NX50_gpio_cfg0_mode           0x0000000fU
#define SRT_NX50_gpio_cfg0_mode           0
#define DFLT_VAL_NX50_gpio_cfg0_mode      0x00000000U
#define MSK_NX50_gpio_cfg0_inv            0x00000010U
#define SRT_NX50_gpio_cfg0_inv            4
#define DFLT_VAL_NX50_gpio_cfg0_inv       0x00000000U
#define MSK_NX50_gpio_cfg0_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg0_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg0_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg0_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg0_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg0_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg0_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG0_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg0_mode;      /* defines the gp input or output mode - depends on iocfg */
	                                                       /* Input modi :                                           */
	unsigned int inv       : BFW_NX50_gpio_cfg0_inv;       /* 1: invert input/output value                           */
	                                                       /* 0: don't invert input/output                           */
	unsigned int count_ref : BFW_NX50_gpio_cfg0_count_ref; /* counter reference                                      */
	                                                       /*  000: counter 0                                        */
	unsigned int reserved1 : BFW_NX50_gpio_cfg0_reserved1; /* reserved                                               */
} NX50_GPIO_CFG0_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG0_BIT_T bf;
} NX50_GPIO_CFG0_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg1 */
/* => GPIO pin 1 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg1  0x00000004U
#define Adr_NX50_gpio_gpio_cfg1 0x1C000804U
#define Adr_NX50_gpio_cfg1      0x1C000804U
#define DFLT_VAL_NX50_gpio_cfg1 0x00000000U

#define MSK_NX50_gpio_cfg1_mode           0x0000000fU
#define SRT_NX50_gpio_cfg1_mode           0
#define DFLT_VAL_NX50_gpio_cfg1_mode      0x00000000U
#define MSK_NX50_gpio_cfg1_inv            0x00000010U
#define SRT_NX50_gpio_cfg1_inv            4
#define DFLT_VAL_NX50_gpio_cfg1_inv       0x00000000U
#define MSK_NX50_gpio_cfg1_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg1_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg1_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg1_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg1_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg1_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg1_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG1_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg1_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg1_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg1_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg1_reserved1; /* reserved            */
} NX50_GPIO_CFG1_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG1_BIT_T bf;
} NX50_GPIO_CFG1_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg2 */
/* => GPIO pin 2 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg2  0x00000008U
#define Adr_NX50_gpio_gpio_cfg2 0x1C000808U
#define Adr_NX50_gpio_cfg2      0x1C000808U
#define DFLT_VAL_NX50_gpio_cfg2 0x00000000U

#define MSK_NX50_gpio_cfg2_mode           0x0000000fU
#define SRT_NX50_gpio_cfg2_mode           0
#define DFLT_VAL_NX50_gpio_cfg2_mode      0x00000000U
#define MSK_NX50_gpio_cfg2_inv            0x00000010U
#define SRT_NX50_gpio_cfg2_inv            4
#define DFLT_VAL_NX50_gpio_cfg2_inv       0x00000000U
#define MSK_NX50_gpio_cfg2_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg2_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg2_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg2_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg2_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg2_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg2_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG2_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg2_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg2_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg2_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg2_reserved1; /* reserved            */
} NX50_GPIO_CFG2_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG2_BIT_T bf;
} NX50_GPIO_CFG2_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg3 */
/* => GPIO pin 3 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg3  0x0000000CU
#define Adr_NX50_gpio_gpio_cfg3 0x1C00080CU
#define Adr_NX50_gpio_cfg3      0x1C00080CU
#define DFLT_VAL_NX50_gpio_cfg3 0x00000000U

#define MSK_NX50_gpio_cfg3_mode           0x0000000fU
#define SRT_NX50_gpio_cfg3_mode           0
#define DFLT_VAL_NX50_gpio_cfg3_mode      0x00000000U
#define MSK_NX50_gpio_cfg3_inv            0x00000010U
#define SRT_NX50_gpio_cfg3_inv            4
#define DFLT_VAL_NX50_gpio_cfg3_inv       0x00000000U
#define MSK_NX50_gpio_cfg3_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg3_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg3_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg3_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg3_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg3_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg3_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG3_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg3_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg3_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg3_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg3_reserved1; /* reserved            */
} NX50_GPIO_CFG3_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG3_BIT_T bf;
} NX50_GPIO_CFG3_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg4 */
/* => GPIO pin 4 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg4  0x00000010U
#define Adr_NX50_gpio_gpio_cfg4 0x1C000810U
#define Adr_NX50_gpio_cfg4      0x1C000810U
#define DFLT_VAL_NX50_gpio_cfg4 0x00000000U

#define MSK_NX50_gpio_cfg4_mode           0x0000000fU
#define SRT_NX50_gpio_cfg4_mode           0
#define DFLT_VAL_NX50_gpio_cfg4_mode      0x00000000U
#define MSK_NX50_gpio_cfg4_inv            0x00000010U
#define SRT_NX50_gpio_cfg4_inv            4
#define DFLT_VAL_NX50_gpio_cfg4_inv       0x00000000U
#define MSK_NX50_gpio_cfg4_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg4_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg4_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg4_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg4_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg4_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg4_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG4_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg4_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg4_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg4_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg4_reserved1; /* reserved            */
} NX50_GPIO_CFG4_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG4_BIT_T bf;
} NX50_GPIO_CFG4_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg5 */
/* => GPIO pin 5 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg5  0x00000014U
#define Adr_NX50_gpio_gpio_cfg5 0x1C000814U
#define Adr_NX50_gpio_cfg5      0x1C000814U
#define DFLT_VAL_NX50_gpio_cfg5 0x00000000U

#define MSK_NX50_gpio_cfg5_mode           0x0000000fU
#define SRT_NX50_gpio_cfg5_mode           0
#define DFLT_VAL_NX50_gpio_cfg5_mode      0x00000000U
#define MSK_NX50_gpio_cfg5_inv            0x00000010U
#define SRT_NX50_gpio_cfg5_inv            4
#define DFLT_VAL_NX50_gpio_cfg5_inv       0x00000000U
#define MSK_NX50_gpio_cfg5_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg5_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg5_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg5_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg5_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg5_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg5_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG5_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg5_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg5_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg5_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg5_reserved1; /* reserved            */
} NX50_GPIO_CFG5_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG5_BIT_T bf;
} NX50_GPIO_CFG5_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg6 */
/* => GPIO pin 6 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg6  0x00000018U
#define Adr_NX50_gpio_gpio_cfg6 0x1C000818U
#define Adr_NX50_gpio_cfg6      0x1C000818U
#define DFLT_VAL_NX50_gpio_cfg6 0x00000000U

#define MSK_NX50_gpio_cfg6_mode           0x0000000fU
#define SRT_NX50_gpio_cfg6_mode           0
#define DFLT_VAL_NX50_gpio_cfg6_mode      0x00000000U
#define MSK_NX50_gpio_cfg6_inv            0x00000010U
#define SRT_NX50_gpio_cfg6_inv            4
#define DFLT_VAL_NX50_gpio_cfg6_inv       0x00000000U
#define MSK_NX50_gpio_cfg6_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg6_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg6_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg6_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg6_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg6_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg6_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG6_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg6_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg6_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg6_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg6_reserved1; /* reserved            */
} NX50_GPIO_CFG6_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG6_BIT_T bf;
} NX50_GPIO_CFG6_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg7 */
/* => GPIO pin 7 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg7  0x0000001CU
#define Adr_NX50_gpio_gpio_cfg7 0x1C00081CU
#define Adr_NX50_gpio_cfg7      0x1C00081CU
#define DFLT_VAL_NX50_gpio_cfg7 0x00000000U

#define MSK_NX50_gpio_cfg7_mode           0x0000000fU
#define SRT_NX50_gpio_cfg7_mode           0
#define DFLT_VAL_NX50_gpio_cfg7_mode      0x00000000U
#define MSK_NX50_gpio_cfg7_inv            0x00000010U
#define SRT_NX50_gpio_cfg7_inv            4
#define DFLT_VAL_NX50_gpio_cfg7_inv       0x00000000U
#define MSK_NX50_gpio_cfg7_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg7_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg7_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg7_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg7_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg7_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg7_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG7_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg7_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg7_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg7_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg7_reserved1; /* reserved            */
} NX50_GPIO_CFG7_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG7_BIT_T bf;
} NX50_GPIO_CFG7_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg8 */
/* => GPIO pin 8 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg8  0x00000020U
#define Adr_NX50_gpio_gpio_cfg8 0x1C000820U
#define Adr_NX50_gpio_cfg8      0x1C000820U
#define DFLT_VAL_NX50_gpio_cfg8 0x00000000U

#define MSK_NX50_gpio_cfg8_mode           0x0000000fU
#define SRT_NX50_gpio_cfg8_mode           0
#define DFLT_VAL_NX50_gpio_cfg8_mode      0x00000000U
#define MSK_NX50_gpio_cfg8_inv            0x00000010U
#define SRT_NX50_gpio_cfg8_inv            4
#define DFLT_VAL_NX50_gpio_cfg8_inv       0x00000000U
#define MSK_NX50_gpio_cfg8_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg8_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg8_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg8_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg8_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg8_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg8_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG8_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg8_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg8_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg8_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg8_reserved1; /* reserved            */
} NX50_GPIO_CFG8_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG8_BIT_T bf;
} NX50_GPIO_CFG8_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg9 */
/* => GPIO pin 9 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg9  0x00000024U
#define Adr_NX50_gpio_gpio_cfg9 0x1C000824U
#define Adr_NX50_gpio_cfg9      0x1C000824U
#define DFLT_VAL_NX50_gpio_cfg9 0x00000000U

#define MSK_NX50_gpio_cfg9_mode           0x0000000fU
#define SRT_NX50_gpio_cfg9_mode           0
#define DFLT_VAL_NX50_gpio_cfg9_mode      0x00000000U
#define MSK_NX50_gpio_cfg9_inv            0x00000010U
#define SRT_NX50_gpio_cfg9_inv            4
#define DFLT_VAL_NX50_gpio_cfg9_inv       0x00000000U
#define MSK_NX50_gpio_cfg9_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg9_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg9_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg9_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg9_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg9_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg9_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG9_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg9_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg9_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg9_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg9_reserved1; /* reserved            */
} NX50_GPIO_CFG9_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_CFG9_BIT_T bf;
} NX50_GPIO_CFG9_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg10 */
/* => GPIO pin 10 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg10  0x00000028U
#define Adr_NX50_gpio_gpio_cfg10 0x1C000828U
#define Adr_NX50_gpio_cfg10      0x1C000828U
#define DFLT_VAL_NX50_gpio_cfg10 0x00000000U

#define MSK_NX50_gpio_cfg10_mode           0x0000000fU
#define SRT_NX50_gpio_cfg10_mode           0
#define DFLT_VAL_NX50_gpio_cfg10_mode      0x00000000U
#define MSK_NX50_gpio_cfg10_inv            0x00000010U
#define SRT_NX50_gpio_cfg10_inv            4
#define DFLT_VAL_NX50_gpio_cfg10_inv       0x00000000U
#define MSK_NX50_gpio_cfg10_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg10_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg10_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg10_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg10_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg10_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg10_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG10_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg10_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg10_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg10_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg10_reserved1; /* reserved            */
} NX50_GPIO_CFG10_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG10_BIT_T bf;
} NX50_GPIO_CFG10_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg11 */
/* => GPIO pin 11 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg11  0x0000002CU
#define Adr_NX50_gpio_gpio_cfg11 0x1C00082CU
#define Adr_NX50_gpio_cfg11      0x1C00082CU
#define DFLT_VAL_NX50_gpio_cfg11 0x00000000U

#define MSK_NX50_gpio_cfg11_mode           0x0000000fU
#define SRT_NX50_gpio_cfg11_mode           0
#define DFLT_VAL_NX50_gpio_cfg11_mode      0x00000000U
#define MSK_NX50_gpio_cfg11_inv            0x00000010U
#define SRT_NX50_gpio_cfg11_inv            4
#define DFLT_VAL_NX50_gpio_cfg11_inv       0x00000000U
#define MSK_NX50_gpio_cfg11_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg11_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg11_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg11_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg11_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg11_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg11_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG11_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg11_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg11_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg11_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg11_reserved1; /* reserved            */
} NX50_GPIO_CFG11_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG11_BIT_T bf;
} NX50_GPIO_CFG11_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg12 */
/* => GPIO pin 12 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg12  0x00000030U
#define Adr_NX50_gpio_gpio_cfg12 0x1C000830U
#define Adr_NX50_gpio_cfg12      0x1C000830U
#define DFLT_VAL_NX50_gpio_cfg12 0x00000000U

#define MSK_NX50_gpio_cfg12_mode           0x0000000fU
#define SRT_NX50_gpio_cfg12_mode           0
#define DFLT_VAL_NX50_gpio_cfg12_mode      0x00000000U
#define MSK_NX50_gpio_cfg12_inv            0x00000010U
#define SRT_NX50_gpio_cfg12_inv            4
#define DFLT_VAL_NX50_gpio_cfg12_inv       0x00000000U
#define MSK_NX50_gpio_cfg12_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg12_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg12_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg12_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg12_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg12_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg12_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG12_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg12_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg12_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg12_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg12_reserved1; /* reserved            */
} NX50_GPIO_CFG12_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG12_BIT_T bf;
} NX50_GPIO_CFG12_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg13 */
/* => GPIO pin 13 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg13  0x00000034U
#define Adr_NX50_gpio_gpio_cfg13 0x1C000834U
#define Adr_NX50_gpio_cfg13      0x1C000834U
#define DFLT_VAL_NX50_gpio_cfg13 0x00000000U

#define MSK_NX50_gpio_cfg13_mode           0x0000000fU
#define SRT_NX50_gpio_cfg13_mode           0
#define DFLT_VAL_NX50_gpio_cfg13_mode      0x00000000U
#define MSK_NX50_gpio_cfg13_inv            0x00000010U
#define SRT_NX50_gpio_cfg13_inv            4
#define DFLT_VAL_NX50_gpio_cfg13_inv       0x00000000U
#define MSK_NX50_gpio_cfg13_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg13_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg13_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg13_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg13_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg13_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg13_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG13_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg13_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg13_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg13_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg13_reserved1; /* reserved            */
} NX50_GPIO_CFG13_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG13_BIT_T bf;
} NX50_GPIO_CFG13_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg14 */
/* => GPIO pin 14 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg14  0x00000038U
#define Adr_NX50_gpio_gpio_cfg14 0x1C000838U
#define Adr_NX50_gpio_cfg14      0x1C000838U
#define DFLT_VAL_NX50_gpio_cfg14 0x00000000U

#define MSK_NX50_gpio_cfg14_mode           0x0000000fU
#define SRT_NX50_gpio_cfg14_mode           0
#define DFLT_VAL_NX50_gpio_cfg14_mode      0x00000000U
#define MSK_NX50_gpio_cfg14_inv            0x00000010U
#define SRT_NX50_gpio_cfg14_inv            4
#define DFLT_VAL_NX50_gpio_cfg14_inv       0x00000000U
#define MSK_NX50_gpio_cfg14_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg14_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg14_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg14_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg14_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg14_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg14_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG14_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg14_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg14_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg14_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg14_reserved1; /* reserved            */
} NX50_GPIO_CFG14_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG14_BIT_T bf;
} NX50_GPIO_CFG14_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg15 */
/* => GPIO pin 15 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg15  0x0000003CU
#define Adr_NX50_gpio_gpio_cfg15 0x1C00083CU
#define Adr_NX50_gpio_cfg15      0x1C00083CU
#define DFLT_VAL_NX50_gpio_cfg15 0x00000000U

#define MSK_NX50_gpio_cfg15_mode           0x0000000fU
#define SRT_NX50_gpio_cfg15_mode           0
#define DFLT_VAL_NX50_gpio_cfg15_mode      0x00000000U
#define MSK_NX50_gpio_cfg15_inv            0x00000010U
#define SRT_NX50_gpio_cfg15_inv            4
#define DFLT_VAL_NX50_gpio_cfg15_inv       0x00000000U
#define MSK_NX50_gpio_cfg15_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg15_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg15_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg15_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg15_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg15_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg15_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG15_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg15_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg15_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg15_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg15_reserved1; /* reserved            */
} NX50_GPIO_CFG15_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG15_BIT_T bf;
} NX50_GPIO_CFG15_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg16 */
/* => GPIO pin 16 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg16  0x00000040U
#define Adr_NX50_gpio_gpio_cfg16 0x1C000840U
#define Adr_NX50_gpio_cfg16      0x1C000840U
#define DFLT_VAL_NX50_gpio_cfg16 0x00000000U

#define MSK_NX50_gpio_cfg16_mode           0x0000000fU
#define SRT_NX50_gpio_cfg16_mode           0
#define DFLT_VAL_NX50_gpio_cfg16_mode      0x00000000U
#define MSK_NX50_gpio_cfg16_inv            0x00000010U
#define SRT_NX50_gpio_cfg16_inv            4
#define DFLT_VAL_NX50_gpio_cfg16_inv       0x00000000U
#define MSK_NX50_gpio_cfg16_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg16_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg16_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg16_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg16_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg16_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg16_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG16_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg16_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg16_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg16_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg16_reserved1; /* reserved            */
} NX50_GPIO_CFG16_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG16_BIT_T bf;
} NX50_GPIO_CFG16_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg17 */
/* => GPIO pin 17 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg17  0x00000044U
#define Adr_NX50_gpio_gpio_cfg17 0x1C000844U
#define Adr_NX50_gpio_cfg17      0x1C000844U
#define DFLT_VAL_NX50_gpio_cfg17 0x00000000U

#define MSK_NX50_gpio_cfg17_mode           0x0000000fU
#define SRT_NX50_gpio_cfg17_mode           0
#define DFLT_VAL_NX50_gpio_cfg17_mode      0x00000000U
#define MSK_NX50_gpio_cfg17_inv            0x00000010U
#define SRT_NX50_gpio_cfg17_inv            4
#define DFLT_VAL_NX50_gpio_cfg17_inv       0x00000000U
#define MSK_NX50_gpio_cfg17_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg17_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg17_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg17_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg17_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg17_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg17_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG17_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg17_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg17_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg17_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg17_reserved1; /* reserved            */
} NX50_GPIO_CFG17_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG17_BIT_T bf;
} NX50_GPIO_CFG17_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg18 */
/* => GPIO pin 18 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg18  0x00000048U
#define Adr_NX50_gpio_gpio_cfg18 0x1C000848U
#define Adr_NX50_gpio_cfg18      0x1C000848U
#define DFLT_VAL_NX50_gpio_cfg18 0x00000000U

#define MSK_NX50_gpio_cfg18_mode           0x0000000fU
#define SRT_NX50_gpio_cfg18_mode           0
#define DFLT_VAL_NX50_gpio_cfg18_mode      0x00000000U
#define MSK_NX50_gpio_cfg18_inv            0x00000010U
#define SRT_NX50_gpio_cfg18_inv            4
#define DFLT_VAL_NX50_gpio_cfg18_inv       0x00000000U
#define MSK_NX50_gpio_cfg18_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg18_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg18_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg18_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg18_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg18_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg18_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG18_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg18_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg18_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg18_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg18_reserved1; /* reserved            */
} NX50_GPIO_CFG18_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG18_BIT_T bf;
} NX50_GPIO_CFG18_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg19 */
/* => GPIO pin 19 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg19  0x0000004CU
#define Adr_NX50_gpio_gpio_cfg19 0x1C00084CU
#define Adr_NX50_gpio_cfg19      0x1C00084CU
#define DFLT_VAL_NX50_gpio_cfg19 0x00000000U

#define MSK_NX50_gpio_cfg19_mode           0x0000000fU
#define SRT_NX50_gpio_cfg19_mode           0
#define DFLT_VAL_NX50_gpio_cfg19_mode      0x00000000U
#define MSK_NX50_gpio_cfg19_inv            0x00000010U
#define SRT_NX50_gpio_cfg19_inv            4
#define DFLT_VAL_NX50_gpio_cfg19_inv       0x00000000U
#define MSK_NX50_gpio_cfg19_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg19_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg19_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg19_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg19_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg19_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg19_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG19_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg19_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg19_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg19_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg19_reserved1; /* reserved            */
} NX50_GPIO_CFG19_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG19_BIT_T bf;
} NX50_GPIO_CFG19_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg20 */
/* => GPIO pin 20 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg20  0x00000050U
#define Adr_NX50_gpio_gpio_cfg20 0x1C000850U
#define Adr_NX50_gpio_cfg20      0x1C000850U
#define DFLT_VAL_NX50_gpio_cfg20 0x00000000U

#define MSK_NX50_gpio_cfg20_mode           0x0000000fU
#define SRT_NX50_gpio_cfg20_mode           0
#define DFLT_VAL_NX50_gpio_cfg20_mode      0x00000000U
#define MSK_NX50_gpio_cfg20_inv            0x00000010U
#define SRT_NX50_gpio_cfg20_inv            4
#define DFLT_VAL_NX50_gpio_cfg20_inv       0x00000000U
#define MSK_NX50_gpio_cfg20_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg20_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg20_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg20_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg20_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg20_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg20_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG20_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg20_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg20_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg20_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg20_reserved1; /* reserved            */
} NX50_GPIO_CFG20_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG20_BIT_T bf;
} NX50_GPIO_CFG20_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg21 */
/* => GPIO pin 21 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg21  0x00000054U
#define Adr_NX50_gpio_gpio_cfg21 0x1C000854U
#define Adr_NX50_gpio_cfg21      0x1C000854U
#define DFLT_VAL_NX50_gpio_cfg21 0x00000000U

#define MSK_NX50_gpio_cfg21_mode           0x0000000fU
#define SRT_NX50_gpio_cfg21_mode           0
#define DFLT_VAL_NX50_gpio_cfg21_mode      0x00000000U
#define MSK_NX50_gpio_cfg21_inv            0x00000010U
#define SRT_NX50_gpio_cfg21_inv            4
#define DFLT_VAL_NX50_gpio_cfg21_inv       0x00000000U
#define MSK_NX50_gpio_cfg21_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg21_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg21_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg21_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg21_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg21_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg21_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG21_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg21_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg21_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg21_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg21_reserved1; /* reserved            */
} NX50_GPIO_CFG21_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG21_BIT_T bf;
} NX50_GPIO_CFG21_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg22 */
/* => GPIO pin 22 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg22  0x00000058U
#define Adr_NX50_gpio_gpio_cfg22 0x1C000858U
#define Adr_NX50_gpio_cfg22      0x1C000858U
#define DFLT_VAL_NX50_gpio_cfg22 0x00000000U

#define MSK_NX50_gpio_cfg22_mode           0x0000000fU
#define SRT_NX50_gpio_cfg22_mode           0
#define DFLT_VAL_NX50_gpio_cfg22_mode      0x00000000U
#define MSK_NX50_gpio_cfg22_inv            0x00000010U
#define SRT_NX50_gpio_cfg22_inv            4
#define DFLT_VAL_NX50_gpio_cfg22_inv       0x00000000U
#define MSK_NX50_gpio_cfg22_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg22_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg22_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg22_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg22_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg22_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg22_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG22_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg22_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg22_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg22_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg22_reserved1; /* reserved            */
} NX50_GPIO_CFG22_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG22_BIT_T bf;
} NX50_GPIO_CFG22_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg23 */
/* => GPIO pin 23 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg23  0x0000005CU
#define Adr_NX50_gpio_gpio_cfg23 0x1C00085CU
#define Adr_NX50_gpio_cfg23      0x1C00085CU
#define DFLT_VAL_NX50_gpio_cfg23 0x00000000U

#define MSK_NX50_gpio_cfg23_mode           0x0000000fU
#define SRT_NX50_gpio_cfg23_mode           0
#define DFLT_VAL_NX50_gpio_cfg23_mode      0x00000000U
#define MSK_NX50_gpio_cfg23_inv            0x00000010U
#define SRT_NX50_gpio_cfg23_inv            4
#define DFLT_VAL_NX50_gpio_cfg23_inv       0x00000000U
#define MSK_NX50_gpio_cfg23_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg23_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg23_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg23_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg23_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg23_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg23_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG23_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg23_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg23_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg23_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg23_reserved1; /* reserved            */
} NX50_GPIO_CFG23_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG23_BIT_T bf;
} NX50_GPIO_CFG23_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg24 */
/* => GPIO pin 24 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg24  0x00000060U
#define Adr_NX50_gpio_gpio_cfg24 0x1C000860U
#define Adr_NX50_gpio_cfg24      0x1C000860U
#define DFLT_VAL_NX50_gpio_cfg24 0x00000000U

#define MSK_NX50_gpio_cfg24_mode           0x0000000fU
#define SRT_NX50_gpio_cfg24_mode           0
#define DFLT_VAL_NX50_gpio_cfg24_mode      0x00000000U
#define MSK_NX50_gpio_cfg24_inv            0x00000010U
#define SRT_NX50_gpio_cfg24_inv            4
#define DFLT_VAL_NX50_gpio_cfg24_inv       0x00000000U
#define MSK_NX50_gpio_cfg24_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg24_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg24_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg24_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg24_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg24_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg24_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG24_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg24_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg24_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg24_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg24_reserved1; /* reserved            */
} NX50_GPIO_CFG24_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG24_BIT_T bf;
} NX50_GPIO_CFG24_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg25 */
/* => GPIO pin 25 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg25  0x00000064U
#define Adr_NX50_gpio_gpio_cfg25 0x1C000864U
#define Adr_NX50_gpio_cfg25      0x1C000864U
#define DFLT_VAL_NX50_gpio_cfg25 0x00000000U

#define MSK_NX50_gpio_cfg25_mode           0x0000000fU
#define SRT_NX50_gpio_cfg25_mode           0
#define DFLT_VAL_NX50_gpio_cfg25_mode      0x00000000U
#define MSK_NX50_gpio_cfg25_inv            0x00000010U
#define SRT_NX50_gpio_cfg25_inv            4
#define DFLT_VAL_NX50_gpio_cfg25_inv       0x00000000U
#define MSK_NX50_gpio_cfg25_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg25_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg25_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg25_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg25_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg25_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg25_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG25_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg25_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg25_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg25_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg25_reserved1; /* reserved            */
} NX50_GPIO_CFG25_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG25_BIT_T bf;
} NX50_GPIO_CFG25_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg26 */
/* => GPIO pin 26 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg26  0x00000068U
#define Adr_NX50_gpio_gpio_cfg26 0x1C000868U
#define Adr_NX50_gpio_cfg26      0x1C000868U
#define DFLT_VAL_NX50_gpio_cfg26 0x00000000U

#define MSK_NX50_gpio_cfg26_mode           0x0000000fU
#define SRT_NX50_gpio_cfg26_mode           0
#define DFLT_VAL_NX50_gpio_cfg26_mode      0x00000000U
#define MSK_NX50_gpio_cfg26_inv            0x00000010U
#define SRT_NX50_gpio_cfg26_inv            4
#define DFLT_VAL_NX50_gpio_cfg26_inv       0x00000000U
#define MSK_NX50_gpio_cfg26_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg26_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg26_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg26_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg26_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg26_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg26_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG26_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg26_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg26_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg26_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg26_reserved1; /* reserved            */
} NX50_GPIO_CFG26_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG26_BIT_T bf;
} NX50_GPIO_CFG26_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg27 */
/* => GPIO pin 27 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg27  0x0000006CU
#define Adr_NX50_gpio_gpio_cfg27 0x1C00086CU
#define Adr_NX50_gpio_cfg27      0x1C00086CU
#define DFLT_VAL_NX50_gpio_cfg27 0x00000000U

#define MSK_NX50_gpio_cfg27_mode           0x0000000fU
#define SRT_NX50_gpio_cfg27_mode           0
#define DFLT_VAL_NX50_gpio_cfg27_mode      0x00000000U
#define MSK_NX50_gpio_cfg27_inv            0x00000010U
#define SRT_NX50_gpio_cfg27_inv            4
#define DFLT_VAL_NX50_gpio_cfg27_inv       0x00000000U
#define MSK_NX50_gpio_cfg27_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg27_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg27_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg27_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg27_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg27_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg27_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG27_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg27_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg27_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg27_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg27_reserved1; /* reserved            */
} NX50_GPIO_CFG27_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG27_BIT_T bf;
} NX50_GPIO_CFG27_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg28 */
/* => GPIO pin 28 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg28  0x00000070U
#define Adr_NX50_gpio_gpio_cfg28 0x1C000870U
#define Adr_NX50_gpio_cfg28      0x1C000870U
#define DFLT_VAL_NX50_gpio_cfg28 0x00000000U

#define MSK_NX50_gpio_cfg28_mode           0x0000000fU
#define SRT_NX50_gpio_cfg28_mode           0
#define DFLT_VAL_NX50_gpio_cfg28_mode      0x00000000U
#define MSK_NX50_gpio_cfg28_inv            0x00000010U
#define SRT_NX50_gpio_cfg28_inv            4
#define DFLT_VAL_NX50_gpio_cfg28_inv       0x00000000U
#define MSK_NX50_gpio_cfg28_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg28_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg28_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg28_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg28_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg28_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg28_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG28_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg28_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg28_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg28_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg28_reserved1; /* reserved            */
} NX50_GPIO_CFG28_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG28_BIT_T bf;
} NX50_GPIO_CFG28_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg29 */
/* => GPIO pin 29 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg29  0x00000074U
#define Adr_NX50_gpio_gpio_cfg29 0x1C000874U
#define Adr_NX50_gpio_cfg29      0x1C000874U
#define DFLT_VAL_NX50_gpio_cfg29 0x00000000U

#define MSK_NX50_gpio_cfg29_mode           0x0000000fU
#define SRT_NX50_gpio_cfg29_mode           0
#define DFLT_VAL_NX50_gpio_cfg29_mode      0x00000000U
#define MSK_NX50_gpio_cfg29_inv            0x00000010U
#define SRT_NX50_gpio_cfg29_inv            4
#define DFLT_VAL_NX50_gpio_cfg29_inv       0x00000000U
#define MSK_NX50_gpio_cfg29_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg29_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg29_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg29_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg29_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg29_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg29_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG29_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg29_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg29_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg29_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg29_reserved1; /* reserved            */
} NX50_GPIO_CFG29_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG29_BIT_T bf;
} NX50_GPIO_CFG29_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg30 */
/* => GPIO pin 30 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg30  0x00000078U
#define Adr_NX50_gpio_gpio_cfg30 0x1C000878U
#define Adr_NX50_gpio_cfg30      0x1C000878U
#define DFLT_VAL_NX50_gpio_cfg30 0x00000000U

#define MSK_NX50_gpio_cfg30_mode           0x0000000fU
#define SRT_NX50_gpio_cfg30_mode           0
#define DFLT_VAL_NX50_gpio_cfg30_mode      0x00000000U
#define MSK_NX50_gpio_cfg30_inv            0x00000010U
#define SRT_NX50_gpio_cfg30_inv            4
#define DFLT_VAL_NX50_gpio_cfg30_inv       0x00000000U
#define MSK_NX50_gpio_cfg30_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg30_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg30_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg30_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg30_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg30_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg30_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG30_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg30_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg30_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg30_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg30_reserved1; /* reserved            */
} NX50_GPIO_CFG30_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG30_BIT_T bf;
} NX50_GPIO_CFG30_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg31 */
/* => GPIO pin 31 config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_cfg31  0x0000007CU
#define Adr_NX50_gpio_gpio_cfg31 0x1C00087CU
#define Adr_NX50_gpio_cfg31      0x1C00087CU
#define DFLT_VAL_NX50_gpio_cfg31 0x00000000U

#define MSK_NX50_gpio_cfg31_mode           0x0000000fU
#define SRT_NX50_gpio_cfg31_mode           0
#define DFLT_VAL_NX50_gpio_cfg31_mode      0x00000000U
#define MSK_NX50_gpio_cfg31_inv            0x00000010U
#define SRT_NX50_gpio_cfg31_inv            4
#define DFLT_VAL_NX50_gpio_cfg31_inv       0x00000000U
#define MSK_NX50_gpio_cfg31_count_ref      0x000000e0U
#define SRT_NX50_gpio_cfg31_count_ref      5
#define DFLT_VAL_NX50_gpio_cfg31_count_ref 0x00000000U

enum {
	BFW_NX50_gpio_cfg31_mode      = 4,  /* [3:0] */
	BFW_NX50_gpio_cfg31_inv       = 1,  /* [4] */
	BFW_NX50_gpio_cfg31_count_ref = 3,  /* [7:5] */
	BFW_NX50_gpio_cfg31_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_GPIO_CFG31_BIT_Ttag {
	unsigned int mode      : BFW_NX50_gpio_cfg31_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX50_gpio_cfg31_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX50_gpio_cfg31_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : BFW_NX50_gpio_cfg31_reserved1; /* reserved            */
} NX50_GPIO_CFG31_BIT_T;

typedef union {
	unsigned int          val;
	NX50_GPIO_CFG31_BIT_T bf;
} NX50_GPIO_CFG31_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc0 */
/* => GPIO pin 0 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc0  0x00000080U
#define Adr_NX50_gpio_gpio_tc0 0x1C000880U
#define Adr_NX50_gpio_tc0      0x1C000880U
#define DFLT_VAL_NX50_gpio_tc0 0x00000000U

#define MSK_NX50_gpio_tc0_val      0xffffffffU
#define SRT_NX50_gpio_tc0_val      0
#define DFLT_VAL_NX50_gpio_tc0_val 0x00000000U

enum {
	BFW_NX50_gpio_tc0_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC0_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc0_val; /* Treshold/Capture register: */
	                                          /* PWM mode (treshold):       */
} NX50_GPIO_TC0_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC0_BIT_T bf;
} NX50_GPIO_TC0_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc1 */
/* => GPIO pin 1 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc1  0x00000084U
#define Adr_NX50_gpio_gpio_tc1 0x1C000884U
#define Adr_NX50_gpio_tc1      0x1C000884U
#define DFLT_VAL_NX50_gpio_tc1 0x00000000U

#define MSK_NX50_gpio_tc1_val      0xffffffffU
#define SRT_NX50_gpio_tc1_val      0
#define DFLT_VAL_NX50_gpio_tc1_val 0x00000000U

enum {
	BFW_NX50_gpio_tc1_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC1_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc1_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC1_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC1_BIT_T bf;
} NX50_GPIO_TC1_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc2 */
/* => GPIO pin 2 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc2  0x00000088U
#define Adr_NX50_gpio_gpio_tc2 0x1C000888U
#define Adr_NX50_gpio_tc2      0x1C000888U
#define DFLT_VAL_NX50_gpio_tc2 0x00000000U

#define MSK_NX50_gpio_tc2_val      0xffffffffU
#define SRT_NX50_gpio_tc2_val      0
#define DFLT_VAL_NX50_gpio_tc2_val 0x00000000U

enum {
	BFW_NX50_gpio_tc2_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC2_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc2_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC2_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC2_BIT_T bf;
} NX50_GPIO_TC2_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc3 */
/* => GPIO pin 3 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc3  0x0000008CU
#define Adr_NX50_gpio_gpio_tc3 0x1C00088CU
#define Adr_NX50_gpio_tc3      0x1C00088CU
#define DFLT_VAL_NX50_gpio_tc3 0x00000000U

#define MSK_NX50_gpio_tc3_val      0xffffffffU
#define SRT_NX50_gpio_tc3_val      0
#define DFLT_VAL_NX50_gpio_tc3_val 0x00000000U

enum {
	BFW_NX50_gpio_tc3_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC3_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc3_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC3_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC3_BIT_T bf;
} NX50_GPIO_TC3_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc4 */
/* => GPIO pin 4 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc4  0x00000090U
#define Adr_NX50_gpio_gpio_tc4 0x1C000890U
#define Adr_NX50_gpio_tc4      0x1C000890U
#define DFLT_VAL_NX50_gpio_tc4 0x00000000U

#define MSK_NX50_gpio_tc4_val      0xffffffffU
#define SRT_NX50_gpio_tc4_val      0
#define DFLT_VAL_NX50_gpio_tc4_val 0x00000000U

enum {
	BFW_NX50_gpio_tc4_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC4_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc4_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC4_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC4_BIT_T bf;
} NX50_GPIO_TC4_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc5 */
/* => GPIO pin 5 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc5  0x00000094U
#define Adr_NX50_gpio_gpio_tc5 0x1C000894U
#define Adr_NX50_gpio_tc5      0x1C000894U
#define DFLT_VAL_NX50_gpio_tc5 0x00000000U

#define MSK_NX50_gpio_tc5_val      0xffffffffU
#define SRT_NX50_gpio_tc5_val      0
#define DFLT_VAL_NX50_gpio_tc5_val 0x00000000U

enum {
	BFW_NX50_gpio_tc5_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC5_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc5_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC5_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC5_BIT_T bf;
} NX50_GPIO_TC5_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc6 */
/* => GPIO pin 6 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc6  0x00000098U
#define Adr_NX50_gpio_gpio_tc6 0x1C000898U
#define Adr_NX50_gpio_tc6      0x1C000898U
#define DFLT_VAL_NX50_gpio_tc6 0x00000000U

#define MSK_NX50_gpio_tc6_val      0xffffffffU
#define SRT_NX50_gpio_tc6_val      0
#define DFLT_VAL_NX50_gpio_tc6_val 0x00000000U

enum {
	BFW_NX50_gpio_tc6_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC6_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc6_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC6_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC6_BIT_T bf;
} NX50_GPIO_TC6_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc7 */
/* => GPIO pin 7 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc7  0x0000009CU
#define Adr_NX50_gpio_gpio_tc7 0x1C00089CU
#define Adr_NX50_gpio_tc7      0x1C00089CU
#define DFLT_VAL_NX50_gpio_tc7 0x00000000U

#define MSK_NX50_gpio_tc7_val      0xffffffffU
#define SRT_NX50_gpio_tc7_val      0
#define DFLT_VAL_NX50_gpio_tc7_val 0x00000000U

enum {
	BFW_NX50_gpio_tc7_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC7_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc7_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC7_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC7_BIT_T bf;
} NX50_GPIO_TC7_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc8 */
/* => GPIO pin 8 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc8  0x000000A0U
#define Adr_NX50_gpio_gpio_tc8 0x1C0008A0U
#define Adr_NX50_gpio_tc8      0x1C0008A0U
#define DFLT_VAL_NX50_gpio_tc8 0x00000000U

#define MSK_NX50_gpio_tc8_val      0xffffffffU
#define SRT_NX50_gpio_tc8_val      0
#define DFLT_VAL_NX50_gpio_tc8_val 0x00000000U

enum {
	BFW_NX50_gpio_tc8_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC8_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc8_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC8_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC8_BIT_T bf;
} NX50_GPIO_TC8_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc9 */
/* => GPIO pin 9 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc9  0x000000A4U
#define Adr_NX50_gpio_gpio_tc9 0x1C0008A4U
#define Adr_NX50_gpio_tc9      0x1C0008A4U
#define DFLT_VAL_NX50_gpio_tc9 0x00000000U

#define MSK_NX50_gpio_tc9_val      0xffffffffU
#define SRT_NX50_gpio_tc9_val      0
#define DFLT_VAL_NX50_gpio_tc9_val 0x00000000U

enum {
	BFW_NX50_gpio_tc9_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC9_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc9_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC9_BIT_T;

typedef union {
	unsigned int        val;
	NX50_GPIO_TC9_BIT_T bf;
} NX50_GPIO_TC9_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc10 */
/* => GPIO pin 10 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc10  0x000000A8U
#define Adr_NX50_gpio_gpio_tc10 0x1C0008A8U
#define Adr_NX50_gpio_tc10      0x1C0008A8U
#define DFLT_VAL_NX50_gpio_tc10 0x00000000U

#define MSK_NX50_gpio_tc10_val      0xffffffffU
#define SRT_NX50_gpio_tc10_val      0
#define DFLT_VAL_NX50_gpio_tc10_val 0x00000000U

enum {
	BFW_NX50_gpio_tc10_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC10_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc10_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC10_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC10_BIT_T bf;
} NX50_GPIO_TC10_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc11 */
/* => GPIO pin 11 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc11  0x000000ACU
#define Adr_NX50_gpio_gpio_tc11 0x1C0008ACU
#define Adr_NX50_gpio_tc11      0x1C0008ACU
#define DFLT_VAL_NX50_gpio_tc11 0x00000000U

#define MSK_NX50_gpio_tc11_val      0xffffffffU
#define SRT_NX50_gpio_tc11_val      0
#define DFLT_VAL_NX50_gpio_tc11_val 0x00000000U

enum {
	BFW_NX50_gpio_tc11_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC11_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc11_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC11_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC11_BIT_T bf;
} NX50_GPIO_TC11_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc12 */
/* => GPIO pin 12 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc12  0x000000B0U
#define Adr_NX50_gpio_gpio_tc12 0x1C0008B0U
#define Adr_NX50_gpio_tc12      0x1C0008B0U
#define DFLT_VAL_NX50_gpio_tc12 0x00000000U

#define MSK_NX50_gpio_tc12_val      0xffffffffU
#define SRT_NX50_gpio_tc12_val      0
#define DFLT_VAL_NX50_gpio_tc12_val 0x00000000U

enum {
	BFW_NX50_gpio_tc12_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC12_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc12_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC12_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC12_BIT_T bf;
} NX50_GPIO_TC12_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc13 */
/* => GPIO pin 13 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc13  0x000000B4U
#define Adr_NX50_gpio_gpio_tc13 0x1C0008B4U
#define Adr_NX50_gpio_tc13      0x1C0008B4U
#define DFLT_VAL_NX50_gpio_tc13 0x00000000U

#define MSK_NX50_gpio_tc13_val      0xffffffffU
#define SRT_NX50_gpio_tc13_val      0
#define DFLT_VAL_NX50_gpio_tc13_val 0x00000000U

enum {
	BFW_NX50_gpio_tc13_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC13_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc13_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC13_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC13_BIT_T bf;
} NX50_GPIO_TC13_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc14 */
/* => GPIO pin 14 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc14  0x000000B8U
#define Adr_NX50_gpio_gpio_tc14 0x1C0008B8U
#define Adr_NX50_gpio_tc14      0x1C0008B8U
#define DFLT_VAL_NX50_gpio_tc14 0x00000000U

#define MSK_NX50_gpio_tc14_val      0xffffffffU
#define SRT_NX50_gpio_tc14_val      0
#define DFLT_VAL_NX50_gpio_tc14_val 0x00000000U

enum {
	BFW_NX50_gpio_tc14_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC14_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc14_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC14_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC14_BIT_T bf;
} NX50_GPIO_TC14_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc15 */
/* => GPIO pin 15 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc15  0x000000BCU
#define Adr_NX50_gpio_gpio_tc15 0x1C0008BCU
#define Adr_NX50_gpio_tc15      0x1C0008BCU
#define DFLT_VAL_NX50_gpio_tc15 0x00000000U

#define MSK_NX50_gpio_tc15_val      0xffffffffU
#define SRT_NX50_gpio_tc15_val      0
#define DFLT_VAL_NX50_gpio_tc15_val 0x00000000U

enum {
	BFW_NX50_gpio_tc15_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC15_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc15_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC15_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC15_BIT_T bf;
} NX50_GPIO_TC15_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc16 */
/* => GPIO pin 16 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc16  0x000000C0U
#define Adr_NX50_gpio_gpio_tc16 0x1C0008C0U
#define Adr_NX50_gpio_tc16      0x1C0008C0U
#define DFLT_VAL_NX50_gpio_tc16 0x00000000U

#define MSK_NX50_gpio_tc16_val      0xffffffffU
#define SRT_NX50_gpio_tc16_val      0
#define DFLT_VAL_NX50_gpio_tc16_val 0x00000000U

enum {
	BFW_NX50_gpio_tc16_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC16_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc16_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC16_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC16_BIT_T bf;
} NX50_GPIO_TC16_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc17 */
/* => GPIO pin 17 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc17  0x000000C4U
#define Adr_NX50_gpio_gpio_tc17 0x1C0008C4U
#define Adr_NX50_gpio_tc17      0x1C0008C4U
#define DFLT_VAL_NX50_gpio_tc17 0x00000000U

#define MSK_NX50_gpio_tc17_val      0xffffffffU
#define SRT_NX50_gpio_tc17_val      0
#define DFLT_VAL_NX50_gpio_tc17_val 0x00000000U

enum {
	BFW_NX50_gpio_tc17_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC17_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc17_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC17_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC17_BIT_T bf;
} NX50_GPIO_TC17_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc18 */
/* => GPIO pin 18 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc18  0x000000C8U
#define Adr_NX50_gpio_gpio_tc18 0x1C0008C8U
#define Adr_NX50_gpio_tc18      0x1C0008C8U
#define DFLT_VAL_NX50_gpio_tc18 0x00000000U

#define MSK_NX50_gpio_tc18_val      0xffffffffU
#define SRT_NX50_gpio_tc18_val      0
#define DFLT_VAL_NX50_gpio_tc18_val 0x00000000U

enum {
	BFW_NX50_gpio_tc18_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC18_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc18_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC18_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC18_BIT_T bf;
} NX50_GPIO_TC18_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc19 */
/* => GPIO pin 19 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc19  0x000000CCU
#define Adr_NX50_gpio_gpio_tc19 0x1C0008CCU
#define Adr_NX50_gpio_tc19      0x1C0008CCU
#define DFLT_VAL_NX50_gpio_tc19 0x00000000U

#define MSK_NX50_gpio_tc19_val      0xffffffffU
#define SRT_NX50_gpio_tc19_val      0
#define DFLT_VAL_NX50_gpio_tc19_val 0x00000000U

enum {
	BFW_NX50_gpio_tc19_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC19_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc19_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC19_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC19_BIT_T bf;
} NX50_GPIO_TC19_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc20 */
/* => GPIO pin 20 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc20  0x000000D0U
#define Adr_NX50_gpio_gpio_tc20 0x1C0008D0U
#define Adr_NX50_gpio_tc20      0x1C0008D0U
#define DFLT_VAL_NX50_gpio_tc20 0x00000000U

#define MSK_NX50_gpio_tc20_val      0xffffffffU
#define SRT_NX50_gpio_tc20_val      0
#define DFLT_VAL_NX50_gpio_tc20_val 0x00000000U

enum {
	BFW_NX50_gpio_tc20_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC20_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc20_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC20_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC20_BIT_T bf;
} NX50_GPIO_TC20_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc21 */
/* => GPIO pin 21 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc21  0x000000D4U
#define Adr_NX50_gpio_gpio_tc21 0x1C0008D4U
#define Adr_NX50_gpio_tc21      0x1C0008D4U
#define DFLT_VAL_NX50_gpio_tc21 0x00000000U

#define MSK_NX50_gpio_tc21_val      0xffffffffU
#define SRT_NX50_gpio_tc21_val      0
#define DFLT_VAL_NX50_gpio_tc21_val 0x00000000U

enum {
	BFW_NX50_gpio_tc21_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC21_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc21_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC21_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC21_BIT_T bf;
} NX50_GPIO_TC21_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc22 */
/* => GPIO pin 22 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc22  0x000000D8U
#define Adr_NX50_gpio_gpio_tc22 0x1C0008D8U
#define Adr_NX50_gpio_tc22      0x1C0008D8U
#define DFLT_VAL_NX50_gpio_tc22 0x00000000U

#define MSK_NX50_gpio_tc22_val      0xffffffffU
#define SRT_NX50_gpio_tc22_val      0
#define DFLT_VAL_NX50_gpio_tc22_val 0x00000000U

enum {
	BFW_NX50_gpio_tc22_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC22_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc22_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC22_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC22_BIT_T bf;
} NX50_GPIO_TC22_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc23 */
/* => GPIO pin 23 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc23  0x000000DCU
#define Adr_NX50_gpio_gpio_tc23 0x1C0008DCU
#define Adr_NX50_gpio_tc23      0x1C0008DCU
#define DFLT_VAL_NX50_gpio_tc23 0x00000000U

#define MSK_NX50_gpio_tc23_val      0xffffffffU
#define SRT_NX50_gpio_tc23_val      0
#define DFLT_VAL_NX50_gpio_tc23_val 0x00000000U

enum {
	BFW_NX50_gpio_tc23_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC23_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc23_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC23_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC23_BIT_T bf;
} NX50_GPIO_TC23_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc24 */
/* => GPIO pin 24 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc24  0x000000E0U
#define Adr_NX50_gpio_gpio_tc24 0x1C0008E0U
#define Adr_NX50_gpio_tc24      0x1C0008E0U
#define DFLT_VAL_NX50_gpio_tc24 0x00000000U

#define MSK_NX50_gpio_tc24_val      0xffffffffU
#define SRT_NX50_gpio_tc24_val      0
#define DFLT_VAL_NX50_gpio_tc24_val 0x00000000U

enum {
	BFW_NX50_gpio_tc24_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC24_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc24_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC24_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC24_BIT_T bf;
} NX50_GPIO_TC24_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc25 */
/* => GPIO pin 25 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc25  0x000000E4U
#define Adr_NX50_gpio_gpio_tc25 0x1C0008E4U
#define Adr_NX50_gpio_tc25      0x1C0008E4U
#define DFLT_VAL_NX50_gpio_tc25 0x00000000U

#define MSK_NX50_gpio_tc25_val      0xffffffffU
#define SRT_NX50_gpio_tc25_val      0
#define DFLT_VAL_NX50_gpio_tc25_val 0x00000000U

enum {
	BFW_NX50_gpio_tc25_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC25_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc25_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC25_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC25_BIT_T bf;
} NX50_GPIO_TC25_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc26 */
/* => GPIO pin 26 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc26  0x000000E8U
#define Adr_NX50_gpio_gpio_tc26 0x1C0008E8U
#define Adr_NX50_gpio_tc26      0x1C0008E8U
#define DFLT_VAL_NX50_gpio_tc26 0x00000000U

#define MSK_NX50_gpio_tc26_val      0xffffffffU
#define SRT_NX50_gpio_tc26_val      0
#define DFLT_VAL_NX50_gpio_tc26_val 0x00000000U

enum {
	BFW_NX50_gpio_tc26_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC26_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc26_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC26_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC26_BIT_T bf;
} NX50_GPIO_TC26_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc27 */
/* => GPIO pin 27 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc27  0x000000ECU
#define Adr_NX50_gpio_gpio_tc27 0x1C0008ECU
#define Adr_NX50_gpio_tc27      0x1C0008ECU
#define DFLT_VAL_NX50_gpio_tc27 0x00000000U

#define MSK_NX50_gpio_tc27_val      0xffffffffU
#define SRT_NX50_gpio_tc27_val      0
#define DFLT_VAL_NX50_gpio_tc27_val 0x00000000U

enum {
	BFW_NX50_gpio_tc27_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC27_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc27_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC27_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC27_BIT_T bf;
} NX50_GPIO_TC27_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc28 */
/* => GPIO pin 28 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc28  0x000000F0U
#define Adr_NX50_gpio_gpio_tc28 0x1C0008F0U
#define Adr_NX50_gpio_tc28      0x1C0008F0U
#define DFLT_VAL_NX50_gpio_tc28 0x00000000U

#define MSK_NX50_gpio_tc28_val      0xffffffffU
#define SRT_NX50_gpio_tc28_val      0
#define DFLT_VAL_NX50_gpio_tc28_val 0x00000000U

enum {
	BFW_NX50_gpio_tc28_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC28_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc28_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC28_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC28_BIT_T bf;
} NX50_GPIO_TC28_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc29 */
/* => GPIO pin 29 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc29  0x000000F4U
#define Adr_NX50_gpio_gpio_tc29 0x1C0008F4U
#define Adr_NX50_gpio_tc29      0x1C0008F4U
#define DFLT_VAL_NX50_gpio_tc29 0x00000000U

#define MSK_NX50_gpio_tc29_val      0xffffffffU
#define SRT_NX50_gpio_tc29_val      0
#define DFLT_VAL_NX50_gpio_tc29_val 0x00000000U

enum {
	BFW_NX50_gpio_tc29_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC29_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc29_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC29_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC29_BIT_T bf;
} NX50_GPIO_TC29_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc30 */
/* => GPIO pin 30 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc30  0x000000F8U
#define Adr_NX50_gpio_gpio_tc30 0x1C0008F8U
#define Adr_NX50_gpio_tc30      0x1C0008F8U
#define DFLT_VAL_NX50_gpio_tc30 0x00000000U

#define MSK_NX50_gpio_tc30_val      0xffffffffU
#define SRT_NX50_gpio_tc30_val      0
#define DFLT_VAL_NX50_gpio_tc30_val 0x00000000U

enum {
	BFW_NX50_gpio_tc30_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC30_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc30_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC30_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC30_BIT_T bf;
} NX50_GPIO_TC30_T;

/* --------------------------------------------------------------------- */
/* Register gpio_tc31 */
/* => GPIO pin 31 threshold or capture register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_tc31  0x000000FCU
#define Adr_NX50_gpio_gpio_tc31 0x1C0008FCU
#define Adr_NX50_gpio_tc31      0x1C0008FCU
#define DFLT_VAL_NX50_gpio_tc31 0x00000000U

#define MSK_NX50_gpio_tc31_val      0xffffffffU
#define SRT_NX50_gpio_tc31_val      0
#define DFLT_VAL_NX50_gpio_tc31_val 0x00000000U

enum {
	BFW_NX50_gpio_tc31_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_TC31_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_tc31_val; /* analog to gpio_tc0 */
} NX50_GPIO_TC31_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_TC31_BIT_T bf;
} NX50_GPIO_TC31_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter0_ctrl */
/* => GPIO counter0 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter0_ctrl  0x00000100U
#define Adr_NX50_gpio_gpio_counter0_ctrl 0x1C000900U
#define Adr_NX50_gpio_counter0_ctrl      0x1C000900U
#define DFLT_VAL_NX50_gpio_counter0_ctrl 0x00000000U

#define MSK_NX50_gpio_counter0_ctrl_run            0x00000001U
#define SRT_NX50_gpio_counter0_ctrl_run            0
#define DFLT_VAL_NX50_gpio_counter0_ctrl_run       0x00000000U
#define MSK_NX50_gpio_counter0_ctrl_sym_nasym      0x00000002U
#define SRT_NX50_gpio_counter0_ctrl_sym_nasym      1
#define DFLT_VAL_NX50_gpio_counter0_ctrl_sym_nasym 0x00000000U
#define MSK_NX50_gpio_counter0_ctrl_irq_en         0x00000004U
#define SRT_NX50_gpio_counter0_ctrl_irq_en         2
#define DFLT_VAL_NX50_gpio_counter0_ctrl_irq_en    0x00000000U
#define MSK_NX50_gpio_counter0_ctrl_sel_event      0x00000008U
#define SRT_NX50_gpio_counter0_ctrl_sel_event      3
#define DFLT_VAL_NX50_gpio_counter0_ctrl_sel_event 0x00000000U
#define MSK_NX50_gpio_counter0_ctrl_once           0x00000010U
#define SRT_NX50_gpio_counter0_ctrl_once           4
#define DFLT_VAL_NX50_gpio_counter0_ctrl_once      0x00000000U
#define MSK_NX50_gpio_counter0_ctrl_event_act      0x00000060U
#define SRT_NX50_gpio_counter0_ctrl_event_act      5
#define DFLT_VAL_NX50_gpio_counter0_ctrl_event_act 0x00000000U
#define MSK_NX50_gpio_counter0_ctrl_gpio_ref       0x00000f80U
#define SRT_NX50_gpio_counter0_ctrl_gpio_ref       7
#define DFLT_VAL_NX50_gpio_counter0_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX50_gpio_counter0_ctrl_run       = 1,  /* [0] */
	BFW_NX50_gpio_counter0_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX50_gpio_counter0_ctrl_irq_en    = 1,  /* [2] */
	BFW_NX50_gpio_counter0_ctrl_sel_event = 1,  /* [3] */
	BFW_NX50_gpio_counter0_ctrl_once      = 1,  /* [4] */
	BFW_NX50_gpio_counter0_ctrl_event_act = 2,  /* [6:5] */
	BFW_NX50_gpio_counter0_ctrl_gpio_ref  = 5,  /* [11:7] */
	BFW_NX50_gpio_counter0_ctrl_reserved1 = 20  /* [31:12] */
};

typedef struct NX50_GPIO_COUNTER0_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX50_gpio_counter0_ctrl_run;       /* 1: start counter, counter is running                                        */
	                                                                /* 0: stop counter                                                             */
	unsigned int sym_nasym : BFW_NX50_gpio_counter0_ctrl_sym_nasym; /* 1: symmetric mode (triangle)                                                */
	                                                                /* 0: asymmetric mode (sawtooth)                                               */
	unsigned int irq_en    : BFW_NX50_gpio_counter0_ctrl_irq_en;    /* 1: enable interrupt request on sel_event                                    */
	                                                                /* 0: disable interrupt request                                                */
	unsigned int sel_event : BFW_NX50_gpio_counter0_ctrl_sel_event; /* select external event                                                       */
	                                                                /* 0: high level, invert gpio in gpio_cfg register to select low level         */
	unsigned int once      : BFW_NX50_gpio_counter0_ctrl_once;      /* 1: count once (reset run bit after 1 period)                                */
	                                                                /* 0: count continue                                                           */
	unsigned int event_act : BFW_NX50_gpio_counter0_ctrl_event_act; /* Define action of selected external event (dependant on sel_event, gpio_ref) */
	                                                                /* 00: count every clock cycle, ignore external events                         */
	unsigned int gpio_ref  : BFW_NX50_gpio_counter0_ctrl_gpio_ref;  /* gpio reference (0 - 31)                                                     */
	unsigned int reserved1 : BFW_NX50_gpio_counter0_ctrl_reserved1; /* reserved                                                                    */
} NX50_GPIO_COUNTER0_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_GPIO_COUNTER0_CTRL_BIT_T bf;
} NX50_GPIO_COUNTER0_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter1_ctrl */
/* => GPIO counter1 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter1_ctrl  0x00000104U
#define Adr_NX50_gpio_gpio_counter1_ctrl 0x1C000904U
#define Adr_NX50_gpio_counter1_ctrl      0x1C000904U
#define DFLT_VAL_NX50_gpio_counter1_ctrl 0x00000000U

#define MSK_NX50_gpio_counter1_ctrl_run            0x00000001U
#define SRT_NX50_gpio_counter1_ctrl_run            0
#define DFLT_VAL_NX50_gpio_counter1_ctrl_run       0x00000000U
#define MSK_NX50_gpio_counter1_ctrl_sym_nasym      0x00000002U
#define SRT_NX50_gpio_counter1_ctrl_sym_nasym      1
#define DFLT_VAL_NX50_gpio_counter1_ctrl_sym_nasym 0x00000000U
#define MSK_NX50_gpio_counter1_ctrl_irq_en         0x00000004U
#define SRT_NX50_gpio_counter1_ctrl_irq_en         2
#define DFLT_VAL_NX50_gpio_counter1_ctrl_irq_en    0x00000000U
#define MSK_NX50_gpio_counter1_ctrl_sel_event      0x00000008U
#define SRT_NX50_gpio_counter1_ctrl_sel_event      3
#define DFLT_VAL_NX50_gpio_counter1_ctrl_sel_event 0x00000000U
#define MSK_NX50_gpio_counter1_ctrl_once           0x00000010U
#define SRT_NX50_gpio_counter1_ctrl_once           4
#define DFLT_VAL_NX50_gpio_counter1_ctrl_once      0x00000000U
#define MSK_NX50_gpio_counter1_ctrl_event_act      0x00000060U
#define SRT_NX50_gpio_counter1_ctrl_event_act      5
#define DFLT_VAL_NX50_gpio_counter1_ctrl_event_act 0x00000000U
#define MSK_NX50_gpio_counter1_ctrl_gpio_ref       0x00000f80U
#define SRT_NX50_gpio_counter1_ctrl_gpio_ref       7
#define DFLT_VAL_NX50_gpio_counter1_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX50_gpio_counter1_ctrl_run       = 1,  /* [0] */
	BFW_NX50_gpio_counter1_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX50_gpio_counter1_ctrl_irq_en    = 1,  /* [2] */
	BFW_NX50_gpio_counter1_ctrl_sel_event = 1,  /* [3] */
	BFW_NX50_gpio_counter1_ctrl_once      = 1,  /* [4] */
	BFW_NX50_gpio_counter1_ctrl_event_act = 2,  /* [6:5] */
	BFW_NX50_gpio_counter1_ctrl_gpio_ref  = 5,  /* [11:7] */
	BFW_NX50_gpio_counter1_ctrl_reserved1 = 20  /* [31:12] */
};

typedef struct NX50_GPIO_COUNTER1_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX50_gpio_counter1_ctrl_run;       /* analog to gpio_counter0_ctrl */
	unsigned int sym_nasym : BFW_NX50_gpio_counter1_ctrl_sym_nasym; /* analog to gpio_counter0_ctrl */
	unsigned int irq_en    : BFW_NX50_gpio_counter1_ctrl_irq_en;    /* analog to gpio_counter0_ctrl */
	unsigned int sel_event : BFW_NX50_gpio_counter1_ctrl_sel_event; /* analog to gpio_counter0_ctrl */
	unsigned int once      : BFW_NX50_gpio_counter1_ctrl_once;      /* analog to gpio_counter0_ctrl */
	unsigned int event_act : BFW_NX50_gpio_counter1_ctrl_event_act; /* analog to gpio_counter0_ctrl */
	unsigned int gpio_ref  : BFW_NX50_gpio_counter1_ctrl_gpio_ref;  /* analog to gpio_counter0_ctrl */
	unsigned int reserved1 : BFW_NX50_gpio_counter1_ctrl_reserved1; /* reserved                     */
} NX50_GPIO_COUNTER1_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_GPIO_COUNTER1_CTRL_BIT_T bf;
} NX50_GPIO_COUNTER1_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter2_ctrl */
/* => GPIO counter2 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter2_ctrl  0x00000108U
#define Adr_NX50_gpio_gpio_counter2_ctrl 0x1C000908U
#define Adr_NX50_gpio_counter2_ctrl      0x1C000908U
#define DFLT_VAL_NX50_gpio_counter2_ctrl 0x00000000U

#define MSK_NX50_gpio_counter2_ctrl_run            0x00000001U
#define SRT_NX50_gpio_counter2_ctrl_run            0
#define DFLT_VAL_NX50_gpio_counter2_ctrl_run       0x00000000U
#define MSK_NX50_gpio_counter2_ctrl_sym_nasym      0x00000002U
#define SRT_NX50_gpio_counter2_ctrl_sym_nasym      1
#define DFLT_VAL_NX50_gpio_counter2_ctrl_sym_nasym 0x00000000U
#define MSK_NX50_gpio_counter2_ctrl_irq_en         0x00000004U
#define SRT_NX50_gpio_counter2_ctrl_irq_en         2
#define DFLT_VAL_NX50_gpio_counter2_ctrl_irq_en    0x00000000U
#define MSK_NX50_gpio_counter2_ctrl_sel_event      0x00000008U
#define SRT_NX50_gpio_counter2_ctrl_sel_event      3
#define DFLT_VAL_NX50_gpio_counter2_ctrl_sel_event 0x00000000U
#define MSK_NX50_gpio_counter2_ctrl_once           0x00000010U
#define SRT_NX50_gpio_counter2_ctrl_once           4
#define DFLT_VAL_NX50_gpio_counter2_ctrl_once      0x00000000U
#define MSK_NX50_gpio_counter2_ctrl_event_act      0x00000060U
#define SRT_NX50_gpio_counter2_ctrl_event_act      5
#define DFLT_VAL_NX50_gpio_counter2_ctrl_event_act 0x00000000U
#define MSK_NX50_gpio_counter2_ctrl_gpio_ref       0x00000f80U
#define SRT_NX50_gpio_counter2_ctrl_gpio_ref       7
#define DFLT_VAL_NX50_gpio_counter2_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX50_gpio_counter2_ctrl_run       = 1,  /* [0] */
	BFW_NX50_gpio_counter2_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX50_gpio_counter2_ctrl_irq_en    = 1,  /* [2] */
	BFW_NX50_gpio_counter2_ctrl_sel_event = 1,  /* [3] */
	BFW_NX50_gpio_counter2_ctrl_once      = 1,  /* [4] */
	BFW_NX50_gpio_counter2_ctrl_event_act = 2,  /* [6:5] */
	BFW_NX50_gpio_counter2_ctrl_gpio_ref  = 5,  /* [11:7] */
	BFW_NX50_gpio_counter2_ctrl_reserved1 = 20  /* [31:12] */
};

typedef struct NX50_GPIO_COUNTER2_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX50_gpio_counter2_ctrl_run;       /* analog to gpio_counter0_ctrl */
	unsigned int sym_nasym : BFW_NX50_gpio_counter2_ctrl_sym_nasym; /* analog to gpio_counter0_ctrl */
	unsigned int irq_en    : BFW_NX50_gpio_counter2_ctrl_irq_en;    /* analog to gpio_counter0_ctrl */
	unsigned int sel_event : BFW_NX50_gpio_counter2_ctrl_sel_event; /* analog to gpio_counter0_ctrl */
	unsigned int once      : BFW_NX50_gpio_counter2_ctrl_once;      /* analog to gpio_counter0_ctrl */
	unsigned int event_act : BFW_NX50_gpio_counter2_ctrl_event_act; /* analog to gpio_counter0_ctrl */
	unsigned int gpio_ref  : BFW_NX50_gpio_counter2_ctrl_gpio_ref;  /* analog to gpio_counter0_ctrl */
	unsigned int reserved1 : BFW_NX50_gpio_counter2_ctrl_reserved1; /* reserved                     */
} NX50_GPIO_COUNTER2_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_GPIO_COUNTER2_CTRL_BIT_T bf;
} NX50_GPIO_COUNTER2_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter3_ctrl */
/* => GPIO counter3 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter3_ctrl  0x0000010CU
#define Adr_NX50_gpio_gpio_counter3_ctrl 0x1C00090CU
#define Adr_NX50_gpio_counter3_ctrl      0x1C00090CU
#define DFLT_VAL_NX50_gpio_counter3_ctrl 0x00000000U

#define MSK_NX50_gpio_counter3_ctrl_run            0x00000001U
#define SRT_NX50_gpio_counter3_ctrl_run            0
#define DFLT_VAL_NX50_gpio_counter3_ctrl_run       0x00000000U
#define MSK_NX50_gpio_counter3_ctrl_sym_nasym      0x00000002U
#define SRT_NX50_gpio_counter3_ctrl_sym_nasym      1
#define DFLT_VAL_NX50_gpio_counter3_ctrl_sym_nasym 0x00000000U
#define MSK_NX50_gpio_counter3_ctrl_irq_en         0x00000004U
#define SRT_NX50_gpio_counter3_ctrl_irq_en         2
#define DFLT_VAL_NX50_gpio_counter3_ctrl_irq_en    0x00000000U
#define MSK_NX50_gpio_counter3_ctrl_sel_event      0x00000008U
#define SRT_NX50_gpio_counter3_ctrl_sel_event      3
#define DFLT_VAL_NX50_gpio_counter3_ctrl_sel_event 0x00000000U
#define MSK_NX50_gpio_counter3_ctrl_once           0x00000010U
#define SRT_NX50_gpio_counter3_ctrl_once           4
#define DFLT_VAL_NX50_gpio_counter3_ctrl_once      0x00000000U
#define MSK_NX50_gpio_counter3_ctrl_event_act      0x00000060U
#define SRT_NX50_gpio_counter3_ctrl_event_act      5
#define DFLT_VAL_NX50_gpio_counter3_ctrl_event_act 0x00000000U
#define MSK_NX50_gpio_counter3_ctrl_gpio_ref       0x00000f80U
#define SRT_NX50_gpio_counter3_ctrl_gpio_ref       7
#define DFLT_VAL_NX50_gpio_counter3_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX50_gpio_counter3_ctrl_run       = 1,  /* [0] */
	BFW_NX50_gpio_counter3_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX50_gpio_counter3_ctrl_irq_en    = 1,  /* [2] */
	BFW_NX50_gpio_counter3_ctrl_sel_event = 1,  /* [3] */
	BFW_NX50_gpio_counter3_ctrl_once      = 1,  /* [4] */
	BFW_NX50_gpio_counter3_ctrl_event_act = 2,  /* [6:5] */
	BFW_NX50_gpio_counter3_ctrl_gpio_ref  = 5,  /* [11:7] */
	BFW_NX50_gpio_counter3_ctrl_reserved1 = 20  /* [31:12] */
};

typedef struct NX50_GPIO_COUNTER3_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX50_gpio_counter3_ctrl_run;       /* analog to gpio_counter0_ctrl */
	unsigned int sym_nasym : BFW_NX50_gpio_counter3_ctrl_sym_nasym; /* analog to gpio_counter0_ctrl */
	unsigned int irq_en    : BFW_NX50_gpio_counter3_ctrl_irq_en;    /* analog to gpio_counter0_ctrl */
	unsigned int sel_event : BFW_NX50_gpio_counter3_ctrl_sel_event; /* analog to gpio_counter0_ctrl */
	unsigned int once      : BFW_NX50_gpio_counter3_ctrl_once;      /* analog to gpio_counter0_ctrl */
	unsigned int event_act : BFW_NX50_gpio_counter3_ctrl_event_act; /* analog to gpio_counter0_ctrl */
	unsigned int gpio_ref  : BFW_NX50_gpio_counter3_ctrl_gpio_ref;  /* analog to gpio_counter0_ctrl */
	unsigned int reserved1 : BFW_NX50_gpio_counter3_ctrl_reserved1; /* reserved                     */
} NX50_GPIO_COUNTER3_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_GPIO_COUNTER3_CTRL_BIT_T bf;
} NX50_GPIO_COUNTER3_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter4_ctrl */
/* => GPIO counter4 control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter4_ctrl  0x00000110U
#define Adr_NX50_gpio_gpio_counter4_ctrl 0x1C000910U
#define Adr_NX50_gpio_counter4_ctrl      0x1C000910U
#define DFLT_VAL_NX50_gpio_counter4_ctrl 0x00000000U

#define MSK_NX50_gpio_counter4_ctrl_run            0x00000001U
#define SRT_NX50_gpio_counter4_ctrl_run            0
#define DFLT_VAL_NX50_gpio_counter4_ctrl_run       0x00000000U
#define MSK_NX50_gpio_counter4_ctrl_sym_nasym      0x00000002U
#define SRT_NX50_gpio_counter4_ctrl_sym_nasym      1
#define DFLT_VAL_NX50_gpio_counter4_ctrl_sym_nasym 0x00000000U
#define MSK_NX50_gpio_counter4_ctrl_irq_en         0x00000004U
#define SRT_NX50_gpio_counter4_ctrl_irq_en         2
#define DFLT_VAL_NX50_gpio_counter4_ctrl_irq_en    0x00000000U
#define MSK_NX50_gpio_counter4_ctrl_sel_event      0x00000008U
#define SRT_NX50_gpio_counter4_ctrl_sel_event      3
#define DFLT_VAL_NX50_gpio_counter4_ctrl_sel_event 0x00000000U
#define MSK_NX50_gpio_counter4_ctrl_once           0x00000010U
#define SRT_NX50_gpio_counter4_ctrl_once           4
#define DFLT_VAL_NX50_gpio_counter4_ctrl_once      0x00000000U
#define MSK_NX50_gpio_counter4_ctrl_event_act      0x00000060U
#define SRT_NX50_gpio_counter4_ctrl_event_act      5
#define DFLT_VAL_NX50_gpio_counter4_ctrl_event_act 0x00000000U
#define MSK_NX50_gpio_counter4_ctrl_gpio_ref       0x00000f80U
#define SRT_NX50_gpio_counter4_ctrl_gpio_ref       7
#define DFLT_VAL_NX50_gpio_counter4_ctrl_gpio_ref  0x00000000U

enum {
	BFW_NX50_gpio_counter4_ctrl_run       = 1,  /* [0] */
	BFW_NX50_gpio_counter4_ctrl_sym_nasym = 1,  /* [1] */
	BFW_NX50_gpio_counter4_ctrl_irq_en    = 1,  /* [2] */
	BFW_NX50_gpio_counter4_ctrl_sel_event = 1,  /* [3] */
	BFW_NX50_gpio_counter4_ctrl_once      = 1,  /* [4] */
	BFW_NX50_gpio_counter4_ctrl_event_act = 2,  /* [6:5] */
	BFW_NX50_gpio_counter4_ctrl_gpio_ref  = 5,  /* [11:7] */
	BFW_NX50_gpio_counter4_ctrl_reserved1 = 20  /* [31:12] */
};

typedef struct NX50_GPIO_COUNTER4_CTRL_BIT_Ttag {
	unsigned int run       : BFW_NX50_gpio_counter4_ctrl_run;       /* analog to gpio_counter0_ctrl */
	unsigned int sym_nasym : BFW_NX50_gpio_counter4_ctrl_sym_nasym; /* analog to gpio_counter0_ctrl */
	unsigned int irq_en    : BFW_NX50_gpio_counter4_ctrl_irq_en;    /* analog to gpio_counter0_ctrl */
	unsigned int sel_event : BFW_NX50_gpio_counter4_ctrl_sel_event; /* analog to gpio_counter0_ctrl */
	unsigned int once      : BFW_NX50_gpio_counter4_ctrl_once;      /* analog to gpio_counter0_ctrl */
	unsigned int event_act : BFW_NX50_gpio_counter4_ctrl_event_act; /* analog to gpio_counter0_ctrl */
	unsigned int gpio_ref  : BFW_NX50_gpio_counter4_ctrl_gpio_ref;  /* analog to gpio_counter0_ctrl */
	unsigned int reserved1 : BFW_NX50_gpio_counter4_ctrl_reserved1; /* reserved                     */
} NX50_GPIO_COUNTER4_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_GPIO_COUNTER4_CTRL_BIT_T bf;
} NX50_GPIO_COUNTER4_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter0_max */
/* => GPIO counter0 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter0_max  0x00000114U
#define Adr_NX50_gpio_gpio_counter0_max 0x1C000914U
#define Adr_NX50_gpio_counter0_max      0x1C000914U
#define DFLT_VAL_NX50_gpio_counter0_max 0x00000000U

#define MSK_NX50_gpio_counter0_max_val      0xffffffffU
#define SRT_NX50_gpio_counter0_max_val      0
#define DFLT_VAL_NX50_gpio_counter0_max_val 0x00000000U

enum {
	BFW_NX50_gpio_counter0_max_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER0_MAX_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter0_max_val; /* Asymmetric mode: counting period in cc + 1 */
	                                                   /* Symmetric mode: counting period in cc      */
} NX50_GPIO_COUNTER0_MAX_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER0_MAX_BIT_T bf;
} NX50_GPIO_COUNTER0_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter1_max */
/* => GPIO counter1 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter1_max  0x00000118U
#define Adr_NX50_gpio_gpio_counter1_max 0x1C000918U
#define Adr_NX50_gpio_counter1_max      0x1C000918U
#define DFLT_VAL_NX50_gpio_counter1_max 0x00000000U

#define MSK_NX50_gpio_counter1_max_val      0xffffffffU
#define SRT_NX50_gpio_counter1_max_val      0
#define DFLT_VAL_NX50_gpio_counter1_max_val 0x00000000U

enum {
	BFW_NX50_gpio_counter1_max_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER1_MAX_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter1_max_val; /* Asymmetric mode: counting period in cc + 1 */
	                                                   /* Symmetric mode: counting period in cc      */
} NX50_GPIO_COUNTER1_MAX_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER1_MAX_BIT_T bf;
} NX50_GPIO_COUNTER1_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter2_max */
/* => GPIO counter2 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter2_max  0x0000011CU
#define Adr_NX50_gpio_gpio_counter2_max 0x1C00091CU
#define Adr_NX50_gpio_counter2_max      0x1C00091CU
#define DFLT_VAL_NX50_gpio_counter2_max 0x00000000U

#define MSK_NX50_gpio_counter2_max_val      0xffffffffU
#define SRT_NX50_gpio_counter2_max_val      0
#define DFLT_VAL_NX50_gpio_counter2_max_val 0x00000000U

enum {
	BFW_NX50_gpio_counter2_max_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER2_MAX_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter2_max_val; /* Asymmetric mode: counting period in cc + 1 */
	                                                   /* Symmetric mode: counting period in cc      */
} NX50_GPIO_COUNTER2_MAX_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER2_MAX_BIT_T bf;
} NX50_GPIO_COUNTER2_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter3_max */
/* => GPIO counter3 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter3_max  0x00000120U
#define Adr_NX50_gpio_gpio_counter3_max 0x1C000920U
#define Adr_NX50_gpio_counter3_max      0x1C000920U
#define DFLT_VAL_NX50_gpio_counter3_max 0x00000000U

#define MSK_NX50_gpio_counter3_max_val      0xffffffffU
#define SRT_NX50_gpio_counter3_max_val      0
#define DFLT_VAL_NX50_gpio_counter3_max_val 0x00000000U

enum {
	BFW_NX50_gpio_counter3_max_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER3_MAX_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter3_max_val; /* Asymmetric mode: counting period in cc + 1 */
	                                                   /* Symmetric mode: counting period in cc      */
} NX50_GPIO_COUNTER3_MAX_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER3_MAX_BIT_T bf;
} NX50_GPIO_COUNTER3_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter4_max */
/* => GPIO counter4 max value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter4_max  0x00000124U
#define Adr_NX50_gpio_gpio_counter4_max 0x1C000924U
#define Adr_NX50_gpio_counter4_max      0x1C000924U
#define DFLT_VAL_NX50_gpio_counter4_max 0x00000000U

#define MSK_NX50_gpio_counter4_max_val      0xffffffffU
#define SRT_NX50_gpio_counter4_max_val      0
#define DFLT_VAL_NX50_gpio_counter4_max_val 0x00000000U

enum {
	BFW_NX50_gpio_counter4_max_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER4_MAX_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter4_max_val; /* Asymmetric mode: counting period in cc + 1 */
	                                                   /* Symmetric mode: counting period in cc      */
} NX50_GPIO_COUNTER4_MAX_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER4_MAX_BIT_T bf;
} NX50_GPIO_COUNTER4_MAX_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter0_cnt */
/* => GPIO counter0 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter0_cnt  0x00000128U
#define Adr_NX50_gpio_gpio_counter0_cnt 0x1C000928U
#define Adr_NX50_gpio_counter0_cnt      0x1C000928U
#define DFLT_VAL_NX50_gpio_counter0_cnt 0x00000000U

#define MSK_NX50_gpio_counter0_cnt_val      0xffffffffU
#define SRT_NX50_gpio_counter0_cnt_val      0
#define DFLT_VAL_NX50_gpio_counter0_cnt_val 0x00000000U

enum {
	BFW_NX50_gpio_counter0_cnt_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER0_CNT_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter0_cnt_val; /* curent counter value */
} NX50_GPIO_COUNTER0_CNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER0_CNT_BIT_T bf;
} NX50_GPIO_COUNTER0_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter1_cnt */
/* => GPIO counter1 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter1_cnt  0x0000012CU
#define Adr_NX50_gpio_gpio_counter1_cnt 0x1C00092CU
#define Adr_NX50_gpio_counter1_cnt      0x1C00092CU
#define DFLT_VAL_NX50_gpio_counter1_cnt 0x00000000U

#define MSK_NX50_gpio_counter1_cnt_val      0xffffffffU
#define SRT_NX50_gpio_counter1_cnt_val      0
#define DFLT_VAL_NX50_gpio_counter1_cnt_val 0x00000000U

enum {
	BFW_NX50_gpio_counter1_cnt_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER1_CNT_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter1_cnt_val; /* curent counter value */
} NX50_GPIO_COUNTER1_CNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER1_CNT_BIT_T bf;
} NX50_GPIO_COUNTER1_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter2_cnt */
/* => GPIO counter2 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter2_cnt  0x00000130U
#define Adr_NX50_gpio_gpio_counter2_cnt 0x1C000930U
#define Adr_NX50_gpio_counter2_cnt      0x1C000930U
#define DFLT_VAL_NX50_gpio_counter2_cnt 0x00000000U

#define MSK_NX50_gpio_counter2_cnt_val      0xffffffffU
#define SRT_NX50_gpio_counter2_cnt_val      0
#define DFLT_VAL_NX50_gpio_counter2_cnt_val 0x00000000U

enum {
	BFW_NX50_gpio_counter2_cnt_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER2_CNT_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter2_cnt_val; /* curent counter value */
} NX50_GPIO_COUNTER2_CNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER2_CNT_BIT_T bf;
} NX50_GPIO_COUNTER2_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter3_cnt */
/* => GPIO counter3 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter3_cnt  0x00000134U
#define Adr_NX50_gpio_gpio_counter3_cnt 0x1C000934U
#define Adr_NX50_gpio_counter3_cnt      0x1C000934U
#define DFLT_VAL_NX50_gpio_counter3_cnt 0x00000000U

#define MSK_NX50_gpio_counter3_cnt_val      0xffffffffU
#define SRT_NX50_gpio_counter3_cnt_val      0
#define DFLT_VAL_NX50_gpio_counter3_cnt_val 0x00000000U

enum {
	BFW_NX50_gpio_counter3_cnt_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER3_CNT_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter3_cnt_val; /* curent counter value */
} NX50_GPIO_COUNTER3_CNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER3_CNT_BIT_T bf;
} NX50_GPIO_COUNTER3_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_counter4_cnt */
/* => GPIO counter4 current value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_counter4_cnt  0x00000138U
#define Adr_NX50_gpio_gpio_counter4_cnt 0x1C000938U
#define Adr_NX50_gpio_counter4_cnt      0x1C000938U
#define DFLT_VAL_NX50_gpio_counter4_cnt 0x00000000U

#define MSK_NX50_gpio_counter4_cnt_val      0xffffffffU
#define SRT_NX50_gpio_counter4_cnt_val      0
#define DFLT_VAL_NX50_gpio_counter4_cnt_val 0x00000000U

enum {
	BFW_NX50_gpio_counter4_cnt_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_COUNTER4_CNT_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_counter4_cnt_val; /* curent counter value */
} NX50_GPIO_COUNTER4_CNT_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_COUNTER4_CNT_BIT_T bf;
} NX50_GPIO_COUNTER4_CNT_T;

/* --------------------------------------------------------------------- */
/* Register gpio_systime_cmp */
/* => GPIO sys_time compare value */
/*    compares this value with systime_ns considering incontinous behaviour of systime_ns */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_systime_cmp  0x0000013CU
#define Adr_NX50_gpio_gpio_systime_cmp 0x1C00093CU
#define Adr_NX50_gpio_systime_cmp      0x1C00093CU
#define DFLT_VAL_NX50_gpio_systime_cmp 0x00000000U

#define MSK_NX50_gpio_systime_cmp_val      0xffffffffU
#define SRT_NX50_gpio_systime_cmp_val      0
#define DFLT_VAL_NX50_gpio_systime_cmp_val 0x00000000U

enum {
	BFW_NX50_gpio_systime_cmp_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_SYSTIME_CMP_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_systime_cmp_val; /* compare value for systime */
} NX50_GPIO_SYSTIME_CMP_BIT_T;

typedef union {
	unsigned int                val;
	NX50_GPIO_SYSTIME_CMP_BIT_T bf;
} NX50_GPIO_SYSTIME_CMP_T;

/* --------------------------------------------------------------------- */
/* Register gpio_line */
/* => GPIO line register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_line  0x00000140U
#define Adr_NX50_gpio_gpio_line 0x1C000940U
#define Adr_NX50_gpio_line      0x1C000940U
#define DFLT_VAL_NX50_gpio_line 0x00000000U

#define MSK_NX50_gpio_line_val      0xffffffffU
#define SRT_NX50_gpio_line_val      0
#define DFLT_VAL_NX50_gpio_line_val 0x00000000U

enum {
	BFW_NX50_gpio_line_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_LINE_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_line_val; /* gpio output values */
} NX50_GPIO_LINE_BIT_T;

typedef union {
	unsigned int         val;
	NX50_GPIO_LINE_BIT_T bf;
} NX50_GPIO_LINE_T;

/* --------------------------------------------------------------------- */
/* Register gpio_in */
/* => GPIO latched register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_in  0x00000144U
#define Adr_NX50_gpio_gpio_in 0x1C000944U
#define Adr_NX50_gpio_in      0x1C000944U

#define MSK_NX50_gpio_in_val 0xffffffffU
#define SRT_NX50_gpio_in_val 0

enum {
	BFW_NX50_gpio_in_val = 32  /* [31:0] */
};

typedef struct NX50_GPIO_IN_BIT_Ttag {
	unsigned int val : BFW_NX50_gpio_in_val; /* gpio input values */
} NX50_GPIO_IN_BIT_T;

typedef union {
	unsigned int       val;
	NX50_GPIO_IN_BIT_T bf;
} NX50_GPIO_IN_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq_raw */
/* => GPIO Raw IRQ register */
/*    Write access with '1' resets the appropriate IRQ */
/*    Write access with '0' does not influence this bit */
/*    Read access shows status of unmasked IRQs */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_irq_raw  0x00000148U
#define Adr_NX50_gpio_gpio_irq_raw 0x1C000948U
#define Adr_NX50_gpio_irq_raw      0x1C000948U
#define DFLT_VAL_NX50_gpio_irq_raw 0x00000000U

#define MSK_NX50_gpio_irq_raw_gpio0       0x00000001U
#define SRT_NX50_gpio_irq_raw_gpio0       0
#define DFLT_VAL_NX50_gpio_irq_raw_gpio0  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio1       0x00000002U
#define SRT_NX50_gpio_irq_raw_gpio1       1
#define DFLT_VAL_NX50_gpio_irq_raw_gpio1  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio2       0x00000004U
#define SRT_NX50_gpio_irq_raw_gpio2       2
#define DFLT_VAL_NX50_gpio_irq_raw_gpio2  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio3       0x00000008U
#define SRT_NX50_gpio_irq_raw_gpio3       3
#define DFLT_VAL_NX50_gpio_irq_raw_gpio3  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio4       0x00000010U
#define SRT_NX50_gpio_irq_raw_gpio4       4
#define DFLT_VAL_NX50_gpio_irq_raw_gpio4  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio5       0x00000020U
#define SRT_NX50_gpio_irq_raw_gpio5       5
#define DFLT_VAL_NX50_gpio_irq_raw_gpio5  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio6       0x00000040U
#define SRT_NX50_gpio_irq_raw_gpio6       6
#define DFLT_VAL_NX50_gpio_irq_raw_gpio6  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio7       0x00000080U
#define SRT_NX50_gpio_irq_raw_gpio7       7
#define DFLT_VAL_NX50_gpio_irq_raw_gpio7  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio8       0x00000100U
#define SRT_NX50_gpio_irq_raw_gpio8       8
#define DFLT_VAL_NX50_gpio_irq_raw_gpio8  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio9       0x00000200U
#define SRT_NX50_gpio_irq_raw_gpio9       9
#define DFLT_VAL_NX50_gpio_irq_raw_gpio9  0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio10      0x00000400U
#define SRT_NX50_gpio_irq_raw_gpio10      10
#define DFLT_VAL_NX50_gpio_irq_raw_gpio10 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio11      0x00000800U
#define SRT_NX50_gpio_irq_raw_gpio11      11
#define DFLT_VAL_NX50_gpio_irq_raw_gpio11 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio12      0x00001000U
#define SRT_NX50_gpio_irq_raw_gpio12      12
#define DFLT_VAL_NX50_gpio_irq_raw_gpio12 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio13      0x00002000U
#define SRT_NX50_gpio_irq_raw_gpio13      13
#define DFLT_VAL_NX50_gpio_irq_raw_gpio13 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio14      0x00004000U
#define SRT_NX50_gpio_irq_raw_gpio14      14
#define DFLT_VAL_NX50_gpio_irq_raw_gpio14 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio15      0x00008000U
#define SRT_NX50_gpio_irq_raw_gpio15      15
#define DFLT_VAL_NX50_gpio_irq_raw_gpio15 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio16      0x00010000U
#define SRT_NX50_gpio_irq_raw_gpio16      16
#define DFLT_VAL_NX50_gpio_irq_raw_gpio16 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio17      0x00020000U
#define SRT_NX50_gpio_irq_raw_gpio17      17
#define DFLT_VAL_NX50_gpio_irq_raw_gpio17 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio18      0x00040000U
#define SRT_NX50_gpio_irq_raw_gpio18      18
#define DFLT_VAL_NX50_gpio_irq_raw_gpio18 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio19      0x00080000U
#define SRT_NX50_gpio_irq_raw_gpio19      19
#define DFLT_VAL_NX50_gpio_irq_raw_gpio19 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio20      0x00100000U
#define SRT_NX50_gpio_irq_raw_gpio20      20
#define DFLT_VAL_NX50_gpio_irq_raw_gpio20 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio21      0x00200000U
#define SRT_NX50_gpio_irq_raw_gpio21      21
#define DFLT_VAL_NX50_gpio_irq_raw_gpio21 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio22      0x00400000U
#define SRT_NX50_gpio_irq_raw_gpio22      22
#define DFLT_VAL_NX50_gpio_irq_raw_gpio22 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio23      0x00800000U
#define SRT_NX50_gpio_irq_raw_gpio23      23
#define DFLT_VAL_NX50_gpio_irq_raw_gpio23 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio24      0x01000000U
#define SRT_NX50_gpio_irq_raw_gpio24      24
#define DFLT_VAL_NX50_gpio_irq_raw_gpio24 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio25      0x02000000U
#define SRT_NX50_gpio_irq_raw_gpio25      25
#define DFLT_VAL_NX50_gpio_irq_raw_gpio25 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio26      0x04000000U
#define SRT_NX50_gpio_irq_raw_gpio26      26
#define DFLT_VAL_NX50_gpio_irq_raw_gpio26 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio27      0x08000000U
#define SRT_NX50_gpio_irq_raw_gpio27      27
#define DFLT_VAL_NX50_gpio_irq_raw_gpio27 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio28      0x10000000U
#define SRT_NX50_gpio_irq_raw_gpio28      28
#define DFLT_VAL_NX50_gpio_irq_raw_gpio28 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio29      0x20000000U
#define SRT_NX50_gpio_irq_raw_gpio29      29
#define DFLT_VAL_NX50_gpio_irq_raw_gpio29 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio30      0x40000000U
#define SRT_NX50_gpio_irq_raw_gpio30      30
#define DFLT_VAL_NX50_gpio_irq_raw_gpio30 0x00000000U
#define MSK_NX50_gpio_irq_raw_gpio31      0x80000000U
#define SRT_NX50_gpio_irq_raw_gpio31      31
#define DFLT_VAL_NX50_gpio_irq_raw_gpio31 0x00000000U

enum {
	BFW_NX50_gpio_irq_raw_gpio0  = 1, /* [0] */
	BFW_NX50_gpio_irq_raw_gpio1  = 1, /* [1] */
	BFW_NX50_gpio_irq_raw_gpio2  = 1, /* [2] */
	BFW_NX50_gpio_irq_raw_gpio3  = 1, /* [3] */
	BFW_NX50_gpio_irq_raw_gpio4  = 1, /* [4] */
	BFW_NX50_gpio_irq_raw_gpio5  = 1, /* [5] */
	BFW_NX50_gpio_irq_raw_gpio6  = 1, /* [6] */
	BFW_NX50_gpio_irq_raw_gpio7  = 1, /* [7] */
	BFW_NX50_gpio_irq_raw_gpio8  = 1, /* [8] */
	BFW_NX50_gpio_irq_raw_gpio9  = 1, /* [9] */
	BFW_NX50_gpio_irq_raw_gpio10 = 1, /* [10] */
	BFW_NX50_gpio_irq_raw_gpio11 = 1, /* [11] */
	BFW_NX50_gpio_irq_raw_gpio12 = 1, /* [12] */
	BFW_NX50_gpio_irq_raw_gpio13 = 1, /* [13] */
	BFW_NX50_gpio_irq_raw_gpio14 = 1, /* [14] */
	BFW_NX50_gpio_irq_raw_gpio15 = 1, /* [15] */
	BFW_NX50_gpio_irq_raw_gpio16 = 1, /* [16] */
	BFW_NX50_gpio_irq_raw_gpio17 = 1, /* [17] */
	BFW_NX50_gpio_irq_raw_gpio18 = 1, /* [18] */
	BFW_NX50_gpio_irq_raw_gpio19 = 1, /* [19] */
	BFW_NX50_gpio_irq_raw_gpio20 = 1, /* [20] */
	BFW_NX50_gpio_irq_raw_gpio21 = 1, /* [21] */
	BFW_NX50_gpio_irq_raw_gpio22 = 1, /* [22] */
	BFW_NX50_gpio_irq_raw_gpio23 = 1, /* [23] */
	BFW_NX50_gpio_irq_raw_gpio24 = 1, /* [24] */
	BFW_NX50_gpio_irq_raw_gpio25 = 1, /* [25] */
	BFW_NX50_gpio_irq_raw_gpio26 = 1, /* [26] */
	BFW_NX50_gpio_irq_raw_gpio27 = 1, /* [27] */
	BFW_NX50_gpio_irq_raw_gpio28 = 1, /* [28] */
	BFW_NX50_gpio_irq_raw_gpio29 = 1, /* [29] */
	BFW_NX50_gpio_irq_raw_gpio30 = 1, /* [30] */
	BFW_NX50_gpio_irq_raw_gpio31 = 1  /* [31] */
};

typedef struct NX50_GPIO_IRQ_RAW_BIT_Ttag {
	unsigned int gpio0  : BFW_NX50_gpio_irq_raw_gpio0;  /* interrupt bit for GPIO0   or IO-Link0-cycle timer interrupt                 */
	unsigned int gpio1  : BFW_NX50_gpio_irq_raw_gpio1;  /* interrupt bit for GPIO1   or IO-Link0-tx_interrupt                          */
	unsigned int gpio2  : BFW_NX50_gpio_irq_raw_gpio2;  /* interrupt bit for GPIO2   or IO-Link0-rx_interrupt                          */
	unsigned int gpio3  : BFW_NX50_gpio_irq_raw_gpio3;  /* interrupt bit for GPIO3   or IO-Link0-wakeup_interrupt                      */
	unsigned int gpio4  : BFW_NX50_gpio_irq_raw_gpio4;  /* interrupt bit for GPIO4   or IO-Link1-cycle timer interrupt                 */
	unsigned int gpio5  : BFW_NX50_gpio_irq_raw_gpio5;  /* interrupt bit for GPIO5   or IO-Link1-tx_interrupt  # default 0        lt 0 */
	unsigned int gpio6  : BFW_NX50_gpio_irq_raw_gpio6;  /* interrupt bit for GPIO6   or IO-Link1-rx_interrupt                          */
	unsigned int gpio7  : BFW_NX50_gpio_irq_raw_gpio7;  /* interrupt bit for GPIO7   or IO-Link1-wakeup_interrupt                      */
	unsigned int gpio8  : BFW_NX50_gpio_irq_raw_gpio8;  /* interrupt bit for GPIO8   or IO-Link2-cycle timer interrupt                 */
	unsigned int gpio9  : BFW_NX50_gpio_irq_raw_gpio9;  /* interrupt bit for GPIO9   or IO-Link2-tx_interrupt                          */
	unsigned int gpio10 : BFW_NX50_gpio_irq_raw_gpio10; /* interrupt bit for GPIO10  or IO-Link2-rx_interrupt                          */
	unsigned int gpio11 : BFW_NX50_gpio_irq_raw_gpio11; /* interrupt bit for GPIO11  or IO-Link2-wakeup_interrupt                      */
	unsigned int gpio12 : BFW_NX50_gpio_irq_raw_gpio12; /* interrupt bit for GPIO12  or IO-Link3-cycle timer interrupt                 */
	unsigned int gpio13 : BFW_NX50_gpio_irq_raw_gpio13; /* interrupt bit for GPIO13  or IO-Link3-tx_interrupt                          */
	unsigned int gpio14 : BFW_NX50_gpio_irq_raw_gpio14; /* interrupt bit for GPIO14  or IO-Link3-rx_interrupt                          */
	unsigned int gpio15 : BFW_NX50_gpio_irq_raw_gpio15; /* interrupt bit for GPIO15  or IO-Link3-wakeup_interrupt                      */
	unsigned int gpio16 : BFW_NX50_gpio_irq_raw_gpio16; /* interrupt bit for GPIO16  or IO-Link4-cycle timer interrupt                 */
	unsigned int gpio17 : BFW_NX50_gpio_irq_raw_gpio17; /* interrupt bit for GPIO17  or IO-Link4-tx_interrupt                          */
	unsigned int gpio18 : BFW_NX50_gpio_irq_raw_gpio18; /* interrupt bit for GPIO18  or IO-Link4-rx_interrupt                          */
	unsigned int gpio19 : BFW_NX50_gpio_irq_raw_gpio19; /* interrupt bit for GPIO19  or IO-Link4-wakeup_interrupt                      */
	unsigned int gpio20 : BFW_NX50_gpio_irq_raw_gpio20; /* interrupt bit for GPIO20  or IO-Link5-cycle timer interrupt                 */
	unsigned int gpio21 : BFW_NX50_gpio_irq_raw_gpio21; /* interrupt bit for GPIO21  or IO-Link5-tx_interrupt                          */
	unsigned int gpio22 : BFW_NX50_gpio_irq_raw_gpio22; /* interrupt bit for GPIO22  or IO-Link5-rx_interrupt                          */
	unsigned int gpio23 : BFW_NX50_gpio_irq_raw_gpio23; /* interrupt bit for GPIO23  or IO-Link5-wakeup_interrupt                      */
	unsigned int gpio24 : BFW_NX50_gpio_irq_raw_gpio24; /* interrupt bit for GPIO24  or IO-Link6-cycle timer interrupt                 */
	unsigned int gpio25 : BFW_NX50_gpio_irq_raw_gpio25; /* interrupt bit for GPIO25  or IO-Link6-tx_interrupt                          */
	unsigned int gpio26 : BFW_NX50_gpio_irq_raw_gpio26; /* interrupt bit for GPIO26  or IO-Link6-rx_interrupt                          */
	unsigned int gpio27 : BFW_NX50_gpio_irq_raw_gpio27; /* interrupt bit for GPIO27  or IO-Link6-wakeup_interrupt                      */
	unsigned int gpio28 : BFW_NX50_gpio_irq_raw_gpio28; /* interrupt bit for GPIO28  or IO-Link7-cycle timer interrupt                 */
	unsigned int gpio29 : BFW_NX50_gpio_irq_raw_gpio29; /* interrupt bit for GPIO29  or IO-Link7-tx_interrupt                          */
	unsigned int gpio30 : BFW_NX50_gpio_irq_raw_gpio30; /* interrupt bit for GPIO30  or IO-Link7-rx_interrupt                          */
	unsigned int gpio31 : BFW_NX50_gpio_irq_raw_gpio31; /* interrupt bit for GPIO31  or IO-Link7-wakeup_interrupt                      */
} NX50_GPIO_IRQ_RAW_BIT_T;

typedef union {
	unsigned int            val;
	NX50_GPIO_IRQ_RAW_BIT_T bf;
} NX50_GPIO_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq_masked */
/* => GPIO Masked IRQ register */
/*    Read access shows status of masked IRQs (as connected to VIC/ARM) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_irq_masked  0x0000014CU
#define Adr_NX50_gpio_gpio_irq_masked 0x1C00094CU
#define Adr_NX50_gpio_irq_masked      0x1C00094CU

#define MSK_NX50_gpio_irq_masked_gpio 0xffffffffU
#define SRT_NX50_gpio_irq_masked_gpio 0

enum {
	BFW_NX50_gpio_irq_masked_gpio = 32  /* [31:0] */
};

typedef struct NX50_GPIO_IRQ_MASKED_BIT_Ttag {
	unsigned int gpio : BFW_NX50_gpio_irq_masked_gpio; /* One bit per GPIO */
} NX50_GPIO_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int               val;
	NX50_GPIO_IRQ_MASKED_BIT_T bf;
} NX50_GPIO_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq_mask_set */
/* => GPIO interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding GPIO) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/*    Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_gpio_irq_raw */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_irq_mask_set  0x00000150U
#define Adr_NX50_gpio_gpio_irq_mask_set 0x1C000950U
#define Adr_NX50_gpio_irq_mask_set      0x1C000950U
#define DFLT_VAL_NX50_gpio_irq_mask_set 0x00000000U

#define MSK_NX50_gpio_irq_mask_set_gpio      0xffffffffU
#define SRT_NX50_gpio_irq_mask_set_gpio      0
#define DFLT_VAL_NX50_gpio_irq_mask_set_gpio 0x00000000U

enum {
	BFW_NX50_gpio_irq_mask_set_gpio = 32  /* [31:0] */
};

typedef struct NX50_GPIO_IRQ_MASK_SET_BIT_Ttag {
	unsigned int gpio : BFW_NX50_gpio_irq_mask_set_gpio; /* One bit per GPIO */
} NX50_GPIO_IRQ_MASK_SET_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_IRQ_MASK_SET_BIT_T bf;
} NX50_GPIO_IRQ_MASK_SET_T;

/* --------------------------------------------------------------------- */
/* Register gpio_irq_mask_rst */
/* => GPIO interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding GPIO) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_gpio_irq_mask_rst  0x00000154U
#define Adr_NX50_gpio_gpio_irq_mask_rst 0x1C000954U
#define Adr_NX50_gpio_irq_mask_rst      0x1C000954U
#define DFLT_VAL_NX50_gpio_irq_mask_rst 0x00000000U

#define MSK_NX50_gpio_irq_mask_rst_gpio      0xffffffffU
#define SRT_NX50_gpio_irq_mask_rst_gpio      0
#define DFLT_VAL_NX50_gpio_irq_mask_rst_gpio 0x00000000U

enum {
	BFW_NX50_gpio_irq_mask_rst_gpio = 32  /* [31:0] */
};

typedef struct NX50_GPIO_IRQ_MASK_RST_BIT_Ttag {
	unsigned int gpio : BFW_NX50_gpio_irq_mask_rst_gpio; /* One bit per GPIO */
} NX50_GPIO_IRQ_MASK_RST_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_GPIO_IRQ_MASK_RST_BIT_T bf;
} NX50_GPIO_IRQ_MASK_RST_T;

/* --------------------------------------------------------------------- */
/* Register cnt_irq_raw */
/* => Counter Raw IRQ register */
/*    Write access with '1' resets the appropriate IRQ */
/*    Write access with '0' does not influence this bit */
/*    Read access shows status of unmasked IRQs */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cnt_irq_raw  0x00000158U
#define Adr_NX50_gpio_cnt_irq_raw 0x1C000958U
#define Adr_NX50_cnt_irq_raw      0x1C000958U
#define DFLT_VAL_NX50_cnt_irq_raw 0x00000000U

#define MSK_NX50_cnt_irq_raw_cnt0          0x00000001U
#define SRT_NX50_cnt_irq_raw_cnt0          0
#define DFLT_VAL_NX50_cnt_irq_raw_cnt0     0x00000000U
#define MSK_NX50_cnt_irq_raw_cnt1          0x00000002U
#define SRT_NX50_cnt_irq_raw_cnt1          1
#define DFLT_VAL_NX50_cnt_irq_raw_cnt1     0x00000000U
#define MSK_NX50_cnt_irq_raw_cnt2          0x00000004U
#define SRT_NX50_cnt_irq_raw_cnt2          2
#define DFLT_VAL_NX50_cnt_irq_raw_cnt2     0x00000000U
#define MSK_NX50_cnt_irq_raw_cnt3          0x00000008U
#define SRT_NX50_cnt_irq_raw_cnt3          3
#define DFLT_VAL_NX50_cnt_irq_raw_cnt3     0x00000000U
#define MSK_NX50_cnt_irq_raw_cnt4          0x00000010U
#define SRT_NX50_cnt_irq_raw_cnt4          4
#define DFLT_VAL_NX50_cnt_irq_raw_cnt4     0x00000000U
#define MSK_NX50_cnt_irq_raw_sys_time      0x00000020U
#define SRT_NX50_cnt_irq_raw_sys_time      5
#define DFLT_VAL_NX50_cnt_irq_raw_sys_time 0x00000000U

enum {
	BFW_NX50_cnt_irq_raw_cnt0      = 1,  /* [0] */
	BFW_NX50_cnt_irq_raw_cnt1      = 1,  /* [1] */
	BFW_NX50_cnt_irq_raw_cnt2      = 1,  /* [2] */
	BFW_NX50_cnt_irq_raw_cnt3      = 1,  /* [3] */
	BFW_NX50_cnt_irq_raw_cnt4      = 1,  /* [4] */
	BFW_NX50_cnt_irq_raw_sys_time  = 1,  /* [5] */
	BFW_NX50_cnt_irq_raw_reserved1 = 26  /* [31:6] */
};

typedef struct NX50_CNT_IRQ_RAW_BIT_Ttag {
	unsigned int cnt0      : BFW_NX50_cnt_irq_raw_cnt0;      /* interrupt bit for counter0                                  */
	unsigned int cnt1      : BFW_NX50_cnt_irq_raw_cnt1;      /* interrupt bit for counter1                                  */
	unsigned int cnt2      : BFW_NX50_cnt_irq_raw_cnt2;      /* interrupt bit for counter2                                  */
	unsigned int cnt3      : BFW_NX50_cnt_irq_raw_cnt3;      /* interrupt bit for counter3                                  */
	unsigned int cnt4      : BFW_NX50_cnt_irq_raw_cnt4;      /* interrupt bit for counter4                                  */
	unsigned int sys_time  : BFW_NX50_cnt_irq_raw_sys_time;  /* interrupt bit for sys_time (if sys_time = gpio_systime_cmp) */
	unsigned int reserved1 : BFW_NX50_cnt_irq_raw_reserved1; /* reserved                                                    */
} NX50_CNT_IRQ_RAW_BIT_T;

typedef union {
	unsigned int           val;
	NX50_CNT_IRQ_RAW_BIT_T bf;
} NX50_CNT_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register cnt_irq_masked */
/* => Counter Masked IRQ register */
/*    Read access shows status of masked IRQs (as connected to VIC/ARM) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cnt_irq_masked  0x0000015CU
#define Adr_NX50_gpio_cnt_irq_masked 0x1C00095CU
#define Adr_NX50_cnt_irq_masked      0x1C00095CU

#define MSK_NX50_cnt_irq_masked_cnt0     0x00000001U
#define SRT_NX50_cnt_irq_masked_cnt0     0
#define MSK_NX50_cnt_irq_masked_cnt1     0x00000002U
#define SRT_NX50_cnt_irq_masked_cnt1     1
#define MSK_NX50_cnt_irq_masked_cnt2     0x00000004U
#define SRT_NX50_cnt_irq_masked_cnt2     2
#define MSK_NX50_cnt_irq_masked_cnt3     0x00000008U
#define SRT_NX50_cnt_irq_masked_cnt3     3
#define MSK_NX50_cnt_irq_masked_cnt4     0x00000010U
#define SRT_NX50_cnt_irq_masked_cnt4     4
#define MSK_NX50_cnt_irq_masked_sys_time 0x00000020U
#define SRT_NX50_cnt_irq_masked_sys_time 5

enum {
	BFW_NX50_cnt_irq_masked_cnt0      = 1,  /* [0] */
	BFW_NX50_cnt_irq_masked_cnt1      = 1,  /* [1] */
	BFW_NX50_cnt_irq_masked_cnt2      = 1,  /* [2] */
	BFW_NX50_cnt_irq_masked_cnt3      = 1,  /* [3] */
	BFW_NX50_cnt_irq_masked_cnt4      = 1,  /* [4] */
	BFW_NX50_cnt_irq_masked_sys_time  = 1,  /* [5] */
	BFW_NX50_cnt_irq_masked_reserved1 = 26  /* [31:6] */
};

typedef struct NX50_CNT_IRQ_MASKED_BIT_Ttag {
	unsigned int cnt0      : BFW_NX50_cnt_irq_masked_cnt0;      /* interrupt bit for counter0                                  */
	unsigned int cnt1      : BFW_NX50_cnt_irq_masked_cnt1;      /* interrupt bit for counter1                                  */
	unsigned int cnt2      : BFW_NX50_cnt_irq_masked_cnt2;      /* interrupt bit for counter2                                  */
	unsigned int cnt3      : BFW_NX50_cnt_irq_masked_cnt3;      /* interrupt bit for counter3                                  */
	unsigned int cnt4      : BFW_NX50_cnt_irq_masked_cnt4;      /* interrupt bit for counter4                                  */
	unsigned int sys_time  : BFW_NX50_cnt_irq_masked_sys_time;  /* interrupt bit for sys_time (if sys_time = gpio_systime_cmp) */
	unsigned int reserved1 : BFW_NX50_cnt_irq_masked_reserved1; /* reserved                                                    */
} NX50_CNT_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int              val;
	NX50_CNT_IRQ_MASKED_BIT_T bf;
} NX50_CNT_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register cnt_irq_mask_set */
/* => Counter interrupt mask enable */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding counter) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/*    Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_cnt_irq_raw */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cnt_irq_mask_set  0x00000160U
#define Adr_NX50_gpio_cnt_irq_mask_set 0x1C000960U
#define Adr_NX50_cnt_irq_mask_set      0x1C000960U
#define DFLT_VAL_NX50_cnt_irq_mask_set 0x00000000U

#define MSK_NX50_cnt_irq_mask_set_cnt0         0x00000001U
#define SRT_NX50_cnt_irq_mask_set_cnt0         0
#define DFLT_VAL_NX50_cnt_irq_mask_set_cnt0    0x00000000U
#define MSK_NX50_cnt_irq_mask_set_cnt1         0x00000002U
#define SRT_NX50_cnt_irq_mask_set_cnt1         1
#define DFLT_VAL_NX50_cnt_irq_mask_set_cnt1    0x00000000U
#define MSK_NX50_cnt_irq_mask_set_cnt2         0x00000004U
#define SRT_NX50_cnt_irq_mask_set_cnt2         2
#define DFLT_VAL_NX50_cnt_irq_mask_set_cnt2    0x00000000U
#define MSK_NX50_cnt_irq_mask_set_cnt3         0x00000008U
#define SRT_NX50_cnt_irq_mask_set_cnt3         3
#define DFLT_VAL_NX50_cnt_irq_mask_set_cnt3    0x00000000U
#define MSK_NX50_cnt_irq_mask_set_cnt4         0x00000010U
#define SRT_NX50_cnt_irq_mask_set_cnt4         4
#define DFLT_VAL_NX50_cnt_irq_mask_set_cnt4    0x00000000U
#define MSK_NX50_cnt_irq_mask_set_systime      0x00000020U
#define SRT_NX50_cnt_irq_mask_set_systime      5
#define DFLT_VAL_NX50_cnt_irq_mask_set_systime 0x00000000U

enum {
	BFW_NX50_cnt_irq_mask_set_cnt0      = 1,  /* [0] */
	BFW_NX50_cnt_irq_mask_set_cnt1      = 1,  /* [1] */
	BFW_NX50_cnt_irq_mask_set_cnt2      = 1,  /* [2] */
	BFW_NX50_cnt_irq_mask_set_cnt3      = 1,  /* [3] */
	BFW_NX50_cnt_irq_mask_set_cnt4      = 1,  /* [4] */
	BFW_NX50_cnt_irq_mask_set_systime   = 1,  /* [5] */
	BFW_NX50_cnt_irq_mask_set_reserved1 = 26  /* [31:6] */
};

typedef struct NX50_CNT_IRQ_MASK_SET_BIT_Ttag {
	unsigned int cnt0      : BFW_NX50_cnt_irq_mask_set_cnt0;      /* counter0 interrupt mask bit */
	unsigned int cnt1      : BFW_NX50_cnt_irq_mask_set_cnt1;      /* counter1 interrupt mask bit */
	unsigned int cnt2      : BFW_NX50_cnt_irq_mask_set_cnt2;      /* counter2 interrupt mask bit */
	unsigned int cnt3      : BFW_NX50_cnt_irq_mask_set_cnt3;      /* counter3 interrupt mask bit */
	unsigned int cnt4      : BFW_NX50_cnt_irq_mask_set_cnt4;      /* counter4 interrupt mask bit */
	unsigned int systime   : BFW_NX50_cnt_irq_mask_set_systime;   /* sys_time interrupt mask bit */
	unsigned int reserved1 : BFW_NX50_cnt_irq_mask_set_reserved1; /* reserved                    */
} NX50_CNT_IRQ_MASK_SET_BIT_T;

typedef union {
	unsigned int                val;
	NX50_CNT_IRQ_MASK_SET_BIT_T bf;
} NX50_CNT_IRQ_MASK_SET_T;

/* --------------------------------------------------------------------- */
/* Register cnt_irq_mask_rst */
/* => Counter interrupt mask disable */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding counter) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cnt_irq_mask_rst  0x00000164U
#define Adr_NX50_gpio_cnt_irq_mask_rst 0x1C000964U
#define Adr_NX50_cnt_irq_mask_rst      0x1C000964U
#define DFLT_VAL_NX50_cnt_irq_mask_rst 0x00000000U

#define MSK_NX50_cnt_irq_mask_rst_cnt0         0x00000001U
#define SRT_NX50_cnt_irq_mask_rst_cnt0         0
#define DFLT_VAL_NX50_cnt_irq_mask_rst_cnt0    0x00000000U
#define MSK_NX50_cnt_irq_mask_rst_cnt1         0x00000002U
#define SRT_NX50_cnt_irq_mask_rst_cnt1         1
#define DFLT_VAL_NX50_cnt_irq_mask_rst_cnt1    0x00000000U
#define MSK_NX50_cnt_irq_mask_rst_cnt2         0x00000004U
#define SRT_NX50_cnt_irq_mask_rst_cnt2         2
#define DFLT_VAL_NX50_cnt_irq_mask_rst_cnt2    0x00000000U
#define MSK_NX50_cnt_irq_mask_rst_cnt3         0x00000008U
#define SRT_NX50_cnt_irq_mask_rst_cnt3         3
#define DFLT_VAL_NX50_cnt_irq_mask_rst_cnt3    0x00000000U
#define MSK_NX50_cnt_irq_mask_rst_cnt4         0x00000010U
#define SRT_NX50_cnt_irq_mask_rst_cnt4         4
#define DFLT_VAL_NX50_cnt_irq_mask_rst_cnt4    0x00000000U
#define MSK_NX50_cnt_irq_mask_rst_systime      0x00000020U
#define SRT_NX50_cnt_irq_mask_rst_systime      5
#define DFLT_VAL_NX50_cnt_irq_mask_rst_systime 0x00000000U

enum {
	BFW_NX50_cnt_irq_mask_rst_cnt0      = 1,  /* [0] */
	BFW_NX50_cnt_irq_mask_rst_cnt1      = 1,  /* [1] */
	BFW_NX50_cnt_irq_mask_rst_cnt2      = 1,  /* [2] */
	BFW_NX50_cnt_irq_mask_rst_cnt3      = 1,  /* [3] */
	BFW_NX50_cnt_irq_mask_rst_cnt4      = 1,  /* [4] */
	BFW_NX50_cnt_irq_mask_rst_systime   = 1,  /* [5] */
	BFW_NX50_cnt_irq_mask_rst_reserved1 = 26  /* [31:6] */
};

typedef struct NX50_CNT_IRQ_MASK_RST_BIT_Ttag {
	unsigned int cnt0      : BFW_NX50_cnt_irq_mask_rst_cnt0;      /* counter0 interrupt mask bit */
	unsigned int cnt1      : BFW_NX50_cnt_irq_mask_rst_cnt1;      /* counter1 interrupt mask bit */
	unsigned int cnt2      : BFW_NX50_cnt_irq_mask_rst_cnt2;      /* counter2 interrupt mask bit */
	unsigned int cnt3      : BFW_NX50_cnt_irq_mask_rst_cnt3;      /* counter3 interrupt mask bit */
	unsigned int cnt4      : BFW_NX50_cnt_irq_mask_rst_cnt4;      /* counter4 interrupt mask bit */
	unsigned int systime   : BFW_NX50_cnt_irq_mask_rst_systime;   /* sys_time interrupt mask bit */
	unsigned int reserved1 : BFW_NX50_cnt_irq_mask_rst_reserved1; /* reserved                    */
} NX50_CNT_IRQ_MASK_RST_BIT_T;

typedef union {
	unsigned int                val;
	NX50_CNT_IRQ_MASK_RST_BIT_T bf;
} NX50_CNT_IRQ_MASK_RST_T;


/* ===================================================================== */

/* AREA iolink */
/* Area of iolink0, iolink1, iolink2, iolink3, iolink4, iolink5, iolink6, iolink7 */

/* ===================================================================== */

#define Addr_NX50_iolink0      0x1C000880U
#define NX50_NETX_IOLINK0_AREA 0x1C000880U
#define Addr_NX50_iolink1      0x1C000890U
#define NX50_NETX_IOLINK1_AREA 0x1C000890U
#define Addr_NX50_iolink2      0x1C0008A0U
#define NX50_NETX_IOLINK2_AREA 0x1C0008A0U
#define Addr_NX50_iolink3      0x1C0008B0U
#define NX50_NETX_IOLINK3_AREA 0x1C0008B0U
#define Addr_NX50_iolink4      0x1C0008C0U
#define NX50_NETX_IOLINK4_AREA 0x1C0008C0U
#define Addr_NX50_iolink5      0x1C0008D0U
#define NX50_NETX_IOLINK5_AREA 0x1C0008D0U
#define Addr_NX50_iolink6      0x1C0008E0U
#define NX50_NETX_IOLINK6_AREA 0x1C0008E0U
#define Addr_NX50_iolink7      0x1C0008F0U
#define NX50_NETX_IOLINK7_AREA 0x1C0008F0U

/* --------------------------------------------------------------------- */
/* Register iolink_cfg */
/* => IO-Link configuration register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_iolink_cfg     0x00000000U
#define Adr_NX50_iolink0_iolink_cfg 0x1C000880U
#define Adr_NX50_iolink1_iolink_cfg 0x1C000890U
#define Adr_NX50_iolink2_iolink_cfg 0x1C0008A0U
#define Adr_NX50_iolink3_iolink_cfg 0x1C0008B0U
#define Adr_NX50_iolink4_iolink_cfg 0x1C0008C0U
#define Adr_NX50_iolink5_iolink_cfg 0x1C0008D0U
#define Adr_NX50_iolink6_iolink_cfg 0x1C0008E0U
#define Adr_NX50_iolink7_iolink_cfg 0x1C0008F0U
#define DFLT_VAL_NX50_iolink_cfg    0x00000000U

#define MSK_NX50_iolink_cfg_frame_cycle           0x000000ffU
#define SRT_NX50_iolink_cfg_frame_cycle           0
#define DFLT_VAL_NX50_iolink_cfg_frame_cycle      0x00000000U
#define MSK_NX50_iolink_cfg_freq_sel              0x00000300U
#define SRT_NX50_iolink_cfg_freq_sel              8
#define DFLT_VAL_NX50_iolink_cfg_freq_sel         0x00000000U
#define MSK_NX50_iolink_cfg_nr_tx_oct             0x00001c00U
#define SRT_NX50_iolink_cfg_nr_tx_oct             10
#define DFLT_VAL_NX50_iolink_cfg_nr_tx_oct        0x00000000U
#define MSK_NX50_iolink_cfg_nr_rx_oct             0x00006000U
#define SRT_NX50_iolink_cfg_nr_rx_oct             13
#define DFLT_VAL_NX50_iolink_cfg_nr_rx_oct        0x00000000U
#define MSK_NX50_iolink_cfg_sngl_trans            0x00010000U
#define SRT_NX50_iolink_cfg_sngl_trans            16
#define DFLT_VAL_NX50_iolink_cfg_sngl_trans       0x00000000U
#define MSK_NX50_iolink_cfg_tx_lsb_first          0x00020000U
#define SRT_NX50_iolink_cfg_tx_lsb_first          17
#define DFLT_VAL_NX50_iolink_cfg_tx_lsb_first     0x00000000U
#define MSK_NX50_iolink_cfg_tx_init               0x00040000U
#define SRT_NX50_iolink_cfg_tx_init               18
#define DFLT_VAL_NX50_iolink_cfg_tx_init          0x00000000U
#define MSK_NX50_iolink_cfg_en_frame_timeout      0x00080000U
#define SRT_NX50_iolink_cfg_en_frame_timeout      19
#define DFLT_VAL_NX50_iolink_cfg_en_frame_timeout 0x00000000U
#define MSK_NX50_iolink_cfg_tx_oe_dis             0x00100000U
#define SRT_NX50_iolink_cfg_tx_oe_dis             20
#define DFLT_VAL_NX50_iolink_cfg_tx_oe_dis        0x00000000U
#define MSK_NX50_iolink_cfg_tx_loop               0x00200000U
#define SRT_NX50_iolink_cfg_tx_loop               21
#define DFLT_VAL_NX50_iolink_cfg_tx_loop          0x00000000U
#define MSK_NX50_iolink_cfg_en_delay              0x00400000U
#define SRT_NX50_iolink_cfg_en_delay              22
#define DFLT_VAL_NX50_iolink_cfg_en_delay         0x00000000U
#define MSK_NX50_iolink_cfg_latch_dval            0x00800000U
#define SRT_NX50_iolink_cfg_latch_dval            23
#define DFLT_VAL_NX50_iolink_cfg_latch_dval       0x00000000U
#define MSK_NX50_iolink_cfg_enable_fm_intr        0x01000000U
#define SRT_NX50_iolink_cfg_enable_fm_intr        24
#define DFLT_VAL_NX50_iolink_cfg_enable_fm_intr   0x00000000U
#define MSK_NX50_iolink_cfg_pio_tx_oe_active      0x02000000U
#define SRT_NX50_iolink_cfg_pio_tx_oe_active      25
#define DFLT_VAL_NX50_iolink_cfg_pio_tx_oe_active 0x00000000U
#define MSK_NX50_iolink_cfg_gen_wake_up           0x04000000U
#define SRT_NX50_iolink_cfg_gen_wake_up           26
#define DFLT_VAL_NX50_iolink_cfg_gen_wake_up      0x00000000U
#define MSK_NX50_iolink_cfg_rx_lsb_first          0x08000000U
#define SRT_NX50_iolink_cfg_rx_lsb_first          27
#define DFLT_VAL_NX50_iolink_cfg_rx_lsb_first     0x00000000U
#define MSK_NX50_iolink_cfg_debug_vec             0x70000000U
#define SRT_NX50_iolink_cfg_debug_vec             28
#define DFLT_VAL_NX50_iolink_cfg_debug_vec        0x00000000U
#define MSK_NX50_iolink_cfg_set_status            0x80000000U
#define SRT_NX50_iolink_cfg_set_status            31
#define DFLT_VAL_NX50_iolink_cfg_set_status       0x00000000U

enum {
	BFW_NX50_iolink_cfg_frame_cycle      = 8, /* [7:0] */
	BFW_NX50_iolink_cfg_freq_sel         = 2, /* [9:8] */
	BFW_NX50_iolink_cfg_nr_tx_oct        = 3, /* [12:10] */
	BFW_NX50_iolink_cfg_nr_rx_oct        = 2, /* [14:13] */
	BFW_NX50_iolink_cfg_reserved1        = 1, /* [15] */
	BFW_NX50_iolink_cfg_sngl_trans       = 1, /* [16] */
	BFW_NX50_iolink_cfg_tx_lsb_first     = 1, /* [17] */
	BFW_NX50_iolink_cfg_tx_init          = 1, /* [18] */
	BFW_NX50_iolink_cfg_en_frame_timeout = 1, /* [19] */
	BFW_NX50_iolink_cfg_tx_oe_dis        = 1, /* [20] */
	BFW_NX50_iolink_cfg_tx_loop          = 1, /* [21] */
	BFW_NX50_iolink_cfg_en_delay         = 1, /* [22] */
	BFW_NX50_iolink_cfg_latch_dval       = 1, /* [23] */
	BFW_NX50_iolink_cfg_enable_fm_intr   = 1, /* [24] */
	BFW_NX50_iolink_cfg_pio_tx_oe_active = 1, /* [25] */
	BFW_NX50_iolink_cfg_gen_wake_up      = 1, /* [26] */
	BFW_NX50_iolink_cfg_rx_lsb_first     = 1, /* [27] */
	BFW_NX50_iolink_cfg_debug_vec        = 3, /* [30:28] */
	BFW_NX50_iolink_cfg_set_status       = 1  /* [31] */
};

typedef struct NX50_IOLINK_CFG_BIT_Ttag {
	unsigned int frame_cycle      : BFW_NX50_iolink_cfg_frame_cycle;      /* Half of number of T_clk cycles, this compare value is doubled by the hardware! */
	unsigned int freq_sel         : BFW_NX50_iolink_cfg_freq_sel;         /* Set the baud rate  (T_clk):                                                    */
	                                                                      /* 00: 250ns  test only                                                           */
	unsigned int nr_tx_oct        : BFW_NX50_iolink_cfg_nr_tx_oct;        /* Number for octets to transmit                                                  */
	                                                                      /* _________________________                                                      */
	unsigned int nr_rx_oct        : BFW_NX50_iolink_cfg_nr_rx_oct;        /* Number for octets to receive:                                                  */
	                                                                      /* _________________________                                                      */
	unsigned int reserved1        : BFW_NX50_iolink_cfg_reserved1;        /* reserved                                                                       */
	unsigned int sngl_trans       : BFW_NX50_iolink_cfg_sngl_trans;       /* Single frame transfer mode:                                                    */
	                                                                      /* Reset and set this bit to activate the transfer.                               */
	unsigned int tx_lsb_first     : BFW_NX50_iolink_cfg_tx_lsb_first;     /* LSByte first for transmit process.                                             */
	unsigned int tx_init          : BFW_NX50_iolink_cfg_tx_init;          /* Default tx output level.                                                       */
	unsigned int en_frame_timeout : BFW_NX50_iolink_cfg_en_frame_timeout; /* Enable the frame timeout function.                                             */
	unsigned int tx_oe_dis        : BFW_NX50_iolink_cfg_tx_oe_dis;        /* Disable the tx_oe generation if wake up generation proceeds.                   */
	unsigned int tx_loop          : BFW_NX50_iolink_cfg_tx_loop;          /* Enable tx auto repeat transmission.                                            */
	unsigned int en_delay         : BFW_NX50_iolink_cfg_en_delay;         /* Enable delay function before transmitting the frame.                           */
	                                                                      /* The delay value is the tx_octet8 byte of the adr_iolink_tx_frame_2nd register. */
	unsigned int latch_dval       : BFW_NX50_iolink_cfg_latch_dval;       /* Latch the delay value (from frame_cycle_r).                                    */
	                                                                      /* Set this bit to write the delay value.                                         */
	unsigned int enable_fm_intr   : BFW_NX50_iolink_cfg_enable_fm_intr;   /* Enable frame interrupt.                                                        */
	unsigned int pio_tx_oe_active : BFW_NX50_iolink_cfg_pio_tx_oe_active; /* Activate the link output control.                                              */
	unsigned int gen_wake_up      : BFW_NX50_iolink_cfg_gen_wake_up;      /* Set this bit to generate one wake up pulse,                                    */
	                                                                      /* set the tx_init_r according to the WAKE_H/WAKE_L coding.                       */
	unsigned int rx_lsb_first     : BFW_NX50_iolink_cfg_rx_lsb_first;     /* LSByte first for receive process.                                              */
	unsigned int debug_vec        : BFW_NX50_iolink_cfg_debug_vec;        /* Debug vector, must not be changed on operation.                                */
	unsigned int set_status       : BFW_NX50_iolink_cfg_set_status;       /* If set, status vector will be mapped to this register address.                 */
	                                                                      /* A read access to this register will then show the following information:       */
} NX50_IOLINK_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_IOLINK_CFG_BIT_T bf;
} NX50_IOLINK_CFG_T;

/* --------------------------------------------------------------------- */
/* Register iolink_tx_frame_1st */
/* => IO-Link TX0 data register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_iolink_tx_frame_1st     0x00000004U
#define Adr_NX50_iolink0_iolink_tx_frame_1st 0x1C000884U
#define Adr_NX50_iolink1_iolink_tx_frame_1st 0x1C000894U
#define Adr_NX50_iolink2_iolink_tx_frame_1st 0x1C0008A4U
#define Adr_NX50_iolink3_iolink_tx_frame_1st 0x1C0008B4U
#define Adr_NX50_iolink4_iolink_tx_frame_1st 0x1C0008C4U
#define Adr_NX50_iolink5_iolink_tx_frame_1st 0x1C0008D4U
#define Adr_NX50_iolink6_iolink_tx_frame_1st 0x1C0008E4U
#define Adr_NX50_iolink7_iolink_tx_frame_1st 0x1C0008F4U
#define DFLT_VAL_NX50_iolink_tx_frame_1st    0x00000000U

#define MSK_NX50_iolink_tx_frame_1st_tx_octet1      0x000000ffU
#define SRT_NX50_iolink_tx_frame_1st_tx_octet1      0
#define DFLT_VAL_NX50_iolink_tx_frame_1st_tx_octet1 0x00000000U
#define MSK_NX50_iolink_tx_frame_1st_tx_octet2      0x0000ff00U
#define SRT_NX50_iolink_tx_frame_1st_tx_octet2      8
#define DFLT_VAL_NX50_iolink_tx_frame_1st_tx_octet2 0x00000000U
#define MSK_NX50_iolink_tx_frame_1st_tx_octet3      0x00ff0000U
#define SRT_NX50_iolink_tx_frame_1st_tx_octet3      16
#define DFLT_VAL_NX50_iolink_tx_frame_1st_tx_octet3 0x00000000U
#define MSK_NX50_iolink_tx_frame_1st_tx_octet4      0xff000000U
#define SRT_NX50_iolink_tx_frame_1st_tx_octet4      24
#define DFLT_VAL_NX50_iolink_tx_frame_1st_tx_octet4 0x00000000U

enum {
	BFW_NX50_iolink_tx_frame_1st_tx_octet1 = 8, /* [7:0] */
	BFW_NX50_iolink_tx_frame_1st_tx_octet2 = 8, /* [15:8] */
	BFW_NX50_iolink_tx_frame_1st_tx_octet3 = 8, /* [23:16] */
	BFW_NX50_iolink_tx_frame_1st_tx_octet4 = 8  /* [31:24] */
};

typedef struct NX50_IOLINK_TX_FRAME_1ST_BIT_Ttag {
	unsigned int tx_octet1 : BFW_NX50_iolink_tx_frame_1st_tx_octet1; /* Transmit octet 1 */
	unsigned int tx_octet2 : BFW_NX50_iolink_tx_frame_1st_tx_octet2; /* Transmit octet 2 */
	unsigned int tx_octet3 : BFW_NX50_iolink_tx_frame_1st_tx_octet3; /* Transmit octet 3 */
	unsigned int tx_octet4 : BFW_NX50_iolink_tx_frame_1st_tx_octet4; /* Transmit octet 4 */
} NX50_IOLINK_TX_FRAME_1ST_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_IOLINK_TX_FRAME_1ST_BIT_T bf;
} NX50_IOLINK_TX_FRAME_1ST_T;

/* --------------------------------------------------------------------- */
/* Register iolink_tx_frame_2nd */
/* => IO-Link TX1 data register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_iolink_tx_frame_2nd     0x00000008U
#define Adr_NX50_iolink0_iolink_tx_frame_2nd 0x1C000888U
#define Adr_NX50_iolink1_iolink_tx_frame_2nd 0x1C000898U
#define Adr_NX50_iolink2_iolink_tx_frame_2nd 0x1C0008A8U
#define Adr_NX50_iolink3_iolink_tx_frame_2nd 0x1C0008B8U
#define Adr_NX50_iolink4_iolink_tx_frame_2nd 0x1C0008C8U
#define Adr_NX50_iolink5_iolink_tx_frame_2nd 0x1C0008D8U
#define Adr_NX50_iolink6_iolink_tx_frame_2nd 0x1C0008E8U
#define Adr_NX50_iolink7_iolink_tx_frame_2nd 0x1C0008F8U
#define DFLT_VAL_NX50_iolink_tx_frame_2nd    0x00000000U

#define MSK_NX50_iolink_tx_frame_2nd_tx_octet5      0x000000ffU
#define SRT_NX50_iolink_tx_frame_2nd_tx_octet5      0
#define DFLT_VAL_NX50_iolink_tx_frame_2nd_tx_octet5 0x00000000U
#define MSK_NX50_iolink_tx_frame_2nd_tx_octet6      0x0000ff00U
#define SRT_NX50_iolink_tx_frame_2nd_tx_octet6      8
#define DFLT_VAL_NX50_iolink_tx_frame_2nd_tx_octet6 0x00000000U
#define MSK_NX50_iolink_tx_frame_2nd_tx_octet7      0x00ff0000U
#define SRT_NX50_iolink_tx_frame_2nd_tx_octet7      16
#define DFLT_VAL_NX50_iolink_tx_frame_2nd_tx_octet7 0x00000000U
#define MSK_NX50_iolink_tx_frame_2nd_tx_octet8      0xff000000U
#define SRT_NX50_iolink_tx_frame_2nd_tx_octet8      24
#define DFLT_VAL_NX50_iolink_tx_frame_2nd_tx_octet8 0x00000000U

enum {
	BFW_NX50_iolink_tx_frame_2nd_tx_octet5 = 8, /* [7:0] */
	BFW_NX50_iolink_tx_frame_2nd_tx_octet6 = 8, /* [15:8] */
	BFW_NX50_iolink_tx_frame_2nd_tx_octet7 = 8, /* [23:16] */
	BFW_NX50_iolink_tx_frame_2nd_tx_octet8 = 8  /* [31:24] */
};

typedef struct NX50_IOLINK_TX_FRAME_2ND_BIT_Ttag {
	unsigned int tx_octet5 : BFW_NX50_iolink_tx_frame_2nd_tx_octet5; /* Transmit octet 5                                                                     */
	unsigned int tx_octet6 : BFW_NX50_iolink_tx_frame_2nd_tx_octet6; /* Transmit octet 6, debug only!                                                        */
	unsigned int tx_octet7 : BFW_NX50_iolink_tx_frame_2nd_tx_octet7; /* Transmit octet 7, debug only!                                                        */
	unsigned int tx_octet8 : BFW_NX50_iolink_tx_frame_2nd_tx_octet8; /* Transmit octet 8, debug only!, if en_delay_r bit set, this value is a tx delay value */
} NX50_IOLINK_TX_FRAME_2ND_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_IOLINK_TX_FRAME_2ND_BIT_T bf;
} NX50_IOLINK_TX_FRAME_2ND_T;

/* --------------------------------------------------------------------- */
/* Register iolink_rx_frame_1st */
/* => IO-Link RX data register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_iolink_rx_frame_1st     0x0000000CU
#define Adr_NX50_iolink0_iolink_rx_frame_1st 0x1C00088CU
#define Adr_NX50_iolink1_iolink_rx_frame_1st 0x1C00089CU
#define Adr_NX50_iolink2_iolink_rx_frame_1st 0x1C0008ACU
#define Adr_NX50_iolink3_iolink_rx_frame_1st 0x1C0008BCU
#define Adr_NX50_iolink4_iolink_rx_frame_1st 0x1C0008CCU
#define Adr_NX50_iolink5_iolink_rx_frame_1st 0x1C0008DCU
#define Adr_NX50_iolink6_iolink_rx_frame_1st 0x1C0008ECU
#define Adr_NX50_iolink7_iolink_rx_frame_1st 0x1C0008FCU
#define DFLT_VAL_NX50_iolink_rx_frame_1st    0x00000000U

#define MSK_NX50_iolink_rx_frame_1st_rx_octet1      0x000000ffU
#define SRT_NX50_iolink_rx_frame_1st_rx_octet1      0
#define DFLT_VAL_NX50_iolink_rx_frame_1st_rx_octet1 0x00000000U
#define MSK_NX50_iolink_rx_frame_1st_rx_octet2      0x0000ff00U
#define SRT_NX50_iolink_rx_frame_1st_rx_octet2      8
#define DFLT_VAL_NX50_iolink_rx_frame_1st_rx_octet2 0x00000000U
#define MSK_NX50_iolink_rx_frame_1st_rx_octet3      0x00ff0000U
#define SRT_NX50_iolink_rx_frame_1st_rx_octet3      16
#define DFLT_VAL_NX50_iolink_rx_frame_1st_rx_octet3 0x00000000U
#define MSK_NX50_iolink_rx_frame_1st_rx_octet4      0xff000000U
#define SRT_NX50_iolink_rx_frame_1st_rx_octet4      24
#define DFLT_VAL_NX50_iolink_rx_frame_1st_rx_octet4 0x00000000U

enum {
	BFW_NX50_iolink_rx_frame_1st_rx_octet1 = 8, /* [7:0] */
	BFW_NX50_iolink_rx_frame_1st_rx_octet2 = 8, /* [15:8] */
	BFW_NX50_iolink_rx_frame_1st_rx_octet3 = 8, /* [23:16] */
	BFW_NX50_iolink_rx_frame_1st_rx_octet4 = 8  /* [31:24] */
};

typedef struct NX50_IOLINK_RX_FRAME_1ST_BIT_Ttag {
	unsigned int rx_octet1 : BFW_NX50_iolink_rx_frame_1st_rx_octet1; /* Receive octet 1              */
	unsigned int rx_octet2 : BFW_NX50_iolink_rx_frame_1st_rx_octet2; /* Receive octet 2              */
	unsigned int rx_octet3 : BFW_NX50_iolink_rx_frame_1st_rx_octet3; /* Receive octet 3              */
	unsigned int rx_octet4 : BFW_NX50_iolink_rx_frame_1st_rx_octet4; /* Receive octet 4, debug only! */
} NX50_IOLINK_RX_FRAME_1ST_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_IOLINK_RX_FRAME_1ST_BIT_T bf;
} NX50_IOLINK_RX_FRAME_1ST_T;


/* ===================================================================== */

/* Area of pio */

/* ===================================================================== */

#define Addr_NX50_pio      0x1C000A00U
#define NX50_NETX_PIO_AREA 0x1C000A00U

/* --------------------------------------------------------------------- */
/* Register pio_in */
/* => PIO input register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pio_in 0x00000000U
#define Adr_NX50_pio_pio_in 0x1C000A00U
#define Adr_NX50_pio_in     0x1C000A00U

#define MSK_NX50_pio_in_val 0x000000ffU
#define SRT_NX50_pio_in_val 0

enum {
	BFW_NX50_pio_in_val       = 8,  /* [7:0] */
	BFW_NX50_pio_in_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_PIO_IN_BIT_Ttag {
	unsigned int val       : BFW_NX50_pio_in_val;       /* pio input values */
	unsigned int reserved1 : BFW_NX50_pio_in_reserved1; /* reserved         */
} NX50_PIO_IN_BIT_T;

typedef union {
	unsigned int      val;
	NX50_PIO_IN_BIT_T bf;
} NX50_PIO_IN_T;

/* --------------------------------------------------------------------- */
/* Register pio_out */
/* => PIO output register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pio_out  0x00000004U
#define Adr_NX50_pio_pio_out  0x1C000A04U
#define Adr_NX50_pio_out      0x1C000A04U
#define DFLT_VAL_NX50_pio_out 0x00000000U

#define MSK_NX50_pio_out_val      0x000000ffU
#define SRT_NX50_pio_out_val      0
#define DFLT_VAL_NX50_pio_out_val 0x00000000U

enum {
	BFW_NX50_pio_out_val       = 8,  /* [7:0] */
	BFW_NX50_pio_out_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_PIO_OUT_BIT_Ttag {
	unsigned int val       : BFW_NX50_pio_out_val;       /* pio output values */
	unsigned int reserved1 : BFW_NX50_pio_out_reserved1; /* reserved          */
} NX50_PIO_OUT_BIT_T;

typedef union {
	unsigned int       val;
	NX50_PIO_OUT_BIT_T bf;
} NX50_PIO_OUT_T;

/* --------------------------------------------------------------------- */
/* Register pio_oe */
/* => PIO output enable register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pio_oe  0x00000008U
#define Adr_NX50_pio_pio_oe  0x1C000A08U
#define Adr_NX50_pio_oe      0x1C000A08U
#define DFLT_VAL_NX50_pio_oe 0x00000000U

#define MSK_NX50_pio_oe_val      0x000000ffU
#define SRT_NX50_pio_oe_val      0
#define DFLT_VAL_NX50_pio_oe_val 0x00000000U

enum {
	BFW_NX50_pio_oe_val       = 8,  /* [7:0] */
	BFW_NX50_pio_oe_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_PIO_OE_BIT_Ttag {
	unsigned int val       : BFW_NX50_pio_oe_val;       /* pio output enables */
	unsigned int reserved1 : BFW_NX50_pio_oe_reserved1; /* reserved           */
} NX50_PIO_OE_BIT_T;

typedef union {
	unsigned int      val;
	NX50_PIO_OE_BIT_T bf;
} NX50_PIO_OE_T;


/* ===================================================================== */

/* AREA uart */
/* Area of uart0, uart1, uart2 */

/* ===================================================================== */

#define Addr_NX50_uart0      0x1C000B00U
#define NX50_NETX_UART0_AREA 0x1C000B00U
#define Addr_NX50_uart1      0x1C000B40U
#define NX50_NETX_UART1_AREA 0x1C000B40U
#define Addr_NX50_uart2      0x1C000B80U
#define NX50_NETX_UART2_AREA 0x1C000B80U

/* --------------------------------------------------------------------- */
/* Register uartdr */
/* => data read or written from the interface */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartdr   0x00000000U
#define Adr_NX50_uart0_uartdr 0x1C000B00U
#define Adr_NX50_uart1_uartdr 0x1C000B40U
#define Adr_NX50_uart2_uartdr 0x1C000B80U
#define DFLT_VAL_NX50_uartdr  0x00000000U

#define MSK_NX50_uartdr_DATA      0x000000ffU
#define SRT_NX50_uartdr_DATA      0
#define DFLT_VAL_NX50_uartdr_DATA 0x00000000U
#define MSK_NX50_uartdr_FE        0x00000100U
#define SRT_NX50_uartdr_FE        8
#define DFLT_VAL_NX50_uartdr_FE   0x00000000U
#define MSK_NX50_uartdr_PE        0x00000200U
#define SRT_NX50_uartdr_PE        9
#define DFLT_VAL_NX50_uartdr_PE   0x00000000U
#define MSK_NX50_uartdr_BE        0x00000400U
#define SRT_NX50_uartdr_BE        10
#define DFLT_VAL_NX50_uartdr_BE   0x00000000U

enum {
	BFW_NX50_uartdr_DATA      = 8,  /* [7:0] */
	BFW_NX50_uartdr_FE        = 1,  /* [8] */
	BFW_NX50_uartdr_PE        = 1,  /* [9] */
	BFW_NX50_uartdr_BE        = 1,  /* [10] */
	BFW_NX50_uartdr_reserved1 = 21  /* [31:11] */
};

typedef struct NX50_UARTDR_BIT_Ttag {
	unsigned int DATA      : BFW_NX50_uartdr_DATA;      /* data read or written from the interface                                         */
	unsigned int FE        : BFW_NX50_uartdr_FE;        /* Framing Error, read only, mirrored from uartrsr, to handle in DMA-read-out data */
	unsigned int PE        : BFW_NX50_uartdr_PE;        /* Parity Error, read only, mirrored from uartrsr, to handle in DMA-read-out data  */
	unsigned int BE        : BFW_NX50_uartdr_BE;        /* Break Error, read only, mirrored from uartrsr, to handle in DMA-read-out data   */
	unsigned int reserved1 : BFW_NX50_uartdr_reserved1; /* reserved                                                                        */
} NX50_UARTDR_BIT_T;

typedef union {
	unsigned int      val;
	NX50_UARTDR_BIT_T bf;
} NX50_UARTDR_T;

/* --------------------------------------------------------------------- */
/* Register uartrsr */
/* => receive status register (read) / Error Clear Register (write) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartrsr   0x00000004U
#define Adr_NX50_uart0_uartrsr 0x1C000B04U
#define Adr_NX50_uart1_uartrsr 0x1C000B44U
#define Adr_NX50_uart2_uartrsr 0x1C000B84U
#define DFLT_VAL_NX50_uartrsr  0x00000000U

#define MSK_NX50_uartrsr_FE      0x00000001U
#define SRT_NX50_uartrsr_FE      0
#define DFLT_VAL_NX50_uartrsr_FE 0x00000000U
#define MSK_NX50_uartrsr_PE      0x00000002U
#define SRT_NX50_uartrsr_PE      1
#define DFLT_VAL_NX50_uartrsr_PE 0x00000000U
#define MSK_NX50_uartrsr_BE      0x00000004U
#define SRT_NX50_uartrsr_BE      2
#define DFLT_VAL_NX50_uartrsr_BE 0x00000000U
#define MSK_NX50_uartrsr_OE      0x00000008U
#define SRT_NX50_uartrsr_OE      3
#define DFLT_VAL_NX50_uartrsr_OE 0x00000000U

enum {
	BFW_NX50_uartrsr_FE        = 1,  /* [0] */
	BFW_NX50_uartrsr_PE        = 1,  /* [1] */
	BFW_NX50_uartrsr_BE        = 1,  /* [2] */
	BFW_NX50_uartrsr_OE        = 1,  /* [3] */
	BFW_NX50_uartrsr_reserved1 = 28  /* [31:4] */
};

typedef struct NX50_UARTRSR_BIT_Ttag {
	unsigned int FE        : BFW_NX50_uartrsr_FE;        /* Framing Error */
	unsigned int PE        : BFW_NX50_uartrsr_PE;        /* Parity Error  */
	unsigned int BE        : BFW_NX50_uartrsr_BE;        /* Break Error   */
	unsigned int OE        : BFW_NX50_uartrsr_OE;        /* Overrun Error */
	unsigned int reserved1 : BFW_NX50_uartrsr_reserved1; /* reserved      */
} NX50_UARTRSR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_UARTRSR_BIT_T bf;
} NX50_UARTRSR_T;

/* --------------------------------------------------------------------- */
/* Register uartlcr_h */
/* => Line control Register, high byte */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartlcr_h   0x00000008U
#define Adr_NX50_uart0_uartlcr_h 0x1C000B08U
#define Adr_NX50_uart1_uartlcr_h 0x1C000B48U
#define Adr_NX50_uart2_uartlcr_h 0x1C000B88U
#define DFLT_VAL_NX50_uartlcr_h  0x00000000U

#define MSK_NX50_uartlcr_h_BRK       0x00000001U
#define SRT_NX50_uartlcr_h_BRK       0
#define DFLT_VAL_NX50_uartlcr_h_BRK  0x00000000U
#define MSK_NX50_uartlcr_h_PEN       0x00000002U
#define SRT_NX50_uartlcr_h_PEN       1
#define DFLT_VAL_NX50_uartlcr_h_PEN  0x00000000U
#define MSK_NX50_uartlcr_h_EPS       0x00000004U
#define SRT_NX50_uartlcr_h_EPS       2
#define DFLT_VAL_NX50_uartlcr_h_EPS  0x00000000U
#define MSK_NX50_uartlcr_h_STP2      0x00000008U
#define SRT_NX50_uartlcr_h_STP2      3
#define DFLT_VAL_NX50_uartlcr_h_STP2 0x00000000U
#define MSK_NX50_uartlcr_h_FEN       0x00000010U
#define SRT_NX50_uartlcr_h_FEN       4
#define DFLT_VAL_NX50_uartlcr_h_FEN  0x00000000U
#define MSK_NX50_uartlcr_h_WLEN      0x00000060U
#define SRT_NX50_uartlcr_h_WLEN      5
#define DFLT_VAL_NX50_uartlcr_h_WLEN 0x00000000U

enum {
	BFW_NX50_uartlcr_h_BRK       = 1,  /* [0] */
	BFW_NX50_uartlcr_h_PEN       = 1,  /* [1] */
	BFW_NX50_uartlcr_h_EPS       = 1,  /* [2] */
	BFW_NX50_uartlcr_h_STP2      = 1,  /* [3] */
	BFW_NX50_uartlcr_h_FEN       = 1,  /* [4] */
	BFW_NX50_uartlcr_h_WLEN      = 2,  /* [6:5] */
	BFW_NX50_uartlcr_h_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_UARTLCR_H_BIT_Ttag {
	unsigned int BRK       : BFW_NX50_uartlcr_h_BRK;       /* Send Break         */
	unsigned int PEN       : BFW_NX50_uartlcr_h_PEN;       /* Parity Enalble     */
	unsigned int EPS       : BFW_NX50_uartlcr_h_EPS;       /* Even Parity Select */
	unsigned int STP2      : BFW_NX50_uartlcr_h_STP2;      /* 2 Stop Bits Select */
	unsigned int FEN       : BFW_NX50_uartlcr_h_FEN;       /* FIFO Enable        */
	unsigned int WLEN      : BFW_NX50_uartlcr_h_WLEN;      /*  Word Length       */
	                                                       /* "00" 5 bits        */
	unsigned int reserved1 : BFW_NX50_uartlcr_h_reserved1; /* reserved           */
} NX50_UARTLCR_H_BIT_T;

typedef union {
	unsigned int         val;
	NX50_UARTLCR_H_BIT_T bf;
} NX50_UARTLCR_H_T;

/* --------------------------------------------------------------------- */
/* Register uartlcr_m */
/* => Line control Register, middle byte */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartlcr_m   0x0000000CU
#define Adr_NX50_uart0_uartlcr_m 0x1C000B0CU
#define Adr_NX50_uart1_uartlcr_m 0x1C000B4CU
#define Adr_NX50_uart2_uartlcr_m 0x1C000B8CU
#define DFLT_VAL_NX50_uartlcr_m  0x00000000U

#define MSK_NX50_uartlcr_m_BAUDDIVMS      0x000000ffU
#define SRT_NX50_uartlcr_m_BAUDDIVMS      0
#define DFLT_VAL_NX50_uartlcr_m_BAUDDIVMS 0x00000000U

enum {
	BFW_NX50_uartlcr_m_BAUDDIVMS = 8,  /* [7:0] */
	BFW_NX50_uartlcr_m_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTLCR_M_BIT_Ttag {
	unsigned int BAUDDIVMS : BFW_NX50_uartlcr_m_BAUDDIVMS; /* bauddiv : Baud Divisor Most Significant Byte                     */
	                                                       /* use higher byte of bauddiv = (system clk / (16 * baud rate)) - 1 */
	unsigned int reserved1 : BFW_NX50_uartlcr_m_reserved1; /* reserved                                                         */
} NX50_UARTLCR_M_BIT_T;

typedef union {
	unsigned int         val;
	NX50_UARTLCR_M_BIT_T bf;
} NX50_UARTLCR_M_T;

/* --------------------------------------------------------------------- */
/* Register uartlcr_l */
/* => Line control Register, low byte */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartlcr_l   0x00000010U
#define Adr_NX50_uart0_uartlcr_l 0x1C000B10U
#define Adr_NX50_uart1_uartlcr_l 0x1C000B50U
#define Adr_NX50_uart2_uartlcr_l 0x1C000B90U
#define DFLT_VAL_NX50_uartlcr_l  0x00000000U

#define MSK_NX50_uartlcr_l_BAUDDIVLS      0x000000ffU
#define SRT_NX50_uartlcr_l_BAUDDIVLS      0
#define DFLT_VAL_NX50_uartlcr_l_BAUDDIVLS 0x00000000U

enum {
	BFW_NX50_uartlcr_l_BAUDDIVLS = 8,  /* [7:0] */
	BFW_NX50_uartlcr_l_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTLCR_L_BIT_Ttag {
	unsigned int BAUDDIVLS : BFW_NX50_uartlcr_l_BAUDDIVLS; /* Baud Divisor Least Significant Byte                             */
	                                                       /* use lower byte of bauddiv = (system clk / (16 * baud rate)) - 1 */
	unsigned int reserved1 : BFW_NX50_uartlcr_l_reserved1; /* reserved                                                        */
} NX50_UARTLCR_L_BIT_T;

typedef union {
	unsigned int         val;
	NX50_UARTLCR_L_BIT_T bf;
} NX50_UARTLCR_L_T;

/* --------------------------------------------------------------------- */
/* Register uartcr */
/* => uart control Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartcr   0x00000014U
#define Adr_NX50_uart0_uartcr 0x1C000B14U
#define Adr_NX50_uart1_uartcr 0x1C000B54U
#define Adr_NX50_uart2_uartcr 0x1C000B94U
#define DFLT_VAL_NX50_uartcr  0x00000000U

#define MSK_NX50_uartcr_uartEN          0x00000001U
#define SRT_NX50_uartcr_uartEN          0
#define DFLT_VAL_NX50_uartcr_uartEN     0x00000000U
#define MSK_NX50_uartcr_SIREN           0x00000002U
#define SRT_NX50_uartcr_SIREN           1
#define DFLT_VAL_NX50_uartcr_SIREN      0x00000000U
#define MSK_NX50_uartcr_SIRLP           0x00000004U
#define SRT_NX50_uartcr_SIRLP           2
#define DFLT_VAL_NX50_uartcr_SIRLP      0x00000000U
#define MSK_NX50_uartcr_MSIE            0x00000008U
#define SRT_NX50_uartcr_MSIE            3
#define DFLT_VAL_NX50_uartcr_MSIE       0x00000000U
#define MSK_NX50_uartcr_RIE             0x00000010U
#define SRT_NX50_uartcr_RIE             4
#define DFLT_VAL_NX50_uartcr_RIE        0x00000000U
#define MSK_NX50_uartcr_TIE             0x00000020U
#define SRT_NX50_uartcr_TIE             5
#define DFLT_VAL_NX50_uartcr_TIE        0x00000000U
#define MSK_NX50_uartcr_RTIE            0x00000040U
#define SRT_NX50_uartcr_RTIE            6
#define DFLT_VAL_NX50_uartcr_RTIE       0x00000000U
#define MSK_NX50_uartcr_LBE             0x00000080U
#define SRT_NX50_uartcr_LBE             7
#define DFLT_VAL_NX50_uartcr_LBE        0x00000000U
#define MSK_NX50_uartcr_TX_RX_LOOP      0x00000100U
#define SRT_NX50_uartcr_TX_RX_LOOP      8
#define DFLT_VAL_NX50_uartcr_TX_RX_LOOP 0x00000000U

enum {
	BFW_NX50_uartcr_uartEN     = 1,  /* [0] */
	BFW_NX50_uartcr_SIREN      = 1,  /* [1] */
	BFW_NX50_uartcr_SIRLP      = 1,  /* [2] */
	BFW_NX50_uartcr_MSIE       = 1,  /* [3] */
	BFW_NX50_uartcr_RIE        = 1,  /* [4] */
	BFW_NX50_uartcr_TIE        = 1,  /* [5] */
	BFW_NX50_uartcr_RTIE       = 1,  /* [6] */
	BFW_NX50_uartcr_LBE        = 1,  /* [7] */
	BFW_NX50_uartcr_TX_RX_LOOP = 1,  /* [8] */
	BFW_NX50_uartcr_reserved1  = 23  /* [31:9] */
};

typedef struct NX50_UARTCR_BIT_Ttag {
	unsigned int uartEN     : BFW_NX50_uartcr_uartEN;     /* uart Enable                                  */
	unsigned int SIREN      : BFW_NX50_uartcr_SIREN;      /* SIR Enable                                   */
	unsigned int SIRLP      : BFW_NX50_uartcr_SIRLP;      /* IrDA SIR Low Power Mode                      */
	unsigned int MSIE       : BFW_NX50_uartcr_MSIE;       /* Modem Status Interrupt Enable                */
	unsigned int RIE        : BFW_NX50_uartcr_RIE;        /* Receive Interrupt Enable                     */
	unsigned int TIE        : BFW_NX50_uartcr_TIE;        /* Transmit Interrupt Enable                    */
	unsigned int RTIE       : BFW_NX50_uartcr_RTIE;       /* Receive Timeout Interrupt Enable             */
	unsigned int LBE        : BFW_NX50_uartcr_LBE;        /* Loop Back Enable for IrDA mode               */
	unsigned int TX_RX_LOOP : BFW_NX50_uartcr_TX_RX_LOOP; /* internal loop (TX -> RX) (test purpose only) */
	unsigned int reserved1  : BFW_NX50_uartcr_reserved1;  /* reserved                                     */
} NX50_UARTCR_BIT_T;

typedef union {
	unsigned int      val;
	NX50_UARTCR_BIT_T bf;
} NX50_UARTCR_T;

/* --------------------------------------------------------------------- */
/* Register uartfr */
/* => uart Flag Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartfr   0x00000018U
#define Adr_NX50_uart0_uartfr 0x1C000B18U
#define Adr_NX50_uart1_uartfr 0x1C000B58U
#define Adr_NX50_uart2_uartfr 0x1C000B98U

#define MSK_NX50_uartfr_CTS  0x00000001U
#define SRT_NX50_uartfr_CTS  0
#define MSK_NX50_uartfr_DSR  0x00000002U
#define SRT_NX50_uartfr_DSR  1
#define MSK_NX50_uartfr_DCD  0x00000004U
#define SRT_NX50_uartfr_DCD  2
#define MSK_NX50_uartfr_BUSY 0x00000008U
#define SRT_NX50_uartfr_BUSY 3
#define MSK_NX50_uartfr_RXFE 0x00000010U
#define SRT_NX50_uartfr_RXFE 4
#define MSK_NX50_uartfr_TXFF 0x00000020U
#define SRT_NX50_uartfr_TXFF 5
#define MSK_NX50_uartfr_RXFF 0x00000040U
#define SRT_NX50_uartfr_RXFF 6
#define MSK_NX50_uartfr_TXFE 0x00000080U
#define SRT_NX50_uartfr_TXFE 7

enum {
	BFW_NX50_uartfr_CTS       = 1,  /* [0] */
	BFW_NX50_uartfr_DSR       = 1,  /* [1] */
	BFW_NX50_uartfr_DCD       = 1,  /* [2] */
	BFW_NX50_uartfr_BUSY      = 1,  /* [3] */
	BFW_NX50_uartfr_RXFE      = 1,  /* [4] */
	BFW_NX50_uartfr_TXFF      = 1,  /* [5] */
	BFW_NX50_uartfr_RXFF      = 1,  /* [6] */
	BFW_NX50_uartfr_TXFE      = 1,  /* [7] */
	BFW_NX50_uartfr_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTFR_BIT_Ttag {
	unsigned int CTS       : BFW_NX50_uartfr_CTS;       /* Clear To Send       */
	unsigned int DSR       : BFW_NX50_uartfr_DSR;       /* Data Set Ready      */
	unsigned int DCD       : BFW_NX50_uartfr_DCD;       /* Data Carrier Detect */
	unsigned int BUSY      : BFW_NX50_uartfr_BUSY;      /* uart BUSY           */
	unsigned int RXFE      : BFW_NX50_uartfr_RXFE;      /* Receive FIFO Empty  */
	unsigned int TXFF      : BFW_NX50_uartfr_TXFF;      /* Transmit FIFO Full  */
	unsigned int RXFF      : BFW_NX50_uartfr_RXFF;      /* Receive FIFO Full   */
	unsigned int TXFE      : BFW_NX50_uartfr_TXFE;      /* Transmit FIFO Empty */
	unsigned int reserved1 : BFW_NX50_uartfr_reserved1; /* reserved            */
} NX50_UARTFR_BIT_T;

typedef union {
	unsigned int      val;
	NX50_UARTFR_BIT_T bf;
} NX50_UARTFR_T;

/* --------------------------------------------------------------------- */
/* Register uartiir */
/* => Interrupt Identification (read) / interrupt clear (write) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartiir   0x0000001CU
#define Adr_NX50_uart0_uartiir 0x1C000B1CU
#define Adr_NX50_uart1_uartiir 0x1C000B5CU
#define Adr_NX50_uart2_uartiir 0x1C000B9CU
#define DFLT_VAL_NX50_uartiir  0x00000000U

#define MSK_NX50_uartiir_MIS       0x00000001U
#define SRT_NX50_uartiir_MIS       0
#define DFLT_VAL_NX50_uartiir_MIS  0x00000000U
#define MSK_NX50_uartiir_RIS       0x00000002U
#define SRT_NX50_uartiir_RIS       1
#define DFLT_VAL_NX50_uartiir_RIS  0x00000000U
#define MSK_NX50_uartiir_TIS       0x00000004U
#define SRT_NX50_uartiir_TIS       2
#define DFLT_VAL_NX50_uartiir_TIS  0x00000000U
#define MSK_NX50_uartiir_RTIS      0x00000008U
#define SRT_NX50_uartiir_RTIS      3
#define DFLT_VAL_NX50_uartiir_RTIS 0x00000000U

enum {
	BFW_NX50_uartiir_MIS       = 1,  /* [0] */
	BFW_NX50_uartiir_RIS       = 1,  /* [1] */
	BFW_NX50_uartiir_TIS       = 1,  /* [2] */
	BFW_NX50_uartiir_RTIS      = 1,  /* [3] */
	BFW_NX50_uartiir_reserved1 = 28  /* [31:4] */
};

typedef struct NX50_UARTIIR_BIT_Ttag {
	unsigned int MIS       : BFW_NX50_uartiir_MIS;       /* Modem Interrupt Status           */
	unsigned int RIS       : BFW_NX50_uartiir_RIS;       /* Receive Interrupt Status         */
	unsigned int TIS       : BFW_NX50_uartiir_TIS;       /* Transmit Interrupt Status        */
	unsigned int RTIS      : BFW_NX50_uartiir_RTIS;      /* Receive Timeout Interrupt Status */
	unsigned int reserved1 : BFW_NX50_uartiir_reserved1; /* reserved                         */
} NX50_UARTIIR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_UARTIIR_BIT_T bf;
} NX50_UARTIIR_T;

/* --------------------------------------------------------------------- */
/* Register uartilpr */
/* => IrDA Low Power Counter Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartilpr   0x00000020U
#define Adr_NX50_uart0_uartilpr 0x1C000B20U
#define Adr_NX50_uart1_uartilpr 0x1C000B60U
#define Adr_NX50_uart2_uartilpr 0x1C000BA0U
#define DFLT_VAL_NX50_uartilpr  0x00000000U

#define MSK_NX50_uartilpr_ILPDVSR      0x000000ffU
#define SRT_NX50_uartilpr_ILPDVSR      0
#define DFLT_VAL_NX50_uartilpr_ILPDVSR 0x00000000U

enum {
	BFW_NX50_uartilpr_ILPDVSR   = 8,  /* [7:0] */
	BFW_NX50_uartilpr_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTILPR_BIT_Ttag {
	unsigned int ILPDVSR   : BFW_NX50_uartilpr_ILPDVSR;   /* IrDA Low Power Divisor */
	unsigned int reserved1 : BFW_NX50_uartilpr_reserved1; /* reserved               */
} NX50_UARTILPR_BIT_T;

typedef union {
	unsigned int        val;
	NX50_UARTILPR_BIT_T bf;
} NX50_UARTILPR_T;

/* --------------------------------------------------------------------- */
/* Register uartrts */
/* => RTS Control Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartrts   0x00000024U
#define Adr_NX50_uart0_uartrts 0x1C000B24U
#define Adr_NX50_uart1_uartrts 0x1C000B64U
#define Adr_NX50_uart2_uartrts 0x1C000BA4U
#define DFLT_VAL_NX50_uartrts  0x00000000U

#define MSK_NX50_uartrts_AUTO         0x00000001U
#define SRT_NX50_uartrts_AUTO         0
#define DFLT_VAL_NX50_uartrts_AUTO    0x00000000U
#define MSK_NX50_uartrts_RTS          0x00000002U
#define SRT_NX50_uartrts_RTS          1
#define DFLT_VAL_NX50_uartrts_RTS     0x00000000U
#define MSK_NX50_uartrts_COUNT        0x00000004U
#define SRT_NX50_uartrts_COUNT        2
#define DFLT_VAL_NX50_uartrts_COUNT   0x00000000U
#define MSK_NX50_uartrts_MOD2         0x00000008U
#define SRT_NX50_uartrts_MOD2         3
#define DFLT_VAL_NX50_uartrts_MOD2    0x00000000U
#define MSK_NX50_uartrts_RTS_pol      0x00000010U
#define SRT_NX50_uartrts_RTS_pol      4
#define DFLT_VAL_NX50_uartrts_RTS_pol 0x00000000U
#define MSK_NX50_uartrts_CTS_ctr      0x00000020U
#define SRT_NX50_uartrts_CTS_ctr      5
#define DFLT_VAL_NX50_uartrts_CTS_ctr 0x00000000U
#define MSK_NX50_uartrts_CTS_pol      0x00000040U
#define SRT_NX50_uartrts_CTS_pol      6
#define DFLT_VAL_NX50_uartrts_CTS_pol 0x00000000U
#define MSK_NX50_uartrts_STICK        0x00000080U
#define SRT_NX50_uartrts_STICK        7
#define DFLT_VAL_NX50_uartrts_STICK   0x00000000U

enum {
	BFW_NX50_uartrts_AUTO      = 1,  /* [0] */
	BFW_NX50_uartrts_RTS       = 1,  /* [1] */
	BFW_NX50_uartrts_COUNT     = 1,  /* [2] */
	BFW_NX50_uartrts_MOD2      = 1,  /* [3] */
	BFW_NX50_uartrts_RTS_pol   = 1,  /* [4] */
	BFW_NX50_uartrts_CTS_ctr   = 1,  /* [5] */
	BFW_NX50_uartrts_CTS_pol   = 1,  /* [6] */
	BFW_NX50_uartrts_STICK     = 1,  /* [7] */
	BFW_NX50_uartrts_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTRTS_BIT_Ttag {
	unsigned int AUTO      : BFW_NX50_uartrts_AUTO;      /* automatic or controlled by the next bit (RTS) */
	unsigned int RTS       : BFW_NX50_uartrts_RTS;       /* if AUTO=0: controlled by this bit             */
	unsigned int COUNT     : BFW_NX50_uartrts_COUNT;     /* count base: 1=system clocks, 0=time in bauds  */
	unsigned int MOD2      : BFW_NX50_uartrts_MOD2;      /* mode1/mode2                                   */
	unsigned int RTS_pol   : BFW_NX50_uartrts_RTS_pol;   /* RTS polarity: 1=active high                   */
	unsigned int CTS_ctr   : BFW_NX50_uartrts_CTS_ctr;   /* nUARTCTS control                              */
	unsigned int CTS_pol   : BFW_NX50_uartrts_CTS_pol;   /* nUARTCTS polarity: 1=active high              */
	unsigned int STICK     : BFW_NX50_uartrts_STICK;     /* stick parity                                  */
	unsigned int reserved1 : BFW_NX50_uartrts_reserved1; /* reserved                                      */
} NX50_UARTRTS_BIT_T;

typedef union {
	unsigned int       val;
	NX50_UARTRTS_BIT_T bf;
} NX50_UARTRTS_T;

/* --------------------------------------------------------------------- */
/* Register uartforerun */
/* => RTS forerun cycles */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartforerun   0x00000028U
#define Adr_NX50_uart0_uartforerun 0x1C000B28U
#define Adr_NX50_uart1_uartforerun 0x1C000B68U
#define Adr_NX50_uart2_uartforerun 0x1C000BA8U
#define DFLT_VAL_NX50_uartforerun  0x00000000U

#define MSK_NX50_uartforerun_FORERUN      0x000000ffU
#define SRT_NX50_uartforerun_FORERUN      0
#define DFLT_VAL_NX50_uartforerun_FORERUN 0x00000000U

enum {
	BFW_NX50_uartforerun_FORERUN   = 8,  /* [7:0] */
	BFW_NX50_uartforerun_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTFORERUN_BIT_Ttag {
	unsigned int FORERUN   : BFW_NX50_uartforerun_FORERUN;   /* number of forerun cycles in system clocks or bauds */
	unsigned int reserved1 : BFW_NX50_uartforerun_reserved1; /* reserved                                           */
} NX50_UARTFORERUN_BIT_T;

typedef union {
	unsigned int           val;
	NX50_UARTFORERUN_BIT_T bf;
} NX50_UARTFORERUN_T;

/* --------------------------------------------------------------------- */
/* Register uarttrail */
/* => RTS trail cycles */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uarttrail   0x0000002CU
#define Adr_NX50_uart0_uarttrail 0x1C000B2CU
#define Adr_NX50_uart1_uarttrail 0x1C000B6CU
#define Adr_NX50_uart2_uarttrail 0x1C000BACU
#define DFLT_VAL_NX50_uarttrail  0x00000000U

#define MSK_NX50_uarttrail_TRAIL      0x000000ffU
#define SRT_NX50_uarttrail_TRAIL      0
#define DFLT_VAL_NX50_uarttrail_TRAIL 0x00000000U

enum {
	BFW_NX50_uarttrail_TRAIL     = 8,  /* [7:0] */
	BFW_NX50_uarttrail_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_UARTTRAIL_BIT_Ttag {
	unsigned int TRAIL     : BFW_NX50_uarttrail_TRAIL;     /* number of trail cycles in system clocks or bauds */
	unsigned int reserved1 : BFW_NX50_uarttrail_reserved1; /* reserved                                         */
} NX50_UARTTRAIL_BIT_T;

typedef union {
	unsigned int         val;
	NX50_UARTTRAIL_BIT_T bf;
} NX50_UARTTRAIL_T;

/* --------------------------------------------------------------------- */
/* Register uartdrvout */
/* => Drive Output */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartdrvout   0x00000030U
#define Adr_NX50_uart0_uartdrvout 0x1C000B30U
#define Adr_NX50_uart1_uartdrvout 0x1C000B70U
#define Adr_NX50_uart2_uartdrvout 0x1C000BB0U
#define DFLT_VAL_NX50_uartdrvout  0x00000000U

#define MSK_NX50_uartdrvout_DRVTX       0x00000001U
#define SRT_NX50_uartdrvout_DRVTX       0
#define DFLT_VAL_NX50_uartdrvout_DRVTX  0x00000000U
#define MSK_NX50_uartdrvout_DRVRTS      0x00000002U
#define SRT_NX50_uartdrvout_DRVRTS      1
#define DFLT_VAL_NX50_uartdrvout_DRVRTS 0x00000000U

enum {
	BFW_NX50_uartdrvout_DRVTX     = 1,  /* [0] */
	BFW_NX50_uartdrvout_DRVRTS    = 1,  /* [1] */
	BFW_NX50_uartdrvout_reserved1 = 30  /* [31:2] */
};

typedef struct NX50_UARTDRVOUT_BIT_Ttag {
	unsigned int DRVTX     : BFW_NX50_uartdrvout_DRVTX;     /* enable driver for TX  */
	unsigned int DRVRTS    : BFW_NX50_uartdrvout_DRVRTS;    /* enable driver for RTS */
	unsigned int reserved1 : BFW_NX50_uartdrvout_reserved1; /* reserved              */
} NX50_UARTDRVOUT_BIT_T;

typedef union {
	unsigned int          val;
	NX50_UARTDRVOUT_BIT_T bf;
} NX50_UARTDRVOUT_T;

/* --------------------------------------------------------------------- */
/* Register uartcr_2 */
/* => Control Register 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartcr_2   0x00000034U
#define Adr_NX50_uart0_uartcr_2 0x1C000B34U
#define Adr_NX50_uart1_uartcr_2 0x1C000B74U
#define Adr_NX50_uart2_uartcr_2 0x1C000BB4U
#define DFLT_VAL_NX50_uartcr_2  0x00000000U

#define MSK_NX50_uartcr_2_Baud_Rate_Mode      0x00000001U
#define SRT_NX50_uartcr_2_Baud_Rate_Mode      0
#define DFLT_VAL_NX50_uartcr_2_Baud_Rate_Mode 0x00000000U

enum {
	BFW_NX50_uartcr_2_Baud_Rate_Mode = 1,  /* [0] */
	BFW_NX50_uartcr_2_reserved1      = 31  /* [31:1] */
};

typedef struct NX50_UARTCR_2_BIT_Ttag {
	unsigned int Baud_Rate_Mode : BFW_NX50_uartcr_2_Baud_Rate_Mode; /* If this bit is set the baud rate is generated more exactly by the following formula: */
	                                                                /* value = ( (Baud Rate * 16) / System Frequency ) * 2^16  .                            */
	unsigned int reserved1      : BFW_NX50_uartcr_2_reserved1;      /* reserved                                                                             */
} NX50_UARTCR_2_BIT_T;

typedef union {
	unsigned int        val;
	NX50_UARTCR_2_BIT_T bf;
} NX50_UARTCR_2_T;

/* --------------------------------------------------------------------- */
/* Register uartrxiflsel */
/* => RX FIFO trigger level and RX-DMA enable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uartrxiflsel   0x00000038U
#define Adr_NX50_uart0_uartrxiflsel 0x1C000B38U
#define Adr_NX50_uart1_uartrxiflsel 0x1C000B78U
#define Adr_NX50_uart2_uartrxiflsel 0x1C000BB8U
#define DFLT_VAL_NX50_uartrxiflsel  0x00000008U

#define MSK_NX50_uartrxiflsel_RXIFLSEL      0x0000001fU
#define SRT_NX50_uartrxiflsel_RXIFLSEL      0
#define DFLT_VAL_NX50_uartrxiflsel_RXIFLSEL 0x00000008U
#define MSK_NX50_uartrxiflsel_RXDMA         0x00000020U
#define SRT_NX50_uartrxiflsel_RXDMA         5
#define DFLT_VAL_NX50_uartrxiflsel_RXDMA    0x00000000U

enum {
	BFW_NX50_uartrxiflsel_RXIFLSEL  = 5,  /* [4:0] */
	BFW_NX50_uartrxiflsel_RXDMA     = 1,  /* [5] */
	BFW_NX50_uartrxiflsel_reserved1 = 26  /* [31:6] */
};

typedef struct NX50_UARTRXIFLSEL_BIT_Ttag {
	unsigned int RXIFLSEL  : BFW_NX50_uartrxiflsel_RXIFLSEL;  /*  Choose a number between 1 and 16. It defines the IRQ trigger level of the receive fifo.                                  */
	                                                          /*  The IRQ (UARTRXINTR) will be set if the number of received bytes in the receive fifo are greater than or equal RXIFLSEL. */
	unsigned int RXDMA     : BFW_NX50_uartrxiflsel_RXDMA;     /*  Enable DMA-requests for RX-fifo-data.                                                                                    */
	                                                          /*  A request will be generated if RX-FIFO is not empty and uartcr.uartEN (module enable) is set.                            */
	unsigned int reserved1 : BFW_NX50_uartrxiflsel_reserved1; /* reserved                                                                                                                  */
} NX50_UARTRXIFLSEL_BIT_T;

typedef union {
	unsigned int            val;
	NX50_UARTRXIFLSEL_BIT_T bf;
} NX50_UARTRXIFLSEL_T;

/* --------------------------------------------------------------------- */
/* Register uarttxiflsel */
/* => TX FIFO trigger level and TX-DMA enable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_uarttxiflsel   0x0000003CU
#define Adr_NX50_uart0_uarttxiflsel 0x1C000B3CU
#define Adr_NX50_uart1_uarttxiflsel 0x1C000B7CU
#define Adr_NX50_uart2_uarttxiflsel 0x1C000BBCU
#define DFLT_VAL_NX50_uarttxiflsel  0x00000008U

#define MSK_NX50_uarttxiflsel_TXIFLSEL      0x0000001fU
#define SRT_NX50_uarttxiflsel_TXIFLSEL      0
#define DFLT_VAL_NX50_uarttxiflsel_TXIFLSEL 0x00000008U
#define MSK_NX50_uarttxiflsel_TXDMA         0x00000020U
#define SRT_NX50_uarttxiflsel_TXDMA         5
#define DFLT_VAL_NX50_uarttxiflsel_TXDMA    0x00000000U

enum {
	BFW_NX50_uarttxiflsel_TXIFLSEL  = 5,  /* [4:0] */
	BFW_NX50_uarttxiflsel_TXDMA     = 1,  /* [5] */
	BFW_NX50_uarttxiflsel_reserved1 = 26  /* [31:6] */
};

typedef struct NX50_UARTTXIFLSEL_BIT_Ttag {
	unsigned int TXIFLSEL  : BFW_NX50_uarttxiflsel_TXIFLSEL;  /*  Choose a number between 1 and 16. It defines the IRQ trigger level of the transmit fifo.                         */
	                                                          /*  The IRQ (UARTTXINTR) will be set if the number of transmitted bytes in the transmit fifo are less than TXIFLSEL. */
	unsigned int TXDMA     : BFW_NX50_uarttxiflsel_TXDMA;     /*  Enable DMA-requests for TX-fifo-data.                                                                            */
	                                                          /*  A request will be generated if TX-FIFO is not full and uartcr.uartEN (module enable) is set.                     */
	unsigned int reserved1 : BFW_NX50_uarttxiflsel_reserved1; /* reserved                                                                                                          */
} NX50_UARTTXIFLSEL_BIT_T;

typedef union {
	unsigned int            val;
	NX50_UARTTXIFLSEL_BIT_T bf;
} NX50_UARTTXIFLSEL_T;


/* ===================================================================== */

/* Area of miimu */

/* ===================================================================== */

#define Addr_NX50_miimu      0x1C000C00U
#define NX50_NETX_MIIMU_AREA 0x1C000C00U

/* --------------------------------------------------------------------- */
/* Register miimu_reg */
/* => MIIMU Receive/Transmit Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_miimu_reg   0x00000000U
#define Adr_NX50_miimu_miimu_reg 0x1C000C00U
#define Adr_NX50_miimu_reg       0x1C000C00U
#define DFLT_VAL_NX50_miimu_reg  0x00000010U

#define MSK_NX50_miimu_reg_miimu_snrdy           0x00000001U
#define SRT_NX50_miimu_reg_miimu_snrdy           0
#define DFLT_VAL_NX50_miimu_reg_miimu_snrdy      0x00000000U
#define MSK_NX50_miimu_reg_miimu_preamble        0x00000002U
#define SRT_NX50_miimu_reg_miimu_preamble        1
#define DFLT_VAL_NX50_miimu_reg_miimu_preamble   0x00000000U
#define MSK_NX50_miimu_reg_miimu_opmode          0x00000004U
#define SRT_NX50_miimu_reg_miimu_opmode          2
#define DFLT_VAL_NX50_miimu_reg_miimu_opmode     0x00000000U
#define MSK_NX50_miimu_reg_miimu_mdc_period      0x00000008U
#define SRT_NX50_miimu_reg_miimu_mdc_period      3
#define DFLT_VAL_NX50_miimu_reg_miimu_mdc_period 0x00000000U
#define MSK_NX50_miimu_reg_phy_nres              0x00000010U
#define SRT_NX50_miimu_reg_phy_nres              4
#define DFLT_VAL_NX50_miimu_reg_phy_nres         0x00000010U
#define MSK_NX50_miimu_reg_miimu_rta             0x00000020U
#define SRT_NX50_miimu_reg_miimu_rta             5
#define DFLT_VAL_NX50_miimu_reg_miimu_rta        0x00000000U
#define MSK_NX50_miimu_reg_miimu_regaddr         0x000007c0U
#define SRT_NX50_miimu_reg_miimu_regaddr         6
#define DFLT_VAL_NX50_miimu_reg_miimu_regaddr    0x00000000U
#define MSK_NX50_miimu_reg_miimu_phyaddr         0x0000f800U
#define SRT_NX50_miimu_reg_miimu_phyaddr         11
#define DFLT_VAL_NX50_miimu_reg_miimu_phyaddr    0x00000000U
#define MSK_NX50_miimu_reg_miimu_data            0xffff0000U
#define SRT_NX50_miimu_reg_miimu_data            16
#define DFLT_VAL_NX50_miimu_reg_miimu_data       0x00000000U

enum {
	BFW_NX50_miimu_reg_miimu_snrdy      = 1,  /* [0] */
	BFW_NX50_miimu_reg_miimu_preamble   = 1,  /* [1] */
	BFW_NX50_miimu_reg_miimu_opmode     = 1,  /* [2] */
	BFW_NX50_miimu_reg_miimu_mdc_period = 1,  /* [3] */
	BFW_NX50_miimu_reg_phy_nres         = 1,  /* [4] */
	BFW_NX50_miimu_reg_miimu_rta        = 1,  /* [5] */
	BFW_NX50_miimu_reg_miimu_regaddr    = 5,  /* [10:6] */
	BFW_NX50_miimu_reg_miimu_phyaddr    = 5,  /* [15:11] */
	BFW_NX50_miimu_reg_miimu_data       = 16  /* [31:16] */
};

typedef struct NX50_MIIMU_REG_BIT_Ttag {
	unsigned int miimu_snrdy      : BFW_NX50_miimu_reg_miimu_snrdy;      /* Start not ready                                                               */
	unsigned int miimu_preamble   : BFW_NX50_miimu_reg_miimu_preamble;   /* Send preamble                                                                 */
	unsigned int miimu_opmode     : BFW_NX50_miimu_reg_miimu_opmode;     /* Operation mode:                                                               */
	                                                                     /* 1: write                                                                      */
	unsigned int miimu_mdc_period : BFW_NX50_miimu_reg_miimu_mdc_period; /* MDC period:                                                                   */
	                                                                     /* 1: 800ns                                                                      */
	unsigned int phy_nres         : BFW_NX50_miimu_reg_phy_nres;         /* PHY hardware nReset (activ low!):                                             */
	                                                                     /* If this bit and the miimu_snrdy-bit is set, the PHYs will be hardware-reset.  */
	unsigned int miimu_rta        : BFW_NX50_miimu_reg_miimu_rta;        /* Read Turn Around field:                                                       */
	                                                                     /* 0: one bit                                                                    */
	unsigned int miimu_regaddr    : BFW_NX50_miimu_reg_miimu_regaddr;    /* Register address                                                              */
	unsigned int miimu_phyaddr    : BFW_NX50_miimu_reg_miimu_phyaddr;    /* PHY address                                                                   */
	unsigned int miimu_data       : BFW_NX50_miimu_reg_miimu_data;       /* Data to or from PHY register                                                  */
} NX50_MIIMU_REG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MIIMU_REG_BIT_T bf;
} NX50_MIIMU_REG_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_en */
/* => MIIMU Software Mode Enable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_miimu_sw_en   0x00000004U
#define Adr_NX50_miimu_miimu_sw_en 0x1C000C04U
#define Adr_NX50_miimu_sw_en       0x1C000C04U
#define DFLT_VAL_NX50_miimu_sw_en  0x00000000U

#define MSK_NX50_miimu_sw_en_miimu_sw_en      0x00000001U
#define SRT_NX50_miimu_sw_en_miimu_sw_en      0
#define DFLT_VAL_NX50_miimu_sw_en_miimu_sw_en 0x00000000U

enum {
	BFW_NX50_miimu_sw_en_miimu_sw_en = 1,  /* [0] */
	BFW_NX50_miimu_sw_en_reserved1   = 31  /* [31:1] */
};

typedef struct NX50_MIIMU_SW_EN_BIT_Ttag {
	unsigned int miimu_sw_en : BFW_NX50_miimu_sw_en_miimu_sw_en; /* Enables software mode:                  */
	                                                             /* MDC, MDO and MDOE are set by software.  */
	unsigned int reserved1   : BFW_NX50_miimu_sw_en_reserved1;   /* reserved                                */
} NX50_MIIMU_SW_EN_BIT_T;

typedef union {
	unsigned int           val;
	NX50_MIIMU_SW_EN_BIT_T bf;
} NX50_MIIMU_SW_EN_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdc */
/* => MIIMU Software Mode MDC Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_miimu_sw_mdc   0x00000008U
#define Adr_NX50_miimu_miimu_sw_mdc 0x1C000C08U
#define Adr_NX50_miimu_sw_mdc       0x1C000C08U
#define DFLT_VAL_NX50_miimu_sw_mdc  0x00000000U

#define MSK_NX50_miimu_sw_mdc_miimu_sw_mdc      0x00000001U
#define SRT_NX50_miimu_sw_mdc_miimu_sw_mdc      0
#define DFLT_VAL_NX50_miimu_sw_mdc_miimu_sw_mdc 0x00000000U

enum {
	BFW_NX50_miimu_sw_mdc_miimu_sw_mdc = 1,  /* [0] */
	BFW_NX50_miimu_sw_mdc_reserved1    = 31  /* [31:1] */
};

typedef struct NX50_MIIMU_SW_MDC_BIT_Ttag {
	unsigned int miimu_sw_mdc : BFW_NX50_miimu_sw_mdc_miimu_sw_mdc; /* MDC value for software mode */
	unsigned int reserved1    : BFW_NX50_miimu_sw_mdc_reserved1;    /* reserved                    */
} NX50_MIIMU_SW_MDC_BIT_T;

typedef union {
	unsigned int            val;
	NX50_MIIMU_SW_MDC_BIT_T bf;
} NX50_MIIMU_SW_MDC_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdo */
/* => MIIMU Software Mode MDO Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_miimu_sw_mdo   0x0000000CU
#define Adr_NX50_miimu_miimu_sw_mdo 0x1C000C0CU
#define Adr_NX50_miimu_sw_mdo       0x1C000C0CU
#define DFLT_VAL_NX50_miimu_sw_mdo  0x00000000U

#define MSK_NX50_miimu_sw_mdo_miimu_sw_mdo      0x00000001U
#define SRT_NX50_miimu_sw_mdo_miimu_sw_mdo      0
#define DFLT_VAL_NX50_miimu_sw_mdo_miimu_sw_mdo 0x00000000U

enum {
	BFW_NX50_miimu_sw_mdo_miimu_sw_mdo = 1,  /* [0] */
	BFW_NX50_miimu_sw_mdo_reserved1    = 31  /* [31:1] */
};

typedef struct NX50_MIIMU_SW_MDO_BIT_Ttag {
	unsigned int miimu_sw_mdo : BFW_NX50_miimu_sw_mdo_miimu_sw_mdo; /* MDO value for software mode */
	unsigned int reserved1    : BFW_NX50_miimu_sw_mdo_reserved1;    /* reserved                    */
} NX50_MIIMU_SW_MDO_BIT_T;

typedef union {
	unsigned int            val;
	NX50_MIIMU_SW_MDO_BIT_T bf;
} NX50_MIIMU_SW_MDO_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdoe */
/* => MIIMU Software Mode MDOE Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_miimu_sw_mdoe   0x00000010U
#define Adr_NX50_miimu_miimu_sw_mdoe 0x1C000C10U
#define Adr_NX50_miimu_sw_mdoe       0x1C000C10U
#define DFLT_VAL_NX50_miimu_sw_mdoe  0x00000000U

#define MSK_NX50_miimu_sw_mdoe_miimu_sw_mdoe      0x00000001U
#define SRT_NX50_miimu_sw_mdoe_miimu_sw_mdoe      0
#define DFLT_VAL_NX50_miimu_sw_mdoe_miimu_sw_mdoe 0x00000000U

enum {
	BFW_NX50_miimu_sw_mdoe_miimu_sw_mdoe = 1,  /* [0] */
	BFW_NX50_miimu_sw_mdoe_reserved1     = 31  /* [31:1] */
};

typedef struct NX50_MIIMU_SW_MDOE_BIT_Ttag {
	unsigned int miimu_sw_mdoe : BFW_NX50_miimu_sw_mdoe_miimu_sw_mdoe; /* MDOE value for software mode */
	unsigned int reserved1     : BFW_NX50_miimu_sw_mdoe_reserved1;     /* reserved                     */
} NX50_MIIMU_SW_MDOE_BIT_T;

typedef union {
	unsigned int             val;
	NX50_MIIMU_SW_MDOE_BIT_T bf;
} NX50_MIIMU_SW_MDOE_T;

/* --------------------------------------------------------------------- */
/* Register miimu_sw_mdi */
/* => MIIMU Software Mode MDI Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_miimu_sw_mdi   0x00000014U
#define Adr_NX50_miimu_miimu_sw_mdi 0x1C000C14U
#define Adr_NX50_miimu_sw_mdi       0x1C000C14U

#define MSK_NX50_miimu_sw_mdi_miimu_sw_mdi 0x00000001U
#define SRT_NX50_miimu_sw_mdi_miimu_sw_mdi 0

enum {
	BFW_NX50_miimu_sw_mdi_miimu_sw_mdi = 1,  /* [0] */
	BFW_NX50_miimu_sw_mdi_reserved1    = 31  /* [31:1] */
};

typedef struct NX50_MIIMU_SW_MDI_BIT_Ttag {
	unsigned int miimu_sw_mdi : BFW_NX50_miimu_sw_mdi_miimu_sw_mdi; /* current MDI value */
	unsigned int reserved1    : BFW_NX50_miimu_sw_mdi_reserved1;    /* reserved          */
} NX50_MIIMU_SW_MDI_BIT_T;

typedef union {
	unsigned int            val;
	NX50_MIIMU_SW_MDI_BIT_T bf;
} NX50_MIIMU_SW_MDI_T;


/* ===================================================================== */

/* AREA spi */
/* Area of spi0, spi1 */

/* ===================================================================== */

#define Addr_NX50_spi0      0x1C000D00U
#define NX50_NETX_SPI0_AREA 0x1C000D00U
#define Addr_NX50_spi1      0x1C000D40U
#define NX50_NETX_SPI1_AREA 0x1C000D40U

/* --------------------------------------------------------------------- */
/* Register spi_cr0 */
/* => spi control register 0 */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_cr0  0x00000000U
#define Adr_NX50_spi0_spi_cr0 0x1C000D00U
#define Adr_NX50_spi1_spi_cr0 0x1C000D40U
#define DFLT_VAL_NX50_spi_cr0 0x80080007U

#define MSK_NX50_spi_cr0_datasize             0x0000000fU
#define SRT_NX50_spi_cr0_datasize             0
#define DFLT_VAL_NX50_spi_cr0_datasize        0x00000007U
#define MSK_NX50_spi_cr0_SPO                  0x00000040U
#define SRT_NX50_spi_cr0_SPO                  6
#define DFLT_VAL_NX50_spi_cr0_SPO             0x00000000U
#define MSK_NX50_spi_cr0_SPH                  0x00000080U
#define SRT_NX50_spi_cr0_SPH                  7
#define DFLT_VAL_NX50_spi_cr0_SPH             0x00000000U
#define MSK_NX50_spi_cr0_sck_muladd           0x000fff00U
#define SRT_NX50_spi_cr0_sck_muladd           8
#define DFLT_VAL_NX50_spi_cr0_sck_muladd      0x00080000U
#define MSK_NX50_spi_cr0_format               0x03000000U
#define SRT_NX50_spi_cr0_format               24
#define DFLT_VAL_NX50_spi_cr0_format          0x00000000U
#define MSK_NX50_spi_cr0_filter_in            0x08000000U
#define SRT_NX50_spi_cr0_filter_in            27
#define DFLT_VAL_NX50_spi_cr0_filter_in       0x00000000U
#define MSK_NX50_spi_cr0_slave_sig_early      0x10000000U
#define SRT_NX50_spi_cr0_slave_sig_early      28
#define DFLT_VAL_NX50_spi_cr0_slave_sig_early 0x00000000U
#define MSK_NX50_spi_cr0_netx100_comp         0x80000000U
#define SRT_NX50_spi_cr0_netx100_comp         31
#define DFLT_VAL_NX50_spi_cr0_netx100_comp    0x80000000U

enum {
	BFW_NX50_spi_cr0_datasize        = 4,  /* [3:0] */
	BFW_NX50_spi_cr0_reserved1       = 2,  /* [5:4] */
	BFW_NX50_spi_cr0_SPO             = 1,  /* [6] */
	BFW_NX50_spi_cr0_SPH             = 1,  /* [7] */
	BFW_NX50_spi_cr0_sck_muladd      = 12, /* [19:8] */
	BFW_NX50_spi_cr0_reserved2       = 4,  /* [23:20] */
	BFW_NX50_spi_cr0_format          = 2,  /* [25:24] */
	BFW_NX50_spi_cr0_reserved3       = 1,  /* [26] */
	BFW_NX50_spi_cr0_filter_in       = 1,  /* [27] */
	BFW_NX50_spi_cr0_slave_sig_early = 1,  /* [28] */
	BFW_NX50_spi_cr0_reserved4       = 2,  /* [30:29] */
	BFW_NX50_spi_cr0_netx100_comp    = 1   /* [31] */
};

typedef struct NX50_SPI_CR0_BIT_Ttag {
	unsigned int datasize        : BFW_NX50_spi_cr0_datasize;        /* DSS: data size select (transfer size = datasize + 1 bits)                                      */
	                                                                 /* 0000...0010: reserved                                                                          */
	unsigned int reserved1       : BFW_NX50_spi_cr0_reserved1;       /* reserved                                                                                       */
	unsigned int SPO             : BFW_NX50_spi_cr0_SPO;             /* serial clock polarity (netx500: CR_cpol)                                                       */
	                                                                 /* 0: idle: clock is low, first edge is rising                                                    */
	unsigned int SPH             : BFW_NX50_spi_cr0_SPH;             /* serial clock phase (netx500: CR_ncpha)                                                         */
	                                                                 /* 1: sample data at second clock edge edge, data is generated half a clock phase before sampling */
	unsigned int sck_muladd      : BFW_NX50_spi_cr0_sck_muladd;      /* Serial clock rate multiply add value for master spi_sck generation.                            */
	                                                                 /* spi_sck-frequency: f_spi_sck = (sck_muladd * 100)/4096 [MHz].                                  */
	unsigned int reserved2       : BFW_NX50_spi_cr0_reserved2;       /* reserved                                                                                       */
	unsigned int format          : BFW_NX50_spi_cr0_format;          /* frame format                                                                                   */
	                                                                 /* 00: Motorola SPI frame format                                                                  */
	unsigned int reserved3       : BFW_NX50_spi_cr0_reserved3;       /* reserved                                                                                       */
	unsigned int filter_in       : BFW_NX50_spi_cr0_filter_in;       /* Receive-data is sampled every 10ns (100MHz system clock). If this bit is set, the              */
	                                                                 /* stored receive value will be the result of a majority decision of the three sampling points    */
	unsigned int slave_sig_early : BFW_NX50_spi_cr0_slave_sig_early; /* Generate MISO in slavemode 1 spi_sck clock edge earlier than Spec-defined.                     */
	                                                                 /* This is to compensate Pad/sampling-delays on fast data rates.                                  */
	unsigned int reserved4       : BFW_NX50_spi_cr0_reserved4;       /* reserved                                                                                       */
	unsigned int netx100_comp    : BFW_NX50_spi_cr0_netx100_comp;    /* use netx100/500-compatible SPI mode:                                                           */
	                                                                 /* 0: start transfer after writing data                                                           */
} NX50_SPI_CR0_BIT_T;

typedef union {
	unsigned int       val;
	NX50_SPI_CR0_BIT_T bf;
} NX50_SPI_CR0_T;

/* --------------------------------------------------------------------- */
/* Register spi_cr1 */
/* => spi control register 0 */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_cr1  0x00000004U
#define Adr_NX50_spi0_spi_cr1 0x1C000D04U
#define Adr_NX50_spi1_spi_cr1 0x1C000D44U
#define DFLT_VAL_NX50_spi_cr1 0x08080000U

#define MSK_NX50_spi_cr1_LBM              0x00000001U
#define SRT_NX50_spi_cr1_LBM              0
#define DFLT_VAL_NX50_spi_cr1_LBM         0x00000000U
#define MSK_NX50_spi_cr1_SSE              0x00000002U
#define SRT_NX50_spi_cr1_SSE              1
#define DFLT_VAL_NX50_spi_cr1_SSE         0x00000000U
#define MSK_NX50_spi_cr1_MS               0x00000004U
#define SRT_NX50_spi_cr1_MS               2
#define DFLT_VAL_NX50_spi_cr1_MS          0x00000000U
#define MSK_NX50_spi_cr1_SOD              0x00000008U
#define SRT_NX50_spi_cr1_SOD              3
#define DFLT_VAL_NX50_spi_cr1_SOD         0x00000000U
#define MSK_NX50_spi_cr1_fss              0x00000700U
#define SRT_NX50_spi_cr1_fss              8
#define DFLT_VAL_NX50_spi_cr1_fss         0x00000000U
#define MSK_NX50_spi_cr1_fss_static       0x00000800U
#define SRT_NX50_spi_cr1_fss_static       11
#define DFLT_VAL_NX50_spi_cr1_fss_static  0x00000000U
#define MSK_NX50_spi_cr1_tx_fifo_wm       0x000f0000U
#define SRT_NX50_spi_cr1_tx_fifo_wm       16
#define DFLT_VAL_NX50_spi_cr1_tx_fifo_wm  0x00080000U
#define MSK_NX50_spi_cr1_tx_fifo_clr      0x00100000U
#define SRT_NX50_spi_cr1_tx_fifo_clr      20
#define DFLT_VAL_NX50_spi_cr1_tx_fifo_clr 0x00000000U
#define MSK_NX50_spi_cr1_rx_fifo_wm       0x0f000000U
#define SRT_NX50_spi_cr1_rx_fifo_wm       24
#define DFLT_VAL_NX50_spi_cr1_rx_fifo_wm  0x08000000U
#define MSK_NX50_spi_cr1_rx_fifo_clr      0x10000000U
#define SRT_NX50_spi_cr1_rx_fifo_clr      28
#define DFLT_VAL_NX50_spi_cr1_rx_fifo_clr 0x00000000U

enum {
	BFW_NX50_spi_cr1_LBM         = 1, /* [0] */
	BFW_NX50_spi_cr1_SSE         = 1, /* [1] */
	BFW_NX50_spi_cr1_MS          = 1, /* [2] */
	BFW_NX50_spi_cr1_SOD         = 1, /* [3] */
	BFW_NX50_spi_cr1_reserved1   = 4, /* [7:4] */
	BFW_NX50_spi_cr1_fss         = 3, /* [10:8] */
	BFW_NX50_spi_cr1_fss_static  = 1, /* [11] */
	BFW_NX50_spi_cr1_reserved2   = 4, /* [15:12] */
	BFW_NX50_spi_cr1_tx_fifo_wm  = 4, /* [19:16] */
	BFW_NX50_spi_cr1_tx_fifo_clr = 1, /* [20] */
	BFW_NX50_spi_cr1_reserved3   = 3, /* [23:21] */
	BFW_NX50_spi_cr1_rx_fifo_wm  = 4, /* [27:24] */
	BFW_NX50_spi_cr1_rx_fifo_clr = 1, /* [28] */
	BFW_NX50_spi_cr1_reserved4   = 3  /* [31:29] */
};

typedef struct NX50_SPI_CR1_BIT_Ttag {
	unsigned int LBM         : BFW_NX50_spi_cr1_LBM;         /* loop back mode                                                                                    */
	                                                         /* 0: internal loop back disabled                                                                    */
	unsigned int SSE         : BFW_NX50_spi_cr1_SSE;         /* SPI enable.                                                                                       */
	                                                         /* 0: interface disabled                                                                             */
	unsigned int MS          : BFW_NX50_spi_cr1_MS;          /* mode select:                                                                                      */
	                                                         /* 0: device is configured as master                                                                 */
	unsigned int SOD         : BFW_NX50_spi_cr1_SOD;         /* slave mode output disable (to connect multibe slaves to opne master)                              */
	                                                         /* 0: SPI-MISO can be driven in slave mode                                                           */
	unsigned int reserved1   : BFW_NX50_spi_cr1_reserved1;   /* reserved                                                                                          */
	unsigned int fss         : BFW_NX50_spi_cr1_fss;         /* extended: Frame or slave select (up to 3 devices can be assigned directly,                        */
	                                                         /* up to 8 devices can be assigned if an external demultiplexer is used if device is master.         */
	unsigned int fss_static  : BFW_NX50_spi_cr1_fss_static;  /* SPI static chipselect                                                                             */
	                                                         /* 0: SPI-chipselect will be toggled automatically at data frame begin/end according to fss and FRF0 */
	unsigned int reserved2   : BFW_NX50_spi_cr1_reserved2;   /* reserved                                                                                          */
	unsigned int tx_fifo_wm  : BFW_NX50_spi_cr1_tx_fifo_wm;  /* transmit FIFO watermark for IRQ-generation                                                        */
	unsigned int tx_fifo_clr : BFW_NX50_spi_cr1_tx_fifo_clr; /* extended: writing "1" to this bit will clear the transmit-FIFOs                                   */
	                                                         /* There must be at least 1 system-clock idle after clear before writing new data to the FIFO.       */
	unsigned int reserved3   : BFW_NX50_spi_cr1_reserved3;   /* reserved                                                                                          */
	unsigned int rx_fifo_wm  : BFW_NX50_spi_cr1_rx_fifo_wm;  /* receive FIFO watermark for IRQ-generation                                                         */
	unsigned int rx_fifo_clr : BFW_NX50_spi_cr1_rx_fifo_clr; /* extended: writing "1" to this bit will clear the receive-FIFOs                                    */
	unsigned int reserved4   : BFW_NX50_spi_cr1_reserved4;   /* reserved                                                                                          */
} NX50_SPI_CR1_BIT_T;

typedef union {
	unsigned int       val;
	NX50_SPI_CR1_BIT_T bf;
} NX50_SPI_CR1_T;

/* --------------------------------------------------------------------- */
/* Register spi_dr */
/* => spi data register (DR) */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    read access: received data byte is delivered from receive FIFO */
/*    write access: send data byte is written to send FIFO */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_dr  0x00000008U
#define Adr_NX50_spi0_spi_dr 0x1C000D08U
#define Adr_NX50_spi1_spi_dr 0x1C000D48U
#define DFLT_VAL_NX50_spi_dr 0x00000000U

#define MSK_NX50_spi_dr_data      0x0001ffffU
#define SRT_NX50_spi_dr_data      0
#define DFLT_VAL_NX50_spi_dr_data 0x00000000U

enum {
	BFW_NX50_spi_dr_data      = 17, /* [16:0] */
	BFW_NX50_spi_dr_reserved1 = 15  /* [31:17] */
};

typedef struct NX50_SPI_DR_BIT_Ttag {
	unsigned int data      : BFW_NX50_spi_dr_data;      /* Transmit data, must be right aligned on writing, only bits according to spi_cr0.DSS are considered */
	                                                    /* Receive data will be delivered right aligned, unused bits (spi_cr0.DSS < 0xF) will be "0".         */
	unsigned int reserved1 : BFW_NX50_spi_dr_reserved1; /* reserved                                                                                           */
} NX50_SPI_DR_BIT_T;

typedef union {
	unsigned int      val;
	NX50_SPI_DR_BIT_T bf;
} NX50_SPI_DR_T;

/* --------------------------------------------------------------------- */
/* Register spi_sr */
/* => read only spi status register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    SPI master mode: MISO-input-data will be stored in the receive FIFO, transmit FIFO generates MOSI-output-data */
/*    SPI slave mode: MOSI-input-data will be stored in the receive FIFO, transmit FIFO generates MISO-output-data */
/*    Shows the current status of the spi interface. */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_sr  0x0000000CU
#define Adr_NX50_spi0_spi_sr 0x1C000D0CU
#define Adr_NX50_spi1_spi_sr 0x1C000D4CU

#define MSK_NX50_spi_sr_TFE              0x00000001U
#define SRT_NX50_spi_sr_TFE              0
#define MSK_NX50_spi_sr_TNF              0x00000002U
#define SRT_NX50_spi_sr_TNF              1
#define MSK_NX50_spi_sr_RNE              0x00000004U
#define SRT_NX50_spi_sr_RNE              2
#define MSK_NX50_spi_sr_RFF              0x00000008U
#define SRT_NX50_spi_sr_RFF              3
#define MSK_NX50_spi_sr_BSY              0x00000010U
#define SRT_NX50_spi_sr_BSY              4
#define MSK_NX50_spi_sr_tx_fifo_level    0x001f0000U
#define SRT_NX50_spi_sr_tx_fifo_level    16
#define MSK_NX50_spi_sr_tx_fifo_err_ovfl 0x00400000U
#define SRT_NX50_spi_sr_tx_fifo_err_ovfl 22
#define MSK_NX50_spi_sr_tx_fifo_err_undr 0x00800000U
#define SRT_NX50_spi_sr_tx_fifo_err_undr 23
#define MSK_NX50_spi_sr_rx_fifo_level    0x1f000000U
#define SRT_NX50_spi_sr_rx_fifo_level    24
#define MSK_NX50_spi_sr_rx_fifo_err_ovfl 0x40000000U
#define SRT_NX50_spi_sr_rx_fifo_err_ovfl 30
#define MSK_NX50_spi_sr_rx_fifo_err_undr 0x80000000U
#define SRT_NX50_spi_sr_rx_fifo_err_undr 31

enum {
	BFW_NX50_spi_sr_TFE              = 1,  /* [0] */
	BFW_NX50_spi_sr_TNF              = 1,  /* [1] */
	BFW_NX50_spi_sr_RNE              = 1,  /* [2] */
	BFW_NX50_spi_sr_RFF              = 1,  /* [3] */
	BFW_NX50_spi_sr_BSY              = 1,  /* [4] */
	BFW_NX50_spi_sr_reserved1        = 11, /* [15:5] */
	BFW_NX50_spi_sr_tx_fifo_level    = 5,  /* [20:16] */
	BFW_NX50_spi_sr_reserved2        = 1,  /* [21] */
	BFW_NX50_spi_sr_tx_fifo_err_ovfl = 1,  /* [22] */
	BFW_NX50_spi_sr_tx_fifo_err_undr = 1,  /* [23] */
	BFW_NX50_spi_sr_rx_fifo_level    = 5,  /* [28:24] */
	BFW_NX50_spi_sr_reserved3        = 1,  /* [29] */
	BFW_NX50_spi_sr_rx_fifo_err_ovfl = 1,  /* [30] */
	BFW_NX50_spi_sr_rx_fifo_err_undr = 1   /* [31] */
};

typedef struct NX50_SPI_SR_BIT_Ttag {
	unsigned int TFE              : BFW_NX50_spi_sr_TFE;              /* transmit FIFO is empty (1 if empty)                                                         */
	unsigned int TNF              : BFW_NX50_spi_sr_TNF;              /* transmit FIFO is not full (0 if full)                                                       */
	unsigned int RNE              : BFW_NX50_spi_sr_RNE;              /* receive FIFO is not empty (0 if empty)                                                      */
	unsigned int RFF              : BFW_NX50_spi_sr_RFF;              /* receive FIFO is full (1 if full)                                                            */
	unsigned int BSY              : BFW_NX50_spi_sr_BSY;              /* device busy (1 if data is currently transmitted/received or the transmit FIFO is not empty) */
	unsigned int reserved1        : BFW_NX50_spi_sr_reserved1;        /* reserved                                                                                    */
	unsigned int tx_fifo_level    : BFW_NX50_spi_sr_tx_fifo_level;    /* extended: transmit FIFO level (number of words to transmit are left in FIFO)                */
	unsigned int reserved2        : BFW_NX50_spi_sr_reserved2;        /* reserved                                                                                    */
	unsigned int tx_fifo_err_ovfl : BFW_NX50_spi_sr_tx_fifo_err_ovfl; /* extended: transmit FIFO overflow error occured, data is lost                                */
	unsigned int tx_fifo_err_undr : BFW_NX50_spi_sr_tx_fifo_err_undr; /* extended: transmit FIFO underrun error occured, data is lost                                */
	unsigned int rx_fifo_level    : BFW_NX50_spi_sr_rx_fifo_level;    /* extended: receive FIFO level (number of received words to read out are left in FIFO)        */
	unsigned int reserved3        : BFW_NX50_spi_sr_reserved3;        /* reserved                                                                                    */
	unsigned int rx_fifo_err_ovfl : BFW_NX50_spi_sr_rx_fifo_err_ovfl; /* extended: receive FIFO overflow error occured, data is lost                                 */
	unsigned int rx_fifo_err_undr : BFW_NX50_spi_sr_rx_fifo_err_undr; /* extended: receive FIFO underrun error occured, data is lost                                 */
} NX50_SPI_SR_BIT_T;

typedef union {
	unsigned int      val;
	NX50_SPI_SR_BIT_T bf;
} NX50_SPI_SR_T;

/* --------------------------------------------------------------------- */
/* Register spi_cpsr */
/* => Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    spi clock prescale register */
/*    No clock predeviding is done. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_cpsr  0x00000010U
#define Adr_NX50_spi0_spi_cpsr 0x1C000D10U
#define Adr_NX50_spi1_spi_cpsr 0x1C000D50U
#define DFLT_VAL_NX50_spi_cpsr 0x00000000U

#define MSK_NX50_spi_cpsr_CPSDVSR      0x000000ffU
#define SRT_NX50_spi_cpsr_CPSDVSR      0
#define DFLT_VAL_NX50_spi_cpsr_CPSDVSR 0x00000000U

enum {
	BFW_NX50_spi_cpsr_CPSDVSR   = 8,  /* [7:0] */
	BFW_NX50_spi_cpsr_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_SPI_CPSR_BIT_Ttag {
	unsigned int CPSDVSR   : BFW_NX50_spi_cpsr_CPSDVSR;   /* obsolet  */
	unsigned int reserved1 : BFW_NX50_spi_cpsr_reserved1; /* reserved */
} NX50_SPI_CPSR_BIT_T;

typedef union {
	unsigned int        val;
	NX50_SPI_CPSR_BIT_T bf;
} NX50_SPI_CPSR_T;

/* --------------------------------------------------------------------- */
/* Register spi_imsc */
/* => spi interrupt mask set or clear register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    AND-mask */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_imsc  0x00000014U
#define Adr_NX50_spi0_spi_imsc 0x1C000D14U
#define Adr_NX50_spi1_spi_imsc 0x1C000D54U
#define DFLT_VAL_NX50_spi_imsc 0x00000000U

#define MSK_NX50_spi_imsc_RORIM       0x00000001U
#define SRT_NX50_spi_imsc_RORIM       0
#define DFLT_VAL_NX50_spi_imsc_RORIM  0x00000000U
#define MSK_NX50_spi_imsc_RTIM        0x00000002U
#define SRT_NX50_spi_imsc_RTIM        1
#define DFLT_VAL_NX50_spi_imsc_RTIM   0x00000000U
#define MSK_NX50_spi_imsc_RXIM        0x00000004U
#define SRT_NX50_spi_imsc_RXIM        2
#define DFLT_VAL_NX50_spi_imsc_RXIM   0x00000000U
#define MSK_NX50_spi_imsc_TXIM        0x00000008U
#define SRT_NX50_spi_imsc_TXIM        3
#define DFLT_VAL_NX50_spi_imsc_TXIM   0x00000000U
#define MSK_NX50_spi_imsc_rxneim      0x00000010U
#define SRT_NX50_spi_imsc_rxneim      4
#define DFLT_VAL_NX50_spi_imsc_rxneim 0x00000000U
#define MSK_NX50_spi_imsc_rxfim       0x00000020U
#define SRT_NX50_spi_imsc_rxfim       5
#define DFLT_VAL_NX50_spi_imsc_rxfim  0x00000000U
#define MSK_NX50_spi_imsc_txeim       0x00000040U
#define SRT_NX50_spi_imsc_txeim       6
#define DFLT_VAL_NX50_spi_imsc_txeim  0x00000000U

enum {
	BFW_NX50_spi_imsc_RORIM     = 1,  /* [0] */
	BFW_NX50_spi_imsc_RTIM      = 1,  /* [1] */
	BFW_NX50_spi_imsc_RXIM      = 1,  /* [2] */
	BFW_NX50_spi_imsc_TXIM      = 1,  /* [3] */
	BFW_NX50_spi_imsc_rxneim    = 1,  /* [4] */
	BFW_NX50_spi_imsc_rxfim     = 1,  /* [5] */
	BFW_NX50_spi_imsc_txeim     = 1,  /* [6] */
	BFW_NX50_spi_imsc_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_SPI_IMSC_BIT_Ttag {
	unsigned int RORIM     : BFW_NX50_spi_imsc_RORIM;     /* receive FIFO overrun interrupt mask                                */
	unsigned int RTIM      : BFW_NX50_spi_imsc_RTIM;      /* receive timeout interrupt mask                                     */
	unsigned int RXIM      : BFW_NX50_spi_imsc_RXIM;      /* receive FIFO interrupt mask                                        */
	unsigned int TXIM      : BFW_NX50_spi_imsc_TXIM;      /* transmit FIFO interrupt mask                                       */
	unsigned int rxneim    : BFW_NX50_spi_imsc_rxneim;    /* receive FIFO not empty interrupt mask (for netx100/500 compliance) */
	unsigned int rxfim     : BFW_NX50_spi_imsc_rxfim;     /* receive FIFO full interrupt mask (for netx100/500 compliance)      */
	unsigned int txeim     : BFW_NX50_spi_imsc_txeim;     /* transmit FIFO empty interrupt mask (for netx100/500 compliance)    */
	unsigned int reserved1 : BFW_NX50_spi_imsc_reserved1; /* reserved                                                           */
} NX50_SPI_IMSC_BIT_T;

typedef union {
	unsigned int        val;
	NX50_SPI_IMSC_BIT_T bf;
} NX50_SPI_IMSC_T;

/* --------------------------------------------------------------------- */
/* Register spi_ris */
/* => spi interrupt state before masking register (raw interrupt) */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_ris  0x00000018U
#define Adr_NX50_spi0_spi_ris 0x1C000D18U
#define Adr_NX50_spi1_spi_ris 0x1C000D58U

#define MSK_NX50_spi_ris_RORRIS  0x00000001U
#define SRT_NX50_spi_ris_RORRIS  0
#define MSK_NX50_spi_ris_RTRIS   0x00000002U
#define SRT_NX50_spi_ris_RTRIS   1
#define MSK_NX50_spi_ris_RXRIS   0x00000004U
#define SRT_NX50_spi_ris_RXRIS   2
#define MSK_NX50_spi_ris_TXRIS   0x00000008U
#define SRT_NX50_spi_ris_TXRIS   3
#define MSK_NX50_spi_ris_rxneris 0x00000010U
#define SRT_NX50_spi_ris_rxneris 4
#define MSK_NX50_spi_ris_rxfris  0x00000020U
#define SRT_NX50_spi_ris_rxfris  5
#define MSK_NX50_spi_ris_txeris  0x00000040U
#define SRT_NX50_spi_ris_txeris  6

enum {
	BFW_NX50_spi_ris_RORRIS    = 1,  /* [0] */
	BFW_NX50_spi_ris_RTRIS     = 1,  /* [1] */
	BFW_NX50_spi_ris_RXRIS     = 1,  /* [2] */
	BFW_NX50_spi_ris_TXRIS     = 1,  /* [3] */
	BFW_NX50_spi_ris_rxneris   = 1,  /* [4] */
	BFW_NX50_spi_ris_rxfris    = 1,  /* [5] */
	BFW_NX50_spi_ris_txeris    = 1,  /* [6] */
	BFW_NX50_spi_ris_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_SPI_RIS_BIT_Ttag {
	unsigned int RORRIS    : BFW_NX50_spi_ris_RORRIS;    /* unmasked receive FIFO overrun interrupt state                                */
	                                                     /* 1: receive FIFO overun error ocuured                                         */
	unsigned int RTRIS     : BFW_NX50_spi_ris_RTRIS;     /* unmasked receive timeout interrupt state                                     */
	                                                     /* timeout period are 32 SPI-clock periods depending on adr_spi_cr0.SCR         */
	unsigned int RXRIS     : BFW_NX50_spi_ris_RXRIS;     /* unmasked receive FIFO interrupt state                                        */
	                                                     /* 1: receive FIFO is higher than spi_cr1.rx_fifo_wm                            */
	unsigned int TXRIS     : BFW_NX50_spi_ris_TXRIS;     /* unmasked transmit FIFO interrupt state                                       */
	                                                     /* 1: transmit FIFO level is below spi_cr1.tx_fifo_wm                           */
	unsigned int rxneris   : BFW_NX50_spi_ris_rxneris;   /* unmasked receive FIFO not empty interrupt state (for netx100/500 compliance) */
	                                                     /* 1: receive FIFO is not empty                                                 */
	unsigned int rxfris    : BFW_NX50_spi_ris_rxfris;    /* unmasked receive FIFO full interrupt state (for netx100/500 compliance)      */
	                                                     /* 1: receive FIFO is full                                                      */
	unsigned int txeris    : BFW_NX50_spi_ris_txeris;    /* unmasked transmit FIFO empty interrupt state (for netx100/500 compliance)    */
	                                                     /* 1: transmit FIFO is empty                                                    */
	unsigned int reserved1 : BFW_NX50_spi_ris_reserved1; /* reserved                                                                     */
} NX50_SPI_RIS_BIT_T;

typedef union {
	unsigned int       val;
	NX50_SPI_RIS_BIT_T bf;
} NX50_SPI_RIS_T;

/* --------------------------------------------------------------------- */
/* Register spi_mis */
/* => spi interrupt status register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_mis  0x0000001CU
#define Adr_NX50_spi0_spi_mis 0x1C000D1CU
#define Adr_NX50_spi1_spi_mis 0x1C000D5CU

#define MSK_NX50_spi_mis_RORMIS  0x00000001U
#define SRT_NX50_spi_mis_RORMIS  0
#define MSK_NX50_spi_mis_RTMIS   0x00000002U
#define SRT_NX50_spi_mis_RTMIS   1
#define MSK_NX50_spi_mis_RXMIS   0x00000004U
#define SRT_NX50_spi_mis_RXMIS   2
#define MSK_NX50_spi_mis_TXMIS   0x00000008U
#define SRT_NX50_spi_mis_TXMIS   3
#define MSK_NX50_spi_mis_rxnemis 0x00000010U
#define SRT_NX50_spi_mis_rxnemis 4
#define MSK_NX50_spi_mis_rxfmis  0x00000020U
#define SRT_NX50_spi_mis_rxfmis  5
#define MSK_NX50_spi_mis_txemis  0x00000040U
#define SRT_NX50_spi_mis_txemis  6

enum {
	BFW_NX50_spi_mis_RORMIS    = 1,  /* [0] */
	BFW_NX50_spi_mis_RTMIS     = 1,  /* [1] */
	BFW_NX50_spi_mis_RXMIS     = 1,  /* [2] */
	BFW_NX50_spi_mis_TXMIS     = 1,  /* [3] */
	BFW_NX50_spi_mis_rxnemis   = 1,  /* [4] */
	BFW_NX50_spi_mis_rxfmis    = 1,  /* [5] */
	BFW_NX50_spi_mis_txemis    = 1,  /* [6] */
	BFW_NX50_spi_mis_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_SPI_MIS_BIT_Ttag {
	unsigned int RORMIS    : BFW_NX50_spi_mis_RORMIS;    /* masked receive FIFO overrun interrupt state                                */
	unsigned int RTMIS     : BFW_NX50_spi_mis_RTMIS;     /* masked receive timeout interrupt state                                     */
	unsigned int RXMIS     : BFW_NX50_spi_mis_RXMIS;     /* masked receive FIFO interrupt state                                        */
	unsigned int TXMIS     : BFW_NX50_spi_mis_TXMIS;     /* masked transmit FIFO interrupt state                                       */
	unsigned int rxnemis   : BFW_NX50_spi_mis_rxnemis;   /* masked receive FIFO not empty interrupt state (for netx100/500 compliance) */
	unsigned int rxfmis    : BFW_NX50_spi_mis_rxfmis;    /* masked receive FIFO full interrupt state (for netx100/500 compliance)      */
	unsigned int txemis    : BFW_NX50_spi_mis_txemis;    /* masked transmit FIFO empty interrupt state (for netx100/500 compliance)    */
	unsigned int reserved1 : BFW_NX50_spi_mis_reserved1; /* reserved                                                                   */
} NX50_SPI_MIS_BIT_T;

typedef union {
	unsigned int       val;
	NX50_SPI_MIS_BIT_T bf;
} NX50_SPI_MIS_T;

/* --------------------------------------------------------------------- */
/* Register spi_icr */
/* => spi interrupt clear register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    interrupt is cleard by writing "1" to the according bit */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_icr  0x00000020U
#define Adr_NX50_spi0_spi_icr 0x1C000D20U
#define Adr_NX50_spi1_spi_icr 0x1C000D60U
#define DFLT_VAL_NX50_spi_icr 0x00000000U

#define MSK_NX50_spi_icr_RORIC       0x00000001U
#define SRT_NX50_spi_icr_RORIC       0
#define DFLT_VAL_NX50_spi_icr_RORIC  0x00000000U
#define MSK_NX50_spi_icr_RTIC        0x00000002U
#define SRT_NX50_spi_icr_RTIC        1
#define DFLT_VAL_NX50_spi_icr_RTIC   0x00000000U
#define MSK_NX50_spi_icr_RXIC        0x00000004U
#define SRT_NX50_spi_icr_RXIC        2
#define DFLT_VAL_NX50_spi_icr_RXIC   0x00000000U
#define MSK_NX50_spi_icr_TXIC        0x00000008U
#define SRT_NX50_spi_icr_TXIC        3
#define DFLT_VAL_NX50_spi_icr_TXIC   0x00000000U
#define MSK_NX50_spi_icr_rxneic      0x00000010U
#define SRT_NX50_spi_icr_rxneic      4
#define DFLT_VAL_NX50_spi_icr_rxneic 0x00000000U
#define MSK_NX50_spi_icr_rxfic       0x00000020U
#define SRT_NX50_spi_icr_rxfic       5
#define DFLT_VAL_NX50_spi_icr_rxfic  0x00000000U
#define MSK_NX50_spi_icr_txeic       0x00000040U
#define SRT_NX50_spi_icr_txeic       6
#define DFLT_VAL_NX50_spi_icr_txeic  0x00000000U

enum {
	BFW_NX50_spi_icr_RORIC     = 1,  /* [0] */
	BFW_NX50_spi_icr_RTIC      = 1,  /* [1] */
	BFW_NX50_spi_icr_RXIC      = 1,  /* [2] */
	BFW_NX50_spi_icr_TXIC      = 1,  /* [3] */
	BFW_NX50_spi_icr_rxneic    = 1,  /* [4] */
	BFW_NX50_spi_icr_rxfic     = 1,  /* [5] */
	BFW_NX50_spi_icr_txeic     = 1,  /* [6] */
	BFW_NX50_spi_icr_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_SPI_ICR_BIT_Ttag {
	unsigned int RORIC     : BFW_NX50_spi_icr_RORIC;     /* clear receive FIFO overrun interrupt                                */
	                                                     /* writing '1' here will clear the receive FIFO                        */
	unsigned int RTIC      : BFW_NX50_spi_icr_RTIC;      /* clear receive FIFO overrun interrupt                                */
	unsigned int RXIC      : BFW_NX50_spi_icr_RXIC;      /* PL022 extention: clear receive FIFO interrupt                       */
	unsigned int TXIC      : BFW_NX50_spi_icr_TXIC;      /* PL022 extention: clear transmit FIFO interrupt                      */
	unsigned int rxneic    : BFW_NX50_spi_icr_rxneic;    /* clear receive FIFO not empty interrupt (for netx100/500 compliance) */
	unsigned int rxfic     : BFW_NX50_spi_icr_rxfic;     /* clear receive FIFO full interrupt (for netx100/500 compliance)      */
	unsigned int txeic     : BFW_NX50_spi_icr_txeic;     /* clear transmit FIFO empty interrupt (for netx100/500 compliance)    */
	unsigned int reserved1 : BFW_NX50_spi_icr_reserved1; /* reserved                                                            */
} NX50_SPI_ICR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_SPI_ICR_BIT_T bf;
} NX50_SPI_ICR_T;

/* --------------------------------------------------------------------- */
/* Register spi_dmacr */
/* => spi DMA control register */
/*    Only single transfer requests will be generated by this module. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_dmacr  0x00000024U
#define Adr_NX50_spi0_spi_dmacr 0x1C000D24U
#define Adr_NX50_spi1_spi_dmacr 0x1C000D64U
#define DFLT_VAL_NX50_spi_dmacr 0x00000000U

#define MSK_NX50_spi_dmacr_RXDMAE      0x00000001U
#define SRT_NX50_spi_dmacr_RXDMAE      0
#define DFLT_VAL_NX50_spi_dmacr_RXDMAE 0x00000000U
#define MSK_NX50_spi_dmacr_TXDMAE      0x00000002U
#define SRT_NX50_spi_dmacr_TXDMAE      1
#define DFLT_VAL_NX50_spi_dmacr_TXDMAE 0x00000000U

enum {
	BFW_NX50_spi_dmacr_RXDMAE    = 1,  /* [0] */
	BFW_NX50_spi_dmacr_TXDMAE    = 1,  /* [1] */
	BFW_NX50_spi_dmacr_reserved1 = 30  /* [31:2] */
};

typedef struct NX50_SPI_DMACR_BIT_Ttag {
	unsigned int RXDMAE    : BFW_NX50_spi_dmacr_RXDMAE;    /* enable DMA for SPI-receive data                                                             */
	                                                       /* A request will be generated if RX-FIFO is not empty and spi_cr1.SSE (module enable) is set. */
	unsigned int TXDMAE    : BFW_NX50_spi_dmacr_TXDMAE;    /* enable DMA for SPI-transmit data                                                            */
	                                                       /* A request will be generated if TX-FIFO is not full and spi_cr1.SSE (module enable) is set.  */
	unsigned int reserved1 : BFW_NX50_spi_dmacr_reserved1; /* reserved                                                                                    */
} NX50_SPI_DMACR_BIT_T;

typedef union {
	unsigned int         val;
	NX50_SPI_DMACR_BIT_T bf;
} NX50_SPI_DMACR_T;

/* --------------------------------------------------------------------- */
/* Register spi_data_register */
/* => netx100/500 compliant spi data register (DR) */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    2 data bytes with valid bits */
/*    During write-access data_byte_1 and dr_valid1 must not be used. dr_valid0 must be set. */
/*    In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software */
/*    compatible, not more than 8 bytes should be in netx100/500-FIFOs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_data_register  0x00000030U
#define Adr_NX50_spi0_spi_data_register 0x1C000D30U
#define Adr_NX50_spi1_spi_data_register 0x1C000D70U
#define DFLT_VAL_NX50_spi_data_register 0x00000000U

#define MSK_NX50_spi_data_register_data_byte_0      0x000000ffU
#define SRT_NX50_spi_data_register_data_byte_0      0
#define DFLT_VAL_NX50_spi_data_register_data_byte_0 0x00000000U
#define MSK_NX50_spi_data_register_data_byte_1      0x0000ff00U
#define SRT_NX50_spi_data_register_data_byte_1      8
#define DFLT_VAL_NX50_spi_data_register_data_byte_1 0x00000000U
#define MSK_NX50_spi_data_register_dr_valid0        0x00010000U
#define SRT_NX50_spi_data_register_dr_valid0        16
#define DFLT_VAL_NX50_spi_data_register_dr_valid0   0x00000000U
#define MSK_NX50_spi_data_register_dr_valid1        0x00020000U
#define SRT_NX50_spi_data_register_dr_valid1        17
#define DFLT_VAL_NX50_spi_data_register_dr_valid1   0x00000000U

enum {
	BFW_NX50_spi_data_register_data_byte_0 = 8,  /* [7:0] */
	BFW_NX50_spi_data_register_data_byte_1 = 8,  /* [15:8] */
	BFW_NX50_spi_data_register_dr_valid0   = 1,  /* [16] */
	BFW_NX50_spi_data_register_dr_valid1   = 1,  /* [17] */
	BFW_NX50_spi_data_register_reserved1   = 14  /* [31:18] */
};

typedef struct NX50_SPI_DATA_REGISTER_BIT_Ttag {
	unsigned int data_byte_0 : BFW_NX50_spi_data_register_data_byte_0; /* data byte 0                                                                     */
	unsigned int data_byte_1 : BFW_NX50_spi_data_register_data_byte_1; /* obsolet, don't use                                                              */
	unsigned int dr_valid0   : BFW_NX50_spi_data_register_dr_valid0;   /* valid bit for data_byte_0                                                       */
	                                                                   /* This bit shows if data_byte_0 Is valid and must be set during FIFO write access */
	unsigned int dr_valid1   : BFW_NX50_spi_data_register_dr_valid1;   /* obsolet, always 0                                                               */
	unsigned int reserved1   : BFW_NX50_spi_data_register_reserved1;   /* reserved                                                                        */
} NX50_SPI_DATA_REGISTER_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_SPI_DATA_REGISTER_BIT_T bf;
} NX50_SPI_DATA_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_status_register */
/* => netx100/500 compliant spi status register (SR): */
/*    Shows the actual status of the spi interface. */
/*    Bits 24..18 show occured interrupts, */
/*    writing ones into these bits deletes the interrupts. */
/*    Writing into other bits has no effect. */
/*    In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software */
/*    compatible, not more than 8 bytes should be in netx100/500-FIFOs. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_status_register  0x00000034U
#define Adr_NX50_spi0_spi_status_register 0x1C000D34U
#define Adr_NX50_spi1_spi_status_register 0x1C000D74U

#define MSK_NX50_spi_status_register_SR_in_fuel_val  0x000001ffU
#define SRT_NX50_spi_status_register_SR_in_fuel_val  0
#define MSK_NX50_spi_status_register_SR_out_fuel_val 0x0003fe00U
#define SRT_NX50_spi_status_register_SR_out_fuel_val 9
#define MSK_NX50_spi_status_register_SR_in_fuel      0x00040000U
#define SRT_NX50_spi_status_register_SR_in_fuel      18
#define MSK_NX50_spi_status_register_SR_in_recdata   0x00080000U
#define SRT_NX50_spi_status_register_SR_in_recdata   19
#define MSK_NX50_spi_status_register_SR_in_full      0x00100000U
#define SRT_NX50_spi_status_register_SR_in_full      20
#define MSK_NX50_spi_status_register_SR_out_fuel     0x00200000U
#define SRT_NX50_spi_status_register_SR_out_fuel     21
#define MSK_NX50_spi_status_register_SR_out_fw       0x00400000U
#define SRT_NX50_spi_status_register_SR_out_fw       22
#define MSK_NX50_spi_status_register_SR_out_empty    0x00800000U
#define SRT_NX50_spi_status_register_SR_out_empty    23
#define MSK_NX50_spi_status_register_SR_out_full     0x01000000U
#define SRT_NX50_spi_status_register_SR_out_full     24
#define MSK_NX50_spi_status_register_SR_selected     0x02000000U
#define SRT_NX50_spi_status_register_SR_selected     25

enum {
	BFW_NX50_spi_status_register_SR_in_fuel_val  = 9, /* [8:0] */
	BFW_NX50_spi_status_register_SR_out_fuel_val = 9, /* [17:9] */
	BFW_NX50_spi_status_register_SR_in_fuel      = 1, /* [18] */
	BFW_NX50_spi_status_register_SR_in_recdata   = 1, /* [19] */
	BFW_NX50_spi_status_register_SR_in_full      = 1, /* [20] */
	BFW_NX50_spi_status_register_SR_out_fuel     = 1, /* [21] */
	BFW_NX50_spi_status_register_SR_out_fw       = 1, /* [22] */
	BFW_NX50_spi_status_register_SR_out_empty    = 1, /* [23] */
	BFW_NX50_spi_status_register_SR_out_full     = 1, /* [24] */
	BFW_NX50_spi_status_register_SR_selected     = 1, /* [25] */
	BFW_NX50_spi_status_register_reserved1       = 6  /* [31:26] */
};

typedef struct NX50_SPI_STATUS_REGISTER_BIT_Ttag {
	unsigned int SR_in_fuel_val  : BFW_NX50_spi_status_register_SR_in_fuel_val;  /* input FIFO fill value (number of bytes)                                                              */
	unsigned int SR_out_fuel_val : BFW_NX50_spi_status_register_SR_out_fuel_val; /* output FIFO fill vlaue (number of bytes)                                                             */
	unsigned int SR_in_fuel      : BFW_NX50_spi_status_register_SR_in_fuel;      /* adjustable fill value of input FIFO reached (equals adr_spi_ris.RXRIS in netx50 and later versions)  */
	unsigned int SR_in_recdata   : BFW_NX50_spi_status_register_SR_in_recdata;   /* valid data bytes in input FIFO (equals adr_spi_ris.rxneris in netx50 and later versions)             */
	unsigned int SR_in_full      : BFW_NX50_spi_status_register_SR_in_full;      /* input FIFO is full (equals adr_spi_ris.rxfris in netx50 and later versions)                          */
	unsigned int SR_out_fuel     : BFW_NX50_spi_status_register_SR_out_fuel;     /* adjustable fill value of output FIFO reached (equals adr_spi_ris.TXRIS in netx50 and later versions) */
	unsigned int SR_out_fw       : BFW_NX50_spi_status_register_SR_out_fw;       /* netx is writing data to fast into output FIFO. This is only with netx100/500 an IRQ.                 */
	                                                                             /* (equals adr_spi_sr.tx_fifo_err_ovfl in netx50 and later versions)                                    */
	unsigned int SR_out_empty    : BFW_NX50_spi_status_register_SR_out_empty;    /* output FIFO is empty in slave mode. (equals adr_spi_ris.txeris in netx50 and later versions)         */
	unsigned int SR_out_full     : BFW_NX50_spi_status_register_SR_out_full;     /* output FIFO is full .This is only with netx100/500 an IRQ.                                           */
	unsigned int SR_selected     : BFW_NX50_spi_status_register_SR_selected;     /* external master has access to spi-interface                                                          */
	unsigned int reserved1       : BFW_NX50_spi_status_register_reserved1;       /* reserved                                                                                             */
} NX50_SPI_STATUS_REGISTER_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_SPI_STATUS_REGISTER_BIT_T bf;
} NX50_SPI_STATUS_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_control_register */
/* => netx100/500 compliant spi control register (CR) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_control_register  0x00000038U
#define Adr_NX50_spi0_spi_control_register 0x1C000D38U
#define Adr_NX50_spi1_spi_control_register 0x1C000D78U
#define DFLT_VAL_NX50_spi_control_register 0x00000000U

#define MSK_NX50_spi_control_register_CR_softreset        0x00000001U
#define SRT_NX50_spi_control_register_CR_softreset        0
#define DFLT_VAL_NX50_spi_control_register_CR_softreset   0x00000000U
#define MSK_NX50_spi_control_register_CR_speed            0x0000001eU
#define SRT_NX50_spi_control_register_CR_speed            1
#define DFLT_VAL_NX50_spi_control_register_CR_speed       0x00000000U
#define MSK_NX50_spi_control_register_CR_read             0x00000040U
#define SRT_NX50_spi_control_register_CR_read             6
#define DFLT_VAL_NX50_spi_control_register_CR_read        0x00000000U
#define MSK_NX50_spi_control_register_CR_write            0x00000080U
#define SRT_NX50_spi_control_register_CR_write            7
#define DFLT_VAL_NX50_spi_control_register_CR_write       0x00000000U
#define MSK_NX50_spi_control_register_CR_ss               0x00000700U
#define SRT_NX50_spi_control_register_CR_ss               8
#define DFLT_VAL_NX50_spi_control_register_CR_ss          0x00000000U
#define MSK_NX50_spi_control_register_CS_mode             0x00000800U
#define SRT_NX50_spi_control_register_CS_mode             11
#define DFLT_VAL_NX50_spi_control_register_CS_mode        0x00000000U
#define MSK_NX50_spi_control_register_CR_clr_infifo       0x00100000U
#define SRT_NX50_spi_control_register_CR_clr_infifo       20
#define DFLT_VAL_NX50_spi_control_register_CR_clr_infifo  0x00000000U
#define MSK_NX50_spi_control_register_CR_clr_outfifo      0x00200000U
#define SRT_NX50_spi_control_register_CR_clr_outfifo      21
#define DFLT_VAL_NX50_spi_control_register_CR_clr_outfifo 0x00000000U
#define MSK_NX50_spi_control_register_CR_burstdelay       0x01c00000U
#define SRT_NX50_spi_control_register_CR_burstdelay       22
#define DFLT_VAL_NX50_spi_control_register_CR_burstdelay  0x00000000U
#define MSK_NX50_spi_control_register_CR_burst            0x0e000000U
#define SRT_NX50_spi_control_register_CR_burst            25
#define DFLT_VAL_NX50_spi_control_register_CR_burst       0x00000000U
#define MSK_NX50_spi_control_register_CR_ncpha            0x10000000U
#define SRT_NX50_spi_control_register_CR_ncpha            28
#define DFLT_VAL_NX50_spi_control_register_CR_ncpha       0x00000000U
#define MSK_NX50_spi_control_register_CR_cpol             0x20000000U
#define SRT_NX50_spi_control_register_CR_cpol             29
#define DFLT_VAL_NX50_spi_control_register_CR_cpol        0x00000000U
#define MSK_NX50_spi_control_register_CR_ms               0x40000000U
#define SRT_NX50_spi_control_register_CR_ms               30
#define DFLT_VAL_NX50_spi_control_register_CR_ms          0x00000000U
#define MSK_NX50_spi_control_register_CR_en               0x80000000U
#define SRT_NX50_spi_control_register_CR_en               31
#define DFLT_VAL_NX50_spi_control_register_CR_en          0x00000000U

enum {
	BFW_NX50_spi_control_register_CR_softreset   = 1, /* [0] */
	BFW_NX50_spi_control_register_CR_speed       = 4, /* [4:1] */
	BFW_NX50_spi_control_register_reserved1      = 1, /* [5] */
	BFW_NX50_spi_control_register_CR_read        = 1, /* [6] */
	BFW_NX50_spi_control_register_CR_write       = 1, /* [7] */
	BFW_NX50_spi_control_register_CR_ss          = 3, /* [10:8] */
	BFW_NX50_spi_control_register_CS_mode        = 1, /* [11] */
	BFW_NX50_spi_control_register_reserved2      = 8, /* [19:12] */
	BFW_NX50_spi_control_register_CR_clr_infifo  = 1, /* [20] */
	BFW_NX50_spi_control_register_CR_clr_outfifo = 1, /* [21] */
	BFW_NX50_spi_control_register_CR_burstdelay  = 3, /* [24:22] */
	BFW_NX50_spi_control_register_CR_burst       = 3, /* [27:25] */
	BFW_NX50_spi_control_register_CR_ncpha       = 1, /* [28] */
	BFW_NX50_spi_control_register_CR_cpol        = 1, /* [29] */
	BFW_NX50_spi_control_register_CR_ms          = 1, /* [30] */
	BFW_NX50_spi_control_register_CR_en          = 1  /* [31] */
};

typedef struct NX50_SPI_CONTROL_REGISTER_BIT_Ttag {
	unsigned int CR_softreset   : BFW_NX50_spi_control_register_CR_softreset;   /* write only: no function in netx100/netx500; later Versions: clears IRQs and FIFOs                             */
	unsigned int CR_speed       : BFW_NX50_spi_control_register_CR_speed;       /* clock devider for SPI clock (2 - 2^16)                                                                        */
	                                                                            /* If SPI Clock-rate is changed by adr_spi_cr0.SCR, this value will not be updated an may be incorrect           */
	unsigned int reserved1      : BFW_NX50_spi_control_register_reserved1;      /* reserved                                                                                                      */
	unsigned int CR_read        : BFW_NX50_spi_control_register_CR_read;        /* netx100/netx500 only, in later versions always "1":  1: enable spi interface read data                        */
	unsigned int CR_write       : BFW_NX50_spi_control_register_CR_write;       /* netx100/netx500 only, in later versions always "1":  1: enable spi interface write data                       */
	unsigned int CR_ss          : BFW_NX50_spi_control_register_CR_ss;          /* external slave select                                                                                         */
	unsigned int CS_mode        : BFW_NX50_spi_control_register_CS_mode;        /* 1: chip select is generated automatically by the internal state machine                                       */
	                                                                            /* 0: chip select is directly controlled by software (see bits CR_ss).                                           */
	unsigned int reserved2      : BFW_NX50_spi_control_register_reserved2;      /* reserved                                                                                                      */
	unsigned int CR_clr_infifo  : BFW_NX50_spi_control_register_CR_clr_infifo;  /* clear input FIFO                                                                                              */
	unsigned int CR_clr_outfifo : BFW_NX50_spi_control_register_CR_clr_outfifo; /* clear output FIFO                                                                                             */
	unsigned int CR_burstdelay  : BFW_NX50_spi_control_register_CR_burstdelay;  /* netx100/netx500 only, obsolet in later versions: delay between transmittion of 2 data bytes                   */
	                                                                            /* (0 to 7 SCK cycles)                                                                                           */
	unsigned int CR_burst       : BFW_NX50_spi_control_register_CR_burst;       /* netx100/netx500 only, obsolet in later versions: burst lenght = 2^CR_burst                                    */
	unsigned int CR_ncpha       : BFW_NX50_spi_control_register_CR_ncpha;       /* SPI clock phase mode (Note: meaning of this bit is inverted to functionality of bit SPH in spi_cr0 register): */
	                                                                            /* 0: Change data to secondary spi_sck edge                                                                      */
	unsigned int CR_cpol        : BFW_NX50_spi_control_register_CR_cpol;        /* 1:falling edge of spi_sck is primary                                                                          */
	                                                                            /* 0:rising edge of spi_sck is primary                                                                           */
	unsigned int CR_ms          : BFW_NX50_spi_control_register_CR_ms;          /* 1:master mode 0:slave mode                                                                                    */
	unsigned int CR_en          : BFW_NX50_spi_control_register_CR_en;          /* 1:enable 0:disable spi interface                                                                              */
} NX50_SPI_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_SPI_CONTROL_REGISTER_BIT_T bf;
} NX50_SPI_CONTROL_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_interrupt_control_register */
/* => netx100/500 compliant spi interrupt control register (IR) */
/*    In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software */
/*    compatible, not more than 8 bytes should be in netx100/500-FIFOs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_spi_interrupt_control_register  0x0000003CU
#define Adr_NX50_spi0_spi_interrupt_control_register 0x1C000D3CU
#define Adr_NX50_spi1_spi_interrupt_control_register 0x1C000D7CU
#define DFLT_VAL_NX50_spi_interrupt_control_register 0x00000000U

#define MSK_NX50_spi_interrupt_control_register_IR_in_fuel            0x000001ffU
#define SRT_NX50_spi_interrupt_control_register_IR_in_fuel            0
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_in_fuel       0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_out_fuel           0x0003fe00U
#define SRT_NX50_spi_interrupt_control_register_IR_out_fuel           9
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_out_fuel      0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_in_fuel_en         0x00040000U
#define SRT_NX50_spi_interrupt_control_register_IR_in_fuel_en         18
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_in_fuel_en    0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_in_recdata_en      0x00080000U
#define SRT_NX50_spi_interrupt_control_register_IR_in_recdata_en      19
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_in_recdata_en 0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_in_full_en         0x00100000U
#define SRT_NX50_spi_interrupt_control_register_IR_in_full_en         20
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_in_full_en    0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_out_fuel_en        0x00200000U
#define SRT_NX50_spi_interrupt_control_register_IR_out_fuel_en        21
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_out_fuel_en   0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_out_fw_en          0x00400000U
#define SRT_NX50_spi_interrupt_control_register_IR_out_fw_en          22
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_out_fw_en     0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_out_empty_en       0x00800000U
#define SRT_NX50_spi_interrupt_control_register_IR_out_empty_en       23
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_out_empty_en  0x00000000U
#define MSK_NX50_spi_interrupt_control_register_IR_out_full_en        0x01000000U
#define SRT_NX50_spi_interrupt_control_register_IR_out_full_en        24
#define DFLT_VAL_NX50_spi_interrupt_control_register_IR_out_full_en   0x00000000U

enum {
	BFW_NX50_spi_interrupt_control_register_IR_in_fuel       = 9, /* [8:0] */
	BFW_NX50_spi_interrupt_control_register_IR_out_fuel      = 9, /* [17:9] */
	BFW_NX50_spi_interrupt_control_register_IR_in_fuel_en    = 1, /* [18] */
	BFW_NX50_spi_interrupt_control_register_IR_in_recdata_en = 1, /* [19] */
	BFW_NX50_spi_interrupt_control_register_IR_in_full_en    = 1, /* [20] */
	BFW_NX50_spi_interrupt_control_register_IR_out_fuel_en   = 1, /* [21] */
	BFW_NX50_spi_interrupt_control_register_IR_out_fw_en     = 1, /* [22] */
	BFW_NX50_spi_interrupt_control_register_IR_out_empty_en  = 1, /* [23] */
	BFW_NX50_spi_interrupt_control_register_IR_out_full_en   = 1, /* [24] */
	BFW_NX50_spi_interrupt_control_register_reserved1        = 7  /* [31:25] */
};

typedef struct NX50_SPI_INTERRUPT_CONTROL_REGISTER_BIT_Ttag {
	unsigned int IR_in_fuel       : BFW_NX50_spi_interrupt_control_register_IR_in_fuel;       /* adjustable watermark level of input FIFO                                             */
	unsigned int IR_out_fuel      : BFW_NX50_spi_interrupt_control_register_IR_out_fuel;      /* adjustable watermark level of output FIFO                                            */
	unsigned int IR_in_fuel_en    : BFW_NX50_spi_interrupt_control_register_IR_in_fuel_en;    /* IRQ enable for irq_spi(0)  (equals adr_spi_imsc.RXIM in netx50 and later versions)   */
	unsigned int IR_in_recdata_en : BFW_NX50_spi_interrupt_control_register_IR_in_recdata_en; /* IRQ enable for irq_spi(1)  (equals adr_spi_imsc.txneim in netx50 and later versions) */
	unsigned int IR_in_full_en    : BFW_NX50_spi_interrupt_control_register_IR_in_full_en;    /* IRQ enable for irq_spi(2)  (equals adr_spi_imsc.txfim in netx50 and later versions)  */
	unsigned int IR_out_fuel_en   : BFW_NX50_spi_interrupt_control_register_IR_out_fuel_en;   /* IRQ enable for irq_spi(3)  (equals adr_spi_imsc.TXIM in netx50 and later versions)   */
	unsigned int IR_out_fw_en     : BFW_NX50_spi_interrupt_control_register_IR_out_fw_en;     /* IRQ enable for irq_spi(4), netx100/netx500 only, always "0" in later versions        */
	unsigned int IR_out_empty_en  : BFW_NX50_spi_interrupt_control_register_IR_out_empty_en;  /* IRQ enable for irq_spi(5)  (equals adr_spi_imsc.rxeim in netx50 and later versions)  */
	unsigned int IR_out_full_en   : BFW_NX50_spi_interrupt_control_register_IR_out_full_en;   /* IRQ enable for irq_spi(6), netx100/netx500 only, always "0" in later versions        */
	unsigned int reserved1        : BFW_NX50_spi_interrupt_control_register_reserved1;        /* reserved                                                                             */
} NX50_SPI_INTERRUPT_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                              val;
	NX50_SPI_INTERRUPT_CONTROL_REGISTER_BIT_T bf;
} NX50_SPI_INTERRUPT_CONTROL_REGISTER_T;


/* ===================================================================== */

/* Area of i2c */

/* ===================================================================== */

#define Addr_NX50_i2c      0x1C000E00U
#define NX50_NETX_I2C_AREA 0x1C000E00U

/* --------------------------------------------------------------------- */
/* Register i2c_mcr */
/* => I2C master control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_mcr  0x00000000U
#define Adr_NX50_i2c_i2c_mcr  0x1C000E00U
#define Adr_NX50_i2c_mcr      0x1C000E00U
#define DFLT_VAL_NX50_i2c_mcr 0x00000000U

#define MSK_NX50_i2c_mcr_en_i2c      0x00000001U
#define SRT_NX50_i2c_mcr_en_i2c      0
#define DFLT_VAL_NX50_i2c_mcr_en_i2c 0x00000000U
#define MSK_NX50_i2c_mcr_mode        0x0000000eU
#define SRT_NX50_i2c_mcr_mode        1
#define DFLT_VAL_NX50_i2c_mcr_mode   0x00000000U
#define MSK_NX50_i2c_mcr_sadr        0x000007f0U
#define SRT_NX50_i2c_mcr_sadr        4
#define DFLT_VAL_NX50_i2c_mcr_sadr   0x00000000U

enum {
	BFW_NX50_i2c_mcr_en_i2c    = 1,  /* [0] */
	BFW_NX50_i2c_mcr_mode      = 3,  /* [3:1] */
	BFW_NX50_i2c_mcr_sadr      = 7,  /* [10:4] */
	BFW_NX50_i2c_mcr_reserved1 = 21  /* [31:11] */
};

typedef struct NX50_I2C_MCR_BIT_Ttag {
	unsigned int en_i2c    : BFW_NX50_i2c_mcr_en_i2c;    /* 1: enable I2C-controller, 0: disable I2C-controller,                                                                             */
	unsigned int mode      : BFW_NX50_i2c_mcr_mode;      /* I2C-speed-mode:                                                                                                                  */
	                                                     /* If this device is used only as slave, mode should be set to the maximum data rate generated by the fastest master on the I2C-bus */
	unsigned int sadr      : BFW_NX50_i2c_mcr_sadr;      /* 7-bit Slave address send after (r)START:                                                                                         */
	                                                     /* For 10-bit addressing, the first byte (10bit-start "11110", MSB[9:8] must be programmed here, second start                       */
	unsigned int reserved1 : BFW_NX50_i2c_mcr_reserved1; /* reserved                                                                                                                         */
} NX50_I2C_MCR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_I2C_MCR_BIT_T bf;
} NX50_I2C_MCR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_scr */
/* => I2C slave control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_scr  0x00000004U
#define Adr_NX50_i2c_i2c_scr  0x1C000E04U
#define Adr_NX50_i2c_scr      0x1C000E04U
#define DFLT_VAL_NX50_i2c_scr 0x00000000U

#define MSK_NX50_i2c_scr_sid           0x000003ffU
#define SRT_NX50_i2c_scr_sid           0
#define DFLT_VAL_NX50_i2c_scr_sid      0x00000000U
#define MSK_NX50_i2c_scr_sid10         0x00000400U
#define SRT_NX50_i2c_scr_sid10         10
#define DFLT_VAL_NX50_i2c_scr_sid10    0x00000000U
#define MSK_NX50_i2c_scr_ac_srx        0x00010000U
#define SRT_NX50_i2c_scr_ac_srx        16
#define DFLT_VAL_NX50_i2c_scr_ac_srx   0x00000000U
#define MSK_NX50_i2c_scr_ac_start      0x00020000U
#define SRT_NX50_i2c_scr_ac_start      17
#define DFLT_VAL_NX50_i2c_scr_ac_start 0x00000000U
#define MSK_NX50_i2c_scr_ac_gcall      0x00040000U
#define SRT_NX50_i2c_scr_ac_gcall      18
#define DFLT_VAL_NX50_i2c_scr_ac_gcall 0x00000000U

enum {
	BFW_NX50_i2c_scr_sid       = 10, /* [9:0] */
	BFW_NX50_i2c_scr_sid10     = 1,  /* [10] */
	BFW_NX50_i2c_scr_reserved1 = 5,  /* [15:11] */
	BFW_NX50_i2c_scr_ac_srx    = 1,  /* [16] */
	BFW_NX50_i2c_scr_ac_start  = 1,  /* [17] */
	BFW_NX50_i2c_scr_ac_gcall  = 1,  /* [18] */
	BFW_NX50_i2c_scr_reserved2 = 13  /* [31:19] */
};

typedef struct NX50_I2C_SCR_BIT_Ttag {
	unsigned int sid       : BFW_NX50_i2c_scr_sid;       /* Slave device ID:                                                                                            */
	                                                     /* External masters can address this device by this address.                                                   */
	unsigned int sid10     : BFW_NX50_i2c_scr_sid10;     /* 10-bit Slave device ID:                                                                                     */
	                                                     /*  0: listen for 7bit slave address after (r)START                                                            */
	unsigned int reserved1 : BFW_NX50_i2c_scr_reserved1; /* reserved                                                                                                    */
	unsigned int ac_srx    : BFW_NX50_i2c_scr_ac_srx;    /* Enable slave-receive-data acknowledge:                                                                      */
	                                                     /*  0: do not generate acknowledge on receive bytes.                                                           */
	unsigned int ac_start  : BFW_NX50_i2c_scr_ac_start;  /* Enable start sequence acknowledge:                                                                          */
	                                                     /* The start byte (2 bytes if sid10 is set) will be acknowledged if the received address matches the sid-bits. */
	unsigned int ac_gcall  : BFW_NX50_i2c_scr_ac_gcall;  /* General Call acknowledge:                                                                                   */
	                                                     /*  0: do not generate acknowledge after General Call                                                          */
	unsigned int reserved2 : BFW_NX50_i2c_scr_reserved2; /* reserved                                                                                                    */
} NX50_I2C_SCR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_I2C_SCR_BIT_T bf;
} NX50_I2C_SCR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_cmd */
/* => I2C master command register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_cmd  0x00000008U
#define Adr_NX50_i2c_i2c_cmd  0x1C000E08U
#define Adr_NX50_i2c_cmd      0x1C000E08U
#define DFLT_VAL_NX50_i2c_cmd 0x0000000eU

#define MSK_NX50_i2c_cmd_nwr            0x00000001U
#define SRT_NX50_i2c_cmd_nwr            0
#define DFLT_VAL_NX50_i2c_cmd_nwr       0x00000000U
#define MSK_NX50_i2c_cmd_cmd            0x0000000eU
#define SRT_NX50_i2c_cmd_cmd            1
#define DFLT_VAL_NX50_i2c_cmd_cmd       0x0000000eU
#define MSK_NX50_i2c_cmd_tsize          0x0003ff00U
#define SRT_NX50_i2c_cmd_tsize          8
#define DFLT_VAL_NX50_i2c_cmd_tsize     0x00000000U
#define MSK_NX50_i2c_cmd_acpollmax      0x0ff00000U
#define SRT_NX50_i2c_cmd_acpollmax      20
#define DFLT_VAL_NX50_i2c_cmd_acpollmax 0x00000000U

enum {
	BFW_NX50_i2c_cmd_nwr       = 1,  /* [0] */
	BFW_NX50_i2c_cmd_cmd       = 3,  /* [3:1] */
	BFW_NX50_i2c_cmd_reserved1 = 4,  /* [7:4] */
	BFW_NX50_i2c_cmd_tsize     = 10, /* [17:8] */
	BFW_NX50_i2c_cmd_reserved2 = 2,  /* [19:18] */
	BFW_NX50_i2c_cmd_acpollmax = 8,  /* [27:20] */
	BFW_NX50_i2c_cmd_reserved3 = 4   /* [31:28] */
};

typedef struct NX50_I2C_CMD_BIT_Ttag {
	unsigned int nwr       : BFW_NX50_i2c_cmd_nwr;       /* Transfer direction:                                                                                                              */
	                                                     /*  0: cmd will be done as write.                                                                                                   */
	unsigned int cmd       : BFW_NX50_i2c_cmd_cmd;       /* I2C sequence command:                                                                                                            */
	                                                     /* All commands will either generate the cmd_ok IRQ or the cmd_err IRQ. Successful command termination will always generate         */
	unsigned int reserved1 : BFW_NX50_i2c_cmd_reserved1; /* reserved                                                                                                                         */
	unsigned int tsize     : BFW_NX50_i2c_cmd_tsize;     /* Transfer tsize+1 bytes (1...1024):                                                                                               */
	                                                     /* If no acknowledge was generated by slave (receiver), write transfers will be terminated and the cmd_err IRQ will be generated.   */
	unsigned int reserved2 : BFW_NX50_i2c_cmd_reserved2; /* reserved                                                                                                                         */
	unsigned int acpollmax : BFW_NX50_i2c_cmd_acpollmax; /* acpollmax+1 (1...256) tries for start sequence acknowledge polling:                                                              */
	                                                     /* For 7-bit addressed acknowledge polling START and the first byte containing the slave address (i2c_mcr.sadr) will be repeated up */
	unsigned int reserved3 : BFW_NX50_i2c_cmd_reserved3; /* reserved                                                                                                                         */
} NX50_I2C_CMD_BIT_T;

typedef union {
	unsigned int       val;
	NX50_I2C_CMD_BIT_T bf;
} NX50_I2C_CMD_T;

/* --------------------------------------------------------------------- */
/* Register i2c_mdr */
/* => I2C master data register (master FIFO) */
/*    There is only one FIFO for both, receive and transmit master data with a depth of 16 bytes. For master write access, data send by the master */
/*    is delivered from the FIFO, for master read access data received by the master is stored in the FIFO. */
/*    In case of imminent data transfer failure (read transfer and FIFO is full or write transfer and FIFO is empty), the cmd_err IRQ will be set after the last */
/*    byte that could be transmitted. No FIFO-underrun or overflow will occur. i2c_cmd.tsize+1 will show amount of not transmitted data. */
/*    In case of master write transfer direction, either the FIFO can be filled and the transfer may be completed (CTC, CT) or the transfer can be broken (rSTART, STOP). */
/*    In case of master read transfer direction, the command will terminate when the FIFO is full. The last read byte will be acknowledged and */
/*    stored in the FIFO. After reading out data from the FIFO the transfer must be completed (CTC, CT) to flag read data end (no acknowledge at last byte). STOP or rSTART */
/*    will fail if next read data MSB is 0 (as the next bit already driven by the slave is 0). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_mdr  0x0000000CU
#define Adr_NX50_i2c_i2c_mdr  0x1C000E0CU
#define Adr_NX50_i2c_mdr      0x1C000E0CU
#define DFLT_VAL_NX50_i2c_mdr 0x00000000U

#define MSK_NX50_i2c_mdr_mdata      0x000000ffU
#define SRT_NX50_i2c_mdr_mdata      0
#define DFLT_VAL_NX50_i2c_mdr_mdata 0x00000000U

enum {
	BFW_NX50_i2c_mdr_mdata     = 8,  /* [7:0] */
	BFW_NX50_i2c_mdr_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_I2C_MDR_BIT_Ttag {
	unsigned int mdata     : BFW_NX50_i2c_mdr_mdata;     /* I2C master transmit or receive data:                                                                                     */
	                                                     /* Write data will be removed from the FIFO after receiving slave has generated the according acknowledge. Not acknowledged */
	unsigned int reserved1 : BFW_NX50_i2c_mdr_reserved1; /* reserved                                                                                                                 */
} NX50_I2C_MDR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_I2C_MDR_BIT_T bf;
} NX50_I2C_MDR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_sdr */
/* => I2C slave data register (slave FIFO) */
/*    There is only one FIFO for both, receive and transmit slave data with a depth of 16 bytes. For master read access, data send by the slave */
/*    is delivered from the FIFO, for master write access data received by the slave is stored in the FIFO. */
/*    A transfer is initiated after detection of I2C-start-sequence to the device address (i2c_scr.sid, sreq IRQ) which is acknowledged by this device (i2c_scr.ac_start). For read */
/*    transfers send data is read from the FIFO immediately after acknowledge was detected on the I2C-bus. SDA will be driven with next data MSB immediately after acknowledge SCL high phase. */
/*    In case of master read transfer and slave FIFO underrun, corrupted data will be send to the master and the fifo_err IRQ will be set. */
/*    In case of master write transfer and slave FIFO is full, no acknowledge will be generated for the last received byte. No FIFO overflow will occur but */
/*    the last transferred byte (not acknowledged) will be lost and has to be send again by the master. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_sdr  0x00000010U
#define Adr_NX50_i2c_i2c_sdr  0x1C000E10U
#define Adr_NX50_i2c_sdr      0x1C000E10U
#define DFLT_VAL_NX50_i2c_sdr 0x00000000U

#define MSK_NX50_i2c_sdr_sdata      0x000000ffU
#define SRT_NX50_i2c_sdr_sdata      0
#define DFLT_VAL_NX50_i2c_sdr_sdata 0x00000000U

enum {
	BFW_NX50_i2c_sdr_sdata     = 8,  /* [7:0] */
	BFW_NX50_i2c_sdr_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_I2C_SDR_BIT_Ttag {
	unsigned int sdata     : BFW_NX50_i2c_sdr_sdata;     /* I2C slave transmit or receive data:                                                         */
	                                                     /* i2c_scr.ac_start must be handled correctly by software to avoid FIFO errors after (r)START. */
	unsigned int reserved1 : BFW_NX50_i2c_sdr_reserved1; /* reserved                                                                                    */
} NX50_I2C_SDR_BIT_T;

typedef union {
	unsigned int       val;
	NX50_I2C_SDR_BIT_T bf;
} NX50_I2C_SDR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_mfifo_cr */
/* => I2C master FIFO control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_mfifo_cr  0x00000014U
#define Adr_NX50_i2c_i2c_mfifo_cr  0x1C000E14U
#define Adr_NX50_i2c_mfifo_cr      0x1C000E14U
#define DFLT_VAL_NX50_i2c_mfifo_cr 0x00000000U

#define MSK_NX50_i2c_mfifo_cr_mfifo_wm       0x0000000fU
#define SRT_NX50_i2c_mfifo_cr_mfifo_wm       0
#define DFLT_VAL_NX50_i2c_mfifo_cr_mfifo_wm  0x00000000U
#define MSK_NX50_i2c_mfifo_cr_mfifo_clr      0x00000100U
#define SRT_NX50_i2c_mfifo_cr_mfifo_clr      8
#define DFLT_VAL_NX50_i2c_mfifo_cr_mfifo_clr 0x00000000U

enum {
	BFW_NX50_i2c_mfifo_cr_mfifo_wm  = 4,  /* [3:0] */
	BFW_NX50_i2c_mfifo_cr_reserved1 = 4,  /* [7:4] */
	BFW_NX50_i2c_mfifo_cr_mfifo_clr = 1,  /* [8] */
	BFW_NX50_i2c_mfifo_cr_reserved2 = 23  /* [31:9] */
};

typedef struct NX50_I2C_MFIFO_CR_BIT_Ttag {
	unsigned int mfifo_wm  : BFW_NX50_i2c_mfifo_cr_mfifo_wm;  /* Master FIFO watermark for mfifo_req IRQ generation:                                                        */
	                                                          /* If master is transmitter (enabled and nwr==0-command), mfifo_req IRQ is generated if mfifo_level<mfifo_wm. */
	unsigned int reserved1 : BFW_NX50_i2c_mfifo_cr_reserved1; /* reserved                                                                                                   */
	unsigned int mfifo_clr : BFW_NX50_i2c_mfifo_cr_mfifo_clr; /* Clear master data FIFO, write only bit.                                                                    */
	unsigned int reserved2 : BFW_NX50_i2c_mfifo_cr_reserved2; /* reserved                                                                                                   */
} NX50_I2C_MFIFO_CR_BIT_T;

typedef union {
	unsigned int            val;
	NX50_I2C_MFIFO_CR_BIT_T bf;
} NX50_I2C_MFIFO_CR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_sfifo_cr */
/* => I2C slave FIFO control register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_sfifo_cr  0x00000018U
#define Adr_NX50_i2c_i2c_sfifo_cr  0x1C000E18U
#define Adr_NX50_i2c_sfifo_cr      0x1C000E18U
#define DFLT_VAL_NX50_i2c_sfifo_cr 0x00000000U

#define MSK_NX50_i2c_sfifo_cr_sfifo_wm       0x0000000fU
#define SRT_NX50_i2c_sfifo_cr_sfifo_wm       0
#define DFLT_VAL_NX50_i2c_sfifo_cr_sfifo_wm  0x00000000U
#define MSK_NX50_i2c_sfifo_cr_sfifo_clr      0x00000100U
#define SRT_NX50_i2c_sfifo_cr_sfifo_clr      8
#define DFLT_VAL_NX50_i2c_sfifo_cr_sfifo_clr 0x00000000U

enum {
	BFW_NX50_i2c_sfifo_cr_sfifo_wm  = 4,  /* [3:0] */
	BFW_NX50_i2c_sfifo_cr_reserved1 = 4,  /* [7:4] */
	BFW_NX50_i2c_sfifo_cr_sfifo_clr = 1,  /* [8] */
	BFW_NX50_i2c_sfifo_cr_reserved2 = 23  /* [31:9] */
};

typedef struct NX50_I2C_SFIFO_CR_BIT_Ttag {
	unsigned int sfifo_wm  : BFW_NX50_i2c_sfifo_cr_sfifo_wm;  /* Slave FIFO Watermark for sfifo_req IRQ generation:                                                                                             */
	                                                          /* If slave is transmitter (start sequence with set read bit was acknowledged by this slave), sfifo_req IRQ is generated if sfifo_level<sfifo_wm. */
	unsigned int reserved1 : BFW_NX50_i2c_sfifo_cr_reserved1; /* reserved                                                                                                                                       */
	unsigned int sfifo_clr : BFW_NX50_i2c_sfifo_cr_sfifo_clr; /* Clear slave data FIFO, write only bit.                                                                                                         */
	unsigned int reserved2 : BFW_NX50_i2c_sfifo_cr_reserved2; /* reserved                                                                                                                                       */
} NX50_I2C_SFIFO_CR_BIT_T;

typedef union {
	unsigned int            val;
	NX50_I2C_SFIFO_CR_BIT_T bf;
} NX50_I2C_SFIFO_CR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_sr */
/* => read only I2C status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_sr 0x0000001CU
#define Adr_NX50_i2c_i2c_sr 0x1C000E1CU
#define Adr_NX50_i2c_sr     0x1C000E1CU

#define MSK_NX50_i2c_sr_mfifo_level    0x0000001fU
#define SRT_NX50_i2c_sr_mfifo_level    0
#define MSK_NX50_i2c_sr_mfifo_empty    0x00000040U
#define SRT_NX50_i2c_sr_mfifo_empty    6
#define MSK_NX50_i2c_sr_mfifo_full     0x00000080U
#define SRT_NX50_i2c_sr_mfifo_full     7
#define MSK_NX50_i2c_sr_mfifo_err_ovfl 0x00000100U
#define SRT_NX50_i2c_sr_mfifo_err_ovfl 8
#define MSK_NX50_i2c_sr_mfifo_err_undr 0x00000200U
#define SRT_NX50_i2c_sr_mfifo_err_undr 9
#define MSK_NX50_i2c_sr_sfifo_level    0x00007c00U
#define SRT_NX50_i2c_sr_sfifo_level    10
#define MSK_NX50_i2c_sr_sfifo_empty    0x00010000U
#define SRT_NX50_i2c_sr_sfifo_empty    16
#define MSK_NX50_i2c_sr_sfifo_full     0x00020000U
#define SRT_NX50_i2c_sr_sfifo_full     17
#define MSK_NX50_i2c_sr_sfifo_err_ovfl 0x00040000U
#define SRT_NX50_i2c_sr_sfifo_err_ovfl 18
#define MSK_NX50_i2c_sr_sfifo_err_undr 0x00080000U
#define SRT_NX50_i2c_sr_sfifo_err_undr 19
#define MSK_NX50_i2c_sr_bus_master     0x00100000U
#define SRT_NX50_i2c_sr_bus_master     20
#define MSK_NX50_i2c_sr_nwr            0x00200000U
#define SRT_NX50_i2c_sr_nwr            21
#define MSK_NX50_i2c_sr_started        0x00400000U
#define SRT_NX50_i2c_sr_started        22
#define MSK_NX50_i2c_sr_slave_access   0x00800000U
#define SRT_NX50_i2c_sr_slave_access   23
#define MSK_NX50_i2c_sr_last_ac        0x01000000U
#define SRT_NX50_i2c_sr_last_ac        24
#define MSK_NX50_i2c_sr_nwr_aced       0x02000000U
#define SRT_NX50_i2c_sr_nwr_aced       25
#define MSK_NX50_i2c_sr_gcall_aced     0x04000000U
#define SRT_NX50_i2c_sr_gcall_aced     26
#define MSK_NX50_i2c_sr_sid10_aced     0x08000000U
#define SRT_NX50_i2c_sr_sid10_aced     27
#define MSK_NX50_i2c_sr_scl_state      0x40000000U
#define SRT_NX50_i2c_sr_scl_state      30
#define MSK_NX50_i2c_sr_sda_state      0x80000000U
#define SRT_NX50_i2c_sr_sda_state      31

enum {
	BFW_NX50_i2c_sr_mfifo_level    = 5, /* [4:0] */
	BFW_NX50_i2c_sr_reserved1      = 1, /* [5] */
	BFW_NX50_i2c_sr_mfifo_empty    = 1, /* [6] */
	BFW_NX50_i2c_sr_mfifo_full     = 1, /* [7] */
	BFW_NX50_i2c_sr_mfifo_err_ovfl = 1, /* [8] */
	BFW_NX50_i2c_sr_mfifo_err_undr = 1, /* [9] */
	BFW_NX50_i2c_sr_sfifo_level    = 5, /* [14:10] */
	BFW_NX50_i2c_sr_reserved2      = 1, /* [15] */
	BFW_NX50_i2c_sr_sfifo_empty    = 1, /* [16] */
	BFW_NX50_i2c_sr_sfifo_full     = 1, /* [17] */
	BFW_NX50_i2c_sr_sfifo_err_ovfl = 1, /* [18] */
	BFW_NX50_i2c_sr_sfifo_err_undr = 1, /* [19] */
	BFW_NX50_i2c_sr_bus_master     = 1, /* [20] */
	BFW_NX50_i2c_sr_nwr            = 1, /* [21] */
	BFW_NX50_i2c_sr_started        = 1, /* [22] */
	BFW_NX50_i2c_sr_slave_access   = 1, /* [23] */
	BFW_NX50_i2c_sr_last_ac        = 1, /* [24] */
	BFW_NX50_i2c_sr_nwr_aced       = 1, /* [25] */
	BFW_NX50_i2c_sr_gcall_aced     = 1, /* [26] */
	BFW_NX50_i2c_sr_sid10_aced     = 1, /* [27] */
	BFW_NX50_i2c_sr_reserved3      = 2, /* [29:28] */
	BFW_NX50_i2c_sr_scl_state      = 1, /* [30] */
	BFW_NX50_i2c_sr_sda_state      = 1  /* [31] */
};

typedef struct NX50_I2C_SR_BIT_Ttag {
	unsigned int mfifo_level    : BFW_NX50_i2c_sr_mfifo_level;    /* master FIFO level  (0..16)                                                                                                */
	unsigned int reserved1      : BFW_NX50_i2c_sr_reserved1;      /* reserved                                                                                                                  */
	unsigned int mfifo_empty    : BFW_NX50_i2c_sr_mfifo_empty;    /* master FIFO is empty (1 if empty)                                                                                         */
	unsigned int mfifo_full     : BFW_NX50_i2c_sr_mfifo_full;     /* master FIFO is full (1 if full)                                                                                           */
	unsigned int mfifo_err_ovfl : BFW_NX50_i2c_sr_mfifo_err_ovfl; /* master FIFO overflow error occurred, data is lost                                                                         */
	unsigned int mfifo_err_undr : BFW_NX50_i2c_sr_mfifo_err_undr; /* master FIFO underrun error occurred, data is lost                                                                         */
	unsigned int sfifo_level    : BFW_NX50_i2c_sr_sfifo_level;    /* slave FIFO level (0..16)                                                                                                  */
	unsigned int reserved2      : BFW_NX50_i2c_sr_reserved2;      /* reserved                                                                                                                  */
	unsigned int sfifo_empty    : BFW_NX50_i2c_sr_sfifo_empty;    /* slave FIFO is empty (1 if empty)                                                                                          */
	unsigned int sfifo_full     : BFW_NX50_i2c_sr_sfifo_full;     /* slave FIFO is full (1 if full)                                                                                            */
	unsigned int sfifo_err_ovfl : BFW_NX50_i2c_sr_sfifo_err_ovfl; /* slave FIFO overflow error occurred, data is lost                                                                          */
	unsigned int sfifo_err_undr : BFW_NX50_i2c_sr_sfifo_err_undr; /* slave FIFO underrun error occurred, data is lost                                                                          */
	unsigned int bus_master     : BFW_NX50_i2c_sr_bus_master;     /* 1: master gains bus arbitration or bus is idle, 0: master lost bus arbitration, bus is busy by another master             */
	unsigned int nwr            : BFW_NX50_i2c_sr_nwr;            /* Transfer direction detected after last (s)START.                                                                          */
	                                                              /* 0: write; 1: read.                                                                                                        */
	unsigned int started        : BFW_NX50_i2c_sr_started;        /* START condition detection:                                                                                                */
	                                                              /* This detection is also done, if this device is not enabled to get current bus state after enable.                         */
	unsigned int slave_access   : BFW_NX50_i2c_sr_slave_access;   /* 0: No slave access on this device (reset at START or STOP).                                                               */
	                                                              /* 1: A master addressed this slave device (set if start-byte with address matching this slave).                             */
	unsigned int last_ac        : BFW_NX50_i2c_sr_last_ac;        /* Last acknowledge detected on bus:                                                                                         */
	                                                              /* 0: SDA was high i.e no acknowledge.                                                                                       */
	unsigned int nwr_aced       : BFW_NX50_i2c_sr_nwr_aced;       /* Last transfer direction (nwr-bit during start-byte with address matching this slave) acknowledged by this slave to handle */
	                                                              /* slave FIFO (0: write; 1: read). Slave FIFO-requests (IRQ and DMA) are generated depending this direction flag             */
	unsigned int gcall_aced     : BFW_NX50_i2c_sr_gcall_aced;     /* Received General Call was acknowledged (General Call was done and i2c_scr.ac_gcall is set).                               */
	                                                              /* 0: SDA was high i.e no acknowledge.                                                                                       */
	unsigned int sid10_aced     : BFW_NX50_i2c_sr_sid10_aced;     /* Master detected that a 10-bit addressed slave acknowledge the 2-byte start sequence. Master will generate                 */
	                                                              /* only first START-byte during rSTART.                                                                                      */
	unsigned int reserved3      : BFW_NX50_i2c_sr_reserved3;      /* reserved                                                                                                                  */
	unsigned int scl_state      : BFW_NX50_i2c_sr_scl_state;      /* SCL signal state sampled and filtered from bus (e.g. to detect bus blockings)                                             */
	unsigned int sda_state      : BFW_NX50_i2c_sr_sda_state;      /* SDA signal state sampled and filtered from bus (e.g. to detect bus blockings)                                             */
} NX50_I2C_SR_BIT_T;

typedef union {
	unsigned int      val;
	NX50_I2C_SR_BIT_T bf;
} NX50_I2C_SR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_irqmsk */
/* => I2C interrupt mask set or clear register */
/*    These bits have AND-mask character (only if mask bit is set, the appropriate IRQ generates the module IRQ). Enabling (writing '1' and */
/*    prior mask was "0") will clear according raw IRQ-state if it was set before. */
/*    For detailed IRQ-description view i2c_irqraw. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_irqmsk  0x00000020U
#define Adr_NX50_i2c_i2c_irqmsk  0x1C000E20U
#define Adr_NX50_i2c_irqmsk      0x1C000E20U
#define DFLT_VAL_NX50_i2c_irqmsk 0x00000000U

#define MSK_NX50_i2c_irqmsk_cmd_ok         0x00000001U
#define SRT_NX50_i2c_irqmsk_cmd_ok         0
#define DFLT_VAL_NX50_i2c_irqmsk_cmd_ok    0x00000000U
#define MSK_NX50_i2c_irqmsk_cmd_err        0x00000002U
#define SRT_NX50_i2c_irqmsk_cmd_err        1
#define DFLT_VAL_NX50_i2c_irqmsk_cmd_err   0x00000000U
#define MSK_NX50_i2c_irqmsk_fifo_err       0x00000004U
#define SRT_NX50_i2c_irqmsk_fifo_err       2
#define DFLT_VAL_NX50_i2c_irqmsk_fifo_err  0x00000000U
#define MSK_NX50_i2c_irqmsk_bus_busy       0x00000008U
#define SRT_NX50_i2c_irqmsk_bus_busy       3
#define DFLT_VAL_NX50_i2c_irqmsk_bus_busy  0x00000000U
#define MSK_NX50_i2c_irqmsk_mfifo_req      0x00000010U
#define SRT_NX50_i2c_irqmsk_mfifo_req      4
#define DFLT_VAL_NX50_i2c_irqmsk_mfifo_req 0x00000000U
#define MSK_NX50_i2c_irqmsk_sfifo_req      0x00000020U
#define SRT_NX50_i2c_irqmsk_sfifo_req      5
#define DFLT_VAL_NX50_i2c_irqmsk_sfifo_req 0x00000000U
#define MSK_NX50_i2c_irqmsk_sreq           0x00000040U
#define SRT_NX50_i2c_irqmsk_sreq           6
#define DFLT_VAL_NX50_i2c_irqmsk_sreq      0x00000000U

enum {
	BFW_NX50_i2c_irqmsk_cmd_ok    = 1,  /* [0] */
	BFW_NX50_i2c_irqmsk_cmd_err   = 1,  /* [1] */
	BFW_NX50_i2c_irqmsk_fifo_err  = 1,  /* [2] */
	BFW_NX50_i2c_irqmsk_bus_busy  = 1,  /* [3] */
	BFW_NX50_i2c_irqmsk_mfifo_req = 1,  /* [4] */
	BFW_NX50_i2c_irqmsk_sfifo_req = 1,  /* [5] */
	BFW_NX50_i2c_irqmsk_sreq      = 1,  /* [6] */
	BFW_NX50_i2c_irqmsk_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_I2C_IRQMSK_BIT_Ttag {
	unsigned int cmd_ok    : BFW_NX50_i2c_irqmsk_cmd_ok;    /* Command OK interrupt mask.                 */
	unsigned int cmd_err   : BFW_NX50_i2c_irqmsk_cmd_err;   /* Command error interrupt mask.              */
	unsigned int fifo_err  : BFW_NX50_i2c_irqmsk_fifo_err;  /* FIFO error interrupt mask.                 */
	unsigned int bus_busy  : BFW_NX50_i2c_irqmsk_bus_busy;  /* External I2C-bus is busy interrupt mask.   */
	unsigned int mfifo_req : BFW_NX50_i2c_irqmsk_mfifo_req; /* Master FIFO action request interrupt mask. */
	unsigned int sfifo_req : BFW_NX50_i2c_irqmsk_sfifo_req; /* Slave FIFO action request interrupt mask.  */
	unsigned int sreq      : BFW_NX50_i2c_irqmsk_sreq;      /* Slave request interrupt mask.              */
	unsigned int reserved1 : BFW_NX50_i2c_irqmsk_reserved1; /* reserved                                   */
} NX50_I2C_IRQMSK_BIT_T;

typedef union {
	unsigned int          val;
	NX50_I2C_IRQMSK_BIT_T bf;
} NX50_I2C_IRQMSK_T;

/* --------------------------------------------------------------------- */
/* Register i2c_irqsr */
/* => I2C interrupt state register (raw interrupt before masking) */
/*    Writing '1' will clear according IRQ. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_irqsr  0x00000024U
#define Adr_NX50_i2c_i2c_irqsr  0x1C000E24U
#define Adr_NX50_i2c_irqsr      0x1C000E24U
#define DFLT_VAL_NX50_i2c_irqsr 0x00000000U

#define MSK_NX50_i2c_irqsr_cmd_ok         0x00000001U
#define SRT_NX50_i2c_irqsr_cmd_ok         0
#define DFLT_VAL_NX50_i2c_irqsr_cmd_ok    0x00000000U
#define MSK_NX50_i2c_irqsr_cmd_err        0x00000002U
#define SRT_NX50_i2c_irqsr_cmd_err        1
#define DFLT_VAL_NX50_i2c_irqsr_cmd_err   0x00000000U
#define MSK_NX50_i2c_irqsr_fifo_err       0x00000004U
#define SRT_NX50_i2c_irqsr_fifo_err       2
#define DFLT_VAL_NX50_i2c_irqsr_fifo_err  0x00000000U
#define MSK_NX50_i2c_irqsr_bus_busy       0x00000008U
#define SRT_NX50_i2c_irqsr_bus_busy       3
#define DFLT_VAL_NX50_i2c_irqsr_bus_busy  0x00000000U
#define MSK_NX50_i2c_irqsr_mfifo_req      0x00000010U
#define SRT_NX50_i2c_irqsr_mfifo_req      4
#define DFLT_VAL_NX50_i2c_irqsr_mfifo_req 0x00000000U
#define MSK_NX50_i2c_irqsr_sfifo_req      0x00000020U
#define SRT_NX50_i2c_irqsr_sfifo_req      5
#define DFLT_VAL_NX50_i2c_irqsr_sfifo_req 0x00000000U
#define MSK_NX50_i2c_irqsr_sreq           0x00000040U
#define SRT_NX50_i2c_irqsr_sreq           6
#define DFLT_VAL_NX50_i2c_irqsr_sreq      0x00000000U

enum {
	BFW_NX50_i2c_irqsr_cmd_ok    = 1,  /* [0] */
	BFW_NX50_i2c_irqsr_cmd_err   = 1,  /* [1] */
	BFW_NX50_i2c_irqsr_fifo_err  = 1,  /* [2] */
	BFW_NX50_i2c_irqsr_bus_busy  = 1,  /* [3] */
	BFW_NX50_i2c_irqsr_mfifo_req = 1,  /* [4] */
	BFW_NX50_i2c_irqsr_sfifo_req = 1,  /* [5] */
	BFW_NX50_i2c_irqsr_sreq      = 1,  /* [6] */
	BFW_NX50_i2c_irqsr_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_I2C_IRQSR_BIT_Ttag {
	unsigned int cmd_ok    : BFW_NX50_i2c_irqsr_cmd_ok;    /* Unmasked command OK interrupt state:                 */
	                                                       /* Purpose: check last command termination.             */
	unsigned int cmd_err   : BFW_NX50_i2c_irqsr_cmd_err;   /* Unmasked command error interrupt state:              */
	                                                       /* Purpose: check last command termination.             */
	unsigned int fifo_err  : BFW_NX50_i2c_irqsr_fifo_err;  /* Unmasked FIFO error interrupt state:                 */
	                                                       /* Purpose: detect FIFO errors/transfer failures.       */
	unsigned int bus_busy  : BFW_NX50_i2c_irqsr_bus_busy;  /* Unmasked external I2C-bus is busy interrupt state:   */
	                                                       /* Purpose: detect I2C-bus arbitration loss.            */
	unsigned int mfifo_req : BFW_NX50_i2c_irqsr_mfifo_req; /* Unmasked master FIFO action request interrupt state: */
	                                                       /* Purpose: master FIFO should be updated.              */
	unsigned int sfifo_req : BFW_NX50_i2c_irqsr_sfifo_req; /* Unmasked slave FIFO action request interrupt state:  */
	                                                       /* Purpose: slave FIFO should be updated.               */
	unsigned int sreq      : BFW_NX50_i2c_irqsr_sreq;      /* Unmasked slave request interrupt state:              */
	                                                       /* Purpose: set up slave FIFO.                          */
	unsigned int reserved1 : BFW_NX50_i2c_irqsr_reserved1; /* reserved                                             */
} NX50_I2C_IRQSR_BIT_T;

typedef union {
	unsigned int         val;
	NX50_I2C_IRQSR_BIT_T bf;
} NX50_I2C_IRQSR_T;

/* --------------------------------------------------------------------- */
/* Register i2c_irqmsked */
/* => read only I2C masked interrupt state register */
/*    If one of these bits is set, the I2C IRQ will be asserted to the Interrupt-Controller. */
/*    For detailed IRQ-description view i2c_irqraw. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_irqmsked 0x00000028U
#define Adr_NX50_i2c_i2c_irqmsked 0x1C000E28U
#define Adr_NX50_i2c_irqmsked     0x1C000E28U

#define MSK_NX50_i2c_irqmsked_cmd_ok    0x00000001U
#define SRT_NX50_i2c_irqmsked_cmd_ok    0
#define MSK_NX50_i2c_irqmsked_cmd_err   0x00000002U
#define SRT_NX50_i2c_irqmsked_cmd_err   1
#define MSK_NX50_i2c_irqmsked_fifo_err  0x00000004U
#define SRT_NX50_i2c_irqmsked_fifo_err  2
#define MSK_NX50_i2c_irqmsked_bus_busy  0x00000008U
#define SRT_NX50_i2c_irqmsked_bus_busy  3
#define MSK_NX50_i2c_irqmsked_mfifo_req 0x00000010U
#define SRT_NX50_i2c_irqmsked_mfifo_req 4
#define MSK_NX50_i2c_irqmsked_sfifo_req 0x00000020U
#define SRT_NX50_i2c_irqmsked_sfifo_req 5
#define MSK_NX50_i2c_irqmsked_sreq      0x00000040U
#define SRT_NX50_i2c_irqmsked_sreq      6

enum {
	BFW_NX50_i2c_irqmsked_cmd_ok    = 1,  /* [0] */
	BFW_NX50_i2c_irqmsked_cmd_err   = 1,  /* [1] */
	BFW_NX50_i2c_irqmsked_fifo_err  = 1,  /* [2] */
	BFW_NX50_i2c_irqmsked_bus_busy  = 1,  /* [3] */
	BFW_NX50_i2c_irqmsked_mfifo_req = 1,  /* [4] */
	BFW_NX50_i2c_irqmsked_sfifo_req = 1,  /* [5] */
	BFW_NX50_i2c_irqmsked_sreq      = 1,  /* [6] */
	BFW_NX50_i2c_irqmsked_reserved1 = 25  /* [31:7] */
};

typedef struct NX50_I2C_IRQMSKED_BIT_Ttag {
	unsigned int cmd_ok    : BFW_NX50_i2c_irqmsked_cmd_ok;    /* Masked command OK interrupt state.                 */
	unsigned int cmd_err   : BFW_NX50_i2c_irqmsked_cmd_err;   /* Masked command error interrupt state.              */
	unsigned int fifo_err  : BFW_NX50_i2c_irqmsked_fifo_err;  /* Masked FIFO error interrupt state.                 */
	unsigned int bus_busy  : BFW_NX50_i2c_irqmsked_bus_busy;  /* Masked external I2C-bus is busy interrupt state.   */
	unsigned int mfifo_req : BFW_NX50_i2c_irqmsked_mfifo_req; /* Masked master FIFO action request interrupt state. */
	unsigned int sfifo_req : BFW_NX50_i2c_irqmsked_sfifo_req; /* Masked slave FIFO action request interrupt state.  */
	unsigned int sreq      : BFW_NX50_i2c_irqmsked_sreq;      /* Masked slave request interrupt state.              */
	unsigned int reserved1 : BFW_NX50_i2c_irqmsked_reserved1; /* reserved                                           */
} NX50_I2C_IRQMSKED_BIT_T;

typedef union {
	unsigned int            val;
	NX50_I2C_IRQMSKED_BIT_T bf;
} NX50_I2C_IRQMSKED_T;

/* --------------------------------------------------------------------- */
/* Register i2c_dmacr */
/* => I2C DMA control register */
/*    DMA transfer size to/from I2C-module: byte. */
/*    DMA burst length to/from I2C-module: 4. */
/*    DMA burst requests are generated if the according FIFO contains more than 4 bytes (receive case), or if */
/*    there are more than 4 bytes writable to the according FIFO (transmit case). */
/*    DMA single transfer requests are generated if the according FIFO contains more than 1 byte (receive case), or if */
/*    there is more than 1 byte writable to the according FIFO (transmit case). */
/*    No further DMA requests will be generated if all transmit data was written to the master FIFO and flowcontrolling */
/*    is done by this module (for master data only). Once all data is written */
/*    to the master FIFO last burst/single request is generated for the DMA controller. */
/*    If the DMA-Controller flags transfer end by setting DMACTC (terminal count) the appropriate bit will be cleared. */
/*    If one of the bits of this register is set to 0 by software and a dma-transfer was requested before, one last */
/*    transfer will be done by the DMA-Controller to reset DMA-request signals. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_i2c_dmacr  0x0000002CU
#define Adr_NX50_i2c_i2c_dmacr  0x1C000E2CU
#define Adr_NX50_i2c_dmacr      0x1C000E2CU
#define DFLT_VAL_NX50_i2c_dmacr 0x00000000U

#define MSK_NX50_i2c_dmacr_mdmas_en      0x00000001U
#define SRT_NX50_i2c_dmacr_mdmas_en      0
#define DFLT_VAL_NX50_i2c_dmacr_mdmas_en 0x00000000U
#define MSK_NX50_i2c_dmacr_mdmab_en      0x00000002U
#define SRT_NX50_i2c_dmacr_mdmab_en      1
#define DFLT_VAL_NX50_i2c_dmacr_mdmab_en 0x00000000U
#define MSK_NX50_i2c_dmacr_sdmas_en      0x00000004U
#define SRT_NX50_i2c_dmacr_sdmas_en      2
#define DFLT_VAL_NX50_i2c_dmacr_sdmas_en 0x00000000U
#define MSK_NX50_i2c_dmacr_sdmab_en      0x00000008U
#define SRT_NX50_i2c_dmacr_sdmab_en      3
#define DFLT_VAL_NX50_i2c_dmacr_sdmab_en 0x00000000U

enum {
	BFW_NX50_i2c_dmacr_mdmas_en  = 1,  /* [0] */
	BFW_NX50_i2c_dmacr_mdmab_en  = 1,  /* [1] */
	BFW_NX50_i2c_dmacr_sdmas_en  = 1,  /* [2] */
	BFW_NX50_i2c_dmacr_sdmab_en  = 1,  /* [3] */
	BFW_NX50_i2c_dmacr_reserved1 = 28  /* [31:4] */
};

typedef struct NX50_I2C_DMACR_BIT_Ttag {
	unsigned int mdmas_en  : BFW_NX50_i2c_dmacr_mdmas_en;  /* Enable DMA single requests for I2C master data.                                                              */
	                                                       /* Flowcontrolling may be done my DMA-Controller or by I2C-controller controlled by decrementing i2c_cmd.tsize  */
	unsigned int mdmab_en  : BFW_NX50_i2c_dmacr_mdmab_en;  /* Enable DMA burst requests for I2C master data.                                                               */
	                                                       /* Flowcontrolling may be done my DMA-Controller or by I2C-controller controlled by decrementing i2c_cmd.tsize. */
	unsigned int sdmas_en  : BFW_NX50_i2c_dmacr_sdmas_en;  /* Enable DMA single requests for I2C slave data.                                                               */
	                                                       /* Flowcontrolling must be done my DMA-Controller.                                                              */
	unsigned int sdmab_en  : BFW_NX50_i2c_dmacr_sdmab_en;  /* Enable DMA burst requests for I2C slave data.                                                                */
	                                                       /* Flowcontrolling must be done my DMA-Controller.                                                              */
	unsigned int reserved1 : BFW_NX50_i2c_dmacr_reserved1; /* reserved                                                                                                     */
} NX50_I2C_DMACR_BIT_T;

typedef union {
	unsigned int         val;
	NX50_I2C_DMACR_BIT_T bf;
} NX50_I2C_DMACR_T;


/* ===================================================================== */

/* Area of ccdc */

/* ===================================================================== */

#define Addr_NX50_ccdc      0x1C000F00U
#define NX50_NETX_CCDC_AREA 0x1C000F00U

/* --------------------------------------------------------------------- */
/* Register ccdc_config */
/* => CCDC config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_config  0x00000000U
#define Adr_NX50_ccdc_ccdc_config 0x1C000F00U
#define Adr_NX50_ccdc_config      0x1C000F00U
#define DFLT_VAL_NX50_ccdc_config 0x00000000U

#define MSK_NX50_ccdc_config_enable           0x00000001U
#define SRT_NX50_ccdc_config_enable           0
#define DFLT_VAL_NX50_ccdc_config_enable      0x00000000U
#define MSK_NX50_ccdc_config_edge_mode        0x00000002U
#define SRT_NX50_ccdc_config_edge_mode        1
#define DFLT_VAL_NX50_ccdc_config_edge_mode   0x00000000U
#define MSK_NX50_ccdc_config_bright_step      0x00000ff0U
#define SRT_NX50_ccdc_config_bright_step      4
#define DFLT_VAL_NX50_ccdc_config_bright_step 0x00000000U
#define MSK_NX50_ccdc_config_sample_time      0x0000f000U
#define SRT_NX50_ccdc_config_sample_time      12
#define DFLT_VAL_NX50_ccdc_config_sample_time 0x00000000U
#define MSK_NX50_ccdc_config_fifo_0_res       0x00010000U
#define SRT_NX50_ccdc_config_fifo_0_res       16
#define DFLT_VAL_NX50_ccdc_config_fifo_0_res  0x00000000U
#define MSK_NX50_ccdc_config_fifo_0_ovfl      0x00020000U
#define SRT_NX50_ccdc_config_fifo_0_ovfl      17
#define DFLT_VAL_NX50_ccdc_config_fifo_0_ovfl 0x00000000U
#define MSK_NX50_ccdc_config_fifo_0_unfl      0x00040000U
#define SRT_NX50_ccdc_config_fifo_0_unfl      18
#define DFLT_VAL_NX50_ccdc_config_fifo_0_unfl 0x00000000U
#define MSK_NX50_ccdc_config_fifo_0_nxt       0x00080000U
#define SRT_NX50_ccdc_config_fifo_0_nxt       19
#define DFLT_VAL_NX50_ccdc_config_fifo_0_nxt  0x00000000U
#define MSK_NX50_ccdc_config_fifo_1_res       0x00100000U
#define SRT_NX50_ccdc_config_fifo_1_res       20
#define DFLT_VAL_NX50_ccdc_config_fifo_1_res  0x00000000U
#define MSK_NX50_ccdc_config_fifo_1_ovfl      0x00200000U
#define SRT_NX50_ccdc_config_fifo_1_ovfl      21
#define DFLT_VAL_NX50_ccdc_config_fifo_1_ovfl 0x00000000U
#define MSK_NX50_ccdc_config_fifo_1_unfl      0x00400000U
#define SRT_NX50_ccdc_config_fifo_1_unfl      22
#define DFLT_VAL_NX50_ccdc_config_fifo_1_unfl 0x00000000U
#define MSK_NX50_ccdc_config_fifo_1_nxt       0x00800000U
#define SRT_NX50_ccdc_config_fifo_1_nxt       23
#define DFLT_VAL_NX50_ccdc_config_fifo_1_nxt  0x00000000U
#define MSK_NX50_ccdc_config_fifo_2_res       0x01000000U
#define SRT_NX50_ccdc_config_fifo_2_res       24
#define DFLT_VAL_NX50_ccdc_config_fifo_2_res  0x00000000U
#define MSK_NX50_ccdc_config_fifo_2_ovfl      0x02000000U
#define SRT_NX50_ccdc_config_fifo_2_ovfl      25
#define DFLT_VAL_NX50_ccdc_config_fifo_2_ovfl 0x00000000U
#define MSK_NX50_ccdc_config_fifo_2_unfl      0x04000000U
#define SRT_NX50_ccdc_config_fifo_2_unfl      26
#define DFLT_VAL_NX50_ccdc_config_fifo_2_unfl 0x00000000U
#define MSK_NX50_ccdc_config_fifo_2_nxt       0x08000000U
#define SRT_NX50_ccdc_config_fifo_2_nxt       27
#define DFLT_VAL_NX50_ccdc_config_fifo_2_nxt  0x00000000U
#define MSK_NX50_ccdc_config_last_mode        0x10000000U
#define SRT_NX50_ccdc_config_last_mode        28
#define DFLT_VAL_NX50_ccdc_config_last_mode   0x00000000U

enum {
	BFW_NX50_ccdc_config_enable      = 1, /* [0] */
	BFW_NX50_ccdc_config_edge_mode   = 1, /* [1] */
	BFW_NX50_ccdc_config_reserved1   = 2, /* [3:2] */
	BFW_NX50_ccdc_config_bright_step = 8, /* [11:4] */
	BFW_NX50_ccdc_config_sample_time = 4, /* [15:12] */
	BFW_NX50_ccdc_config_fifo_0_res  = 1, /* [16] */
	BFW_NX50_ccdc_config_fifo_0_ovfl = 1, /* [17] */
	BFW_NX50_ccdc_config_fifo_0_unfl = 1, /* [18] */
	BFW_NX50_ccdc_config_fifo_0_nxt  = 1, /* [19] */
	BFW_NX50_ccdc_config_fifo_1_res  = 1, /* [20] */
	BFW_NX50_ccdc_config_fifo_1_ovfl = 1, /* [21] */
	BFW_NX50_ccdc_config_fifo_1_unfl = 1, /* [22] */
	BFW_NX50_ccdc_config_fifo_1_nxt  = 1, /* [23] */
	BFW_NX50_ccdc_config_fifo_2_res  = 1, /* [24] */
	BFW_NX50_ccdc_config_fifo_2_ovfl = 1, /* [25] */
	BFW_NX50_ccdc_config_fifo_2_unfl = 1, /* [26] */
	BFW_NX50_ccdc_config_fifo_2_nxt  = 1, /* [27] */
	BFW_NX50_ccdc_config_last_mode   = 1, /* [28] */
	BFW_NX50_ccdc_config_reserved2   = 3  /* [31:29] */
};

typedef struct NX50_CCDC_CONFIG_BIT_Ttag {
	unsigned int enable      : BFW_NX50_ccdc_config_enable;      /* enable CCD - Controller                            */
	unsigned int edge_mode   : BFW_NX50_ccdc_config_edge_mode;   /* 0 :  posedge (pixclk), 1 :  negedge (pixclk)       */
	unsigned int reserved1   : BFW_NX50_ccdc_config_reserved1;   /* reserved                                           */
	unsigned int bright_step : BFW_NX50_ccdc_config_bright_step; /* add every n (bright_step) byte:                    */
	                                                             /*                               0 no add             */
	unsigned int sample_time : BFW_NX50_ccdc_config_sample_time; /* simple_time 0 - 15 100Mhz clocks after pos/negedge */
	                                                             /*                               0      : with edge   */
	unsigned int fifo_0_res  : BFW_NX50_ccdc_config_fifo_0_res;  /* 1'b1 reset; 1'b0 release                           */
	unsigned int fifo_0_ovfl : BFW_NX50_ccdc_config_fifo_0_ovfl; /* overflow read only                                 */
	unsigned int fifo_0_unfl : BFW_NX50_ccdc_config_fifo_0_unfl; /* underflow read only                                */
	unsigned int fifo_0_nxt  : BFW_NX50_ccdc_config_fifo_0_nxt;  /* value in fifo read only                            */
	unsigned int fifo_1_res  : BFW_NX50_ccdc_config_fifo_1_res;  /* 1'b1 reset; 1'b0 release                           */
	unsigned int fifo_1_ovfl : BFW_NX50_ccdc_config_fifo_1_ovfl; /* overflow read only                                 */
	unsigned int fifo_1_unfl : BFW_NX50_ccdc_config_fifo_1_unfl; /* underflow read only                                */
	unsigned int fifo_1_nxt  : BFW_NX50_ccdc_config_fifo_1_nxt;  /* value in fifo read only                            */
	unsigned int fifo_2_res  : BFW_NX50_ccdc_config_fifo_2_res;  /* 1'b1 reset; 1'b0 release                           */
	unsigned int fifo_2_ovfl : BFW_NX50_ccdc_config_fifo_2_ovfl; /* overflow read only                                 */
	unsigned int fifo_2_unfl : BFW_NX50_ccdc_config_fifo_2_unfl; /* underflow read only                                */
	unsigned int fifo_2_nxt  : BFW_NX50_ccdc_config_fifo_2_nxt;  /* value in fifo read only                            */
	unsigned int last_mode   : BFW_NX50_ccdc_config_last_mode;   /* reserved                                           */
	unsigned int reserved2   : BFW_NX50_ccdc_config_reserved2;   /* reserved                                           */
} NX50_CCDC_CONFIG_BIT_T;

typedef union {
	unsigned int           val;
	NX50_CCDC_CONFIG_BIT_T bf;
} NX50_CCDC_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_horiz_start_stop */
/* => CCDC horizontal start/stop values */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_horiz_start_stop  0x00000004U
#define Adr_NX50_ccdc_ccdc_horiz_start_stop 0x1C000F04U
#define Adr_NX50_ccdc_horiz_start_stop      0x1C000F04U
#define DFLT_VAL_NX50_ccdc_horiz_start_stop 0x00000000U

#define MSK_NX50_ccdc_horiz_start_stop_horiz_start      0x0000ffffU
#define SRT_NX50_ccdc_horiz_start_stop_horiz_start      0
#define DFLT_VAL_NX50_ccdc_horiz_start_stop_horiz_start 0x00000000U
#define MSK_NX50_ccdc_horiz_start_stop_horiz_stop       0xffff0000U
#define SRT_NX50_ccdc_horiz_start_stop_horiz_stop       16
#define DFLT_VAL_NX50_ccdc_horiz_start_stop_horiz_stop  0x00000000U

enum {
	BFW_NX50_ccdc_horiz_start_stop_horiz_start = 16, /* [15:0] */
	BFW_NX50_ccdc_horiz_start_stop_horiz_stop  = 16  /* [31:16] */
};

typedef struct NX50_CCDC_HORIZ_START_STOP_BIT_Ttag {
	unsigned int horiz_start : BFW_NX50_ccdc_horiz_start_stop_horiz_start; /* byte count start (inclusive), to cut picture */
	unsigned int horiz_stop  : BFW_NX50_ccdc_horiz_start_stop_horiz_stop;  /* byte count stop (exclusive), to cut picture  */
} NX50_CCDC_HORIZ_START_STOP_BIT_T;

typedef union {
	unsigned int                     val;
	NX50_CCDC_HORIZ_START_STOP_BIT_T bf;
} NX50_CCDC_HORIZ_START_STOP_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_verti_start_stop */
/* => CCDC vertical start/stop values */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_verti_start_stop  0x00000008U
#define Adr_NX50_ccdc_ccdc_verti_start_stop 0x1C000F08U
#define Adr_NX50_ccdc_verti_start_stop      0x1C000F08U
#define DFLT_VAL_NX50_ccdc_verti_start_stop 0x00000000U

#define MSK_NX50_ccdc_verti_start_stop_verti_start      0x0000ffffU
#define SRT_NX50_ccdc_verti_start_stop_verti_start      0
#define DFLT_VAL_NX50_ccdc_verti_start_stop_verti_start 0x00000000U
#define MSK_NX50_ccdc_verti_start_stop_verti_stop       0xffff0000U
#define SRT_NX50_ccdc_verti_start_stop_verti_stop       16
#define DFLT_VAL_NX50_ccdc_verti_start_stop_verti_stop  0x00000000U

enum {
	BFW_NX50_ccdc_verti_start_stop_verti_start = 16, /* [15:0] */
	BFW_NX50_ccdc_verti_start_stop_verti_stop  = 16  /* [31:16] */
};

typedef struct NX50_CCDC_VERTI_START_STOP_BIT_Ttag {
	unsigned int verti_start : BFW_NX50_ccdc_verti_start_stop_verti_start; /* line count start (inclusive), to cut picture */
	unsigned int verti_stop  : BFW_NX50_ccdc_verti_start_stop_verti_stop;  /* line count stop (exclusive), to cut picture  */
} NX50_CCDC_VERTI_START_STOP_BIT_T;

typedef union {
	unsigned int                     val;
	NX50_CCDC_VERTI_START_STOP_BIT_T bf;
} NX50_CCDC_VERTI_START_STOP_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_horiz_verti_counter */
/* => CCDC horizontal/vertical counter */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_horiz_verti_counter  0x0000000CU
#define Adr_NX50_ccdc_ccdc_horiz_verti_counter 0x1C000F0CU
#define Adr_NX50_ccdc_horiz_verti_counter      0x1C000F0CU

#define MSK_NX50_ccdc_horiz_verti_counter_horiz_counter 0x0000ffffU
#define SRT_NX50_ccdc_horiz_verti_counter_horiz_counter 0
#define MSK_NX50_ccdc_horiz_verti_counter_verti_counter 0xffff0000U
#define SRT_NX50_ccdc_horiz_verti_counter_verti_counter 16

enum {
	BFW_NX50_ccdc_horiz_verti_counter_horiz_counter = 16, /* [15:0] */
	BFW_NX50_ccdc_horiz_verti_counter_verti_counter = 16  /* [31:16] */
};

typedef struct NX50_CCDC_HORIZ_VERTI_COUNTER_BIT_Ttag {
	unsigned int horiz_counter : BFW_NX50_ccdc_horiz_verti_counter_horiz_counter; /* byte count while line_valid, reset with posedge line_valid   */
	unsigned int verti_counter : BFW_NX50_ccdc_horiz_verti_counter_verti_counter; /* line count while frame_valid, reset with posedge frame_valid */
} NX50_CCDC_HORIZ_VERTI_COUNTER_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_CCDC_HORIZ_VERTI_COUNTER_BIT_T bf;
} NX50_CCDC_HORIZ_VERTI_COUNTER_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_brightness */
/* => CCDC brightness counter */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_brightness  0x00000010U
#define Adr_NX50_ccdc_ccdc_brightness 0x1C000F10U
#define Adr_NX50_ccdc_brightness      0x1C000F10U

#define MSK_NX50_ccdc_brightness_brightness 0xffffffffU
#define SRT_NX50_ccdc_brightness_brightness 0

enum {
	BFW_NX50_ccdc_brightness_brightness = 32  /* [31:0] */
};

typedef struct NX50_CCDC_BRIGHTNESS_BIT_Ttag {
	unsigned int brightness : BFW_NX50_ccdc_brightness_brightness; /* brightness adder, every bright_step byte, reset with posedge frame_valid */
} NX50_CCDC_BRIGHTNESS_BIT_T;

typedef union {
	unsigned int               val;
	NX50_CCDC_BRIGHTNESS_BIT_T bf;
} NX50_CCDC_BRIGHTNESS_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_fifo_0 */
/* => CCDC Fifo 0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_fifo_0  0x00000014U
#define Adr_NX50_ccdc_ccdc_fifo_0 0x1C000F14U
#define Adr_NX50_ccdc_fifo_0      0x1C000F14U

#define MSK_NX50_ccdc_fifo_0_fifo_0 0xffffffffU
#define SRT_NX50_ccdc_fifo_0_fifo_0 0

enum {
	BFW_NX50_ccdc_fifo_0_fifo_0 = 32  /* [31:0] */
};

typedef struct NX50_CCDC_FIFO_0_BIT_Ttag {
	unsigned int fifo_0 : BFW_NX50_ccdc_fifo_0_fifo_0; /* 2*4 bytes depth */
} NX50_CCDC_FIFO_0_BIT_T;

typedef union {
	unsigned int           val;
	NX50_CCDC_FIFO_0_BIT_T bf;
} NX50_CCDC_FIFO_0_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_fifo_1 */
/* => CCDC Fifo 1 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_fifo_1  0x00000018U
#define Adr_NX50_ccdc_ccdc_fifo_1 0x1C000F18U
#define Adr_NX50_ccdc_fifo_1      0x1C000F18U

#define MSK_NX50_ccdc_fifo_1_fifo_1 0xffffffffU
#define SRT_NX50_ccdc_fifo_1_fifo_1 0

enum {
	BFW_NX50_ccdc_fifo_1_fifo_1 = 32  /* [31:0] */
};

typedef struct NX50_CCDC_FIFO_1_BIT_Ttag {
	unsigned int fifo_1 : BFW_NX50_ccdc_fifo_1_fifo_1; /* 2*4 bytes depth */
} NX50_CCDC_FIFO_1_BIT_T;

typedef union {
	unsigned int           val;
	NX50_CCDC_FIFO_1_BIT_T bf;
} NX50_CCDC_FIFO_1_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_fifo_2 */
/* => CCDC Fifo 2 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_fifo_2  0x0000001CU
#define Adr_NX50_ccdc_ccdc_fifo_2 0x1C000F1CU
#define Adr_NX50_ccdc_fifo_2      0x1C000F1CU

#define MSK_NX50_ccdc_fifo_2_fifo_2 0xffffffffU
#define SRT_NX50_ccdc_fifo_2_fifo_2 0

enum {
	BFW_NX50_ccdc_fifo_2_fifo_2 = 32  /* [31:0] */
};

typedef struct NX50_CCDC_FIFO_2_BIT_Ttag {
	unsigned int fifo_2 : BFW_NX50_ccdc_fifo_2_fifo_2; /* 2*4 bytes depth */
} NX50_CCDC_FIFO_2_BIT_T;

typedef union {
	unsigned int           val;
	NX50_CCDC_FIFO_2_BIT_T bf;
} NX50_CCDC_FIFO_2_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_byte_0_pos */
/* => CCDC Byte Position Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_byte_0_pos  0x00000020U
#define Adr_NX50_ccdc_ccdc_byte_0_pos 0x1C000F20U
#define Adr_NX50_ccdc_byte_0_pos      0x1C000F20U
#define DFLT_VAL_NX50_ccdc_byte_0_pos 0xff000000U

#define MSK_NX50_ccdc_byte_0_pos_first_0_byte_start        0x0000001fU
#define SRT_NX50_ccdc_byte_0_pos_first_0_byte_start        0
#define DFLT_VAL_NX50_ccdc_byte_0_pos_first_0_byte_start   0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_first_0_byte_enable       0x00000020U
#define SRT_NX50_ccdc_byte_0_pos_first_0_byte_enable       5
#define DFLT_VAL_NX50_ccdc_byte_0_pos_first_0_byte_enable  0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_second_0_byte_start       0x000007c0U
#define SRT_NX50_ccdc_byte_0_pos_second_0_byte_start       6
#define DFLT_VAL_NX50_ccdc_byte_0_pos_second_0_byte_start  0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_second_0_byte_enable      0x00000800U
#define SRT_NX50_ccdc_byte_0_pos_second_0_byte_enable      11
#define DFLT_VAL_NX50_ccdc_byte_0_pos_second_0_byte_enable 0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_third_0_byte_start        0x0001f000U
#define SRT_NX50_ccdc_byte_0_pos_third_0_byte_start        12
#define DFLT_VAL_NX50_ccdc_byte_0_pos_third_0_byte_start   0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_third_0_byte_enable       0x00020000U
#define SRT_NX50_ccdc_byte_0_pos_third_0_byte_enable       17
#define DFLT_VAL_NX50_ccdc_byte_0_pos_third_0_byte_enable  0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_fourth_0_byte_start       0x007c0000U
#define SRT_NX50_ccdc_byte_0_pos_fourth_0_byte_start       18
#define DFLT_VAL_NX50_ccdc_byte_0_pos_fourth_0_byte_start  0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_fourth_0_byte_enable      0x00800000U
#define SRT_NX50_ccdc_byte_0_pos_fourth_0_byte_enable      23
#define DFLT_VAL_NX50_ccdc_byte_0_pos_fourth_0_byte_enable 0x00000000U
#define MSK_NX50_ccdc_byte_0_pos_fifo_0_and_mask           0xff000000U
#define SRT_NX50_ccdc_byte_0_pos_fifo_0_and_mask           24
#define DFLT_VAL_NX50_ccdc_byte_0_pos_fifo_0_and_mask      0xff000000U

enum {
	BFW_NX50_ccdc_byte_0_pos_first_0_byte_start   = 5, /* [4:0] */
	BFW_NX50_ccdc_byte_0_pos_first_0_byte_enable  = 1, /* [5] */
	BFW_NX50_ccdc_byte_0_pos_second_0_byte_start  = 5, /* [10:6] */
	BFW_NX50_ccdc_byte_0_pos_second_0_byte_enable = 1, /* [11] */
	BFW_NX50_ccdc_byte_0_pos_third_0_byte_start   = 5, /* [16:12] */
	BFW_NX50_ccdc_byte_0_pos_third_0_byte_enable  = 1, /* [17] */
	BFW_NX50_ccdc_byte_0_pos_fourth_0_byte_start  = 5, /* [22:18] */
	BFW_NX50_ccdc_byte_0_pos_fourth_0_byte_enable = 1, /* [23] */
	BFW_NX50_ccdc_byte_0_pos_fifo_0_and_mask      = 8  /* [31:24] */
};

typedef struct NX50_CCDC_BYTE_0_POS_BIT_Ttag {
	unsigned int first_0_byte_start   : BFW_NX50_ccdc_byte_0_pos_first_0_byte_start;   /* first byte start position  */
	unsigned int first_0_byte_enable  : BFW_NX50_ccdc_byte_0_pos_first_0_byte_enable;  /* enable byte selection      */
	unsigned int second_0_byte_start  : BFW_NX50_ccdc_byte_0_pos_second_0_byte_start;  /* second byte start position */
	unsigned int second_0_byte_enable : BFW_NX50_ccdc_byte_0_pos_second_0_byte_enable; /* enable byte selection      */
	unsigned int third_0_byte_start   : BFW_NX50_ccdc_byte_0_pos_third_0_byte_start;   /* third byte start position  */
	unsigned int third_0_byte_enable  : BFW_NX50_ccdc_byte_0_pos_third_0_byte_enable;  /* enable byte selection      */
	unsigned int fourth_0_byte_start  : BFW_NX50_ccdc_byte_0_pos_fourth_0_byte_start;  /* fourth byte start position */
	unsigned int fourth_0_byte_enable : BFW_NX50_ccdc_byte_0_pos_fourth_0_byte_enable; /* enable byte selection      */
	unsigned int fifo_0_and_mask      : BFW_NX50_ccdc_byte_0_pos_fifo_0_and_mask;      /* and_mask                   */
} NX50_CCDC_BYTE_0_POS_BIT_T;

typedef union {
	unsigned int               val;
	NX50_CCDC_BYTE_0_POS_BIT_T bf;
} NX50_CCDC_BYTE_0_POS_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_byte_1_pos */
/* => CCDC Byte Position Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_byte_1_pos  0x00000024U
#define Adr_NX50_ccdc_ccdc_byte_1_pos 0x1C000F24U
#define Adr_NX50_ccdc_byte_1_pos      0x1C000F24U
#define DFLT_VAL_NX50_ccdc_byte_1_pos 0xff000000U

#define MSK_NX50_ccdc_byte_1_pos_first_1_byte_start        0x0000001fU
#define SRT_NX50_ccdc_byte_1_pos_first_1_byte_start        0
#define DFLT_VAL_NX50_ccdc_byte_1_pos_first_1_byte_start   0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_first_1_byte_enable       0x00000020U
#define SRT_NX50_ccdc_byte_1_pos_first_1_byte_enable       5
#define DFLT_VAL_NX50_ccdc_byte_1_pos_first_1_byte_enable  0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_second_1_byte_start       0x000007c0U
#define SRT_NX50_ccdc_byte_1_pos_second_1_byte_start       6
#define DFLT_VAL_NX50_ccdc_byte_1_pos_second_1_byte_start  0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_second_1_byte_enable      0x00000800U
#define SRT_NX50_ccdc_byte_1_pos_second_1_byte_enable      11
#define DFLT_VAL_NX50_ccdc_byte_1_pos_second_1_byte_enable 0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_third_1_byte_start        0x0001f000U
#define SRT_NX50_ccdc_byte_1_pos_third_1_byte_start        12
#define DFLT_VAL_NX50_ccdc_byte_1_pos_third_1_byte_start   0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_third_1_byte_enable       0x00020000U
#define SRT_NX50_ccdc_byte_1_pos_third_1_byte_enable       17
#define DFLT_VAL_NX50_ccdc_byte_1_pos_third_1_byte_enable  0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_fourth_1_byte_start       0x007c0000U
#define SRT_NX50_ccdc_byte_1_pos_fourth_1_byte_start       18
#define DFLT_VAL_NX50_ccdc_byte_1_pos_fourth_1_byte_start  0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_fourth_1_byte_enable      0x00800000U
#define SRT_NX50_ccdc_byte_1_pos_fourth_1_byte_enable      23
#define DFLT_VAL_NX50_ccdc_byte_1_pos_fourth_1_byte_enable 0x00000000U
#define MSK_NX50_ccdc_byte_1_pos_fifo_1_and_mask           0xff000000U
#define SRT_NX50_ccdc_byte_1_pos_fifo_1_and_mask           24
#define DFLT_VAL_NX50_ccdc_byte_1_pos_fifo_1_and_mask      0xff000000U

enum {
	BFW_NX50_ccdc_byte_1_pos_first_1_byte_start   = 5, /* [4:0] */
	BFW_NX50_ccdc_byte_1_pos_first_1_byte_enable  = 1, /* [5] */
	BFW_NX50_ccdc_byte_1_pos_second_1_byte_start  = 5, /* [10:6] */
	BFW_NX50_ccdc_byte_1_pos_second_1_byte_enable = 1, /* [11] */
	BFW_NX50_ccdc_byte_1_pos_third_1_byte_start   = 5, /* [16:12] */
	BFW_NX50_ccdc_byte_1_pos_third_1_byte_enable  = 1, /* [17] */
	BFW_NX50_ccdc_byte_1_pos_fourth_1_byte_start  = 5, /* [22:18] */
	BFW_NX50_ccdc_byte_1_pos_fourth_1_byte_enable = 1, /* [23] */
	BFW_NX50_ccdc_byte_1_pos_fifo_1_and_mask      = 8  /* [31:24] */
};

typedef struct NX50_CCDC_BYTE_1_POS_BIT_Ttag {
	unsigned int first_1_byte_start   : BFW_NX50_ccdc_byte_1_pos_first_1_byte_start;   /* first byte start position  */
	unsigned int first_1_byte_enable  : BFW_NX50_ccdc_byte_1_pos_first_1_byte_enable;  /* enable byte selection      */
	unsigned int second_1_byte_start  : BFW_NX50_ccdc_byte_1_pos_second_1_byte_start;  /* second byte start position */
	unsigned int second_1_byte_enable : BFW_NX50_ccdc_byte_1_pos_second_1_byte_enable; /* enable byte selection      */
	unsigned int third_1_byte_start   : BFW_NX50_ccdc_byte_1_pos_third_1_byte_start;   /* third byte start position  */
	unsigned int third_1_byte_enable  : BFW_NX50_ccdc_byte_1_pos_third_1_byte_enable;  /* enable byte selection      */
	unsigned int fourth_1_byte_start  : BFW_NX50_ccdc_byte_1_pos_fourth_1_byte_start;  /* fourth byte start position */
	unsigned int fourth_1_byte_enable : BFW_NX50_ccdc_byte_1_pos_fourth_1_byte_enable; /* enable byte selection      */
	unsigned int fifo_1_and_mask      : BFW_NX50_ccdc_byte_1_pos_fifo_1_and_mask;      /* and_mask                   */
} NX50_CCDC_BYTE_1_POS_BIT_T;

typedef union {
	unsigned int               val;
	NX50_CCDC_BYTE_1_POS_BIT_T bf;
} NX50_CCDC_BYTE_1_POS_T;

/* --------------------------------------------------------------------- */
/* Register ccdc_byte_2_pos */
/* => CCDC Byte Position Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ccdc_byte_2_pos  0x00000028U
#define Adr_NX50_ccdc_ccdc_byte_2_pos 0x1C000F28U
#define Adr_NX50_ccdc_byte_2_pos      0x1C000F28U
#define DFLT_VAL_NX50_ccdc_byte_2_pos 0xff000000U

#define MSK_NX50_ccdc_byte_2_pos_first_2_byte_start        0x0000001fU
#define SRT_NX50_ccdc_byte_2_pos_first_2_byte_start        0
#define DFLT_VAL_NX50_ccdc_byte_2_pos_first_2_byte_start   0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_first_2_byte_enable       0x00000020U
#define SRT_NX50_ccdc_byte_2_pos_first_2_byte_enable       5
#define DFLT_VAL_NX50_ccdc_byte_2_pos_first_2_byte_enable  0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_second_2_byte_start       0x000007c0U
#define SRT_NX50_ccdc_byte_2_pos_second_2_byte_start       6
#define DFLT_VAL_NX50_ccdc_byte_2_pos_second_2_byte_start  0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_second_2_byte_enable      0x00000800U
#define SRT_NX50_ccdc_byte_2_pos_second_2_byte_enable      11
#define DFLT_VAL_NX50_ccdc_byte_2_pos_second_2_byte_enable 0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_third_2_byte_start        0x0001f000U
#define SRT_NX50_ccdc_byte_2_pos_third_2_byte_start        12
#define DFLT_VAL_NX50_ccdc_byte_2_pos_third_2_byte_start   0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_third_2_byte_enable       0x00020000U
#define SRT_NX50_ccdc_byte_2_pos_third_2_byte_enable       17
#define DFLT_VAL_NX50_ccdc_byte_2_pos_third_2_byte_enable  0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_fourth_2_byte_start       0x007c0000U
#define SRT_NX50_ccdc_byte_2_pos_fourth_2_byte_start       18
#define DFLT_VAL_NX50_ccdc_byte_2_pos_fourth_2_byte_start  0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_fourth_2_byte_enable      0x00800000U
#define SRT_NX50_ccdc_byte_2_pos_fourth_2_byte_enable      23
#define DFLT_VAL_NX50_ccdc_byte_2_pos_fourth_2_byte_enable 0x00000000U
#define MSK_NX50_ccdc_byte_2_pos_fifo_2_and_mask           0xff000000U
#define SRT_NX50_ccdc_byte_2_pos_fifo_2_and_mask           24
#define DFLT_VAL_NX50_ccdc_byte_2_pos_fifo_2_and_mask      0xff000000U

enum {
	BFW_NX50_ccdc_byte_2_pos_first_2_byte_start   = 5, /* [4:0] */
	BFW_NX50_ccdc_byte_2_pos_first_2_byte_enable  = 1, /* [5] */
	BFW_NX50_ccdc_byte_2_pos_second_2_byte_start  = 5, /* [10:6] */
	BFW_NX50_ccdc_byte_2_pos_second_2_byte_enable = 1, /* [11] */
	BFW_NX50_ccdc_byte_2_pos_third_2_byte_start   = 5, /* [16:12] */
	BFW_NX50_ccdc_byte_2_pos_third_2_byte_enable  = 1, /* [17] */
	BFW_NX50_ccdc_byte_2_pos_fourth_2_byte_start  = 5, /* [22:18] */
	BFW_NX50_ccdc_byte_2_pos_fourth_2_byte_enable = 1, /* [23] */
	BFW_NX50_ccdc_byte_2_pos_fifo_2_and_mask      = 8  /* [31:24] */
};

typedef struct NX50_CCDC_BYTE_2_POS_BIT_Ttag {
	unsigned int first_2_byte_start   : BFW_NX50_ccdc_byte_2_pos_first_2_byte_start;   /* first byte start position  */
	unsigned int first_2_byte_enable  : BFW_NX50_ccdc_byte_2_pos_first_2_byte_enable;  /* enable byte selection      */
	unsigned int second_2_byte_start  : BFW_NX50_ccdc_byte_2_pos_second_2_byte_start;  /* second byte start position */
	unsigned int second_2_byte_enable : BFW_NX50_ccdc_byte_2_pos_second_2_byte_enable; /* enable byte selection      */
	unsigned int third_2_byte_start   : BFW_NX50_ccdc_byte_2_pos_third_2_byte_start;   /* third byte start position  */
	unsigned int third_2_byte_enable  : BFW_NX50_ccdc_byte_2_pos_third_2_byte_enable;  /* enable byte selection      */
	unsigned int fourth_2_byte_start  : BFW_NX50_ccdc_byte_2_pos_fourth_2_byte_start;  /* fourth byte start position */
	unsigned int fourth_2_byte_enable : BFW_NX50_ccdc_byte_2_pos_fourth_2_byte_enable; /* enable byte selection      */
	unsigned int fifo_2_and_mask      : BFW_NX50_ccdc_byte_2_pos_fifo_2_and_mask;      /* and_mask                   */
} NX50_CCDC_BYTE_2_POS_BIT_T;

typedef union {
	unsigned int               val;
	NX50_CCDC_BYTE_2_POS_BIT_T bf;
} NX50_CCDC_BYTE_2_POS_T;


/* ===================================================================== */

/* Area of crc */

/* ===================================================================== */

#define Addr_NX50_crc      0x1C001000U
#define NX50_NETX_CRC_AREA 0x1C001000U

/* --------------------------------------------------------------------- */
/* Register crc_crc */
/* => CRC Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_crc_crc  0x00000000U
#define Adr_NX50_crc_crc_crc  0x1C001000U
#define Adr_NX50_crc_crc      0x1C001000U
#define DFLT_VAL_NX50_crc_crc 0x00000000U

#define MSK_NX50_crc_crc_crc_val      0xffffffffU
#define SRT_NX50_crc_crc_crc_val      0
#define DFLT_VAL_NX50_crc_crc_crc_val 0x00000000U

enum {
	BFW_NX50_crc_crc_crc_val = 32  /* [31:0] */
};

typedef struct NX50_CRC_CRC_BIT_Ttag {
	unsigned int crc_val : BFW_NX50_crc_crc_crc_val; /* CRC value                                          */
	                                                 /* Upper bits should be masked, if crc_len smaller 31 */
} NX50_CRC_CRC_BIT_T;

typedef union {
	unsigned int       val;
	NX50_CRC_CRC_BIT_T bf;
} NX50_CRC_CRC_T;

/* --------------------------------------------------------------------- */
/* Register crc_data_in */
/* => CRC data in Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_crc_data_in  0x00000004U
#define Adr_NX50_crc_crc_data_in  0x1C001004U
#define Adr_NX50_crc_data_in      0x1C001004U
#define DFLT_VAL_NX50_crc_data_in 0x00000000U

#define MSK_NX50_crc_data_in_in      0x000000ffU
#define SRT_NX50_crc_data_in_in      0
#define DFLT_VAL_NX50_crc_data_in_in 0x00000000U

enum {
	BFW_NX50_crc_data_in_in        = 8,  /* [7:0] */
	BFW_NX50_crc_data_in_reserved1 = 24  /* [31:8] */
};

typedef struct NX50_CRC_DATA_IN_BIT_Ttag {
	unsigned int in        : BFW_NX50_crc_data_in_in;        /* CRC input bits */
	unsigned int reserved1 : BFW_NX50_crc_data_in_reserved1; /* reserved       */
} NX50_CRC_DATA_IN_BIT_T;

typedef union {
	unsigned int           val;
	NX50_CRC_DATA_IN_BIT_T bf;
} NX50_CRC_DATA_IN_T;

/* --------------------------------------------------------------------- */
/* Register crc_polynomial */
/* => CRC Polynomial Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_crc_polynomial  0x00000008U
#define Adr_NX50_crc_crc_polynomial  0x1C001008U
#define Adr_NX50_crc_polynomial      0x1C001008U
#define DFLT_VAL_NX50_crc_polynomial 0x04c11db7U

#define MSK_NX50_crc_polynomial_crc_polynomial      0xffffffffU
#define SRT_NX50_crc_polynomial_crc_polynomial      0
#define DFLT_VAL_NX50_crc_polynomial_crc_polynomial 0x04c11db7U

enum {
	BFW_NX50_crc_polynomial_crc_polynomial = 32  /* [31:0] */
};

typedef struct NX50_CRC_POLYNOMIAL_BIT_Ttag {
	unsigned int crc_polynomial : BFW_NX50_crc_polynomial_crc_polynomial; /* crc polynomial (default:Ethenet CRC32)                               */
	                                                                      /* Most significant bit of polynome is always one, thus not considered. */
} NX50_CRC_POLYNOMIAL_BIT_T;

typedef union {
	unsigned int              val;
	NX50_CRC_POLYNOMIAL_BIT_T bf;
} NX50_CRC_POLYNOMIAL_T;

/* --------------------------------------------------------------------- */
/* Register crc_config */
/* => CRC config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_crc_config  0x0000000CU
#define Adr_NX50_crc_crc_config  0x1C00100CU
#define Adr_NX50_crc_config      0x1C00100CU
#define DFLT_VAL_NX50_crc_config 0x00000000U

#define MSK_NX50_crc_config_crc_len              0x0000003fU
#define SRT_NX50_crc_config_crc_len              0
#define DFLT_VAL_NX50_crc_config_crc_len         0x00000000U
#define MSK_NX50_crc_config_crc_shift_right      0x00000040U
#define SRT_NX50_crc_config_crc_shift_right      6
#define DFLT_VAL_NX50_crc_config_crc_shift_right 0x00000000U
#define MSK_NX50_crc_config_crc_direct_div       0x00000080U
#define SRT_NX50_crc_config_crc_direct_div       7
#define DFLT_VAL_NX50_crc_config_crc_direct_div  0x00000000U
#define MSK_NX50_crc_config_crc_nof_bits         0x00000300U
#define SRT_NX50_crc_config_crc_nof_bits         8
#define DFLT_VAL_NX50_crc_config_crc_nof_bits    0x00000000U
#define MSK_NX50_crc_config_crc_in_msb_low       0x00000400U
#define SRT_NX50_crc_config_crc_in_msb_low       10
#define DFLT_VAL_NX50_crc_config_crc_in_msb_low  0x00000000U

enum {
	BFW_NX50_crc_config_crc_len         = 6,  /* [5:0] */
	BFW_NX50_crc_config_crc_shift_right = 1,  /* [6] */
	BFW_NX50_crc_config_crc_direct_div  = 1,  /* [7] */
	BFW_NX50_crc_config_crc_nof_bits    = 2,  /* [9:8] */
	BFW_NX50_crc_config_crc_in_msb_low  = 1,  /* [10] */
	BFW_NX50_crc_config_reserved1       = 21  /* [31:11] */
};

typedef struct NX50_CRC_CONFIG_BIT_Ttag {
	unsigned int crc_len         : BFW_NX50_crc_config_crc_len;         /* Length of CRC - 1                                                                                   */
	unsigned int crc_shift_right : BFW_NX50_crc_config_crc_shift_right; /* 1: shift crc right                                                                                  */
	unsigned int crc_direct_div  : BFW_NX50_crc_config_crc_direct_div;  /* 1: calculate direct polynolial division without n zeros after frame, usefull for parity calculation */
	unsigned int crc_nof_bits    : BFW_NX50_crc_config_crc_nof_bits;    /* number of bits to be calculated in parallel (00: 1, 01: 2, 10; 4, 11: 8)                            */
	unsigned int crc_in_msb_low  : BFW_NX50_crc_config_crc_in_msb_low;  /* swap crc_data_in, only usefull when calculating multiple bits in parallel (crc_nof_bits > 0):       */
	                                                                    /* 1: msb of incoming bits is data_in[0],                                                              */
	unsigned int reserved1       : BFW_NX50_crc_config_reserved1;       /* reserved                                                                                            */
} NX50_CRC_CONFIG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_CRC_CONFIG_BIT_T bf;
} NX50_CRC_CONFIG_T;


/* ===================================================================== */

/* Area of systime */

/* ===================================================================== */

#define Addr_NX50_systime       0x1C001100U
#define NX50_NETX_SYS_TIME_AREA 0x1C001100U

/* --------------------------------------------------------------------- */
/* Register systime_ns */
/* => lower SYSTIME register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_ns     0x00000000U
#define Adr_NX50_systime_systime_ns 0x1C001100U
#define Adr_NX50_systime_ns         0x1C001100U
#define DFLT_VAL_NX50_systime_ns    0x00000000U

#define MSK_NX50_systime_ns_systime_ns      0xffffffffU
#define SRT_NX50_systime_ns_systime_ns      0
#define DFLT_VAL_NX50_systime_ns_systime_ns 0x00000000U

enum {
	BFW_NX50_systime_ns_systime_ns = 32  /* [31:0] */
};

typedef struct NX50_SYSTIME_NS_BIT_Ttag {
	unsigned int systime_ns : BFW_NX50_systime_ns_systime_ns; /* Systime low (used for counting nanoseconds in IEEE15888) */
} NX50_SYSTIME_NS_BIT_T;

typedef union {
	unsigned int          val;
	NX50_SYSTIME_NS_BIT_T bf;
} NX50_SYSTIME_NS_T;

/* --------------------------------------------------------------------- */
/* Register systime_s */
/* => upper SYSTIME register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_s     0x00000004U
#define Adr_NX50_systime_systime_s 0x1C001104U
#define Adr_NX50_systime_s         0x1C001104U
#define DFLT_VAL_NX50_systime_s    0x00000000U

#define MSK_NX50_systime_s_systime_s      0xffffffffU
#define SRT_NX50_systime_s_systime_s      0
#define DFLT_VAL_NX50_systime_s_systime_s 0x00000000U

enum {
	BFW_NX50_systime_s_systime_s = 32  /* [31:0] */
};

typedef struct NX50_SYSTIME_S_BIT_Ttag {
	unsigned int systime_s : BFW_NX50_systime_s_systime_s; /* systime high (used for counting seconds in IEEE 1588)      */
	                                                       /* value is incremented, if systime_ns reaches systime_border */
} NX50_SYSTIME_S_BIT_T;

typedef union {
	unsigned int         val;
	NX50_SYSTIME_S_BIT_T bf;
} NX50_SYSTIME_S_T;

/* --------------------------------------------------------------------- */
/* Register systime_border */
/* => SYSTIME border register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_border     0x00000008U
#define Adr_NX50_systime_systime_border 0x1C001108U
#define Adr_NX50_systime_border         0x1C001108U
#define DFLT_VAL_NX50_systime_border    0x3b9ac9ffU

#define MSK_NX50_systime_border_systime_border      0xffffffffU
#define SRT_NX50_systime_border_systime_border      0
#define DFLT_VAL_NX50_systime_border_systime_border 0x3b9ac9ffU

enum {
	BFW_NX50_systime_border_systime_border = 32  /* [31:0] */
};

typedef struct NX50_SYSTIME_BORDER_BIT_Ttag {
	unsigned int systime_border : BFW_NX50_systime_border_systime_border; /* Systime border for lower systime:                  */
	                                                                      /* systime_ns counts from 0 to this value (inlcuded), */
} NX50_SYSTIME_BORDER_BIT_T;

typedef union {
	unsigned int              val;
	NX50_SYSTIME_BORDER_BIT_T bf;
} NX50_SYSTIME_BORDER_T;

/* --------------------------------------------------------------------- */
/* Register systime_count_value */
/* => SYSTIME count register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_count_value     0x0000000CU
#define Adr_NX50_systime_systime_count_value 0x1C00110CU
#define Adr_NX50_systime_count_value         0x1C00110CU
#define DFLT_VAL_NX50_systime_count_value    0xa0000000U

#define MSK_NX50_systime_count_value_systime_count_value      0xffffffffU
#define SRT_NX50_systime_count_value_systime_count_value      0
#define DFLT_VAL_NX50_systime_count_value_systime_count_value 0xa0000000U

enum {
	BFW_NX50_systime_count_value_systime_count_value = 32  /* [31:0] */
};

typedef struct NX50_SYSTIME_COUNT_VALUE_BIT_Ttag {
	unsigned int systime_count_value : BFW_NX50_systime_count_value_systime_count_value; /* Each clock cycle (systime_count_value >> 28)             */
	                                                                                     /* will be added to systime (rate multiplier for IEEE1588). */
} NX50_SYSTIME_COUNT_VALUE_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_SYSTIME_COUNT_VALUE_BIT_T bf;
} NX50_SYSTIME_COUNT_VALUE_T;

/* --------------------------------------------------------------------- */
/* Register systime_s_compare_value */
/* => SYSTIME sec compare register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_s_compare_value     0x00000010U
#define Adr_NX50_systime_systime_s_compare_value 0x1C001110U
#define Adr_NX50_systime_s_compare_value         0x1C001110U
#define DFLT_VAL_NX50_systime_s_compare_value    0x00000000U

#define MSK_NX50_systime_s_compare_value_systime_s_compare_value      0xffffffffU
#define SRT_NX50_systime_s_compare_value_systime_s_compare_value      0
#define DFLT_VAL_NX50_systime_s_compare_value_systime_s_compare_value 0x00000000U

enum {
	BFW_NX50_systime_s_compare_value_systime_s_compare_value = 32  /* [31:0] */
};

typedef struct NX50_SYSTIME_S_COMPARE_VALUE_BIT_Ttag {
	unsigned int systime_s_compare_value : BFW_NX50_systime_s_compare_value_systime_s_compare_value; /* compare value with systime_s (seconds)                                */
	                                                                                                 /* set systime_s_compare_irq register if systime_s_compare_enable is set */
} NX50_SYSTIME_S_COMPARE_VALUE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_SYSTIME_S_COMPARE_VALUE_BIT_T bf;
} NX50_SYSTIME_S_COMPARE_VALUE_T;

/* --------------------------------------------------------------------- */
/* Register systime_s_compare_enable */
/* => SYSTIME sec compare enable register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_s_compare_enable     0x00000014U
#define Adr_NX50_systime_systime_s_compare_enable 0x1C001114U
#define Adr_NX50_systime_s_compare_enable         0x1C001114U
#define DFLT_VAL_NX50_systime_s_compare_enable    0x00000000U

#define MSK_NX50_systime_s_compare_enable_systime_s_compare_enable      0x00000001U
#define SRT_NX50_systime_s_compare_enable_systime_s_compare_enable      0
#define DFLT_VAL_NX50_systime_s_compare_enable_systime_s_compare_enable 0x00000000U

enum {
	BFW_NX50_systime_s_compare_enable_systime_s_compare_enable = 1,  /* [0] */
	BFW_NX50_systime_s_compare_enable_reserved1                = 31  /* [31:1] */
};

typedef struct NX50_SYSTIME_S_COMPARE_ENABLE_BIT_Ttag {
	unsigned int systime_s_compare_enable : BFW_NX50_systime_s_compare_enable_systime_s_compare_enable; /* enable compare with systime_s (seconds)        */
	                                                                                                    /* automatic set with set systime_s_compare_value */
	unsigned int reserved1                : BFW_NX50_systime_s_compare_enable_reserved1;                /* reserved                                       */
} NX50_SYSTIME_S_COMPARE_ENABLE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_SYSTIME_S_COMPARE_ENABLE_BIT_T bf;
} NX50_SYSTIME_S_COMPARE_ENABLE_T;

/* --------------------------------------------------------------------- */
/* Register systime_s_compare_irq */
/* => SYSTIME sec compare irq register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_systime_s_compare_irq     0x00000018U
#define Adr_NX50_systime_systime_s_compare_irq 0x1C001118U
#define Adr_NX50_systime_s_compare_irq         0x1C001118U
#define DFLT_VAL_NX50_systime_s_compare_irq    0x00000000U

#define MSK_NX50_systime_s_compare_irq_systime_s_compare_irq      0x00000001U
#define SRT_NX50_systime_s_compare_irq_systime_s_compare_irq      0
#define DFLT_VAL_NX50_systime_s_compare_irq_systime_s_compare_irq 0x00000000U

enum {
	BFW_NX50_systime_s_compare_irq_systime_s_compare_irq = 1,  /* [0] */
	BFW_NX50_systime_s_compare_irq_reserved1             = 31  /* [31:1] */
};

typedef struct NX50_SYSTIME_S_COMPARE_IRQ_BIT_Ttag {
	unsigned int systime_s_compare_irq : BFW_NX50_systime_s_compare_irq_systime_s_compare_irq; /* compare with systime_s (seconds) irq           */
	                                                                                           /* set if systime_s equal systime_s_compare_value */
	unsigned int reserved1             : BFW_NX50_systime_s_compare_irq_reserved1;             /* reserved                                       */
} NX50_SYSTIME_S_COMPARE_IRQ_BIT_T;

typedef union {
	unsigned int                     val;
	NX50_SYSTIME_S_COMPARE_IRQ_BIT_T bf;
} NX50_SYSTIME_S_COMPARE_IRQ_T;


/* ===================================================================== */

/* Area of mmio_ctrl */

/* ===================================================================== */

#define Addr_NX50_mmio_ctrl      0x1C001300U
#define NX50_NETX_MMIO_CTRL_AREA 0x1C001300U

/* --------------------------------------------------------------------- */
/* Register mmio0_cfg */
/* => Multiplexmatrix Configuration Register for MMIO0 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    mmio*_sel - coding: */
/*    {       |                         |                            | border=1 */
/*    Coding   netX internal function \  signal type                  functional group */
/*             (core connection) */
/*    0x00     xm0_io0                   bidirectional                Fieldbus0 */
/*    0x01     xm0_io1                   bidirectional                Fieldbus0 */
/*    0x02     xm0_io2                   bidirectional                Fieldbus0 */
/*    0x03     xm0_io3                   bidirectional                Fieldbus0 */
/*    0x04     xm0_io4                   bidirectional                Fieldbus0 */
/*    0x05     xm0_io5                   bidirectional                Fieldbus0 */
/*    0x06     xm0_rx                    input                        Fieldbus0 */
/*    0x07     xm0_tx_oe                 nontristatable output        Fieldbus0 */
/*    0x08     xm0_tx_out                tristatable output           Fieldbus0 */
/*    0x09     xm1_io0                   bidirectional                Fieldbus1 */
/*    0x0a     xm1_io1                   bidirectional                Fieldbus1 */
/*    0x0b     xm1_io2                   bidirectional                Fieldbus1 */
/*    0x0c     xm1_io3                   bidirectional                Fieldbus1 */
/*    0x0d     xm1_io4                   bidirectional                Fieldbus1 */
/*    0x0e     xm1_io5                   bidirectional                Fieldbus1 */
/*    0x0f     xm1_rx                    input                        Fieldbus1 */
/*    0x10     xm1_tx_oe                 nontristatable output        Fieldbus1 */
/*    0x11     xm1_tx_out                tristatable output           Fieldbus1 */
/*    0x12     gpio0                     bidirectional                GPIO */
/*    0x13     gpio1                     bidirectional                GPIO */
/*    0x14     gpio2                     bidirectional                GPIO */
/*    0x15     gpio3                     bidirectional                GPIO */
/*    0x16     gpio4                     bidirectional                GPIO */
/*    0x17     gpio5                     bidirectional                GPIO */
/*    0x18     gpio6                     bidirectional                GPIO */
/*    0x19     gpio7                     bidirectional                GPIO */
/*    0x1a     gpio8                     bidirectional                GPIO */
/*    0x1b     gpio9                     bidirectional                GPIO */
/*    0x1c     gpio10                    bidirectional                GPIO */
/*    0x1d     gpio11                    bidirectional                GPIO */
/*    0x1e     gpio12                    bidirectional                GPIO */
/*    0x1f     gpio13                    bidirectional                GPIO */
/*    0x20     gpio14                    bidirectional                GPIO */
/*    0x21     gpio15                    bidirectional                GPIO */
/*    0x22     gpio16                    bidirectional                GPIO */
/*    0x23     gpio17                    bidirectional                GPIO */
/*    0x24     gpio18                    bidirectional                GPIO */
/*    0x25     gpio19                    bidirectional                GPIO */
/*    0x26     gpio20                    bidirectional                GPIO */
/*    0x27     gpio21                    bidirectional                GPIO */
/*    0x28     gpio22                    bidirectional                GPIO */
/*    0x29     gpio23                    bidirectional                GPIO */
/*    0x2a     gpio24                    bidirectional                GPIO */
/*    0x2b     gpio25                    bidirectional                GPIO */
/*    0x2c     gpio26                    bidirectional                GPIO */
/*    0x2d     gpio27                    bidirectional                GPIO */
/*    0x2e     gpio28                    bidirectional                GPIO */
/*    0x2f     gpio29                    bidirectional                GPIO */
/*    0x30     gpio30                    bidirectional                GPIO */
/*    0x31     gpio31                    bidirectional                GPIO */
/*    0x32     phy0_led0                 nontristatable output        internal PHY0 Status */
/*    0x33     phy0_led1                 nontristatable output        internal PHY0 Status */
/*    0x34     phy0_led2                 nontristatable output        internal PHY0 Status */
/*    0x35     phy0_led3                 nontristatable output        internal PHY0 Status */
/*    0x36     phy1_led0                 nontristatable output        internal PHY1 Status */
/*    0x37     phy1_led1                 nontristatable output        internal PHY1 Status */
/*    0x38     phy1_led2                 nontristatable output        internal PHY1 Status */
/*    0x39     phy1_led3                 nontristatable output        internal PHY1 Status */
/*    0x3a     mii_mdc                   nontristatable output        MDIO */
/*    0x3b     mii_mdio                  bidirectional                MDIO */
/*    0x3c     mii0_col                  input                        MII0 */
/*    0x3d     mii0_crs                  input                        MII0 */
/*    0x3e     mii0_led0                 input                        MII0 */
/*    0x3f     mii0_led1                 input                        MII0 */
/*    0x40     mii0_led2                 input                        MII0 */
/*    0x41     mii0_led3                 input                        MII0 */
/*    0x42     mii0_rxclk                input                        MII0 */
/*    0x43     mii0_rxd0                 input                        MII0 */
/*    0x44     mii0_rxd1                 input                        MII0 */
/*    0x45     mii0_rxd2                 input                        MII0 */
/*    0x46     mii0_rxd3                 input                        MII0 */
/*    0x47     mii0_rxdv                 input                        MII0 */
/*    0x48     mii0_rxer                 input                        MII0 */
/*    0x49     mii0_txclk                input                        MII0 */
/*    0x4a     mii0_txd0                 tristatable output           MII0 */
/*    0x4b     mii0_txd1                 tristatable output           MII0 */
/*    0x4c     mii0_txd2                 tristatable output           MII0 */
/*    0x4d     mii0_txd3                 tristatable output           MII0 */
/*    0x4e     mii0_txen                 nontristatable output        MII0 */
/*    0x4f     mii0_txer                 nontristatable output        MII0 */
/*    0x50     mii1_col                  input                        MII1 */
/*    0x51     mii1_crs                  input                        MII1 */
/*    0x52     mii1_led0                 input                        MII1 */
/*    0x53     mii1_led1                 input                        MII1 */
/*    0x54     mii1_led2                 input                        MII1 */
/*    0x55     mii1_led3                 input                        MII1 */
/*    0x56     mii1_rxclk                input                        MII1 */
/*    0x57     mii1_rxd0                 input                        MII1 */
/*    0x58     mii1_rxd1                 input                        MII1 */
/*    0x59     mii1_rxd2                 input                        MII1 */
/*    0x5a     mii1_rxd3                 input                        MII1 */
/*    0x5b     mii1_rxdv                 input                        MII1 */
/*    0x5c     mii1_rxer                 input                        MII1 */
/*    0x5d     mii1_txclk                input                        MII1 */
/*    0x5e     mii1_txd0                 tristatable output           MII1 */
/*    0x5f     mii1_txd1                 tristatable output           MII1 */
/*    0x60     mii1_txd2                 tristatable output           MII1 */
/*    0x61     mii1_txd3                 tristatable output           MII1 */
/*    0x62     mii1_txen                 nontristatable output        MII1 */
/*    0x63     mii1_txer                 nontristatable output        MII1 */
/*    0x64     pio0                      bidirectional                PIO */
/*    0x65     pio1                      bidirectional                PIO */
/*    0x66     pio2                      bidirectional                PIO */
/*    0x67     pio3                      bidirectional                PIO */
/*    0x68     pio4                      bidirectional                PIO */
/*    0x69     pio5                      bidirectional                PIO */
/*    0x6a     pio6                      bidirectional                PIO */
/*    0x6b     pio7                      bidirectional                PIO */
/*    0x6c     spi0_cs2n                 bidirectional                SPI0 3rd chip select */
/*    0x6d     spi1_clk                  bidirectional                SPI1 */
/*    0x6e     spi1_cs0n                 bidirectional                SPI1 */
/*    0x6f     spi1_cs1n                 bidirectional                SPI1 */
/*    0x70     spi1_cs2n                 bidirectional                SPI1 */
/*    0x71     spi1_miso                 bidirectional                SPI1 */
/*    0x72     spi1_mosi                 bidirectional                SPI1 */
/*    0x73     i2c_scl_mmio              bidirectional                I2C */
/*    0x74     i2c_sda_mmio              bidirectional                I2C */
/*    0x75     xc_sample0                input                        Trigger/Latch Unit */
/*    0x76     xc_sample1                input                        Trigger/Latch Unit */
/*    0x77     xc_trigger0               tristatable output           Trigger/Latch Unit */
/*    0x78     xc_trigger1               tristatable output           Trigger/Latch Unit */
/*    0x79     uart0_cts                 input                        UART 0 */
/*    0x7a     uart0_rts                 tristatable output           UART 0 */
/*    0x7b     uart0_rxd                 input                        UART 0 */
/*    0x7c     uart0_txd                 tristatable output           UART 0 */
/*    0x7d     uart1_cts                 input                        UART 1 */
/*    0x7e     uart1_rts                 tristatable output           UART 1 */
/*    0x7f     uart1_rxd                 input                        UART 1 */
/*    0x80     uart1_txd                 tristatable output           UART 1 */
/*    0x81     uart2_cts                 input                        UART 2 */
/*    0x82     uart2_rts                 tristatable output           UART 2 */
/*    0x83     uart2_rxd                 input                        UART 2 */
/*    0x84     uart2_txd                 tristatable output           UART 2 */
/*    0x85     usb_id_dig                input                        USB */
/*    0x86     usb_id_pullup_ctrl        nontristatable output        USB */
/*    0x87     usb_rpd_ena               nontristatable output        USB */
/*    0x88     usb_rpu_ena               nontristatable output        USB */
/*    0x89     ccd_data0                 input                        CCD-Sensor */
/*    0x8a     ccd_data1                 input                        CCD-Sensor */
/*    0x8b     ccd_data2                 input                        CCD-Sensor */
/*    0x8c     ccd_data3                 input                        CCD-Sensor */
/*    0x8d     ccd_data4                 input                        CCD-Sensor */
/*    0x8e     ccd_data5                 input                        CCD-Sensor */
/*    0x8f     ccd_data6                 input                        CCD-Sensor */
/*    0x90     ccd_data7                 input                        CCD-Sensor */
/*    0x91     ccd_pixclk                input                        CCD-Sensor */
/*    0x92     ccd_line_valid            input                        CCD-Sensor */
/*    0x93     ccd_frame_valid           input                        CCD-Sensor */
/*    0xff     nc                        force input state if unused  .} */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio0_cfg       0x00000000U
#define Adr_NX50_mmio_ctrl_mmio0_cfg 0x1C001300U
#define Adr_NX50_mmio0_cfg           0x1C001300U
#define DFLT_VAL_NX50_mmio0_cfg      0x00000012U

#define MSK_NX50_mmio0_cfg_mmio0_sel          0x000000ffU
#define SRT_NX50_mmio0_cfg_mmio0_sel          0
#define DFLT_VAL_NX50_mmio0_cfg_mmio0_sel     0x00000012U
#define MSK_NX50_mmio0_cfg_mmio0_out_inv      0x00000100U
#define SRT_NX50_mmio0_cfg_mmio0_out_inv      8
#define DFLT_VAL_NX50_mmio0_cfg_mmio0_out_inv 0x00000000U
#define MSK_NX50_mmio0_cfg_mmio0_in_inv       0x00000200U
#define SRT_NX50_mmio0_cfg_mmio0_in_inv       9
#define DFLT_VAL_NX50_mmio0_cfg_mmio0_in_inv  0x00000000U

enum {
	BFW_NX50_mmio0_cfg_mmio0_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio0_cfg_mmio0_out_inv = 1,  /* [8] */
	BFW_NX50_mmio0_cfg_mmio0_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio0_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO0_CFG_BIT_Ttag {
	unsigned int mmio0_sel     : BFW_NX50_mmio0_cfg_mmio0_sel;     /* MMIO0 signal selection (default: gpio0) */
	unsigned int mmio0_out_inv : BFW_NX50_mmio0_cfg_mmio0_out_inv; /* 1: invert output signal:                */
	                                                               /* 1: invert output signal                 */
	unsigned int mmio0_in_inv  : BFW_NX50_mmio0_cfg_mmio0_in_inv;  /* invert input:                           */
	                                                               /* 1: invert input signal                  */
	unsigned int reserved1     : BFW_NX50_mmio0_cfg_reserved1;     /* reserved                                */
} NX50_MMIO0_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO0_CFG_BIT_T bf;
} NX50_MMIO0_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio1_cfg */
/* => Multiplexmatrix Configuration Register for MMIO1 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio1_cfg       0x00000004U
#define Adr_NX50_mmio_ctrl_mmio1_cfg 0x1C001304U
#define Adr_NX50_mmio1_cfg           0x1C001304U
#define DFLT_VAL_NX50_mmio1_cfg      0x00000013U

#define MSK_NX50_mmio1_cfg_mmio1_sel          0x000000ffU
#define SRT_NX50_mmio1_cfg_mmio1_sel          0
#define DFLT_VAL_NX50_mmio1_cfg_mmio1_sel     0x00000013U
#define MSK_NX50_mmio1_cfg_mmio1_out_inv      0x00000100U
#define SRT_NX50_mmio1_cfg_mmio1_out_inv      8
#define DFLT_VAL_NX50_mmio1_cfg_mmio1_out_inv 0x00000000U
#define MSK_NX50_mmio1_cfg_mmio1_in_inv       0x00000200U
#define SRT_NX50_mmio1_cfg_mmio1_in_inv       9
#define DFLT_VAL_NX50_mmio1_cfg_mmio1_in_inv  0x00000000U

enum {
	BFW_NX50_mmio1_cfg_mmio1_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio1_cfg_mmio1_out_inv = 1,  /* [8] */
	BFW_NX50_mmio1_cfg_mmio1_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio1_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO1_CFG_BIT_Ttag {
	unsigned int mmio1_sel     : BFW_NX50_mmio1_cfg_mmio1_sel;     /* MMIO1 signal selection (default: gpio1)                   */
	unsigned int mmio1_out_inv : BFW_NX50_mmio1_cfg_mmio1_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio1_in_inv  : BFW_NX50_mmio1_cfg_mmio1_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio1_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO1_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO1_CFG_BIT_T bf;
} NX50_MMIO1_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio2_cfg */
/* => Multiplexmatrix Configuration Register for MMIO2 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio2_cfg       0x00000008U
#define Adr_NX50_mmio_ctrl_mmio2_cfg 0x1C001308U
#define Adr_NX50_mmio2_cfg           0x1C001308U
#define DFLT_VAL_NX50_mmio2_cfg      0x00000014U

#define MSK_NX50_mmio2_cfg_mmio2_sel          0x000000ffU
#define SRT_NX50_mmio2_cfg_mmio2_sel          0
#define DFLT_VAL_NX50_mmio2_cfg_mmio2_sel     0x00000014U
#define MSK_NX50_mmio2_cfg_mmio2_out_inv      0x00000100U
#define SRT_NX50_mmio2_cfg_mmio2_out_inv      8
#define DFLT_VAL_NX50_mmio2_cfg_mmio2_out_inv 0x00000000U
#define MSK_NX50_mmio2_cfg_mmio2_in_inv       0x00000200U
#define SRT_NX50_mmio2_cfg_mmio2_in_inv       9
#define DFLT_VAL_NX50_mmio2_cfg_mmio2_in_inv  0x00000000U

enum {
	BFW_NX50_mmio2_cfg_mmio2_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio2_cfg_mmio2_out_inv = 1,  /* [8] */
	BFW_NX50_mmio2_cfg_mmio2_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio2_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO2_CFG_BIT_Ttag {
	unsigned int mmio2_sel     : BFW_NX50_mmio2_cfg_mmio2_sel;     /* MMIO2 signal selection (default: gpio2)                   */
	unsigned int mmio2_out_inv : BFW_NX50_mmio2_cfg_mmio2_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio2_in_inv  : BFW_NX50_mmio2_cfg_mmio2_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio2_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO2_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO2_CFG_BIT_T bf;
} NX50_MMIO2_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio3_cfg */
/* => Multiplexmatrix Configuration Register for MMIO3 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio3_cfg       0x0000000CU
#define Adr_NX50_mmio_ctrl_mmio3_cfg 0x1C00130CU
#define Adr_NX50_mmio3_cfg           0x1C00130CU
#define DFLT_VAL_NX50_mmio3_cfg      0x00000015U

#define MSK_NX50_mmio3_cfg_mmio3_sel          0x000000ffU
#define SRT_NX50_mmio3_cfg_mmio3_sel          0
#define DFLT_VAL_NX50_mmio3_cfg_mmio3_sel     0x00000015U
#define MSK_NX50_mmio3_cfg_mmio3_out_inv      0x00000100U
#define SRT_NX50_mmio3_cfg_mmio3_out_inv      8
#define DFLT_VAL_NX50_mmio3_cfg_mmio3_out_inv 0x00000000U
#define MSK_NX50_mmio3_cfg_mmio3_in_inv       0x00000200U
#define SRT_NX50_mmio3_cfg_mmio3_in_inv       9
#define DFLT_VAL_NX50_mmio3_cfg_mmio3_in_inv  0x00000000U

enum {
	BFW_NX50_mmio3_cfg_mmio3_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio3_cfg_mmio3_out_inv = 1,  /* [8] */
	BFW_NX50_mmio3_cfg_mmio3_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio3_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO3_CFG_BIT_Ttag {
	unsigned int mmio3_sel     : BFW_NX50_mmio3_cfg_mmio3_sel;     /* MMIO3 signal selection (default: gpio3)                   */
	unsigned int mmio3_out_inv : BFW_NX50_mmio3_cfg_mmio3_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio3_in_inv  : BFW_NX50_mmio3_cfg_mmio3_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio3_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO3_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO3_CFG_BIT_T bf;
} NX50_MMIO3_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio4_cfg */
/* => Multiplexmatrix Configuration Register for MMIO4 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio4_cfg       0x00000010U
#define Adr_NX50_mmio_ctrl_mmio4_cfg 0x1C001310U
#define Adr_NX50_mmio4_cfg           0x1C001310U
#define DFLT_VAL_NX50_mmio4_cfg      0x00000016U

#define MSK_NX50_mmio4_cfg_mmio4_sel          0x000000ffU
#define SRT_NX50_mmio4_cfg_mmio4_sel          0
#define DFLT_VAL_NX50_mmio4_cfg_mmio4_sel     0x00000016U
#define MSK_NX50_mmio4_cfg_mmio4_out_inv      0x00000100U
#define SRT_NX50_mmio4_cfg_mmio4_out_inv      8
#define DFLT_VAL_NX50_mmio4_cfg_mmio4_out_inv 0x00000000U
#define MSK_NX50_mmio4_cfg_mmio4_in_inv       0x00000200U
#define SRT_NX50_mmio4_cfg_mmio4_in_inv       9
#define DFLT_VAL_NX50_mmio4_cfg_mmio4_in_inv  0x00000000U

enum {
	BFW_NX50_mmio4_cfg_mmio4_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio4_cfg_mmio4_out_inv = 1,  /* [8] */
	BFW_NX50_mmio4_cfg_mmio4_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio4_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO4_CFG_BIT_Ttag {
	unsigned int mmio4_sel     : BFW_NX50_mmio4_cfg_mmio4_sel;     /* MMIO4 signal selection (default: gpio4)                   */
	unsigned int mmio4_out_inv : BFW_NX50_mmio4_cfg_mmio4_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio4_in_inv  : BFW_NX50_mmio4_cfg_mmio4_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio4_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO4_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO4_CFG_BIT_T bf;
} NX50_MMIO4_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio5_cfg */
/* => Multiplexmatrix Configuration Register for MMIO5 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio5_cfg       0x00000014U
#define Adr_NX50_mmio_ctrl_mmio5_cfg 0x1C001314U
#define Adr_NX50_mmio5_cfg           0x1C001314U
#define DFLT_VAL_NX50_mmio5_cfg      0x00000017U

#define MSK_NX50_mmio5_cfg_mmio5_sel          0x000000ffU
#define SRT_NX50_mmio5_cfg_mmio5_sel          0
#define DFLT_VAL_NX50_mmio5_cfg_mmio5_sel     0x00000017U
#define MSK_NX50_mmio5_cfg_mmio5_out_inv      0x00000100U
#define SRT_NX50_mmio5_cfg_mmio5_out_inv      8
#define DFLT_VAL_NX50_mmio5_cfg_mmio5_out_inv 0x00000000U
#define MSK_NX50_mmio5_cfg_mmio5_in_inv       0x00000200U
#define SRT_NX50_mmio5_cfg_mmio5_in_inv       9
#define DFLT_VAL_NX50_mmio5_cfg_mmio5_in_inv  0x00000000U

enum {
	BFW_NX50_mmio5_cfg_mmio5_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio5_cfg_mmio5_out_inv = 1,  /* [8] */
	BFW_NX50_mmio5_cfg_mmio5_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio5_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO5_CFG_BIT_Ttag {
	unsigned int mmio5_sel     : BFW_NX50_mmio5_cfg_mmio5_sel;     /* MMIO5 signal selection (default: gpio5)                   */
	unsigned int mmio5_out_inv : BFW_NX50_mmio5_cfg_mmio5_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio5_in_inv  : BFW_NX50_mmio5_cfg_mmio5_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio5_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO5_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO5_CFG_BIT_T bf;
} NX50_MMIO5_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio6_cfg */
/* => Multiplexmatrix Configuration Register for MMIO6 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio6_cfg       0x00000018U
#define Adr_NX50_mmio_ctrl_mmio6_cfg 0x1C001318U
#define Adr_NX50_mmio6_cfg           0x1C001318U
#define DFLT_VAL_NX50_mmio6_cfg      0x00000018U

#define MSK_NX50_mmio6_cfg_mmio6_sel          0x000000ffU
#define SRT_NX50_mmio6_cfg_mmio6_sel          0
#define DFLT_VAL_NX50_mmio6_cfg_mmio6_sel     0x00000018U
#define MSK_NX50_mmio6_cfg_mmio6_out_inv      0x00000100U
#define SRT_NX50_mmio6_cfg_mmio6_out_inv      8
#define DFLT_VAL_NX50_mmio6_cfg_mmio6_out_inv 0x00000000U
#define MSK_NX50_mmio6_cfg_mmio6_in_inv       0x00000200U
#define SRT_NX50_mmio6_cfg_mmio6_in_inv       9
#define DFLT_VAL_NX50_mmio6_cfg_mmio6_in_inv  0x00000000U

enum {
	BFW_NX50_mmio6_cfg_mmio6_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio6_cfg_mmio6_out_inv = 1,  /* [8] */
	BFW_NX50_mmio6_cfg_mmio6_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio6_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO6_CFG_BIT_Ttag {
	unsigned int mmio6_sel     : BFW_NX50_mmio6_cfg_mmio6_sel;     /* MMIO6 signal selection (default: gpio6)                   */
	unsigned int mmio6_out_inv : BFW_NX50_mmio6_cfg_mmio6_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio6_in_inv  : BFW_NX50_mmio6_cfg_mmio6_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio6_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO6_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO6_CFG_BIT_T bf;
} NX50_MMIO6_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio7_cfg */
/* => Multiplexmatrix Configuration Register for MMIO7 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio7_cfg       0x0000001CU
#define Adr_NX50_mmio_ctrl_mmio7_cfg 0x1C00131CU
#define Adr_NX50_mmio7_cfg           0x1C00131CU
#define DFLT_VAL_NX50_mmio7_cfg      0x00000019U

#define MSK_NX50_mmio7_cfg_mmio7_sel          0x000000ffU
#define SRT_NX50_mmio7_cfg_mmio7_sel          0
#define DFLT_VAL_NX50_mmio7_cfg_mmio7_sel     0x00000019U
#define MSK_NX50_mmio7_cfg_mmio7_out_inv      0x00000100U
#define SRT_NX50_mmio7_cfg_mmio7_out_inv      8
#define DFLT_VAL_NX50_mmio7_cfg_mmio7_out_inv 0x00000000U
#define MSK_NX50_mmio7_cfg_mmio7_in_inv       0x00000200U
#define SRT_NX50_mmio7_cfg_mmio7_in_inv       9
#define DFLT_VAL_NX50_mmio7_cfg_mmio7_in_inv  0x00000000U

enum {
	BFW_NX50_mmio7_cfg_mmio7_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio7_cfg_mmio7_out_inv = 1,  /* [8] */
	BFW_NX50_mmio7_cfg_mmio7_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio7_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO7_CFG_BIT_Ttag {
	unsigned int mmio7_sel     : BFW_NX50_mmio7_cfg_mmio7_sel;     /* MMIO7 signal selection (default: gpio7)                   */
	unsigned int mmio7_out_inv : BFW_NX50_mmio7_cfg_mmio7_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio7_in_inv  : BFW_NX50_mmio7_cfg_mmio7_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio7_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO7_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO7_CFG_BIT_T bf;
} NX50_MMIO7_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio8_cfg */
/* => Multiplexmatrix Configuration Register for MMIO8 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio8_cfg       0x00000020U
#define Adr_NX50_mmio_ctrl_mmio8_cfg 0x1C001320U
#define Adr_NX50_mmio8_cfg           0x1C001320U
#define DFLT_VAL_NX50_mmio8_cfg      0x0000001aU

#define MSK_NX50_mmio8_cfg_mmio8_sel          0x000000ffU
#define SRT_NX50_mmio8_cfg_mmio8_sel          0
#define DFLT_VAL_NX50_mmio8_cfg_mmio8_sel     0x0000001aU
#define MSK_NX50_mmio8_cfg_mmio8_out_inv      0x00000100U
#define SRT_NX50_mmio8_cfg_mmio8_out_inv      8
#define DFLT_VAL_NX50_mmio8_cfg_mmio8_out_inv 0x00000000U
#define MSK_NX50_mmio8_cfg_mmio8_in_inv       0x00000200U
#define SRT_NX50_mmio8_cfg_mmio8_in_inv       9
#define DFLT_VAL_NX50_mmio8_cfg_mmio8_in_inv  0x00000000U

enum {
	BFW_NX50_mmio8_cfg_mmio8_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio8_cfg_mmio8_out_inv = 1,  /* [8] */
	BFW_NX50_mmio8_cfg_mmio8_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio8_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO8_CFG_BIT_Ttag {
	unsigned int mmio8_sel     : BFW_NX50_mmio8_cfg_mmio8_sel;     /* MMIO8 signal selection (default: gpio8)                   */
	unsigned int mmio8_out_inv : BFW_NX50_mmio8_cfg_mmio8_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio8_in_inv  : BFW_NX50_mmio8_cfg_mmio8_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio8_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO8_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO8_CFG_BIT_T bf;
} NX50_MMIO8_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio9_cfg */
/* => Multiplexmatrix Configuration Register for MMIO9 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio9_cfg       0x00000024U
#define Adr_NX50_mmio_ctrl_mmio9_cfg 0x1C001324U
#define Adr_NX50_mmio9_cfg           0x1C001324U
#define DFLT_VAL_NX50_mmio9_cfg      0x0000001bU

#define MSK_NX50_mmio9_cfg_mmio9_sel          0x000000ffU
#define SRT_NX50_mmio9_cfg_mmio9_sel          0
#define DFLT_VAL_NX50_mmio9_cfg_mmio9_sel     0x0000001bU
#define MSK_NX50_mmio9_cfg_mmio9_out_inv      0x00000100U
#define SRT_NX50_mmio9_cfg_mmio9_out_inv      8
#define DFLT_VAL_NX50_mmio9_cfg_mmio9_out_inv 0x00000000U
#define MSK_NX50_mmio9_cfg_mmio9_in_inv       0x00000200U
#define SRT_NX50_mmio9_cfg_mmio9_in_inv       9
#define DFLT_VAL_NX50_mmio9_cfg_mmio9_in_inv  0x00000000U

enum {
	BFW_NX50_mmio9_cfg_mmio9_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio9_cfg_mmio9_out_inv = 1,  /* [8] */
	BFW_NX50_mmio9_cfg_mmio9_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio9_cfg_reserved1     = 22  /* [31:10] */
};

typedef struct NX50_MMIO9_CFG_BIT_Ttag {
	unsigned int mmio9_sel     : BFW_NX50_mmio9_cfg_mmio9_sel;     /* MMIO9 signal selection (default: gpio9)                   */
	unsigned int mmio9_out_inv : BFW_NX50_mmio9_cfg_mmio9_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio9_in_inv  : BFW_NX50_mmio9_cfg_mmio9_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1     : BFW_NX50_mmio9_cfg_reserved1;     /* reserved                                                  */
} NX50_MMIO9_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX50_MMIO9_CFG_BIT_T bf;
} NX50_MMIO9_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio10_cfg */
/* => Multiplexmatrix Configuration Register for MMIO10 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio10_cfg       0x00000028U
#define Adr_NX50_mmio_ctrl_mmio10_cfg 0x1C001328U
#define Adr_NX50_mmio10_cfg           0x1C001328U
#define DFLT_VAL_NX50_mmio10_cfg      0x0000001cU

#define MSK_NX50_mmio10_cfg_mmio10_sel          0x000000ffU
#define SRT_NX50_mmio10_cfg_mmio10_sel          0
#define DFLT_VAL_NX50_mmio10_cfg_mmio10_sel     0x0000001cU
#define MSK_NX50_mmio10_cfg_mmio10_out_inv      0x00000100U
#define SRT_NX50_mmio10_cfg_mmio10_out_inv      8
#define DFLT_VAL_NX50_mmio10_cfg_mmio10_out_inv 0x00000000U
#define MSK_NX50_mmio10_cfg_mmio10_in_inv       0x00000200U
#define SRT_NX50_mmio10_cfg_mmio10_in_inv       9
#define DFLT_VAL_NX50_mmio10_cfg_mmio10_in_inv  0x00000000U

enum {
	BFW_NX50_mmio10_cfg_mmio10_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio10_cfg_mmio10_out_inv = 1,  /* [8] */
	BFW_NX50_mmio10_cfg_mmio10_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio10_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO10_CFG_BIT_Ttag {
	unsigned int mmio10_sel     : BFW_NX50_mmio10_cfg_mmio10_sel;     /* MMIO10 signal selection (default: gpio10)                 */
	unsigned int mmio10_out_inv : BFW_NX50_mmio10_cfg_mmio10_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio10_in_inv  : BFW_NX50_mmio10_cfg_mmio10_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio10_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO10_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO10_CFG_BIT_T bf;
} NX50_MMIO10_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio11_cfg */
/* => Multiplexmatrix Configuration Register for MMIO11 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio11_cfg       0x0000002CU
#define Adr_NX50_mmio_ctrl_mmio11_cfg 0x1C00132CU
#define Adr_NX50_mmio11_cfg           0x1C00132CU
#define DFLT_VAL_NX50_mmio11_cfg      0x0000001dU

#define MSK_NX50_mmio11_cfg_mmio11_sel          0x000000ffU
#define SRT_NX50_mmio11_cfg_mmio11_sel          0
#define DFLT_VAL_NX50_mmio11_cfg_mmio11_sel     0x0000001dU
#define MSK_NX50_mmio11_cfg_mmio11_out_inv      0x00000100U
#define SRT_NX50_mmio11_cfg_mmio11_out_inv      8
#define DFLT_VAL_NX50_mmio11_cfg_mmio11_out_inv 0x00000000U
#define MSK_NX50_mmio11_cfg_mmio11_in_inv       0x00000200U
#define SRT_NX50_mmio11_cfg_mmio11_in_inv       9
#define DFLT_VAL_NX50_mmio11_cfg_mmio11_in_inv  0x00000000U

enum {
	BFW_NX50_mmio11_cfg_mmio11_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio11_cfg_mmio11_out_inv = 1,  /* [8] */
	BFW_NX50_mmio11_cfg_mmio11_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio11_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO11_CFG_BIT_Ttag {
	unsigned int mmio11_sel     : BFW_NX50_mmio11_cfg_mmio11_sel;     /* MMIO11 signal selection (default: gpio11)                 */
	unsigned int mmio11_out_inv : BFW_NX50_mmio11_cfg_mmio11_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio11_in_inv  : BFW_NX50_mmio11_cfg_mmio11_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio11_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO11_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO11_CFG_BIT_T bf;
} NX50_MMIO11_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio12_cfg */
/* => Multiplexmatrix Configuration Register for MMIO12 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio12_cfg       0x00000030U
#define Adr_NX50_mmio_ctrl_mmio12_cfg 0x1C001330U
#define Adr_NX50_mmio12_cfg           0x1C001330U
#define DFLT_VAL_NX50_mmio12_cfg      0x0000001eU

#define MSK_NX50_mmio12_cfg_mmio12_sel          0x000000ffU
#define SRT_NX50_mmio12_cfg_mmio12_sel          0
#define DFLT_VAL_NX50_mmio12_cfg_mmio12_sel     0x0000001eU
#define MSK_NX50_mmio12_cfg_mmio12_out_inv      0x00000100U
#define SRT_NX50_mmio12_cfg_mmio12_out_inv      8
#define DFLT_VAL_NX50_mmio12_cfg_mmio12_out_inv 0x00000000U
#define MSK_NX50_mmio12_cfg_mmio12_in_inv       0x00000200U
#define SRT_NX50_mmio12_cfg_mmio12_in_inv       9
#define DFLT_VAL_NX50_mmio12_cfg_mmio12_in_inv  0x00000000U

enum {
	BFW_NX50_mmio12_cfg_mmio12_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio12_cfg_mmio12_out_inv = 1,  /* [8] */
	BFW_NX50_mmio12_cfg_mmio12_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio12_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO12_CFG_BIT_Ttag {
	unsigned int mmio12_sel     : BFW_NX50_mmio12_cfg_mmio12_sel;     /* MMIO12 signal selection (default: gpio12)                 */
	unsigned int mmio12_out_inv : BFW_NX50_mmio12_cfg_mmio12_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio12_in_inv  : BFW_NX50_mmio12_cfg_mmio12_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio12_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO12_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO12_CFG_BIT_T bf;
} NX50_MMIO12_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio13_cfg */
/* => Multiplexmatrix Configuration Register for MMIO13 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio13_cfg       0x00000034U
#define Adr_NX50_mmio_ctrl_mmio13_cfg 0x1C001334U
#define Adr_NX50_mmio13_cfg           0x1C001334U
#define DFLT_VAL_NX50_mmio13_cfg      0x0000001fU

#define MSK_NX50_mmio13_cfg_mmio13_sel          0x000000ffU
#define SRT_NX50_mmio13_cfg_mmio13_sel          0
#define DFLT_VAL_NX50_mmio13_cfg_mmio13_sel     0x0000001fU
#define MSK_NX50_mmio13_cfg_mmio13_out_inv      0x00000100U
#define SRT_NX50_mmio13_cfg_mmio13_out_inv      8
#define DFLT_VAL_NX50_mmio13_cfg_mmio13_out_inv 0x00000000U
#define MSK_NX50_mmio13_cfg_mmio13_in_inv       0x00000200U
#define SRT_NX50_mmio13_cfg_mmio13_in_inv       9
#define DFLT_VAL_NX50_mmio13_cfg_mmio13_in_inv  0x00000000U

enum {
	BFW_NX50_mmio13_cfg_mmio13_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio13_cfg_mmio13_out_inv = 1,  /* [8] */
	BFW_NX50_mmio13_cfg_mmio13_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio13_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO13_CFG_BIT_Ttag {
	unsigned int mmio13_sel     : BFW_NX50_mmio13_cfg_mmio13_sel;     /* MMIO13 signal selection (default: gpio13)                 */
	unsigned int mmio13_out_inv : BFW_NX50_mmio13_cfg_mmio13_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio13_in_inv  : BFW_NX50_mmio13_cfg_mmio13_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio13_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO13_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO13_CFG_BIT_T bf;
} NX50_MMIO13_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio14_cfg */
/* => Multiplexmatrix Configuration Register for MMIO14 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio14_cfg       0x00000038U
#define Adr_NX50_mmio_ctrl_mmio14_cfg 0x1C001338U
#define Adr_NX50_mmio14_cfg           0x1C001338U
#define DFLT_VAL_NX50_mmio14_cfg      0x00000020U

#define MSK_NX50_mmio14_cfg_mmio14_sel          0x000000ffU
#define SRT_NX50_mmio14_cfg_mmio14_sel          0
#define DFLT_VAL_NX50_mmio14_cfg_mmio14_sel     0x00000020U
#define MSK_NX50_mmio14_cfg_mmio14_out_inv      0x00000100U
#define SRT_NX50_mmio14_cfg_mmio14_out_inv      8
#define DFLT_VAL_NX50_mmio14_cfg_mmio14_out_inv 0x00000000U
#define MSK_NX50_mmio14_cfg_mmio14_in_inv       0x00000200U
#define SRT_NX50_mmio14_cfg_mmio14_in_inv       9
#define DFLT_VAL_NX50_mmio14_cfg_mmio14_in_inv  0x00000000U

enum {
	BFW_NX50_mmio14_cfg_mmio14_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio14_cfg_mmio14_out_inv = 1,  /* [8] */
	BFW_NX50_mmio14_cfg_mmio14_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio14_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO14_CFG_BIT_Ttag {
	unsigned int mmio14_sel     : BFW_NX50_mmio14_cfg_mmio14_sel;     /* MMIO14 signal selection (default: gpio14)                 */
	unsigned int mmio14_out_inv : BFW_NX50_mmio14_cfg_mmio14_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio14_in_inv  : BFW_NX50_mmio14_cfg_mmio14_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio14_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO14_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO14_CFG_BIT_T bf;
} NX50_MMIO14_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio15_cfg */
/* => Multiplexmatrix Configuration Register for MMIO15 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio15_cfg       0x0000003CU
#define Adr_NX50_mmio_ctrl_mmio15_cfg 0x1C00133CU
#define Adr_NX50_mmio15_cfg           0x1C00133CU
#define DFLT_VAL_NX50_mmio15_cfg      0x00000021U

#define MSK_NX50_mmio15_cfg_mmio15_sel          0x000000ffU
#define SRT_NX50_mmio15_cfg_mmio15_sel          0
#define DFLT_VAL_NX50_mmio15_cfg_mmio15_sel     0x00000021U
#define MSK_NX50_mmio15_cfg_mmio15_out_inv      0x00000100U
#define SRT_NX50_mmio15_cfg_mmio15_out_inv      8
#define DFLT_VAL_NX50_mmio15_cfg_mmio15_out_inv 0x00000000U
#define MSK_NX50_mmio15_cfg_mmio15_in_inv       0x00000200U
#define SRT_NX50_mmio15_cfg_mmio15_in_inv       9
#define DFLT_VAL_NX50_mmio15_cfg_mmio15_in_inv  0x00000000U

enum {
	BFW_NX50_mmio15_cfg_mmio15_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio15_cfg_mmio15_out_inv = 1,  /* [8] */
	BFW_NX50_mmio15_cfg_mmio15_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio15_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO15_CFG_BIT_Ttag {
	unsigned int mmio15_sel     : BFW_NX50_mmio15_cfg_mmio15_sel;     /* MMIO15 signal selection (default: gpio15)                 */
	unsigned int mmio15_out_inv : BFW_NX50_mmio15_cfg_mmio15_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio15_in_inv  : BFW_NX50_mmio15_cfg_mmio15_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio15_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO15_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO15_CFG_BIT_T bf;
} NX50_MMIO15_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio16_cfg */
/* => Multiplexmatrix Configuration Register for MMIO16 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio16_cfg       0x00000040U
#define Adr_NX50_mmio_ctrl_mmio16_cfg 0x1C001340U
#define Adr_NX50_mmio16_cfg           0x1C001340U
#define DFLT_VAL_NX50_mmio16_cfg      0x00000022U

#define MSK_NX50_mmio16_cfg_mmio16_sel          0x000000ffU
#define SRT_NX50_mmio16_cfg_mmio16_sel          0
#define DFLT_VAL_NX50_mmio16_cfg_mmio16_sel     0x00000022U
#define MSK_NX50_mmio16_cfg_mmio16_out_inv      0x00000100U
#define SRT_NX50_mmio16_cfg_mmio16_out_inv      8
#define DFLT_VAL_NX50_mmio16_cfg_mmio16_out_inv 0x00000000U
#define MSK_NX50_mmio16_cfg_mmio16_in_inv       0x00000200U
#define SRT_NX50_mmio16_cfg_mmio16_in_inv       9
#define DFLT_VAL_NX50_mmio16_cfg_mmio16_in_inv  0x00000000U

enum {
	BFW_NX50_mmio16_cfg_mmio16_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio16_cfg_mmio16_out_inv = 1,  /* [8] */
	BFW_NX50_mmio16_cfg_mmio16_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio16_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO16_CFG_BIT_Ttag {
	unsigned int mmio16_sel     : BFW_NX50_mmio16_cfg_mmio16_sel;     /* MMIO16 signal selection (default: gpio16)                 */
	unsigned int mmio16_out_inv : BFW_NX50_mmio16_cfg_mmio16_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio16_in_inv  : BFW_NX50_mmio16_cfg_mmio16_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio16_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO16_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO16_CFG_BIT_T bf;
} NX50_MMIO16_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio17_cfg */
/* => Multiplexmatrix Configuration Register for MMIO17 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio17_cfg       0x00000044U
#define Adr_NX50_mmio_ctrl_mmio17_cfg 0x1C001344U
#define Adr_NX50_mmio17_cfg           0x1C001344U
#define DFLT_VAL_NX50_mmio17_cfg      0x00000023U

#define MSK_NX50_mmio17_cfg_mmio17_sel          0x000000ffU
#define SRT_NX50_mmio17_cfg_mmio17_sel          0
#define DFLT_VAL_NX50_mmio17_cfg_mmio17_sel     0x00000023U
#define MSK_NX50_mmio17_cfg_mmio17_out_inv      0x00000100U
#define SRT_NX50_mmio17_cfg_mmio17_out_inv      8
#define DFLT_VAL_NX50_mmio17_cfg_mmio17_out_inv 0x00000000U
#define MSK_NX50_mmio17_cfg_mmio17_in_inv       0x00000200U
#define SRT_NX50_mmio17_cfg_mmio17_in_inv       9
#define DFLT_VAL_NX50_mmio17_cfg_mmio17_in_inv  0x00000000U

enum {
	BFW_NX50_mmio17_cfg_mmio17_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio17_cfg_mmio17_out_inv = 1,  /* [8] */
	BFW_NX50_mmio17_cfg_mmio17_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio17_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO17_CFG_BIT_Ttag {
	unsigned int mmio17_sel     : BFW_NX50_mmio17_cfg_mmio17_sel;     /* MMIO17 signal selection (default: gpio17)                 */
	unsigned int mmio17_out_inv : BFW_NX50_mmio17_cfg_mmio17_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio17_in_inv  : BFW_NX50_mmio17_cfg_mmio17_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio17_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO17_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO17_CFG_BIT_T bf;
} NX50_MMIO17_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio18_cfg */
/* => Multiplexmatrix Configuration Register for MMIO18 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio18_cfg       0x00000048U
#define Adr_NX50_mmio_ctrl_mmio18_cfg 0x1C001348U
#define Adr_NX50_mmio18_cfg           0x1C001348U
#define DFLT_VAL_NX50_mmio18_cfg      0x00000024U

#define MSK_NX50_mmio18_cfg_mmio18_sel          0x000000ffU
#define SRT_NX50_mmio18_cfg_mmio18_sel          0
#define DFLT_VAL_NX50_mmio18_cfg_mmio18_sel     0x00000024U
#define MSK_NX50_mmio18_cfg_mmio18_out_inv      0x00000100U
#define SRT_NX50_mmio18_cfg_mmio18_out_inv      8
#define DFLT_VAL_NX50_mmio18_cfg_mmio18_out_inv 0x00000000U
#define MSK_NX50_mmio18_cfg_mmio18_in_inv       0x00000200U
#define SRT_NX50_mmio18_cfg_mmio18_in_inv       9
#define DFLT_VAL_NX50_mmio18_cfg_mmio18_in_inv  0x00000000U

enum {
	BFW_NX50_mmio18_cfg_mmio18_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio18_cfg_mmio18_out_inv = 1,  /* [8] */
	BFW_NX50_mmio18_cfg_mmio18_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio18_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO18_CFG_BIT_Ttag {
	unsigned int mmio18_sel     : BFW_NX50_mmio18_cfg_mmio18_sel;     /* MMIO18 signal selection (default: gpio18)                 */
	unsigned int mmio18_out_inv : BFW_NX50_mmio18_cfg_mmio18_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio18_in_inv  : BFW_NX50_mmio18_cfg_mmio18_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio18_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO18_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO18_CFG_BIT_T bf;
} NX50_MMIO18_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio19_cfg */
/* => Multiplexmatrix Configuration Register for MMIO19 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio19_cfg       0x0000004CU
#define Adr_NX50_mmio_ctrl_mmio19_cfg 0x1C00134CU
#define Adr_NX50_mmio19_cfg           0x1C00134CU
#define DFLT_VAL_NX50_mmio19_cfg      0x00000025U

#define MSK_NX50_mmio19_cfg_mmio19_sel          0x000000ffU
#define SRT_NX50_mmio19_cfg_mmio19_sel          0
#define DFLT_VAL_NX50_mmio19_cfg_mmio19_sel     0x00000025U
#define MSK_NX50_mmio19_cfg_mmio19_out_inv      0x00000100U
#define SRT_NX50_mmio19_cfg_mmio19_out_inv      8
#define DFLT_VAL_NX50_mmio19_cfg_mmio19_out_inv 0x00000000U
#define MSK_NX50_mmio19_cfg_mmio19_in_inv       0x00000200U
#define SRT_NX50_mmio19_cfg_mmio19_in_inv       9
#define DFLT_VAL_NX50_mmio19_cfg_mmio19_in_inv  0x00000000U

enum {
	BFW_NX50_mmio19_cfg_mmio19_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio19_cfg_mmio19_out_inv = 1,  /* [8] */
	BFW_NX50_mmio19_cfg_mmio19_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio19_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO19_CFG_BIT_Ttag {
	unsigned int mmio19_sel     : BFW_NX50_mmio19_cfg_mmio19_sel;     /* MMIO19 signal selection (default: gpio19)                 */
	unsigned int mmio19_out_inv : BFW_NX50_mmio19_cfg_mmio19_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio19_in_inv  : BFW_NX50_mmio19_cfg_mmio19_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio19_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO19_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO19_CFG_BIT_T bf;
} NX50_MMIO19_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio20_cfg */
/* => Multiplexmatrix Configuration Register for MMIO20 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio20_cfg       0x00000050U
#define Adr_NX50_mmio_ctrl_mmio20_cfg 0x1C001350U
#define Adr_NX50_mmio20_cfg           0x1C001350U
#define DFLT_VAL_NX50_mmio20_cfg      0x00000026U

#define MSK_NX50_mmio20_cfg_mmio20_sel          0x000000ffU
#define SRT_NX50_mmio20_cfg_mmio20_sel          0
#define DFLT_VAL_NX50_mmio20_cfg_mmio20_sel     0x00000026U
#define MSK_NX50_mmio20_cfg_mmio20_out_inv      0x00000100U
#define SRT_NX50_mmio20_cfg_mmio20_out_inv      8
#define DFLT_VAL_NX50_mmio20_cfg_mmio20_out_inv 0x00000000U
#define MSK_NX50_mmio20_cfg_mmio20_in_inv       0x00000200U
#define SRT_NX50_mmio20_cfg_mmio20_in_inv       9
#define DFLT_VAL_NX50_mmio20_cfg_mmio20_in_inv  0x00000000U

enum {
	BFW_NX50_mmio20_cfg_mmio20_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio20_cfg_mmio20_out_inv = 1,  /* [8] */
	BFW_NX50_mmio20_cfg_mmio20_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio20_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO20_CFG_BIT_Ttag {
	unsigned int mmio20_sel     : BFW_NX50_mmio20_cfg_mmio20_sel;     /* MMIO20 signal selection (default: gpio20)                 */
	unsigned int mmio20_out_inv : BFW_NX50_mmio20_cfg_mmio20_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio20_in_inv  : BFW_NX50_mmio20_cfg_mmio20_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio20_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO20_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO20_CFG_BIT_T bf;
} NX50_MMIO20_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio21_cfg */
/* => Multiplexmatrix Configuration Register for MMIO21 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio21_cfg       0x00000054U
#define Adr_NX50_mmio_ctrl_mmio21_cfg 0x1C001354U
#define Adr_NX50_mmio21_cfg           0x1C001354U
#define DFLT_VAL_NX50_mmio21_cfg      0x00000027U

#define MSK_NX50_mmio21_cfg_mmio21_sel          0x000000ffU
#define SRT_NX50_mmio21_cfg_mmio21_sel          0
#define DFLT_VAL_NX50_mmio21_cfg_mmio21_sel     0x00000027U
#define MSK_NX50_mmio21_cfg_mmio21_out_inv      0x00000100U
#define SRT_NX50_mmio21_cfg_mmio21_out_inv      8
#define DFLT_VAL_NX50_mmio21_cfg_mmio21_out_inv 0x00000000U
#define MSK_NX50_mmio21_cfg_mmio21_in_inv       0x00000200U
#define SRT_NX50_mmio21_cfg_mmio21_in_inv       9
#define DFLT_VAL_NX50_mmio21_cfg_mmio21_in_inv  0x00000000U

enum {
	BFW_NX50_mmio21_cfg_mmio21_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio21_cfg_mmio21_out_inv = 1,  /* [8] */
	BFW_NX50_mmio21_cfg_mmio21_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio21_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO21_CFG_BIT_Ttag {
	unsigned int mmio21_sel     : BFW_NX50_mmio21_cfg_mmio21_sel;     /* MMIO21 signal selection (default: gpio21)                 */
	unsigned int mmio21_out_inv : BFW_NX50_mmio21_cfg_mmio21_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio21_in_inv  : BFW_NX50_mmio21_cfg_mmio21_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio21_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO21_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO21_CFG_BIT_T bf;
} NX50_MMIO21_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio22_cfg */
/* => Multiplexmatrix Configuration Register for MMIO22 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio22_cfg       0x00000058U
#define Adr_NX50_mmio_ctrl_mmio22_cfg 0x1C001358U
#define Adr_NX50_mmio22_cfg           0x1C001358U
#define DFLT_VAL_NX50_mmio22_cfg      0x00000028U

#define MSK_NX50_mmio22_cfg_mmio22_sel          0x000000ffU
#define SRT_NX50_mmio22_cfg_mmio22_sel          0
#define DFLT_VAL_NX50_mmio22_cfg_mmio22_sel     0x00000028U
#define MSK_NX50_mmio22_cfg_mmio22_out_inv      0x00000100U
#define SRT_NX50_mmio22_cfg_mmio22_out_inv      8
#define DFLT_VAL_NX50_mmio22_cfg_mmio22_out_inv 0x00000000U
#define MSK_NX50_mmio22_cfg_mmio22_in_inv       0x00000200U
#define SRT_NX50_mmio22_cfg_mmio22_in_inv       9
#define DFLT_VAL_NX50_mmio22_cfg_mmio22_in_inv  0x00000000U

enum {
	BFW_NX50_mmio22_cfg_mmio22_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio22_cfg_mmio22_out_inv = 1,  /* [8] */
	BFW_NX50_mmio22_cfg_mmio22_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio22_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO22_CFG_BIT_Ttag {
	unsigned int mmio22_sel     : BFW_NX50_mmio22_cfg_mmio22_sel;     /* MMIO22 signal selection (default: gpio22)                 */
	unsigned int mmio22_out_inv : BFW_NX50_mmio22_cfg_mmio22_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio22_in_inv  : BFW_NX50_mmio22_cfg_mmio22_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio22_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO22_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO22_CFG_BIT_T bf;
} NX50_MMIO22_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio23_cfg */
/* => Multiplexmatrix Configuration Register for MMIO23 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio23_cfg       0x0000005CU
#define Adr_NX50_mmio_ctrl_mmio23_cfg 0x1C00135CU
#define Adr_NX50_mmio23_cfg           0x1C00135CU
#define DFLT_VAL_NX50_mmio23_cfg      0x00000029U

#define MSK_NX50_mmio23_cfg_mmio23_sel          0x000000ffU
#define SRT_NX50_mmio23_cfg_mmio23_sel          0
#define DFLT_VAL_NX50_mmio23_cfg_mmio23_sel     0x00000029U
#define MSK_NX50_mmio23_cfg_mmio23_out_inv      0x00000100U
#define SRT_NX50_mmio23_cfg_mmio23_out_inv      8
#define DFLT_VAL_NX50_mmio23_cfg_mmio23_out_inv 0x00000000U
#define MSK_NX50_mmio23_cfg_mmio23_in_inv       0x00000200U
#define SRT_NX50_mmio23_cfg_mmio23_in_inv       9
#define DFLT_VAL_NX50_mmio23_cfg_mmio23_in_inv  0x00000000U

enum {
	BFW_NX50_mmio23_cfg_mmio23_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio23_cfg_mmio23_out_inv = 1,  /* [8] */
	BFW_NX50_mmio23_cfg_mmio23_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio23_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO23_CFG_BIT_Ttag {
	unsigned int mmio23_sel     : BFW_NX50_mmio23_cfg_mmio23_sel;     /* MMIO23 signal selection (default: gpio23)                 */
	unsigned int mmio23_out_inv : BFW_NX50_mmio23_cfg_mmio23_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio23_in_inv  : BFW_NX50_mmio23_cfg_mmio23_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio23_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO23_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO23_CFG_BIT_T bf;
} NX50_MMIO23_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio24_cfg */
/* => Multiplexmatrix Configuration Register for MMIO24 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio24_cfg       0x00000060U
#define Adr_NX50_mmio_ctrl_mmio24_cfg 0x1C001360U
#define Adr_NX50_mmio24_cfg           0x1C001360U
#define DFLT_VAL_NX50_mmio24_cfg      0x0000002aU

#define MSK_NX50_mmio24_cfg_mmio24_sel          0x000000ffU
#define SRT_NX50_mmio24_cfg_mmio24_sel          0
#define DFLT_VAL_NX50_mmio24_cfg_mmio24_sel     0x0000002aU
#define MSK_NX50_mmio24_cfg_mmio24_out_inv      0x00000100U
#define SRT_NX50_mmio24_cfg_mmio24_out_inv      8
#define DFLT_VAL_NX50_mmio24_cfg_mmio24_out_inv 0x00000000U
#define MSK_NX50_mmio24_cfg_mmio24_in_inv       0x00000200U
#define SRT_NX50_mmio24_cfg_mmio24_in_inv       9
#define DFLT_VAL_NX50_mmio24_cfg_mmio24_in_inv  0x00000000U

enum {
	BFW_NX50_mmio24_cfg_mmio24_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio24_cfg_mmio24_out_inv = 1,  /* [8] */
	BFW_NX50_mmio24_cfg_mmio24_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio24_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO24_CFG_BIT_Ttag {
	unsigned int mmio24_sel     : BFW_NX50_mmio24_cfg_mmio24_sel;     /* MMIO24 signal selection (default: gpio24)                 */
	unsigned int mmio24_out_inv : BFW_NX50_mmio24_cfg_mmio24_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio24_in_inv  : BFW_NX50_mmio24_cfg_mmio24_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio24_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO24_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO24_CFG_BIT_T bf;
} NX50_MMIO24_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio25_cfg */
/* => Multiplexmatrix Configuration Register for MMIO25 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio25_cfg       0x00000064U
#define Adr_NX50_mmio_ctrl_mmio25_cfg 0x1C001364U
#define Adr_NX50_mmio25_cfg           0x1C001364U
#define DFLT_VAL_NX50_mmio25_cfg      0x0000002bU

#define MSK_NX50_mmio25_cfg_mmio25_sel          0x000000ffU
#define SRT_NX50_mmio25_cfg_mmio25_sel          0
#define DFLT_VAL_NX50_mmio25_cfg_mmio25_sel     0x0000002bU
#define MSK_NX50_mmio25_cfg_mmio25_out_inv      0x00000100U
#define SRT_NX50_mmio25_cfg_mmio25_out_inv      8
#define DFLT_VAL_NX50_mmio25_cfg_mmio25_out_inv 0x00000000U
#define MSK_NX50_mmio25_cfg_mmio25_in_inv       0x00000200U
#define SRT_NX50_mmio25_cfg_mmio25_in_inv       9
#define DFLT_VAL_NX50_mmio25_cfg_mmio25_in_inv  0x00000000U

enum {
	BFW_NX50_mmio25_cfg_mmio25_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio25_cfg_mmio25_out_inv = 1,  /* [8] */
	BFW_NX50_mmio25_cfg_mmio25_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio25_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO25_CFG_BIT_Ttag {
	unsigned int mmio25_sel     : BFW_NX50_mmio25_cfg_mmio25_sel;     /* MMIO25 signal selection (default: gpio25)                 */
	unsigned int mmio25_out_inv : BFW_NX50_mmio25_cfg_mmio25_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio25_in_inv  : BFW_NX50_mmio25_cfg_mmio25_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio25_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO25_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO25_CFG_BIT_T bf;
} NX50_MMIO25_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio26_cfg */
/* => Multiplexmatrix Configuration Register for MMIO26 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio26_cfg       0x00000068U
#define Adr_NX50_mmio_ctrl_mmio26_cfg 0x1C001368U
#define Adr_NX50_mmio26_cfg           0x1C001368U
#define DFLT_VAL_NX50_mmio26_cfg      0x0000002cU

#define MSK_NX50_mmio26_cfg_mmio26_sel          0x000000ffU
#define SRT_NX50_mmio26_cfg_mmio26_sel          0
#define DFLT_VAL_NX50_mmio26_cfg_mmio26_sel     0x0000002cU
#define MSK_NX50_mmio26_cfg_mmio26_out_inv      0x00000100U
#define SRT_NX50_mmio26_cfg_mmio26_out_inv      8
#define DFLT_VAL_NX50_mmio26_cfg_mmio26_out_inv 0x00000000U
#define MSK_NX50_mmio26_cfg_mmio26_in_inv       0x00000200U
#define SRT_NX50_mmio26_cfg_mmio26_in_inv       9
#define DFLT_VAL_NX50_mmio26_cfg_mmio26_in_inv  0x00000000U

enum {
	BFW_NX50_mmio26_cfg_mmio26_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio26_cfg_mmio26_out_inv = 1,  /* [8] */
	BFW_NX50_mmio26_cfg_mmio26_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio26_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO26_CFG_BIT_Ttag {
	unsigned int mmio26_sel     : BFW_NX50_mmio26_cfg_mmio26_sel;     /* MMIO26 signal selection (default: gpio26)                 */
	unsigned int mmio26_out_inv : BFW_NX50_mmio26_cfg_mmio26_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio26_in_inv  : BFW_NX50_mmio26_cfg_mmio26_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio26_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO26_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO26_CFG_BIT_T bf;
} NX50_MMIO26_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio27_cfg */
/* => Multiplexmatrix Configuration Register for MMIO27 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio27_cfg       0x0000006CU
#define Adr_NX50_mmio_ctrl_mmio27_cfg 0x1C00136CU
#define Adr_NX50_mmio27_cfg           0x1C00136CU
#define DFLT_VAL_NX50_mmio27_cfg      0x0000002dU

#define MSK_NX50_mmio27_cfg_mmio27_sel          0x000000ffU
#define SRT_NX50_mmio27_cfg_mmio27_sel          0
#define DFLT_VAL_NX50_mmio27_cfg_mmio27_sel     0x0000002dU
#define MSK_NX50_mmio27_cfg_mmio27_out_inv      0x00000100U
#define SRT_NX50_mmio27_cfg_mmio27_out_inv      8
#define DFLT_VAL_NX50_mmio27_cfg_mmio27_out_inv 0x00000000U
#define MSK_NX50_mmio27_cfg_mmio27_in_inv       0x00000200U
#define SRT_NX50_mmio27_cfg_mmio27_in_inv       9
#define DFLT_VAL_NX50_mmio27_cfg_mmio27_in_inv  0x00000000U

enum {
	BFW_NX50_mmio27_cfg_mmio27_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio27_cfg_mmio27_out_inv = 1,  /* [8] */
	BFW_NX50_mmio27_cfg_mmio27_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio27_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO27_CFG_BIT_Ttag {
	unsigned int mmio27_sel     : BFW_NX50_mmio27_cfg_mmio27_sel;     /* MMIO27 signal selection (default: gpio27)                 */
	unsigned int mmio27_out_inv : BFW_NX50_mmio27_cfg_mmio27_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio27_in_inv  : BFW_NX50_mmio27_cfg_mmio27_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio27_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO27_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO27_CFG_BIT_T bf;
} NX50_MMIO27_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio28_cfg */
/* => Multiplexmatrix Configuration Register for MMIO28 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio28_cfg       0x00000070U
#define Adr_NX50_mmio_ctrl_mmio28_cfg 0x1C001370U
#define Adr_NX50_mmio28_cfg           0x1C001370U
#define DFLT_VAL_NX50_mmio28_cfg      0x0000002eU

#define MSK_NX50_mmio28_cfg_mmio28_sel          0x000000ffU
#define SRT_NX50_mmio28_cfg_mmio28_sel          0
#define DFLT_VAL_NX50_mmio28_cfg_mmio28_sel     0x0000002eU
#define MSK_NX50_mmio28_cfg_mmio28_out_inv      0x00000100U
#define SRT_NX50_mmio28_cfg_mmio28_out_inv      8
#define DFLT_VAL_NX50_mmio28_cfg_mmio28_out_inv 0x00000000U
#define MSK_NX50_mmio28_cfg_mmio28_in_inv       0x00000200U
#define SRT_NX50_mmio28_cfg_mmio28_in_inv       9
#define DFLT_VAL_NX50_mmio28_cfg_mmio28_in_inv  0x00000000U

enum {
	BFW_NX50_mmio28_cfg_mmio28_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio28_cfg_mmio28_out_inv = 1,  /* [8] */
	BFW_NX50_mmio28_cfg_mmio28_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio28_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO28_CFG_BIT_Ttag {
	unsigned int mmio28_sel     : BFW_NX50_mmio28_cfg_mmio28_sel;     /* MMIO28 signal selection (default: gpio28)                 */
	unsigned int mmio28_out_inv : BFW_NX50_mmio28_cfg_mmio28_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio28_in_inv  : BFW_NX50_mmio28_cfg_mmio28_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio28_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO28_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO28_CFG_BIT_T bf;
} NX50_MMIO28_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio29_cfg */
/* => Multiplexmatrix Configuration Register for MMIO29 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio29_cfg       0x00000074U
#define Adr_NX50_mmio_ctrl_mmio29_cfg 0x1C001374U
#define Adr_NX50_mmio29_cfg           0x1C001374U
#define DFLT_VAL_NX50_mmio29_cfg      0x0000002fU

#define MSK_NX50_mmio29_cfg_mmio29_sel          0x000000ffU
#define SRT_NX50_mmio29_cfg_mmio29_sel          0
#define DFLT_VAL_NX50_mmio29_cfg_mmio29_sel     0x0000002fU
#define MSK_NX50_mmio29_cfg_mmio29_out_inv      0x00000100U
#define SRT_NX50_mmio29_cfg_mmio29_out_inv      8
#define DFLT_VAL_NX50_mmio29_cfg_mmio29_out_inv 0x00000000U
#define MSK_NX50_mmio29_cfg_mmio29_in_inv       0x00000200U
#define SRT_NX50_mmio29_cfg_mmio29_in_inv       9
#define DFLT_VAL_NX50_mmio29_cfg_mmio29_in_inv  0x00000000U

enum {
	BFW_NX50_mmio29_cfg_mmio29_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio29_cfg_mmio29_out_inv = 1,  /* [8] */
	BFW_NX50_mmio29_cfg_mmio29_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio29_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO29_CFG_BIT_Ttag {
	unsigned int mmio29_sel     : BFW_NX50_mmio29_cfg_mmio29_sel;     /* MMIO29 signal selection (default: gpio29)                 */
	unsigned int mmio29_out_inv : BFW_NX50_mmio29_cfg_mmio29_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio29_in_inv  : BFW_NX50_mmio29_cfg_mmio29_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio29_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO29_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO29_CFG_BIT_T bf;
} NX50_MMIO29_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio30_cfg */
/* => Multiplexmatrix Configuration Register for MMIO30 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio30_cfg       0x00000078U
#define Adr_NX50_mmio_ctrl_mmio30_cfg 0x1C001378U
#define Adr_NX50_mmio30_cfg           0x1C001378U
#define DFLT_VAL_NX50_mmio30_cfg      0x00000030U

#define MSK_NX50_mmio30_cfg_mmio30_sel          0x000000ffU
#define SRT_NX50_mmio30_cfg_mmio30_sel          0
#define DFLT_VAL_NX50_mmio30_cfg_mmio30_sel     0x00000030U
#define MSK_NX50_mmio30_cfg_mmio30_out_inv      0x00000100U
#define SRT_NX50_mmio30_cfg_mmio30_out_inv      8
#define DFLT_VAL_NX50_mmio30_cfg_mmio30_out_inv 0x00000000U
#define MSK_NX50_mmio30_cfg_mmio30_in_inv       0x00000200U
#define SRT_NX50_mmio30_cfg_mmio30_in_inv       9
#define DFLT_VAL_NX50_mmio30_cfg_mmio30_in_inv  0x00000000U

enum {
	BFW_NX50_mmio30_cfg_mmio30_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio30_cfg_mmio30_out_inv = 1,  /* [8] */
	BFW_NX50_mmio30_cfg_mmio30_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio30_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO30_CFG_BIT_Ttag {
	unsigned int mmio30_sel     : BFW_NX50_mmio30_cfg_mmio30_sel;     /* MMIO30 signal selection (default: gpio30)                 */
	unsigned int mmio30_out_inv : BFW_NX50_mmio30_cfg_mmio30_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio30_in_inv  : BFW_NX50_mmio30_cfg_mmio30_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio30_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO30_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO30_CFG_BIT_T bf;
} NX50_MMIO30_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio31_cfg */
/* => Multiplexmatrix Configuration Register for MMIO31 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio31_cfg       0x0000007CU
#define Adr_NX50_mmio_ctrl_mmio31_cfg 0x1C00137CU
#define Adr_NX50_mmio31_cfg           0x1C00137CU
#define DFLT_VAL_NX50_mmio31_cfg      0x00000031U

#define MSK_NX50_mmio31_cfg_mmio31_sel          0x000000ffU
#define SRT_NX50_mmio31_cfg_mmio31_sel          0
#define DFLT_VAL_NX50_mmio31_cfg_mmio31_sel     0x00000031U
#define MSK_NX50_mmio31_cfg_mmio31_out_inv      0x00000100U
#define SRT_NX50_mmio31_cfg_mmio31_out_inv      8
#define DFLT_VAL_NX50_mmio31_cfg_mmio31_out_inv 0x00000000U
#define MSK_NX50_mmio31_cfg_mmio31_in_inv       0x00000200U
#define SRT_NX50_mmio31_cfg_mmio31_in_inv       9
#define DFLT_VAL_NX50_mmio31_cfg_mmio31_in_inv  0x00000000U

enum {
	BFW_NX50_mmio31_cfg_mmio31_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio31_cfg_mmio31_out_inv = 1,  /* [8] */
	BFW_NX50_mmio31_cfg_mmio31_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio31_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO31_CFG_BIT_Ttag {
	unsigned int mmio31_sel     : BFW_NX50_mmio31_cfg_mmio31_sel;     /* MMIO31 signal selection (default: gpio31)                 */
	unsigned int mmio31_out_inv : BFW_NX50_mmio31_cfg_mmio31_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio31_in_inv  : BFW_NX50_mmio31_cfg_mmio31_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio31_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO31_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO31_CFG_BIT_T bf;
} NX50_MMIO31_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio32_cfg */
/* => Multiplexmatrix Configuration Register for MMIO32 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio32_cfg       0x00000080U
#define Adr_NX50_mmio_ctrl_mmio32_cfg 0x1C001380U
#define Adr_NX50_mmio32_cfg           0x1C001380U
#define DFLT_VAL_NX50_mmio32_cfg      0x00000079U

#define MSK_NX50_mmio32_cfg_mmio32_sel          0x000000ffU
#define SRT_NX50_mmio32_cfg_mmio32_sel          0
#define DFLT_VAL_NX50_mmio32_cfg_mmio32_sel     0x00000079U
#define MSK_NX50_mmio32_cfg_mmio32_out_inv      0x00000100U
#define SRT_NX50_mmio32_cfg_mmio32_out_inv      8
#define DFLT_VAL_NX50_mmio32_cfg_mmio32_out_inv 0x00000000U
#define MSK_NX50_mmio32_cfg_mmio32_in_inv       0x00000200U
#define SRT_NX50_mmio32_cfg_mmio32_in_inv       9
#define DFLT_VAL_NX50_mmio32_cfg_mmio32_in_inv  0x00000000U

enum {
	BFW_NX50_mmio32_cfg_mmio32_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio32_cfg_mmio32_out_inv = 1,  /* [8] */
	BFW_NX50_mmio32_cfg_mmio32_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio32_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO32_CFG_BIT_Ttag {
	unsigned int mmio32_sel     : BFW_NX50_mmio32_cfg_mmio32_sel;     /* MMIO32 signal selection (default: uart0_cts)              */
	unsigned int mmio32_out_inv : BFW_NX50_mmio32_cfg_mmio32_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio32_in_inv  : BFW_NX50_mmio32_cfg_mmio32_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio32_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO32_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO32_CFG_BIT_T bf;
} NX50_MMIO32_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio33_cfg */
/* => Multiplexmatrix Configuration Register for MMIO33 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio33_cfg       0x00000084U
#define Adr_NX50_mmio_ctrl_mmio33_cfg 0x1C001384U
#define Adr_NX50_mmio33_cfg           0x1C001384U
#define DFLT_VAL_NX50_mmio33_cfg      0x0000007aU

#define MSK_NX50_mmio33_cfg_mmio33_sel          0x000000ffU
#define SRT_NX50_mmio33_cfg_mmio33_sel          0
#define DFLT_VAL_NX50_mmio33_cfg_mmio33_sel     0x0000007aU
#define MSK_NX50_mmio33_cfg_mmio33_out_inv      0x00000100U
#define SRT_NX50_mmio33_cfg_mmio33_out_inv      8
#define DFLT_VAL_NX50_mmio33_cfg_mmio33_out_inv 0x00000000U
#define MSK_NX50_mmio33_cfg_mmio33_in_inv       0x00000200U
#define SRT_NX50_mmio33_cfg_mmio33_in_inv       9
#define DFLT_VAL_NX50_mmio33_cfg_mmio33_in_inv  0x00000000U

enum {
	BFW_NX50_mmio33_cfg_mmio33_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio33_cfg_mmio33_out_inv = 1,  /* [8] */
	BFW_NX50_mmio33_cfg_mmio33_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio33_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO33_CFG_BIT_Ttag {
	unsigned int mmio33_sel     : BFW_NX50_mmio33_cfg_mmio33_sel;     /* MMIO33 signal selection (default: uart0_rts)              */
	unsigned int mmio33_out_inv : BFW_NX50_mmio33_cfg_mmio33_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio33_in_inv  : BFW_NX50_mmio33_cfg_mmio33_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio33_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO33_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO33_CFG_BIT_T bf;
} NX50_MMIO33_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio34_cfg */
/* => Multiplexmatrix Configuration Register for MMIO34 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio34_cfg       0x00000088U
#define Adr_NX50_mmio_ctrl_mmio34_cfg 0x1C001388U
#define Adr_NX50_mmio34_cfg           0x1C001388U
#define DFLT_VAL_NX50_mmio34_cfg      0x0000007bU

#define MSK_NX50_mmio34_cfg_mmio34_sel          0x000000ffU
#define SRT_NX50_mmio34_cfg_mmio34_sel          0
#define DFLT_VAL_NX50_mmio34_cfg_mmio34_sel     0x0000007bU
#define MSK_NX50_mmio34_cfg_mmio34_out_inv      0x00000100U
#define SRT_NX50_mmio34_cfg_mmio34_out_inv      8
#define DFLT_VAL_NX50_mmio34_cfg_mmio34_out_inv 0x00000000U
#define MSK_NX50_mmio34_cfg_mmio34_in_inv       0x00000200U
#define SRT_NX50_mmio34_cfg_mmio34_in_inv       9
#define DFLT_VAL_NX50_mmio34_cfg_mmio34_in_inv  0x00000000U

enum {
	BFW_NX50_mmio34_cfg_mmio34_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio34_cfg_mmio34_out_inv = 1,  /* [8] */
	BFW_NX50_mmio34_cfg_mmio34_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio34_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO34_CFG_BIT_Ttag {
	unsigned int mmio34_sel     : BFW_NX50_mmio34_cfg_mmio34_sel;     /* MMIO34 signal selection (default: uart0_rxd)              */
	unsigned int mmio34_out_inv : BFW_NX50_mmio34_cfg_mmio34_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio34_in_inv  : BFW_NX50_mmio34_cfg_mmio34_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio34_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO34_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO34_CFG_BIT_T bf;
} NX50_MMIO34_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio35_cfg */
/* => Multiplexmatrix Configuration Register for MMIO35 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio35_cfg       0x0000008CU
#define Adr_NX50_mmio_ctrl_mmio35_cfg 0x1C00138CU
#define Adr_NX50_mmio35_cfg           0x1C00138CU
#define DFLT_VAL_NX50_mmio35_cfg      0x0000007cU

#define MSK_NX50_mmio35_cfg_mmio35_sel          0x000000ffU
#define SRT_NX50_mmio35_cfg_mmio35_sel          0
#define DFLT_VAL_NX50_mmio35_cfg_mmio35_sel     0x0000007cU
#define MSK_NX50_mmio35_cfg_mmio35_out_inv      0x00000100U
#define SRT_NX50_mmio35_cfg_mmio35_out_inv      8
#define DFLT_VAL_NX50_mmio35_cfg_mmio35_out_inv 0x00000000U
#define MSK_NX50_mmio35_cfg_mmio35_in_inv       0x00000200U
#define SRT_NX50_mmio35_cfg_mmio35_in_inv       9
#define DFLT_VAL_NX50_mmio35_cfg_mmio35_in_inv  0x00000000U

enum {
	BFW_NX50_mmio35_cfg_mmio35_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio35_cfg_mmio35_out_inv = 1,  /* [8] */
	BFW_NX50_mmio35_cfg_mmio35_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio35_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO35_CFG_BIT_Ttag {
	unsigned int mmio35_sel     : BFW_NX50_mmio35_cfg_mmio35_sel;     /* MMIO35 signal selection (default: uart0_txd)              */
	unsigned int mmio35_out_inv : BFW_NX50_mmio35_cfg_mmio35_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio35_in_inv  : BFW_NX50_mmio35_cfg_mmio35_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio35_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO35_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO35_CFG_BIT_T bf;
} NX50_MMIO35_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio36_cfg */
/* => Multiplexmatrix Configuration Register for MMIO36 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio36_cfg       0x00000090U
#define Adr_NX50_mmio_ctrl_mmio36_cfg 0x1C001390U
#define Adr_NX50_mmio36_cfg           0x1C001390U
#define DFLT_VAL_NX50_mmio36_cfg      0x00000085U

#define MSK_NX50_mmio36_cfg_mmio36_sel          0x000000ffU
#define SRT_NX50_mmio36_cfg_mmio36_sel          0
#define DFLT_VAL_NX50_mmio36_cfg_mmio36_sel     0x00000085U
#define MSK_NX50_mmio36_cfg_mmio36_out_inv      0x00000100U
#define SRT_NX50_mmio36_cfg_mmio36_out_inv      8
#define DFLT_VAL_NX50_mmio36_cfg_mmio36_out_inv 0x00000000U
#define MSK_NX50_mmio36_cfg_mmio36_in_inv       0x00000200U
#define SRT_NX50_mmio36_cfg_mmio36_in_inv       9
#define DFLT_VAL_NX50_mmio36_cfg_mmio36_in_inv  0x00000000U

enum {
	BFW_NX50_mmio36_cfg_mmio36_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio36_cfg_mmio36_out_inv = 1,  /* [8] */
	BFW_NX50_mmio36_cfg_mmio36_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio36_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO36_CFG_BIT_Ttag {
	unsigned int mmio36_sel     : BFW_NX50_mmio36_cfg_mmio36_sel;     /* MMIO36 signal selection (default: usb_id_dig)             */
	unsigned int mmio36_out_inv : BFW_NX50_mmio36_cfg_mmio36_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio36_in_inv  : BFW_NX50_mmio36_cfg_mmio36_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio36_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO36_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO36_CFG_BIT_T bf;
} NX50_MMIO36_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio37_cfg */
/* => Multiplexmatrix Configuration Register for MMIO37 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio37_cfg       0x00000094U
#define Adr_NX50_mmio_ctrl_mmio37_cfg 0x1C001394U
#define Adr_NX50_mmio37_cfg           0x1C001394U
#define DFLT_VAL_NX50_mmio37_cfg      0x000000ffU

#define MSK_NX50_mmio37_cfg_mmio37_sel          0x000000ffU
#define SRT_NX50_mmio37_cfg_mmio37_sel          0
#define DFLT_VAL_NX50_mmio37_cfg_mmio37_sel     0x000000ffU
#define MSK_NX50_mmio37_cfg_mmio37_out_inv      0x00000100U
#define SRT_NX50_mmio37_cfg_mmio37_out_inv      8
#define DFLT_VAL_NX50_mmio37_cfg_mmio37_out_inv 0x00000000U
#define MSK_NX50_mmio37_cfg_mmio37_in_inv       0x00000200U
#define SRT_NX50_mmio37_cfg_mmio37_in_inv       9
#define DFLT_VAL_NX50_mmio37_cfg_mmio37_in_inv  0x00000000U

enum {
	BFW_NX50_mmio37_cfg_mmio37_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio37_cfg_mmio37_out_inv = 1,  /* [8] */
	BFW_NX50_mmio37_cfg_mmio37_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio37_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO37_CFG_BIT_Ttag {
	unsigned int mmio37_sel     : BFW_NX50_mmio37_cfg_mmio37_sel;     /* MMIO37 signal selection (default: not connected)          */
	unsigned int mmio37_out_inv : BFW_NX50_mmio37_cfg_mmio37_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio37_in_inv  : BFW_NX50_mmio37_cfg_mmio37_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio37_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO37_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO37_CFG_BIT_T bf;
} NX50_MMIO37_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio38_cfg */
/* => Multiplexmatrix Configuration Register for MMIO38 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio38_cfg       0x00000098U
#define Adr_NX50_mmio_ctrl_mmio38_cfg 0x1C001398U
#define Adr_NX50_mmio38_cfg           0x1C001398U
#define DFLT_VAL_NX50_mmio38_cfg      0x000000ffU

#define MSK_NX50_mmio38_cfg_mmio38_sel          0x000000ffU
#define SRT_NX50_mmio38_cfg_mmio38_sel          0
#define DFLT_VAL_NX50_mmio38_cfg_mmio38_sel     0x000000ffU
#define MSK_NX50_mmio38_cfg_mmio38_out_inv      0x00000100U
#define SRT_NX50_mmio38_cfg_mmio38_out_inv      8
#define DFLT_VAL_NX50_mmio38_cfg_mmio38_out_inv 0x00000000U
#define MSK_NX50_mmio38_cfg_mmio38_in_inv       0x00000200U
#define SRT_NX50_mmio38_cfg_mmio38_in_inv       9
#define DFLT_VAL_NX50_mmio38_cfg_mmio38_in_inv  0x00000000U

enum {
	BFW_NX50_mmio38_cfg_mmio38_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio38_cfg_mmio38_out_inv = 1,  /* [8] */
	BFW_NX50_mmio38_cfg_mmio38_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio38_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO38_CFG_BIT_Ttag {
	unsigned int mmio38_sel     : BFW_NX50_mmio38_cfg_mmio38_sel;     /* MMIO38 signal selection (default: not connected)          */
	unsigned int mmio38_out_inv : BFW_NX50_mmio38_cfg_mmio38_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio38_in_inv  : BFW_NX50_mmio38_cfg_mmio38_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio38_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO38_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO38_CFG_BIT_T bf;
} NX50_MMIO38_CFG_T;

/* --------------------------------------------------------------------- */
/* Register mmio39_cfg */
/* => Multiplexmatrix Configuration Register for MMIO39 */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Core inputs not mapped to any MMIO will be assigned to 0. \ */
/*    If one core connection is mapped to more than one MMIO, the core-input-state will be these ored MMIO-states. */
/*    For signal selection coding (mmio*_sel) look at header of register mmio0_cfg. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mmio39_cfg       0x0000009CU
#define Adr_NX50_mmio_ctrl_mmio39_cfg 0x1C00139CU
#define Adr_NX50_mmio39_cfg           0x1C00139CU
#define DFLT_VAL_NX50_mmio39_cfg      0x000000ffU

#define MSK_NX50_mmio39_cfg_mmio39_sel          0x000000ffU
#define SRT_NX50_mmio39_cfg_mmio39_sel          0
#define DFLT_VAL_NX50_mmio39_cfg_mmio39_sel     0x000000ffU
#define MSK_NX50_mmio39_cfg_mmio39_out_inv      0x00000100U
#define SRT_NX50_mmio39_cfg_mmio39_out_inv      8
#define DFLT_VAL_NX50_mmio39_cfg_mmio39_out_inv 0x00000000U
#define MSK_NX50_mmio39_cfg_mmio39_in_inv       0x00000200U
#define SRT_NX50_mmio39_cfg_mmio39_in_inv       9
#define DFLT_VAL_NX50_mmio39_cfg_mmio39_in_inv  0x00000000U

enum {
	BFW_NX50_mmio39_cfg_mmio39_sel     = 8,  /* [7:0] */
	BFW_NX50_mmio39_cfg_mmio39_out_inv = 1,  /* [8] */
	BFW_NX50_mmio39_cfg_mmio39_in_inv  = 1,  /* [9] */
	BFW_NX50_mmio39_cfg_reserved1      = 22  /* [31:10] */
};

typedef struct NX50_MMIO39_CFG_BIT_Ttag {
	unsigned int mmio39_sel     : BFW_NX50_mmio39_cfg_mmio39_sel;     /* MMIO39 signal selection (default: not connected)          */
	unsigned int mmio39_out_inv : BFW_NX50_mmio39_cfg_mmio39_out_inv; /* 1: invert output signal; 0: keep original signal polarity */
	unsigned int mmio39_in_inv  : BFW_NX50_mmio39_cfg_mmio39_in_inv;  /* 1: invert input signal; 0: keep original signal polarity  */
	unsigned int reserved1      : BFW_NX50_mmio39_cfg_reserved1;      /* reserved                                                  */
} NX50_MMIO39_CFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_MMIO39_CFG_BIT_T bf;
} NX50_MMIO39_CFG_T;


/* ===================================================================== */

/* Area of hif */

/* ===================================================================== */

#define Addr_NX50_hif 0x1C003000U

/* ===================================================================== */

/* Area of host_controlled_dma_register_block */

/* ===================================================================== */

#define Addr_NX50_host_controlled_dma_register_block 0x1C003000U
#define NX50_NETX_DPM_HOST_DMA_AREA                  0x1C003000U

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_host_start                                0x00000000U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_host_start 0x1C003000U
#define Adr_NX50_dpmhs_ch0_host_start                                    0x1C003000U
#define DFLT_VAL_NX50_dpmhs_ch0_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch0_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH0_HOST_START_BIT_T bf;
} NX50_DPMHS_CH0_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_netx_start                                0x00000004U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_netx_start 0x1C003004U
#define Adr_NX50_dpmhs_ch0_netx_start                                    0x1C003004U
#define DFLT_VAL_NX50_dpmhs_ch0_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch0_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH0_NETX_START_BIT_T bf;
} NX50_DPMHS_CH0_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_dma_ctrl                                0x00000008U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_dma_ctrl 0x1C003008U
#define Adr_NX50_dpmhs_ch0_dma_ctrl                                    0x1C003008U
#define DFLT_VAL_NX50_dpmhs_ch0_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch0_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH0_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH0_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_host_mbx_base                                0x0000000CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_host_mbx_base 0x1C00300CU
#define Adr_NX50_dpmhs_ch0_host_mbx_base                                    0x1C00300CU
#define DFLT_VAL_NX50_dpmhs_ch0_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch0_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH0_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH0_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_buf_ctrl                                0x00000010U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_buf_ctrl 0x1C003010U
#define Adr_NX50_dpmhs_ch0_buf_ctrl                                    0x1C003010U
#define DFLT_VAL_NX50_dpmhs_ch0_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch0_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH0_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH0_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_host_buf3_base                                0x00000014U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_host_buf3_base 0x1C003014U
#define Adr_NX50_dpmhs_ch0_host_buf3_base                                    0x1C003014U
#define DFLT_VAL_NX50_dpmhs_ch0_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch0_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH0_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH0_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_host_buf2_base                                0x00000018U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_host_buf2_base 0x1C003018U
#define Adr_NX50_dpmhs_ch0_host_buf2_base                                    0x1C003018U
#define DFLT_VAL_NX50_dpmhs_ch0_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch0_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH0_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH0_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch0_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch0_host_buf1_base                                0x0000001CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch0_host_buf1_base 0x1C00301CU
#define Adr_NX50_dpmhs_ch0_host_buf1_base                                    0x1C00301CU
#define DFLT_VAL_NX50_dpmhs_ch0_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch0_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch0_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch0_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch0_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH0_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch0_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH0_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH0_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH0_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_host_start                                0x00000020U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_host_start 0x1C003020U
#define Adr_NX50_dpmhs_ch1_host_start                                    0x1C003020U
#define DFLT_VAL_NX50_dpmhs_ch1_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch1_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH1_HOST_START_BIT_T bf;
} NX50_DPMHS_CH1_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_netx_start                                0x00000024U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_netx_start 0x1C003024U
#define Adr_NX50_dpmhs_ch1_netx_start                                    0x1C003024U
#define DFLT_VAL_NX50_dpmhs_ch1_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch1_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH1_NETX_START_BIT_T bf;
} NX50_DPMHS_CH1_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_dma_ctrl                                0x00000028U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_dma_ctrl 0x1C003028U
#define Adr_NX50_dpmhs_ch1_dma_ctrl                                    0x1C003028U
#define DFLT_VAL_NX50_dpmhs_ch1_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch1_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH1_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH1_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_host_mbx_base                                0x0000002CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_host_mbx_base 0x1C00302CU
#define Adr_NX50_dpmhs_ch1_host_mbx_base                                    0x1C00302CU
#define DFLT_VAL_NX50_dpmhs_ch1_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch1_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH1_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH1_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_buf_ctrl                                0x00000030U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_buf_ctrl 0x1C003030U
#define Adr_NX50_dpmhs_ch1_buf_ctrl                                    0x1C003030U
#define DFLT_VAL_NX50_dpmhs_ch1_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch1_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH1_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH1_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_host_buf3_base                                0x00000034U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_host_buf3_base 0x1C003034U
#define Adr_NX50_dpmhs_ch1_host_buf3_base                                    0x1C003034U
#define DFLT_VAL_NX50_dpmhs_ch1_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch1_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH1_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH1_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_host_buf2_base                                0x00000038U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_host_buf2_base 0x1C003038U
#define Adr_NX50_dpmhs_ch1_host_buf2_base                                    0x1C003038U
#define DFLT_VAL_NX50_dpmhs_ch1_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch1_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH1_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH1_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch1_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch1_host_buf1_base                                0x0000003CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch1_host_buf1_base 0x1C00303CU
#define Adr_NX50_dpmhs_ch1_host_buf1_base                                    0x1C00303CU
#define DFLT_VAL_NX50_dpmhs_ch1_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch1_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch1_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch1_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch1_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH1_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch1_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH1_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH1_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH1_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_host_start                                0x00000040U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_host_start 0x1C003040U
#define Adr_NX50_dpmhs_ch2_host_start                                    0x1C003040U
#define DFLT_VAL_NX50_dpmhs_ch2_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch2_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH2_HOST_START_BIT_T bf;
} NX50_DPMHS_CH2_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_netx_start                                0x00000044U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_netx_start 0x1C003044U
#define Adr_NX50_dpmhs_ch2_netx_start                                    0x1C003044U
#define DFLT_VAL_NX50_dpmhs_ch2_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch2_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH2_NETX_START_BIT_T bf;
} NX50_DPMHS_CH2_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_dma_ctrl                                0x00000048U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_dma_ctrl 0x1C003048U
#define Adr_NX50_dpmhs_ch2_dma_ctrl                                    0x1C003048U
#define DFLT_VAL_NX50_dpmhs_ch2_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch2_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH2_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH2_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_host_mbx_base                                0x0000004CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_host_mbx_base 0x1C00304CU
#define Adr_NX50_dpmhs_ch2_host_mbx_base                                    0x1C00304CU
#define DFLT_VAL_NX50_dpmhs_ch2_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch2_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH2_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH2_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_buf_ctrl                                0x00000050U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_buf_ctrl 0x1C003050U
#define Adr_NX50_dpmhs_ch2_buf_ctrl                                    0x1C003050U
#define DFLT_VAL_NX50_dpmhs_ch2_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch2_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH2_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH2_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_host_buf3_base                                0x00000054U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_host_buf3_base 0x1C003054U
#define Adr_NX50_dpmhs_ch2_host_buf3_base                                    0x1C003054U
#define DFLT_VAL_NX50_dpmhs_ch2_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch2_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH2_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH2_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_host_buf2_base                                0x00000058U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_host_buf2_base 0x1C003058U
#define Adr_NX50_dpmhs_ch2_host_buf2_base                                    0x1C003058U
#define DFLT_VAL_NX50_dpmhs_ch2_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch2_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH2_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH2_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch2_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch2_host_buf1_base                                0x0000005CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch2_host_buf1_base 0x1C00305CU
#define Adr_NX50_dpmhs_ch2_host_buf1_base                                    0x1C00305CU
#define DFLT_VAL_NX50_dpmhs_ch2_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch2_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch2_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch2_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch2_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH2_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch2_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH2_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH2_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH2_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_host_start                                0x00000060U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_host_start 0x1C003060U
#define Adr_NX50_dpmhs_ch3_host_start                                    0x1C003060U
#define DFLT_VAL_NX50_dpmhs_ch3_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch3_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH3_HOST_START_BIT_T bf;
} NX50_DPMHS_CH3_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_netx_start                                0x00000064U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_netx_start 0x1C003064U
#define Adr_NX50_dpmhs_ch3_netx_start                                    0x1C003064U
#define DFLT_VAL_NX50_dpmhs_ch3_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch3_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH3_NETX_START_BIT_T bf;
} NX50_DPMHS_CH3_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_dma_ctrl                                0x00000068U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_dma_ctrl 0x1C003068U
#define Adr_NX50_dpmhs_ch3_dma_ctrl                                    0x1C003068U
#define DFLT_VAL_NX50_dpmhs_ch3_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch3_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH3_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH3_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_host_mbx_base                                0x0000006CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_host_mbx_base 0x1C00306CU
#define Adr_NX50_dpmhs_ch3_host_mbx_base                                    0x1C00306CU
#define DFLT_VAL_NX50_dpmhs_ch3_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch3_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH3_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH3_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_buf_ctrl                                0x00000070U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_buf_ctrl 0x1C003070U
#define Adr_NX50_dpmhs_ch3_buf_ctrl                                    0x1C003070U
#define DFLT_VAL_NX50_dpmhs_ch3_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch3_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH3_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH3_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_host_buf3_base                                0x00000074U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_host_buf3_base 0x1C003074U
#define Adr_NX50_dpmhs_ch3_host_buf3_base                                    0x1C003074U
#define DFLT_VAL_NX50_dpmhs_ch3_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch3_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH3_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH3_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_host_buf2_base                                0x00000078U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_host_buf2_base 0x1C003078U
#define Adr_NX50_dpmhs_ch3_host_buf2_base                                    0x1C003078U
#define DFLT_VAL_NX50_dpmhs_ch3_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch3_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH3_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH3_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch3_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch3_host_buf1_base                                0x0000007CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch3_host_buf1_base 0x1C00307CU
#define Adr_NX50_dpmhs_ch3_host_buf1_base                                    0x1C00307CU
#define DFLT_VAL_NX50_dpmhs_ch3_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch3_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch3_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch3_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch3_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH3_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch3_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH3_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH3_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH3_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_host_start                                0x00000080U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_host_start 0x1C003080U
#define Adr_NX50_dpmhs_ch4_host_start                                    0x1C003080U
#define DFLT_VAL_NX50_dpmhs_ch4_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch4_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH4_HOST_START_BIT_T bf;
} NX50_DPMHS_CH4_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_netx_start                                0x00000084U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_netx_start 0x1C003084U
#define Adr_NX50_dpmhs_ch4_netx_start                                    0x1C003084U
#define DFLT_VAL_NX50_dpmhs_ch4_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch4_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH4_NETX_START_BIT_T bf;
} NX50_DPMHS_CH4_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_dma_ctrl                                0x00000088U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_dma_ctrl 0x1C003088U
#define Adr_NX50_dpmhs_ch4_dma_ctrl                                    0x1C003088U
#define DFLT_VAL_NX50_dpmhs_ch4_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch4_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH4_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH4_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_host_mbx_base                                0x0000008CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_host_mbx_base 0x1C00308CU
#define Adr_NX50_dpmhs_ch4_host_mbx_base                                    0x1C00308CU
#define DFLT_VAL_NX50_dpmhs_ch4_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch4_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH4_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH4_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_buf_ctrl                                0x00000090U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_buf_ctrl 0x1C003090U
#define Adr_NX50_dpmhs_ch4_buf_ctrl                                    0x1C003090U
#define DFLT_VAL_NX50_dpmhs_ch4_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch4_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH4_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH4_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_host_buf3_base                                0x00000094U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_host_buf3_base 0x1C003094U
#define Adr_NX50_dpmhs_ch4_host_buf3_base                                    0x1C003094U
#define DFLT_VAL_NX50_dpmhs_ch4_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch4_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH4_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH4_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_host_buf2_base                                0x00000098U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_host_buf2_base 0x1C003098U
#define Adr_NX50_dpmhs_ch4_host_buf2_base                                    0x1C003098U
#define DFLT_VAL_NX50_dpmhs_ch4_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch4_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH4_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH4_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch4_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch4_host_buf1_base                                0x0000009CU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch4_host_buf1_base 0x1C00309CU
#define Adr_NX50_dpmhs_ch4_host_buf1_base                                    0x1C00309CU
#define DFLT_VAL_NX50_dpmhs_ch4_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch4_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch4_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch4_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch4_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH4_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch4_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH4_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH4_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH4_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_host_start                                0x000000A0U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_host_start 0x1C0030A0U
#define Adr_NX50_dpmhs_ch5_host_start                                    0x1C0030A0U
#define DFLT_VAL_NX50_dpmhs_ch5_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch5_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH5_HOST_START_BIT_T bf;
} NX50_DPMHS_CH5_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_netx_start                                0x000000A4U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_netx_start 0x1C0030A4U
#define Adr_NX50_dpmhs_ch5_netx_start                                    0x1C0030A4U
#define DFLT_VAL_NX50_dpmhs_ch5_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch5_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH5_NETX_START_BIT_T bf;
} NX50_DPMHS_CH5_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_dma_ctrl                                0x000000A8U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_dma_ctrl 0x1C0030A8U
#define Adr_NX50_dpmhs_ch5_dma_ctrl                                    0x1C0030A8U
#define DFLT_VAL_NX50_dpmhs_ch5_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch5_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH5_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH5_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_host_mbx_base                                0x000000ACU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_host_mbx_base 0x1C0030ACU
#define Adr_NX50_dpmhs_ch5_host_mbx_base                                    0x1C0030ACU
#define DFLT_VAL_NX50_dpmhs_ch5_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch5_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH5_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH5_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_buf_ctrl                                0x000000B0U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_buf_ctrl 0x1C0030B0U
#define Adr_NX50_dpmhs_ch5_buf_ctrl                                    0x1C0030B0U
#define DFLT_VAL_NX50_dpmhs_ch5_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch5_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH5_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH5_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_host_buf3_base                                0x000000B4U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_host_buf3_base 0x1C0030B4U
#define Adr_NX50_dpmhs_ch5_host_buf3_base                                    0x1C0030B4U
#define DFLT_VAL_NX50_dpmhs_ch5_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch5_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH5_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH5_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_host_buf2_base                                0x000000B8U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_host_buf2_base 0x1C0030B8U
#define Adr_NX50_dpmhs_ch5_host_buf2_base                                    0x1C0030B8U
#define DFLT_VAL_NX50_dpmhs_ch5_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch5_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH5_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH5_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch5_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch5_host_buf1_base                                0x000000BCU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch5_host_buf1_base 0x1C0030BCU
#define Adr_NX50_dpmhs_ch5_host_buf1_base                                    0x1C0030BCU
#define DFLT_VAL_NX50_dpmhs_ch5_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch5_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch5_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch5_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch5_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH5_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch5_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH5_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH5_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH5_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_host_start                                0x000000C0U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_host_start 0x1C0030C0U
#define Adr_NX50_dpmhs_ch6_host_start                                    0x1C0030C0U
#define DFLT_VAL_NX50_dpmhs_ch6_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch6_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH6_HOST_START_BIT_T bf;
} NX50_DPMHS_CH6_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_netx_start                                0x000000C4U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_netx_start 0x1C0030C4U
#define Adr_NX50_dpmhs_ch6_netx_start                                    0x1C0030C4U
#define DFLT_VAL_NX50_dpmhs_ch6_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch6_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH6_NETX_START_BIT_T bf;
} NX50_DPMHS_CH6_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_dma_ctrl                                0x000000C8U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_dma_ctrl 0x1C0030C8U
#define Adr_NX50_dpmhs_ch6_dma_ctrl                                    0x1C0030C8U
#define DFLT_VAL_NX50_dpmhs_ch6_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch6_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH6_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH6_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_host_mbx_base                                0x000000CCU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_host_mbx_base 0x1C0030CCU
#define Adr_NX50_dpmhs_ch6_host_mbx_base                                    0x1C0030CCU
#define DFLT_VAL_NX50_dpmhs_ch6_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch6_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH6_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH6_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_buf_ctrl                                0x000000D0U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_buf_ctrl 0x1C0030D0U
#define Adr_NX50_dpmhs_ch6_buf_ctrl                                    0x1C0030D0U
#define DFLT_VAL_NX50_dpmhs_ch6_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch6_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH6_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH6_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_host_buf3_base                                0x000000D4U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_host_buf3_base 0x1C0030D4U
#define Adr_NX50_dpmhs_ch6_host_buf3_base                                    0x1C0030D4U
#define DFLT_VAL_NX50_dpmhs_ch6_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch6_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH6_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH6_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_host_buf2_base                                0x000000D8U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_host_buf2_base 0x1C0030D8U
#define Adr_NX50_dpmhs_ch6_host_buf2_base                                    0x1C0030D8U
#define DFLT_VAL_NX50_dpmhs_ch6_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch6_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH6_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH6_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch6_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch6_host_buf1_base                                0x000000DCU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch6_host_buf1_base 0x1C0030DCU
#define Adr_NX50_dpmhs_ch6_host_buf1_base                                    0x1C0030DCU
#define DFLT_VAL_NX50_dpmhs_ch6_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch6_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch6_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch6_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch6_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH6_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch6_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH6_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH6_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH6_HOST_BUF1_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_host_start                                0x000000E0U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_host_start 0x1C0030E0U
#define Adr_NX50_dpmhs_ch7_host_start                                    0x1C0030E0U
#define DFLT_VAL_NX50_dpmhs_ch7_host_start                               0x00000000U

#define MSK_NX50_dpmhs_ch7_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH7_HOST_START_BIT_T bf;
} NX50_DPMHS_CH7_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_netx_start                                0x000000E4U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_netx_start 0x1C0030E4U
#define Adr_NX50_dpmhs_ch7_netx_start                                    0x1C0030E4U
#define DFLT_VAL_NX50_dpmhs_ch7_netx_start                               0x00000000U

#define MSK_NX50_dpmhs_ch7_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMHS_CH7_NETX_START_BIT_T bf;
} NX50_DPMHS_CH7_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_dma_ctrl                                0x000000E8U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_dma_ctrl 0x1C0030E8U
#define Adr_NX50_dpmhs_ch7_dma_ctrl                                    0x1C0030E8U
#define DFLT_VAL_NX50_dpmhs_ch7_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch7_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH7_DMA_CTRL_BIT_T bf;
} NX50_DPMHS_CH7_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_host_mbx_base                                0x000000ECU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_host_mbx_base 0x1C0030ECU
#define Adr_NX50_dpmhs_ch7_host_mbx_base                                    0x1C0030ECU
#define DFLT_VAL_NX50_dpmhs_ch7_host_mbx_base                               0x00000000U

#define MSK_NX50_dpmhs_ch7_host_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_host_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_host_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_host_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_HOST_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_host_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_HOST_MBX_BASE_BIT_T;

typedef union {
	unsigned int                       val;
	NX50_DPMHS_CH7_HOST_MBX_BASE_BIT_T bf;
} NX50_DPMHS_CH7_HOST_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_buf_ctrl                                0x000000F0U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_buf_ctrl 0x1C0030F0U
#define Adr_NX50_dpmhs_ch7_buf_ctrl                                    0x1C0030F0U
#define DFLT_VAL_NX50_dpmhs_ch7_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmhs_ch7_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMHS_CH7_BUF_CTRL_BIT_T bf;
} NX50_DPMHS_CH7_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_buf3_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_host_buf3_base                                0x000000F4U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_host_buf3_base 0x1C0030F4U
#define Adr_NX50_dpmhs_ch7_host_buf3_base                                    0x1C0030F4U
#define DFLT_VAL_NX50_dpmhs_ch7_host_buf3_base                               0x00000000U

#define MSK_NX50_dpmhs_ch7_host_buf3_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_host_buf3_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_host_buf3_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_host_buf3_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_HOST_BUF3_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_host_buf3_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_HOST_BUF3_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH7_HOST_BUF3_BASE_BIT_T bf;
} NX50_DPMHS_CH7_HOST_BUF3_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_buf2_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_host_buf2_base                                0x000000F8U
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_host_buf2_base 0x1C0030F8U
#define Adr_NX50_dpmhs_ch7_host_buf2_base                                    0x1C0030F8U
#define DFLT_VAL_NX50_dpmhs_ch7_host_buf2_base                               0x00000000U

#define MSK_NX50_dpmhs_ch7_host_buf2_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_host_buf2_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_host_buf2_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_host_buf2_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_HOST_BUF2_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_host_buf2_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_HOST_BUF2_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH7_HOST_BUF2_BASE_BIT_T bf;
} NX50_DPMHS_CH7_HOST_BUF2_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_ch7_host_buf1_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_ch7_host_buf1_base                                0x000000FCU
#define Adr_NX50_host_controlled_dma_register_block_dpmhs_ch7_host_buf1_base 0x1C0030FCU
#define Adr_NX50_dpmhs_ch7_host_buf1_base                                    0x1C0030FCU
#define DFLT_VAL_NX50_dpmhs_ch7_host_buf1_base                               0x00000000U

#define MSK_NX50_dpmhs_ch7_host_buf1_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_ch7_host_buf1_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_ch7_host_buf1_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_ch7_host_buf1_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_CH7_HOST_BUF1_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_ch7_host_buf1_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_CH7_HOST_BUF1_BASE_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMHS_CH7_HOST_BUF1_BASE_BIT_T bf;
} NX50_DPMHS_CH7_HOST_BUF1_BASE_T;


/* ===================================================================== */

/* Area of host_controlled_global_register_block */

/* ===================================================================== */

#define Addr_NX50_host_controlled_global_register_block 0x1C003100U
#define NX50_NETX_DPM_HOST_GLOB_AREA                    0x1C003100U

/* --------------------------------------------------------------------- */
/* Register pci_base */
/* => dpmhs_pci_targ2_mem_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_base                                   0x000000BCU
#define Adr_NX50_host_controlled_global_register_block_pci_base 0x1C0031BCU
#define Adr_NX50_pci_base                                       0x1C0031BCU
#define DFLT_VAL_NX50_pci_base                                  0x00000000U

#define MSK_NX50_pci_base_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_base_keine_ahnung      0
#define DFLT_VAL_NX50_pci_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_BASE_BIT_T;

typedef union {
	unsigned int        val;
	NX50_PCI_BASE_BIT_T bf;
} NX50_PCI_BASE_T;

/* --------------------------------------------------------------------- */
/* Register wdg_host */
/* => dpmhs_wdg_host_timeout */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_wdg_host                                   0x000000C0U
#define Adr_NX50_host_controlled_global_register_block_wdg_host 0x1C0031C0U
#define Adr_NX50_wdg_host                                       0x1C0031C0U
#define DFLT_VAL_NX50_wdg_host                                  0x00000000U

#define MSK_NX50_wdg_host_keine_ahnung      0xffffffffU
#define SRT_NX50_wdg_host_keine_ahnung      0
#define DFLT_VAL_NX50_wdg_host_keine_ahnung 0x00000000U

enum {
	BFW_NX50_wdg_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_WDG_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_wdg_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_WDG_HOST_BIT_T;

typedef union {
	unsigned int        val;
	NX50_WDG_HOST_BIT_T bf;
} NX50_WDG_HOST_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_wdg_host_trig */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_wdg_host_trig                                   0x000000C4U
#define Adr_NX50_host_controlled_global_register_block_dpmhs_wdg_host_trig 0x1C0031C4U
#define Adr_NX50_dpmhs_wdg_host_trig                                       0x1C0031C4U
#define DFLT_VAL_NX50_dpmhs_wdg_host_trig                                  0x00000000U

#define MSK_NX50_dpmhs_wdg_host_trig_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_wdg_host_trig_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_wdg_host_trig_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_wdg_host_trig_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_WDG_HOST_TRIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_wdg_host_trig_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_WDG_HOST_TRIG_BIT_T;

typedef union {
	unsigned int                   val;
	NX50_DPMHS_WDG_HOST_TRIG_BIT_T bf;
} NX50_DPMHS_WDG_HOST_TRIG_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_wdg_arm_timeout */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_wdg_arm_timeout                                   0x000000C8U
#define Adr_NX50_host_controlled_global_register_block_dpmhs_wdg_arm_timeout 0x1C0031C8U
#define Adr_NX50_dpmhs_wdg_arm_timeout                                       0x1C0031C8U
#define DFLT_VAL_NX50_dpmhs_wdg_arm_timeout                                  0x00000000U

#define MSK_NX50_dpmhs_wdg_arm_timeout_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_wdg_arm_timeout_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_wdg_arm_timeout_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_wdg_arm_timeout_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_WDG_ARM_TIMEOUT_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_wdg_arm_timeout_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_WDG_ARM_TIMEOUT_BIT_T;

typedef union {
	unsigned int                     val;
	NX50_DPMHS_WDG_ARM_TIMEOUT_BIT_T bf;
} NX50_DPMHS_WDG_ARM_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register cyclic_tmr_control */
/* => dpmhs_tmr_ctrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cyclic_tmr_control                                   0x000000D0U
#define Adr_NX50_host_controlled_global_register_block_cyclic_tmr_control 0x1C0031D0U
#define Adr_NX50_cyclic_tmr_control                                       0x1C0031D0U
#define DFLT_VAL_NX50_cyclic_tmr_control                                  0x00000000U

#define MSK_NX50_cyclic_tmr_control_keine_ahnung      0xffffffffU
#define SRT_NX50_cyclic_tmr_control_keine_ahnung      0
#define DFLT_VAL_NX50_cyclic_tmr_control_keine_ahnung 0x00000000U

enum {
	BFW_NX50_cyclic_tmr_control_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_CYCLIC_TMR_CONTROL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_cyclic_tmr_control_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_CYCLIC_TMR_CONTROL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_CYCLIC_TMR_CONTROL_BIT_T bf;
} NX50_CYCLIC_TMR_CONTROL_T;

/* --------------------------------------------------------------------- */
/* Register cyclic_tmr_reload */
/* => dpmhs_tmr_start_value */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cyclic_tmr_reload                                   0x000000D4U
#define Adr_NX50_host_controlled_global_register_block_cyclic_tmr_reload 0x1C0031D4U
#define Adr_NX50_cyclic_tmr_reload                                       0x1C0031D4U
#define DFLT_VAL_NX50_cyclic_tmr_reload                                  0x00000000U

#define MSK_NX50_cyclic_tmr_reload_keine_ahnung      0xffffffffU
#define SRT_NX50_cyclic_tmr_reload_keine_ahnung      0
#define DFLT_VAL_NX50_cyclic_tmr_reload_keine_ahnung 0x00000000U

enum {
	BFW_NX50_cyclic_tmr_reload_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_CYCLIC_TMR_RELOAD_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_cyclic_tmr_reload_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_CYCLIC_TMR_RELOAD_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_CYCLIC_TMR_RELOAD_BIT_T bf;
} NX50_CYCLIC_TMR_RELOAD_T;

/* --------------------------------------------------------------------- */
/* Register sta_host */
/* => dpmhs_sys_sta */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sta_host                                   0x000000D8U
#define Adr_NX50_host_controlled_global_register_block_sta_host 0x1C0031D8U
#define Adr_NX50_sta_host                                       0x1C0031D8U
#define DFLT_VAL_NX50_sta_host                                  0x00000000U

#define MSK_NX50_sta_host_keine_ahnung      0xffffffffU
#define SRT_NX50_sta_host_keine_ahnung      0
#define DFLT_VAL_NX50_sta_host_keine_ahnung 0x00000000U

enum {
	BFW_NX50_sta_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_STA_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_sta_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_STA_HOST_BIT_T;

typedef union {
	unsigned int        val;
	NX50_STA_HOST_BIT_T bf;
} NX50_STA_HOST_T;

/* --------------------------------------------------------------------- */
/* Register res_reg */
/* => dpmhs_res_req */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_res_reg                                   0x000000DCU
#define Adr_NX50_host_controlled_global_register_block_res_reg 0x1C0031DCU
#define Adr_NX50_res_reg                                       0x1C0031DCU
#define DFLT_VAL_NX50_res_reg                                  0x00000000U

#define MSK_NX50_res_reg_keine_ahnung      0xffffffffU
#define SRT_NX50_res_reg_keine_ahnung      0
#define DFLT_VAL_NX50_res_reg_keine_ahnung 0x00000000U

enum {
	BFW_NX50_res_reg_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_RES_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_res_reg_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_RES_REG_BIT_T;

typedef union {
	unsigned int       val;
	NX50_RES_REG_BIT_T bf;
} NX50_RES_REG_T;

/* --------------------------------------------------------------------- */
/* Register irq_reg_host */
/* => dpmhs_int_sta0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_irq_reg_host                                   0x000000E0U
#define Adr_NX50_host_controlled_global_register_block_irq_reg_host 0x1C0031E0U
#define Adr_NX50_irq_reg_host                                       0x1C0031E0U
#define DFLT_VAL_NX50_irq_reg_host                                  0x00000000U

#define MSK_NX50_irq_reg_host_keine_ahnung      0xffffffffU
#define SRT_NX50_irq_reg_host_keine_ahnung      0
#define DFLT_VAL_NX50_irq_reg_host_keine_ahnung 0x00000000U

enum {
	BFW_NX50_irq_reg_host_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IRQ_REG_HOST_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_irq_reg_host_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IRQ_REG_HOST_BIT_T;

typedef union {
	unsigned int            val;
	NX50_IRQ_REG_HOST_BIT_T bf;
} NX50_IRQ_REG_HOST_T;

/* --------------------------------------------------------------------- */
/* Register irq_reg_host1 */
/* => dpmhs_int_sta1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_irq_reg_host1                                   0x000000E4U
#define Adr_NX50_host_controlled_global_register_block_irq_reg_host1 0x1C0031E4U
#define Adr_NX50_irq_reg_host1                                       0x1C0031E4U
#define DFLT_VAL_NX50_irq_reg_host1                                  0x00000000U

#define MSK_NX50_irq_reg_host1_keine_ahnung      0xffffffffU
#define SRT_NX50_irq_reg_host1_keine_ahnung      0
#define DFLT_VAL_NX50_irq_reg_host1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_irq_reg_host1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IRQ_REG_HOST1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_irq_reg_host1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IRQ_REG_HOST1_BIT_T;

typedef union {
	unsigned int             val;
	NX50_IRQ_REG_HOST1_BIT_T bf;
} NX50_IRQ_REG_HOST1_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_int_en0 */
/* => adr_dpmhs_int_en0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_int_en0                                   0x000000F0U
#define Adr_NX50_host_controlled_global_register_block_dpmhs_int_en0 0x1C0031F0U
#define Adr_NX50_dpmhs_int_en0                                       0x1C0031F0U
#define DFLT_VAL_NX50_dpmhs_int_en0                                  0x00000000U

#define MSK_NX50_dpmhs_int_en0_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_int_en0_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_int_en0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_int_en0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_INT_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_int_en0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_INT_EN0_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMHS_INT_EN0_BIT_T bf;
} NX50_DPMHS_INT_EN0_T;

/* --------------------------------------------------------------------- */
/* Register adr_dpmhs_int_en1 */
/* => adr_dpmhs_int_en1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_adr_dpmhs_int_en1                                   0x000000F4U
#define Adr_NX50_host_controlled_global_register_block_adr_dpmhs_int_en1 0x1C0031F4U
#define Adr_NX50_adr_dpmhs_int_en1                                       0x1C0031F4U
#define DFLT_VAL_NX50_adr_dpmhs_int_en1                                  0x00000000U

#define MSK_NX50_adr_dpmhs_int_en1_keine_ahnung      0xffffffffU
#define SRT_NX50_adr_dpmhs_int_en1_keine_ahnung      0
#define DFLT_VAL_NX50_adr_dpmhs_int_en1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_adr_dpmhs_int_en1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_ADR_DPMHS_INT_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_adr_dpmhs_int_en1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_ADR_DPMHS_INT_EN1_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_ADR_DPMHS_INT_EN1_BIT_T bf;
} NX50_ADR_DPMHS_INT_EN1_T;


/* ===================================================================== */

/* Area of host_controlled_handshake_register_block */

/* ===================================================================== */

#define Addr_NX50_host_controlled_handshake_register_block 0x1C003200U
#define NX50_NETX_DPM_HOST_HS_AREA                         0x1C003200U

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data0 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data0                                      0x00000000U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data0 0x1C003200U
#define Adr_NX50_dpmhs_hs_data0                                          0x1C003200U
#define DFLT_VAL_NX50_dpmhs_hs_data0                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data0_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data0_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA0_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA0_BIT_T bf;
} NX50_DPMHS_HS_DATA0_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data1                                      0x00000004U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data1 0x1C003204U
#define Adr_NX50_dpmhs_hs_data1                                          0x1C003204U
#define DFLT_VAL_NX50_dpmhs_hs_data1                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA1_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA1_BIT_T bf;
} NX50_DPMHS_HS_DATA1_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data2                                      0x00000008U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data2 0x1C003208U
#define Adr_NX50_dpmhs_hs_data2                                          0x1C003208U
#define DFLT_VAL_NX50_dpmhs_hs_data2                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA2_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA2_BIT_T bf;
} NX50_DPMHS_HS_DATA2_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data3                                      0x0000000CU
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data3 0x1C00320CU
#define Adr_NX50_dpmhs_hs_data3                                          0x1C00320CU
#define DFLT_VAL_NX50_dpmhs_hs_data3                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA3_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA3_BIT_T bf;
} NX50_DPMHS_HS_DATA3_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data4                                      0x00000010U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data4 0x1C003210U
#define Adr_NX50_dpmhs_hs_data4                                          0x1C003210U
#define DFLT_VAL_NX50_dpmhs_hs_data4                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data4_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data4_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data4_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA4_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA4_BIT_T bf;
} NX50_DPMHS_HS_DATA4_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data5                                      0x00000014U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data5 0x1C003214U
#define Adr_NX50_dpmhs_hs_data5                                          0x1C003214U
#define DFLT_VAL_NX50_dpmhs_hs_data5                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data5_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data5_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data5_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA5_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA5_BIT_T bf;
} NX50_DPMHS_HS_DATA5_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data6                                      0x00000018U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data6 0x1C003218U
#define Adr_NX50_dpmhs_hs_data6                                          0x1C003218U
#define DFLT_VAL_NX50_dpmhs_hs_data6                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data6_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data6_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data6_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA6_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA6_BIT_T bf;
} NX50_DPMHS_HS_DATA6_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data7                                      0x0000001CU
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data7 0x1C00321CU
#define Adr_NX50_dpmhs_hs_data7                                          0x1C00321CU
#define DFLT_VAL_NX50_dpmhs_hs_data7                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data7_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data7_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data7_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA7_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA7_BIT_T bf;
} NX50_DPMHS_HS_DATA7_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data8 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data8                                      0x00000020U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data8 0x1C003220U
#define Adr_NX50_dpmhs_hs_data8                                          0x1C003220U
#define DFLT_VAL_NX50_dpmhs_hs_data8                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data8_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data8_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data8_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data8_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data8_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA8_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA8_BIT_T bf;
} NX50_DPMHS_HS_DATA8_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data9 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data9                                      0x00000024U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data9 0x1C003224U
#define Adr_NX50_dpmhs_hs_data9                                          0x1C003224U
#define DFLT_VAL_NX50_dpmhs_hs_data9                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data9_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data9_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data9_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data9_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data9_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA9_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DPMHS_HS_DATA9_BIT_T bf;
} NX50_DPMHS_HS_DATA9_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data10 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data10                                      0x00000028U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data10 0x1C003228U
#define Adr_NX50_dpmhs_hs_data10                                          0x1C003228U
#define DFLT_VAL_NX50_dpmhs_hs_data10                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data10_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data10_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data10_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data10_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data10_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA10_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DPMHS_HS_DATA10_BIT_T bf;
} NX50_DPMHS_HS_DATA10_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data11 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data11                                      0x0000002CU
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data11 0x1C00322CU
#define Adr_NX50_dpmhs_hs_data11                                          0x1C00322CU
#define DFLT_VAL_NX50_dpmhs_hs_data11                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data11_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data11_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data11_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data11_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data11_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA11_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DPMHS_HS_DATA11_BIT_T bf;
} NX50_DPMHS_HS_DATA11_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data12 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data12                                      0x00000030U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data12 0x1C003230U
#define Adr_NX50_dpmhs_hs_data12                                          0x1C003230U
#define DFLT_VAL_NX50_dpmhs_hs_data12                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data12_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data12_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data12_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data12_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data12_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA12_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DPMHS_HS_DATA12_BIT_T bf;
} NX50_DPMHS_HS_DATA12_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data13 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data13                                      0x00000034U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data13 0x1C003234U
#define Adr_NX50_dpmhs_hs_data13                                          0x1C003234U
#define DFLT_VAL_NX50_dpmhs_hs_data13                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data13_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data13_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data13_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data13_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data13_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA13_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DPMHS_HS_DATA13_BIT_T bf;
} NX50_DPMHS_HS_DATA13_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data14 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data14                                      0x00000038U
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data14 0x1C003238U
#define Adr_NX50_dpmhs_hs_data14                                          0x1C003238U
#define DFLT_VAL_NX50_dpmhs_hs_data14                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data14_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data14_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data14_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data14_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data14_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA14_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DPMHS_HS_DATA14_BIT_T bf;
} NX50_DPMHS_HS_DATA14_T;

/* --------------------------------------------------------------------- */
/* Register dpmhs_hs_data15 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmhs_hs_data15                                      0x0000003CU
#define Adr_NX50_host_controlled_handshake_register_block_dpmhs_hs_data15 0x1C00323CU
#define Adr_NX50_dpmhs_hs_data15                                          0x1C00323CU
#define DFLT_VAL_NX50_dpmhs_hs_data15                                     0x00000000U

#define MSK_NX50_dpmhs_hs_data15_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmhs_hs_data15_keine_ahnung      0
#define DFLT_VAL_NX50_dpmhs_hs_data15_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmhs_hs_data15_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMHS_HS_DATA15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmhs_hs_data15_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMHS_HS_DATA15_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DPMHS_HS_DATA15_BIT_T bf;
} NX50_DPMHS_HS_DATA15_T;


/* ===================================================================== */

/* Area of netx_controlled_dma_register_block */

/* ===================================================================== */

#define Addr_NX50_netx_controlled_dma_register_block 0x1C003300U
#define NX50_NETX_DPM_ARM_DMA_AREA                   0x1C003300U

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_host_start                                0x00000000U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_host_start 0x1C003300U
#define Adr_NX50_dpmas_ch0_host_start                                    0x1C003300U
#define DFLT_VAL_NX50_dpmas_ch0_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch0_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH0_HOST_START_BIT_T bf;
} NX50_DPMAS_CH0_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_netx_start                                0x00000004U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_netx_start 0x1C003304U
#define Adr_NX50_dpmas_ch0_netx_start                                    0x1C003304U
#define DFLT_VAL_NX50_dpmas_ch0_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch0_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH0_NETX_START_BIT_T bf;
} NX50_DPMAS_CH0_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_dma_ctrl                                0x00000008U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_dma_ctrl 0x1C003308U
#define Adr_NX50_dpmas_ch0_dma_ctrl                                    0x1C003308U
#define DFLT_VAL_NX50_dpmas_ch0_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch0_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH0_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH0_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_mbx_base                                0x0000000CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_mbx_base 0x1C00330CU
#define Adr_NX50_dpmas_ch0_mbx_base                                    0x1C00330CU
#define DFLT_VAL_NX50_dpmas_ch0_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch0_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH0_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH0_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_buf_ctrl                                0x00000010U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_buf_ctrl 0x1C003310U
#define Adr_NX50_dpmas_ch0_buf_ctrl                                    0x1C003310U
#define DFLT_VAL_NX50_dpmas_ch0_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch0_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH0_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH0_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_netx_buf_base3                                0x00000014U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_netx_buf_base3 0x1C003314U
#define Adr_NX50_dpmas_ch0_netx_buf_base3                                    0x1C003314U
#define DFLT_VAL_NX50_dpmas_ch0_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch0_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH0_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH0_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_netx_buf_base2                                0x00000018U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_netx_buf_base2 0x1C003318U
#define Adr_NX50_dpmas_ch0_netx_buf_base2                                    0x1C003318U
#define DFLT_VAL_NX50_dpmas_ch0_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch0_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH0_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH0_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch0_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch0_netx_buf_base1                                0x0000001CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch0_netx_buf_base1 0x1C00331CU
#define Adr_NX50_dpmas_ch0_netx_buf_base1                                    0x1C00331CU
#define DFLT_VAL_NX50_dpmas_ch0_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch0_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch0_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch0_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch0_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH0_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch0_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH0_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH0_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH0_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_host_start                                0x00000020U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_host_start 0x1C003320U
#define Adr_NX50_dpmas_ch1_host_start                                    0x1C003320U
#define DFLT_VAL_NX50_dpmas_ch1_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch1_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH1_HOST_START_BIT_T bf;
} NX50_DPMAS_CH1_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_netx_start                                0x00000024U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_netx_start 0x1C003324U
#define Adr_NX50_dpmas_ch1_netx_start                                    0x1C003324U
#define DFLT_VAL_NX50_dpmas_ch1_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch1_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH1_NETX_START_BIT_T bf;
} NX50_DPMAS_CH1_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_dma_ctrl                                0x00000028U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_dma_ctrl 0x1C003328U
#define Adr_NX50_dpmas_ch1_dma_ctrl                                    0x1C003328U
#define DFLT_VAL_NX50_dpmas_ch1_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch1_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH1_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH1_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_mbx_base                                0x0000002CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_mbx_base 0x1C00332CU
#define Adr_NX50_dpmas_ch1_mbx_base                                    0x1C00332CU
#define DFLT_VAL_NX50_dpmas_ch1_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch1_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH1_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH1_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_buf_ctrl                                0x00000030U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_buf_ctrl 0x1C003330U
#define Adr_NX50_dpmas_ch1_buf_ctrl                                    0x1C003330U
#define DFLT_VAL_NX50_dpmas_ch1_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch1_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH1_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH1_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_netx_buf_base3                                0x00000034U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_netx_buf_base3 0x1C003334U
#define Adr_NX50_dpmas_ch1_netx_buf_base3                                    0x1C003334U
#define DFLT_VAL_NX50_dpmas_ch1_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch1_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH1_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH1_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_netx_buf_base2                                0x00000038U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_netx_buf_base2 0x1C003338U
#define Adr_NX50_dpmas_ch1_netx_buf_base2                                    0x1C003338U
#define DFLT_VAL_NX50_dpmas_ch1_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch1_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH1_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH1_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch1_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch1_netx_buf_base1                                0x0000003CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch1_netx_buf_base1 0x1C00333CU
#define Adr_NX50_dpmas_ch1_netx_buf_base1                                    0x1C00333CU
#define DFLT_VAL_NX50_dpmas_ch1_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch1_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch1_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch1_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch1_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH1_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch1_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH1_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH1_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH1_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_host_start                                0x00000040U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_host_start 0x1C003340U
#define Adr_NX50_dpmas_ch2_host_start                                    0x1C003340U
#define DFLT_VAL_NX50_dpmas_ch2_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch2_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH2_HOST_START_BIT_T bf;
} NX50_DPMAS_CH2_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_netx_start                                0x00000044U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_netx_start 0x1C003344U
#define Adr_NX50_dpmas_ch2_netx_start                                    0x1C003344U
#define DFLT_VAL_NX50_dpmas_ch2_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch2_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH2_NETX_START_BIT_T bf;
} NX50_DPMAS_CH2_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_dma_ctrl                                0x00000048U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_dma_ctrl 0x1C003348U
#define Adr_NX50_dpmas_ch2_dma_ctrl                                    0x1C003348U
#define DFLT_VAL_NX50_dpmas_ch2_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch2_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH2_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH2_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_mbx_base                                0x0000004CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_mbx_base 0x1C00334CU
#define Adr_NX50_dpmas_ch2_mbx_base                                    0x1C00334CU
#define DFLT_VAL_NX50_dpmas_ch2_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch2_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH2_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH2_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_buf_ctrl                                0x00000050U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_buf_ctrl 0x1C003350U
#define Adr_NX50_dpmas_ch2_buf_ctrl                                    0x1C003350U
#define DFLT_VAL_NX50_dpmas_ch2_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch2_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH2_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH2_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_netx_buf_base3                                0x00000054U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_netx_buf_base3 0x1C003354U
#define Adr_NX50_dpmas_ch2_netx_buf_base3                                    0x1C003354U
#define DFLT_VAL_NX50_dpmas_ch2_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch2_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH2_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH2_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_netx_buf_base2                                0x00000058U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_netx_buf_base2 0x1C003358U
#define Adr_NX50_dpmas_ch2_netx_buf_base2                                    0x1C003358U
#define DFLT_VAL_NX50_dpmas_ch2_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch2_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH2_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH2_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch2_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch2_netx_buf_base1                                0x0000005CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch2_netx_buf_base1 0x1C00335CU
#define Adr_NX50_dpmas_ch2_netx_buf_base1                                    0x1C00335CU
#define DFLT_VAL_NX50_dpmas_ch2_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch2_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch2_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch2_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch2_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH2_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch2_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH2_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH2_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH2_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_host_start                                0x00000060U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_host_start 0x1C003360U
#define Adr_NX50_dpmas_ch3_host_start                                    0x1C003360U
#define DFLT_VAL_NX50_dpmas_ch3_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch3_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH3_HOST_START_BIT_T bf;
} NX50_DPMAS_CH3_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_netx_start                                0x00000064U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_netx_start 0x1C003364U
#define Adr_NX50_dpmas_ch3_netx_start                                    0x1C003364U
#define DFLT_VAL_NX50_dpmas_ch3_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch3_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH3_NETX_START_BIT_T bf;
} NX50_DPMAS_CH3_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_dma_ctrl                                0x00000068U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_dma_ctrl 0x1C003368U
#define Adr_NX50_dpmas_ch3_dma_ctrl                                    0x1C003368U
#define DFLT_VAL_NX50_dpmas_ch3_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch3_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH3_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH3_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_mbx_base                                0x0000006CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_mbx_base 0x1C00336CU
#define Adr_NX50_dpmas_ch3_mbx_base                                    0x1C00336CU
#define DFLT_VAL_NX50_dpmas_ch3_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch3_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH3_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH3_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_buf_ctrl                                0x00000070U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_buf_ctrl 0x1C003370U
#define Adr_NX50_dpmas_ch3_buf_ctrl                                    0x1C003370U
#define DFLT_VAL_NX50_dpmas_ch3_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch3_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH3_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH3_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_netx_buf_base3                                0x00000074U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_netx_buf_base3 0x1C003374U
#define Adr_NX50_dpmas_ch3_netx_buf_base3                                    0x1C003374U
#define DFLT_VAL_NX50_dpmas_ch3_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch3_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH3_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH3_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_netx_buf_base2                                0x00000078U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_netx_buf_base2 0x1C003378U
#define Adr_NX50_dpmas_ch3_netx_buf_base2                                    0x1C003378U
#define DFLT_VAL_NX50_dpmas_ch3_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch3_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH3_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH3_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch3_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch3_netx_buf_base1                                0x0000007CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch3_netx_buf_base1 0x1C00337CU
#define Adr_NX50_dpmas_ch3_netx_buf_base1                                    0x1C00337CU
#define DFLT_VAL_NX50_dpmas_ch3_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch3_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch3_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch3_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch3_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH3_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch3_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH3_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH3_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH3_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_host_start                                0x00000080U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_host_start 0x1C003380U
#define Adr_NX50_dpmas_ch4_host_start                                    0x1C003380U
#define DFLT_VAL_NX50_dpmas_ch4_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch4_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH4_HOST_START_BIT_T bf;
} NX50_DPMAS_CH4_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_netx_start                                0x00000084U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_netx_start 0x1C003384U
#define Adr_NX50_dpmas_ch4_netx_start                                    0x1C003384U
#define DFLT_VAL_NX50_dpmas_ch4_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch4_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH4_NETX_START_BIT_T bf;
} NX50_DPMAS_CH4_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_dma_ctrl                                0x00000088U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_dma_ctrl 0x1C003388U
#define Adr_NX50_dpmas_ch4_dma_ctrl                                    0x1C003388U
#define DFLT_VAL_NX50_dpmas_ch4_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch4_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH4_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH4_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_mbx_base                                0x0000008CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_mbx_base 0x1C00338CU
#define Adr_NX50_dpmas_ch4_mbx_base                                    0x1C00338CU
#define DFLT_VAL_NX50_dpmas_ch4_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch4_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH4_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH4_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_buf_ctrl                                0x00000090U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_buf_ctrl 0x1C003390U
#define Adr_NX50_dpmas_ch4_buf_ctrl                                    0x1C003390U
#define DFLT_VAL_NX50_dpmas_ch4_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch4_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH4_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH4_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_netx_buf_base3                                0x00000094U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_netx_buf_base3 0x1C003394U
#define Adr_NX50_dpmas_ch4_netx_buf_base3                                    0x1C003394U
#define DFLT_VAL_NX50_dpmas_ch4_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch4_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH4_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH4_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_netx_buf_base2                                0x00000098U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_netx_buf_base2 0x1C003398U
#define Adr_NX50_dpmas_ch4_netx_buf_base2                                    0x1C003398U
#define DFLT_VAL_NX50_dpmas_ch4_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch4_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH4_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH4_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch4_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch4_netx_buf_base1                                0x0000009CU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch4_netx_buf_base1 0x1C00339CU
#define Adr_NX50_dpmas_ch4_netx_buf_base1                                    0x1C00339CU
#define DFLT_VAL_NX50_dpmas_ch4_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch4_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch4_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch4_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch4_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH4_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch4_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH4_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH4_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH4_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_host_start                                0x000000A0U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_host_start 0x1C0033A0U
#define Adr_NX50_dpmas_ch5_host_start                                    0x1C0033A0U
#define DFLT_VAL_NX50_dpmas_ch5_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch5_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH5_HOST_START_BIT_T bf;
} NX50_DPMAS_CH5_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_netx_start                                0x000000A4U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_netx_start 0x1C0033A4U
#define Adr_NX50_dpmas_ch5_netx_start                                    0x1C0033A4U
#define DFLT_VAL_NX50_dpmas_ch5_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch5_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH5_NETX_START_BIT_T bf;
} NX50_DPMAS_CH5_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_dma_ctrl                                0x000000A8U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_dma_ctrl 0x1C0033A8U
#define Adr_NX50_dpmas_ch5_dma_ctrl                                    0x1C0033A8U
#define DFLT_VAL_NX50_dpmas_ch5_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch5_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH5_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH5_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_mbx_base                                0x000000ACU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_mbx_base 0x1C0033ACU
#define Adr_NX50_dpmas_ch5_mbx_base                                    0x1C0033ACU
#define DFLT_VAL_NX50_dpmas_ch5_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch5_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH5_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH5_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_buf_ctrl                                0x000000B0U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_buf_ctrl 0x1C0033B0U
#define Adr_NX50_dpmas_ch5_buf_ctrl                                    0x1C0033B0U
#define DFLT_VAL_NX50_dpmas_ch5_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch5_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH5_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH5_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_netx_buf_base3                                0x000000B4U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_netx_buf_base3 0x1C0033B4U
#define Adr_NX50_dpmas_ch5_netx_buf_base3                                    0x1C0033B4U
#define DFLT_VAL_NX50_dpmas_ch5_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch5_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH5_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH5_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_netx_buf_base2                                0x000000B8U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_netx_buf_base2 0x1C0033B8U
#define Adr_NX50_dpmas_ch5_netx_buf_base2                                    0x1C0033B8U
#define DFLT_VAL_NX50_dpmas_ch5_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch5_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH5_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH5_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch5_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch5_netx_buf_base1                                0x000000BCU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch5_netx_buf_base1 0x1C0033BCU
#define Adr_NX50_dpmas_ch5_netx_buf_base1                                    0x1C0033BCU
#define DFLT_VAL_NX50_dpmas_ch5_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch5_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch5_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch5_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch5_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH5_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch5_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH5_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH5_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH5_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_host_start                                0x000000C0U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_host_start 0x1C0033C0U
#define Adr_NX50_dpmas_ch6_host_start                                    0x1C0033C0U
#define DFLT_VAL_NX50_dpmas_ch6_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch6_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH6_HOST_START_BIT_T bf;
} NX50_DPMAS_CH6_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_netx_start                                0x000000C4U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_netx_start 0x1C0033C4U
#define Adr_NX50_dpmas_ch6_netx_start                                    0x1C0033C4U
#define DFLT_VAL_NX50_dpmas_ch6_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch6_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH6_NETX_START_BIT_T bf;
} NX50_DPMAS_CH6_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_dma_ctrl                                0x000000C8U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_dma_ctrl 0x1C0033C8U
#define Adr_NX50_dpmas_ch6_dma_ctrl                                    0x1C0033C8U
#define DFLT_VAL_NX50_dpmas_ch6_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch6_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH6_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH6_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_mbx_base                                0x000000CCU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_mbx_base 0x1C0033CCU
#define Adr_NX50_dpmas_ch6_mbx_base                                    0x1C0033CCU
#define DFLT_VAL_NX50_dpmas_ch6_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch6_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH6_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH6_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_buf_ctrl                                0x000000D0U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_buf_ctrl 0x1C0033D0U
#define Adr_NX50_dpmas_ch6_buf_ctrl                                    0x1C0033D0U
#define DFLT_VAL_NX50_dpmas_ch6_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch6_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH6_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH6_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_netx_buf_base3                                0x000000D4U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_netx_buf_base3 0x1C0033D4U
#define Adr_NX50_dpmas_ch6_netx_buf_base3                                    0x1C0033D4U
#define DFLT_VAL_NX50_dpmas_ch6_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch6_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH6_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH6_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_netx_buf_base2                                0x000000D8U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_netx_buf_base2 0x1C0033D8U
#define Adr_NX50_dpmas_ch6_netx_buf_base2                                    0x1C0033D8U
#define DFLT_VAL_NX50_dpmas_ch6_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch6_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH6_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH6_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch6_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch6_netx_buf_base1                                0x000000DCU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch6_netx_buf_base1 0x1C0033DCU
#define Adr_NX50_dpmas_ch6_netx_buf_base1                                    0x1C0033DCU
#define DFLT_VAL_NX50_dpmas_ch6_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch6_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch6_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch6_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch6_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH6_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch6_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH6_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH6_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH6_NETX_BUF_BASE1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_host_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_host_start                                0x000000E0U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_host_start 0x1C0033E0U
#define Adr_NX50_dpmas_ch7_host_start                                    0x1C0033E0U
#define DFLT_VAL_NX50_dpmas_ch7_host_start                               0x00000000U

#define MSK_NX50_dpmas_ch7_host_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_host_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_host_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_host_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_HOST_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_host_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_HOST_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH7_HOST_START_BIT_T bf;
} NX50_DPMAS_CH7_HOST_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_start */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_netx_start                                0x000000E4U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_netx_start 0x1C0033E4U
#define Adr_NX50_dpmas_ch7_netx_start                                    0x1C0033E4U
#define DFLT_VAL_NX50_dpmas_ch7_netx_start                               0x00000000U

#define MSK_NX50_dpmas_ch7_netx_start_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_netx_start_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_netx_start_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_netx_start_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_NETX_START_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_netx_start_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_NETX_START_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DPMAS_CH7_NETX_START_BIT_T bf;
} NX50_DPMAS_CH7_NETX_START_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_dma_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_dma_ctrl                                0x000000E8U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_dma_ctrl 0x1C0033E8U
#define Adr_NX50_dpmas_ch7_dma_ctrl                                    0x1C0033E8U
#define DFLT_VAL_NX50_dpmas_ch7_dma_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch7_dma_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_dma_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_dma_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_dma_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_DMA_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_dma_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_DMA_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH7_DMA_CTRL_BIT_T bf;
} NX50_DPMAS_CH7_DMA_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_mbx_base */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_mbx_base                                0x000000ECU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_mbx_base 0x1C0033ECU
#define Adr_NX50_dpmas_ch7_mbx_base                                    0x1C0033ECU
#define DFLT_VAL_NX50_dpmas_ch7_mbx_base                               0x00000000U

#define MSK_NX50_dpmas_ch7_mbx_base_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_mbx_base_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_mbx_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_mbx_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_MBX_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_mbx_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_MBX_BASE_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH7_MBX_BASE_BIT_T bf;
} NX50_DPMAS_CH7_MBX_BASE_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_buf_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_buf_ctrl                                0x000000F0U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_buf_ctrl 0x1C0033F0U
#define Adr_NX50_dpmas_ch7_buf_ctrl                                    0x1C0033F0U
#define DFLT_VAL_NX50_dpmas_ch7_buf_ctrl                               0x00000000U

#define MSK_NX50_dpmas_ch7_buf_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_buf_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_buf_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_buf_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_BUF_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_buf_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_BUF_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_CH7_BUF_CTRL_BIT_T bf;
} NX50_DPMAS_CH7_BUF_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_buf_base3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_netx_buf_base3                                0x000000F4U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_netx_buf_base3 0x1C0033F4U
#define Adr_NX50_dpmas_ch7_netx_buf_base3                                    0x1C0033F4U
#define DFLT_VAL_NX50_dpmas_ch7_netx_buf_base3                               0x00000000U

#define MSK_NX50_dpmas_ch7_netx_buf_base3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_netx_buf_base3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_netx_buf_base3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_netx_buf_base3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_NETX_BUF_BASE3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_netx_buf_base3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_NETX_BUF_BASE3_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH7_NETX_BUF_BASE3_BIT_T bf;
} NX50_DPMAS_CH7_NETX_BUF_BASE3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_buf_base2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_netx_buf_base2                                0x000000F8U
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_netx_buf_base2 0x1C0033F8U
#define Adr_NX50_dpmas_ch7_netx_buf_base2                                    0x1C0033F8U
#define DFLT_VAL_NX50_dpmas_ch7_netx_buf_base2                               0x00000000U

#define MSK_NX50_dpmas_ch7_netx_buf_base2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_netx_buf_base2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_netx_buf_base2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_netx_buf_base2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_NETX_BUF_BASE2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_netx_buf_base2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_NETX_BUF_BASE2_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH7_NETX_BUF_BASE2_BIT_T bf;
} NX50_DPMAS_CH7_NETX_BUF_BASE2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ch7_netx_buf_base1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ch7_netx_buf_base1                                0x000000FCU
#define Adr_NX50_netx_controlled_dma_register_block_dpmas_ch7_netx_buf_base1 0x1C0033FCU
#define Adr_NX50_dpmas_ch7_netx_buf_base1                                    0x1C0033FCU
#define DFLT_VAL_NX50_dpmas_ch7_netx_buf_base1                               0x00000000U

#define MSK_NX50_dpmas_ch7_netx_buf_base1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ch7_netx_buf_base1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ch7_netx_buf_base1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ch7_netx_buf_base1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_CH7_NETX_BUF_BASE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ch7_netx_buf_base1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_CH7_NETX_BUF_BASE1_BIT_T;

typedef union {
	unsigned int                        val;
	NX50_DPMAS_CH7_NETX_BUF_BASE1_BIT_T bf;
} NX50_DPMAS_CH7_NETX_BUF_BASE1_T;


/* ===================================================================== */

/* Area of netx_controlled_global_register_block_1 */

/* ===================================================================== */

#define Addr_NX50_netx_controlled_global_register_block_1 0x1C003400U

/* --------------------------------------------------------------------- */
/* Register pci_window_low0 */
/* => dpmas_mem_win_start0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_low0                                     0x00000080U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_low0 0x1C003480U
#define Adr_NX50_pci_window_low0                                         0x1C003480U
#define DFLT_VAL_NX50_pci_window_low0                                    0x00000000U

#define MSK_NX50_pci_window_low0_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_low0_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_low0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_low0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_LOW0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_low0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_LOW0_BIT_T;

typedef union {
	unsigned int               val;
	NX50_PCI_WINDOW_LOW0_BIT_T bf;
} NX50_PCI_WINDOW_LOW0_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high0 */
/* => dpmas_mem_win_end0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_high0                                     0x00000084U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_high0 0x1C003484U
#define Adr_NX50_pci_window_high0                                         0x1C003484U
#define DFLT_VAL_NX50_pci_window_high0                                    0x00000000U

#define MSK_NX50_pci_window_high0_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_high0_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_high0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_high0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_HIGH0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_high0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_HIGH0_BIT_T;

typedef union {
	unsigned int                val;
	NX50_PCI_WINDOW_HIGH0_BIT_T bf;
} NX50_PCI_WINDOW_HIGH0_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_low1 */
/* => dpmas_mem_win_start1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_low1                                     0x00000088U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_low1 0x1C003488U
#define Adr_NX50_pci_window_low1                                         0x1C003488U
#define DFLT_VAL_NX50_pci_window_low1                                    0x00000000U

#define MSK_NX50_pci_window_low1_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_low1_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_low1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_low1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_LOW1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_low1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_LOW1_BIT_T;

typedef union {
	unsigned int               val;
	NX50_PCI_WINDOW_LOW1_BIT_T bf;
} NX50_PCI_WINDOW_LOW1_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high1 */
/* => dpmas_mem_win_end1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_high1                                     0x0000008CU
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_high1 0x1C00348CU
#define Adr_NX50_pci_window_high1                                         0x1C00348CU
#define DFLT_VAL_NX50_pci_window_high1                                    0x00000000U

#define MSK_NX50_pci_window_high1_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_high1_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_high1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_high1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_HIGH1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_high1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_HIGH1_BIT_T;

typedef union {
	unsigned int                val;
	NX50_PCI_WINDOW_HIGH1_BIT_T bf;
} NX50_PCI_WINDOW_HIGH1_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_low2 */
/* => dpmas_mem_win_start2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_low2                                     0x00000090U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_low2 0x1C003490U
#define Adr_NX50_pci_window_low2                                         0x1C003490U
#define DFLT_VAL_NX50_pci_window_low2                                    0x00000000U

#define MSK_NX50_pci_window_low2_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_low2_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_low2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_low2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_LOW2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_low2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_LOW2_BIT_T;

typedef union {
	unsigned int               val;
	NX50_PCI_WINDOW_LOW2_BIT_T bf;
} NX50_PCI_WINDOW_LOW2_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high2 */
/* => dpmas_mem_win_end2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_high2                                     0x00000094U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_high2 0x1C003494U
#define Adr_NX50_pci_window_high2                                         0x1C003494U
#define DFLT_VAL_NX50_pci_window_high2                                    0x00000000U

#define MSK_NX50_pci_window_high2_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_high2_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_high2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_high2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_HIGH2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_high2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_HIGH2_BIT_T;

typedef union {
	unsigned int                val;
	NX50_PCI_WINDOW_HIGH2_BIT_T bf;
} NX50_PCI_WINDOW_HIGH2_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_low3 */
/* => dpmas_mem_win_start3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_low3                                     0x00000098U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_low3 0x1C003498U
#define Adr_NX50_pci_window_low3                                         0x1C003498U
#define DFLT_VAL_NX50_pci_window_low3                                    0x00000000U

#define MSK_NX50_pci_window_low3_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_low3_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_low3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_low3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_LOW3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_low3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_LOW3_BIT_T;

typedef union {
	unsigned int               val;
	NX50_PCI_WINDOW_LOW3_BIT_T bf;
} NX50_PCI_WINDOW_LOW3_T;

/* --------------------------------------------------------------------- */
/* Register pci_window_high3 */
/* => dpmas_mem_win_end3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_window_high3                                     0x0000009CU
#define Adr_NX50_netx_controlled_global_register_block_1_pci_window_high3 0x1C00349CU
#define Adr_NX50_pci_window_high3                                         0x1C00349CU
#define DFLT_VAL_NX50_pci_window_high3                                    0x00000000U

#define MSK_NX50_pci_window_high3_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_window_high3_keine_ahnung      0
#define DFLT_VAL_NX50_pci_window_high3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_window_high3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_WINDOW_HIGH3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_window_high3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_WINDOW_HIGH3_BIT_T;

typedef union {
	unsigned int                val;
	NX50_PCI_WINDOW_HIGH3_BIT_T bf;
} NX50_PCI_WINDOW_HIGH3_T;

/* --------------------------------------------------------------------- */
/* Register pci_io_base */
/* => dpmas_pci_io_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_io_base                                     0x000000A0U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_io_base 0x1C0034A0U
#define Adr_NX50_pci_io_base                                         0x1C0034A0U
#define DFLT_VAL_NX50_pci_io_base                                    0x00000000U

#define MSK_NX50_pci_io_base_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_io_base_keine_ahnung      0
#define DFLT_VAL_NX50_pci_io_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_io_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_IO_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_io_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_IO_BASE_BIT_T;

typedef union {
	unsigned int           val;
	NX50_PCI_IO_BASE_BIT_T bf;
} NX50_PCI_IO_BASE_T;

/* --------------------------------------------------------------------- */
/* Register pci_rom_base */
/* => dpmas_pci_rom_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_rom_base                                     0x000000A4U
#define Adr_NX50_netx_controlled_global_register_block_1_pci_rom_base 0x1C0034A4U
#define Adr_NX50_pci_rom_base                                         0x1C0034A4U
#define DFLT_VAL_NX50_pci_rom_base                                    0x00000000U

#define MSK_NX50_pci_rom_base_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_rom_base_keine_ahnung      0
#define DFLT_VAL_NX50_pci_rom_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_rom_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_ROM_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_rom_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_ROM_BASE_BIT_T;

typedef union {
	unsigned int            val;
	NX50_PCI_ROM_BASE_BIT_T bf;
} NX50_PCI_ROM_BASE_T;

/* --------------------------------------------------------------------- */
/* Register arb_ctrl */
/* => dpmas_arb_ctrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_arb_ctrl                                     0x000000A8U
#define Adr_NX50_netx_controlled_global_register_block_1_arb_ctrl 0x1C0034A8U
#define Adr_NX50_arb_ctrl                                         0x1C0034A8U
#define DFLT_VAL_NX50_arb_ctrl                                    0x00000000U

#define MSK_NX50_arb_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_arb_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_arb_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_arb_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_ARB_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_arb_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_ARB_CTRL_BIT_T;

typedef union {
	unsigned int        val;
	NX50_ARB_CTRL_BIT_T bf;
} NX50_ARB_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register pci_config */
/* => dpmas_pci_cntrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_config                                     0x000000ACU
#define Adr_NX50_netx_controlled_global_register_block_1_pci_config 0x1C0034ACU
#define Adr_NX50_pci_config                                         0x1C0034ACU
#define DFLT_VAL_NX50_pci_config                                    0x00000000U

#define MSK_NX50_pci_config_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_config_keine_ahnung      0
#define DFLT_VAL_NX50_pci_config_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_config_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_CONFIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_config_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_CONFIG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_PCI_CONFIG_BIT_T bf;
} NX50_PCI_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register sfr_base_addr */
/* => special frank register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sfr_base_addr                                     0x000000B8U
#define Adr_NX50_netx_controlled_global_register_block_1_sfr_base_addr 0x1C0034B8U
#define Adr_NX50_sfr_base_addr                                         0x1C0034B8U
#define DFLT_VAL_NX50_sfr_base_addr                                    0x00000000U

#define MSK_NX50_sfr_base_addr_keine_ahnung      0xffffffffU
#define SRT_NX50_sfr_base_addr_keine_ahnung      0
#define DFLT_VAL_NX50_sfr_base_addr_keine_ahnung 0x00000000U

enum {
	BFW_NX50_sfr_base_addr_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_SFR_BASE_ADDR_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_sfr_base_addr_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_SFR_BASE_ADDR_BIT_T;

typedef union {
	unsigned int             val;
	NX50_SFR_BASE_ADDR_BIT_T bf;
} NX50_SFR_BASE_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register cis_base */
/* => dpmas_cis_base */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_cis_base                                     0x000000BCU
#define Adr_NX50_netx_controlled_global_register_block_1_cis_base 0x1C0034BCU
#define Adr_NX50_cis_base                                         0x1C0034BCU
#define DFLT_VAL_NX50_cis_base                                    0x00000000U

#define MSK_NX50_cis_base_keine_ahnung      0xffffffffU
#define SRT_NX50_cis_base_keine_ahnung      0
#define DFLT_VAL_NX50_cis_base_keine_ahnung 0x00000000U

enum {
	BFW_NX50_cis_base_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_CIS_BASE_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_cis_base_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_CIS_BASE_BIT_T;

typedef union {
	unsigned int        val;
	NX50_CIS_BASE_BIT_T bf;
} NX50_CIS_BASE_T;

/* --------------------------------------------------------------------- */
/* Register wdg_netx */
/* => dpmas_wdg_host_timeout */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_wdg_netx                                     0x000000C0U
#define Adr_NX50_netx_controlled_global_register_block_1_wdg_netx 0x1C0034C0U
#define Adr_NX50_wdg_netx                                         0x1C0034C0U
#define DFLT_VAL_NX50_wdg_netx                                    0x00000000U

#define MSK_NX50_wdg_netx_keine_ahnung      0xffffffffU
#define SRT_NX50_wdg_netx_keine_ahnung      0
#define DFLT_VAL_NX50_wdg_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX50_wdg_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_WDG_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_wdg_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_WDG_NETX_BIT_T;

typedef union {
	unsigned int        val;
	NX50_WDG_NETX_BIT_T bf;
} NX50_WDG_NETX_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_wdg_arm_timeout */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_wdg_arm_timeout                                     0x000000C8U
#define Adr_NX50_netx_controlled_global_register_block_1_dpmas_wdg_arm_timeout 0x1C0034C8U
#define Adr_NX50_dpmas_wdg_arm_timeout                                         0x1C0034C8U
#define DFLT_VAL_NX50_dpmas_wdg_arm_timeout                                    0x00000000U

#define MSK_NX50_dpmas_wdg_arm_timeout_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_wdg_arm_timeout_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_wdg_arm_timeout_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_wdg_arm_timeout_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_WDG_ARM_TIMEOUT_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_wdg_arm_timeout_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_WDG_ARM_TIMEOUT_BIT_T;

typedef union {
	unsigned int                     val;
	NX50_DPMAS_WDG_ARM_TIMEOUT_BIT_T bf;
} NX50_DPMAS_WDG_ARM_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_wdg_arm_trig */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_wdg_arm_trig                                     0x000000CCU
#define Adr_NX50_netx_controlled_global_register_block_1_dpmas_wdg_arm_trig 0x1C0034CCU
#define Adr_NX50_dpmas_wdg_arm_trig                                         0x1C0034CCU
#define DFLT_VAL_NX50_dpmas_wdg_arm_trig                                    0x00000000U

#define MSK_NX50_dpmas_wdg_arm_trig_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_wdg_arm_trig_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_wdg_arm_trig_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_wdg_arm_trig_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_WDG_ARM_TRIG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_wdg_arm_trig_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_WDG_ARM_TRIG_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DPMAS_WDG_ARM_TRIG_BIT_T bf;
} NX50_DPMAS_WDG_ARM_TRIG_T;

/* --------------------------------------------------------------------- */
/* Register sta_netx */
/* => dpmas_sys_sta */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_sta_netx                                     0x000000D8U
#define Adr_NX50_netx_controlled_global_register_block_1_sta_netx 0x1C0034D8U
#define Adr_NX50_sta_netx                                         0x1C0034D8U
#define DFLT_VAL_NX50_sta_netx                                    0x00000000U

#define MSK_NX50_sta_netx_keine_ahnung      0xffffffffU
#define SRT_NX50_sta_netx_keine_ahnung      0
#define DFLT_VAL_NX50_sta_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX50_sta_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_STA_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_sta_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_STA_NETX_BIT_T;

typedef union {
	unsigned int        val;
	NX50_STA_NETX_BIT_T bf;
} NX50_STA_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_reg_netx */
/* => dpmas_int_sta0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_irq_reg_netx                                     0x000000E0U
#define Adr_NX50_netx_controlled_global_register_block_1_irq_reg_netx 0x1C0034E0U
#define Adr_NX50_irq_reg_netx                                         0x1C0034E0U
#define DFLT_VAL_NX50_irq_reg_netx                                    0x00000000U

#define MSK_NX50_irq_reg_netx_keine_ahnung      0xffffffffU
#define SRT_NX50_irq_reg_netx_keine_ahnung      0
#define DFLT_VAL_NX50_irq_reg_netx_keine_ahnung 0x00000000U

enum {
	BFW_NX50_irq_reg_netx_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IRQ_REG_NETX_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_irq_reg_netx_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IRQ_REG_NETX_BIT_T;

typedef union {
	unsigned int            val;
	NX50_IRQ_REG_NETX_BIT_T bf;
} NX50_IRQ_REG_NETX_T;

/* --------------------------------------------------------------------- */
/* Register irq_reg_netx1 */
/* => dpmas_int_sta1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_irq_reg_netx1                                     0x000000E4U
#define Adr_NX50_netx_controlled_global_register_block_1_irq_reg_netx1 0x1C0034E4U
#define Adr_NX50_irq_reg_netx1                                         0x1C0034E4U
#define DFLT_VAL_NX50_irq_reg_netx1                                    0x00000000U

#define MSK_NX50_irq_reg_netx1_keine_ahnung      0xffffffffU
#define SRT_NX50_irq_reg_netx1_keine_ahnung      0
#define DFLT_VAL_NX50_irq_reg_netx1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_irq_reg_netx1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IRQ_REG_NETX1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_irq_reg_netx1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IRQ_REG_NETX1_BIT_T;

typedef union {
	unsigned int             val;
	NX50_IRQ_REG_NETX1_BIT_T bf;
} NX50_IRQ_REG_NETX1_T;

/* --------------------------------------------------------------------- */
/* Register irq_reg_netx2 */
/* => dpmas_int_sta2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_irq_reg_netx2                                     0x000000E8U
#define Adr_NX50_netx_controlled_global_register_block_1_irq_reg_netx2 0x1C0034E8U
#define Adr_NX50_irq_reg_netx2                                         0x1C0034E8U
#define DFLT_VAL_NX50_irq_reg_netx2                                    0x00000000U

#define MSK_NX50_irq_reg_netx2_keine_ahnung      0xffffffffU
#define SRT_NX50_irq_reg_netx2_keine_ahnung      0
#define DFLT_VAL_NX50_irq_reg_netx2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_irq_reg_netx2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IRQ_REG_NETX2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_irq_reg_netx2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IRQ_REG_NETX2_BIT_T;

typedef union {
	unsigned int             val;
	NX50_IRQ_REG_NETX2_BIT_T bf;
} NX50_IRQ_REG_NETX2_T;

/* --------------------------------------------------------------------- */
/* Register irq_reg_netx3 */
/* => dpmas_int_sta3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_irq_reg_netx3                                     0x000000ECU
#define Adr_NX50_netx_controlled_global_register_block_1_irq_reg_netx3 0x1C0034ECU
#define Adr_NX50_irq_reg_netx3                                         0x1C0034ECU
#define DFLT_VAL_NX50_irq_reg_netx3                                    0x00000000U

#define MSK_NX50_irq_reg_netx3_keine_ahnung      0xffffffffU
#define SRT_NX50_irq_reg_netx3_keine_ahnung      0
#define DFLT_VAL_NX50_irq_reg_netx3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_irq_reg_netx3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IRQ_REG_NETX3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_irq_reg_netx3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IRQ_REG_NETX3_BIT_T;

typedef union {
	unsigned int             val;
	NX50_IRQ_REG_NETX3_BIT_T bf;
} NX50_IRQ_REG_NETX3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_int_en0 */
/* => dpmas_int_en0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_int_en0                                     0x000000F0U
#define Adr_NX50_netx_controlled_global_register_block_1_dpmas_int_en0 0x1C0034F0U
#define Adr_NX50_dpmas_int_en0                                         0x1C0034F0U
#define DFLT_VAL_NX50_dpmas_int_en0                                    0x00000000U

#define MSK_NX50_dpmas_int_en0_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_int_en0_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_int_en0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_int_en0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_INT_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_int_en0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_INT_EN0_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_INT_EN0_BIT_T bf;
} NX50_DPMAS_INT_EN0_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_int_en1 */
/* => dpmas_int_en1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_int_en1                                     0x000000F4U
#define Adr_NX50_netx_controlled_global_register_block_1_dpmas_int_en1 0x1C0034F4U
#define Adr_NX50_dpmas_int_en1                                         0x1C0034F4U
#define DFLT_VAL_NX50_dpmas_int_en1                                    0x00000000U

#define MSK_NX50_dpmas_int_en1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_int_en1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_int_en1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_int_en1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_INT_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_int_en1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_INT_EN1_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_INT_EN1_BIT_T bf;
} NX50_DPMAS_INT_EN1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_int_en2 */
/* => dpmas_int_en2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_int_en2                                     0x000000F8U
#define Adr_NX50_netx_controlled_global_register_block_1_dpmas_int_en2 0x1C0034F8U
#define Adr_NX50_dpmas_int_en2                                         0x1C0034F8U
#define DFLT_VAL_NX50_dpmas_int_en2                                    0x00000000U

#define MSK_NX50_dpmas_int_en2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_int_en2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_int_en2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_int_en2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_INT_EN2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_int_en2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_INT_EN2_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_INT_EN2_BIT_T bf;
} NX50_DPMAS_INT_EN2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_int_en3 */
/* => dpmas_int_en3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_int_en3                                     0x000000FCU
#define Adr_NX50_netx_controlled_global_register_block_1_dpmas_int_en3 0x1C0034FCU
#define Adr_NX50_dpmas_int_en3                                         0x1C0034FCU
#define DFLT_VAL_NX50_dpmas_int_en3                                    0x00000000U

#define MSK_NX50_dpmas_int_en3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_int_en3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_int_en3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_int_en3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_INT_EN3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_int_en3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_INT_EN3_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_INT_EN3_BIT_T bf;
} NX50_DPMAS_INT_EN3_T;


/* ===================================================================== */

/* Area of netx_controlled_handshake_register_block */

/* ===================================================================== */

#define Addr_NX50_netx_controlled_handshake_register_block 0x1C003500U
#define NX50_NETX_DPM_ARM_HS_AREA                          0x1C003500U

/* --------------------------------------------------------------------- */
/* Register handshake_ch0 */
/* => dpmas_hs_data0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch0                                      0x00000000U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch0 0x1C003500U
#define Adr_NX50_handshake_ch0                                          0x1C003500U
#define DFLT_VAL_NX50_handshake_ch0                                     0x00000000U

#define MSK_NX50_handshake_ch0_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch0_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH0_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH0_BIT_T bf;
} NX50_HANDSHAKE_CH0_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch1 */
/* => dpmas_hs_data1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch1                                      0x00000004U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch1 0x1C003504U
#define Adr_NX50_handshake_ch1                                          0x1C003504U
#define DFLT_VAL_NX50_handshake_ch1                                     0x00000000U

#define MSK_NX50_handshake_ch1_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch1_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH1_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH1_BIT_T bf;
} NX50_HANDSHAKE_CH1_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch2 */
/* => dpmas_hs_data2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch2                                      0x00000008U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch2 0x1C003508U
#define Adr_NX50_handshake_ch2                                          0x1C003508U
#define DFLT_VAL_NX50_handshake_ch2                                     0x00000000U

#define MSK_NX50_handshake_ch2_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch2_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH2_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH2_BIT_T bf;
} NX50_HANDSHAKE_CH2_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch3 */
/* => dpmas_hs_data3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch3                                      0x0000000CU
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch3 0x1C00350CU
#define Adr_NX50_handshake_ch3                                          0x1C00350CU
#define DFLT_VAL_NX50_handshake_ch3                                     0x00000000U

#define MSK_NX50_handshake_ch3_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch3_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH3_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH3_BIT_T bf;
} NX50_HANDSHAKE_CH3_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch4 */
/* => dpmas_hs_data4 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch4                                      0x00000010U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch4 0x1C003510U
#define Adr_NX50_handshake_ch4                                          0x1C003510U
#define DFLT_VAL_NX50_handshake_ch4                                     0x00000000U

#define MSK_NX50_handshake_ch4_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch4_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch4_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH4_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH4_BIT_T bf;
} NX50_HANDSHAKE_CH4_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch5 */
/* => dpmas_hs_data5 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch5                                      0x00000014U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch5 0x1C003514U
#define Adr_NX50_handshake_ch5                                          0x1C003514U
#define DFLT_VAL_NX50_handshake_ch5                                     0x00000000U

#define MSK_NX50_handshake_ch5_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch5_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch5_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH5_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH5_BIT_T bf;
} NX50_HANDSHAKE_CH5_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch6 */
/* => dpmas_hs_data6 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch6                                      0x00000018U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch6 0x1C003518U
#define Adr_NX50_handshake_ch6                                          0x1C003518U
#define DFLT_VAL_NX50_handshake_ch6                                     0x00000000U

#define MSK_NX50_handshake_ch6_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch6_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch6_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH6_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH6_BIT_T bf;
} NX50_HANDSHAKE_CH6_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch7 */
/* => dpmas_hs_data7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch7                                      0x0000001CU
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch7 0x1C00351CU
#define Adr_NX50_handshake_ch7                                          0x1C00351CU
#define DFLT_VAL_NX50_handshake_ch7                                     0x00000000U

#define MSK_NX50_handshake_ch7_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch7_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch7_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH7_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH7_BIT_T bf;
} NX50_HANDSHAKE_CH7_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch8 */
/* => dpmas_hs_data8 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch8                                      0x00000020U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch8 0x1C003520U
#define Adr_NX50_handshake_ch8                                          0x1C003520U
#define DFLT_VAL_NX50_handshake_ch8                                     0x00000000U

#define MSK_NX50_handshake_ch8_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch8_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch8_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch8_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch8_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH8_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH8_BIT_T bf;
} NX50_HANDSHAKE_CH8_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch9 */
/* => dpmas_hs_data9 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch9                                      0x00000024U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch9 0x1C003524U
#define Adr_NX50_handshake_ch9                                          0x1C003524U
#define DFLT_VAL_NX50_handshake_ch9                                     0x00000000U

#define MSK_NX50_handshake_ch9_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch9_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch9_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch9_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch9_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH9_BIT_T;

typedef union {
	unsigned int             val;
	NX50_HANDSHAKE_CH9_BIT_T bf;
} NX50_HANDSHAKE_CH9_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch10 */
/* => dpmas_hs_data10 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch10                                      0x00000028U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch10 0x1C003528U
#define Adr_NX50_handshake_ch10                                          0x1C003528U
#define DFLT_VAL_NX50_handshake_ch10                                     0x00000000U

#define MSK_NX50_handshake_ch10_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch10_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch10_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch10_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch10_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH10_BIT_T;

typedef union {
	unsigned int              val;
	NX50_HANDSHAKE_CH10_BIT_T bf;
} NX50_HANDSHAKE_CH10_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch11 */
/* => dpmas_hs_data11 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch11                                      0x0000002CU
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch11 0x1C00352CU
#define Adr_NX50_handshake_ch11                                          0x1C00352CU
#define DFLT_VAL_NX50_handshake_ch11                                     0x00000000U

#define MSK_NX50_handshake_ch11_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch11_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch11_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch11_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch11_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH11_BIT_T;

typedef union {
	unsigned int              val;
	NX50_HANDSHAKE_CH11_BIT_T bf;
} NX50_HANDSHAKE_CH11_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch12 */
/* => dpmas_hs_data12 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch12                                      0x00000030U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch12 0x1C003530U
#define Adr_NX50_handshake_ch12                                          0x1C003530U
#define DFLT_VAL_NX50_handshake_ch12                                     0x00000000U

#define MSK_NX50_handshake_ch12_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch12_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch12_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch12_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch12_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH12_BIT_T;

typedef union {
	unsigned int              val;
	NX50_HANDSHAKE_CH12_BIT_T bf;
} NX50_HANDSHAKE_CH12_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch13 */
/* => dpmas_hs_data13 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch13                                      0x00000034U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch13 0x1C003534U
#define Adr_NX50_handshake_ch13                                          0x1C003534U
#define DFLT_VAL_NX50_handshake_ch13                                     0x00000000U

#define MSK_NX50_handshake_ch13_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch13_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch13_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch13_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch13_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH13_BIT_T;

typedef union {
	unsigned int              val;
	NX50_HANDSHAKE_CH13_BIT_T bf;
} NX50_HANDSHAKE_CH13_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch14 */
/* => dpmas_hs_data14 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch14                                      0x00000038U
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch14 0x1C003538U
#define Adr_NX50_handshake_ch14                                          0x1C003538U
#define DFLT_VAL_NX50_handshake_ch14                                     0x00000000U

#define MSK_NX50_handshake_ch14_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch14_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch14_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch14_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch14_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH14_BIT_T;

typedef union {
	unsigned int              val;
	NX50_HANDSHAKE_CH14_BIT_T bf;
} NX50_HANDSHAKE_CH14_T;

/* --------------------------------------------------------------------- */
/* Register handshake_ch15 */
/* => dpmas_hs_data15 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_handshake_ch15                                      0x0000003CU
#define Adr_NX50_netx_controlled_handshake_register_block_handshake_ch15 0x1C00353CU
#define Adr_NX50_handshake_ch15                                          0x1C00353CU
#define DFLT_VAL_NX50_handshake_ch15                                     0x00000000U

#define MSK_NX50_handshake_ch15_keine_ahnung      0xffffffffU
#define SRT_NX50_handshake_ch15_keine_ahnung      0
#define DFLT_VAL_NX50_handshake_ch15_keine_ahnung 0x00000000U

enum {
	BFW_NX50_handshake_ch15_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HANDSHAKE_CH15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_handshake_ch15_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HANDSHAKE_CH15_BIT_T;

typedef union {
	unsigned int              val;
	NX50_HANDSHAKE_CH15_BIT_T bf;
} NX50_HANDSHAKE_CH15_T;


/* ===================================================================== */

/* Area of netx_controlled_global_register_block_2 */

/* ===================================================================== */

#define Addr_NX50_netx_controlled_global_register_block_2 0x1C003600U
#define NX50_NETX_DPM_ARM_GLOB_AREA                       0x1C003600U

/* --------------------------------------------------------------------- */
/* Register clk_reg */
/* => dpmas_clkout_conf */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_clk_reg                                     0x00000004U
#define Adr_NX50_netx_controlled_global_register_block_2_clk_reg 0x1C003604U
#define Adr_NX50_clk_reg                                         0x1C003604U
#define DFLT_VAL_NX50_clk_reg                                    0x00000000U

#define MSK_NX50_clk_reg_keine_ahnung      0xffffffffU
#define SRT_NX50_clk_reg_keine_ahnung      0
#define DFLT_VAL_NX50_clk_reg_keine_ahnung 0x00000000U

enum {
	BFW_NX50_clk_reg_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_CLK_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_clk_reg_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_CLK_REG_BIT_T;

typedef union {
	unsigned int       val;
	NX50_CLK_REG_BIT_T bf;
} NX50_CLK_REG_T;

/* --------------------------------------------------------------------- */
/* Register if_conf1 */
/* => dpmas_if_conf0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_if_conf1                                     0x00000008U
#define Adr_NX50_netx_controlled_global_register_block_2_if_conf1 0x1C003608U
#define Adr_NX50_if_conf1                                         0x1C003608U
#define DFLT_VAL_NX50_if_conf1                                    0x00000000U

#define MSK_NX50_if_conf1_keine_ahnung      0xffffffffU
#define SRT_NX50_if_conf1_keine_ahnung      0
#define DFLT_VAL_NX50_if_conf1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_if_conf1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IF_CONF1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_if_conf1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IF_CONF1_BIT_T;

typedef union {
	unsigned int        val;
	NX50_IF_CONF1_BIT_T bf;
} NX50_IF_CONF1_T;

/* --------------------------------------------------------------------- */
/* Register if_conf2 */
/* => dpmas_if_conf1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_if_conf2                                     0x0000000CU
#define Adr_NX50_netx_controlled_global_register_block_2_if_conf2 0x1C00360CU
#define Adr_NX50_if_conf2                                         0x1C00360CU
#define DFLT_VAL_NX50_if_conf2                                    0x00000000U

#define MSK_NX50_if_conf2_keine_ahnung      0xffffffffU
#define SRT_NX50_if_conf2_keine_ahnung      0
#define DFLT_VAL_NX50_if_conf2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_if_conf2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IF_CONF2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_if_conf2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IF_CONF2_BIT_T;

typedef union {
	unsigned int        val;
	NX50_IF_CONF2_BIT_T bf;
} NX50_IF_CONF2_T;

/* --------------------------------------------------------------------- */
/* Register exp_bus_reg */
/* => dpmas_ext_config0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_exp_bus_reg                                     0x00000010U
#define Adr_NX50_netx_controlled_global_register_block_2_exp_bus_reg 0x1C003610U
#define Adr_NX50_exp_bus_reg                                         0x1C003610U
#define DFLT_VAL_NX50_exp_bus_reg                                    0x00000000U

#define MSK_NX50_exp_bus_reg_keine_ahnung      0xffffffffU
#define SRT_NX50_exp_bus_reg_keine_ahnung      0
#define DFLT_VAL_NX50_exp_bus_reg_keine_ahnung 0x00000000U

enum {
	BFW_NX50_exp_bus_reg_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_EXP_BUS_REG_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_exp_bus_reg_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_EXP_BUS_REG_BIT_T;

typedef union {
	unsigned int           val;
	NX50_EXP_BUS_REG_BIT_T bf;
} NX50_EXP_BUS_REG_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ext_config1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ext_config1                                     0x00000014U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_ext_config1 0x1C003614U
#define Adr_NX50_dpmas_ext_config1                                         0x1C003614U
#define DFLT_VAL_NX50_dpmas_ext_config1                                    0x00000000U

#define MSK_NX50_dpmas_ext_config1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ext_config1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ext_config1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ext_config1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_EXT_CONFIG1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ext_config1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_EXT_CONFIG1_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_EXT_CONFIG1_BIT_T bf;
} NX50_DPMAS_EXT_CONFIG1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ext_config2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ext_config2                                     0x00000018U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_ext_config2 0x1C003618U
#define Adr_NX50_dpmas_ext_config2                                         0x1C003618U
#define DFLT_VAL_NX50_dpmas_ext_config2                                    0x00000000U

#define MSK_NX50_dpmas_ext_config2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ext_config2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ext_config2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ext_config2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_EXT_CONFIG2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ext_config2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_EXT_CONFIG2_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_EXT_CONFIG2_BIT_T bf;
} NX50_DPMAS_EXT_CONFIG2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_ext_config3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_ext_config3                                     0x0000001CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_ext_config3 0x1C00361CU
#define Adr_NX50_dpmas_ext_config3                                         0x1C00361CU
#define DFLT_VAL_NX50_dpmas_ext_config3                                    0x00000000U

#define MSK_NX50_dpmas_ext_config3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_ext_config3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_ext_config3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_ext_config3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_EXT_CONFIG3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_ext_config3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_EXT_CONFIG3_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_EXT_CONFIG3_BIT_T bf;
} NX50_DPMAS_EXT_CONFIG3_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_mode0 */
/* => dpmas_io_mode0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_mode0                                     0x00000020U
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_mode0 0x1C003620U
#define Adr_NX50_io_reg_mode0                                         0x1C003620U
#define DFLT_VAL_NX50_io_reg_mode0                                    0x00000000U

#define MSK_NX50_io_reg_mode0_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_mode0_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_mode0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_mode0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_MODE0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_mode0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_MODE0_BIT_T;

typedef union {
	unsigned int            val;
	NX50_IO_REG_MODE0_BIT_T bf;
} NX50_IO_REG_MODE0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_drv_en0 */
/* => dpmas_io_drv_en0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_drv_en0                                     0x00000024U
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_drv_en0 0x1C003624U
#define Adr_NX50_io_reg_drv_en0                                         0x1C003624U
#define DFLT_VAL_NX50_io_reg_drv_en0                                    0x00000000U

#define MSK_NX50_io_reg_drv_en0_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_drv_en0_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_drv_en0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_drv_en0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_DRV_EN0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_drv_en0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_DRV_EN0_BIT_T;

typedef union {
	unsigned int              val;
	NX50_IO_REG_DRV_EN0_BIT_T bf;
} NX50_IO_REG_DRV_EN0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_data0 */
/* => dpmas_io_data0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_data0                                     0x00000028U
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_data0 0x1C003628U
#define Adr_NX50_io_reg_data0                                         0x1C003628U
#define DFLT_VAL_NX50_io_reg_data0                                    0x00000000U

#define MSK_NX50_io_reg_data0_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_data0_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_data0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_data0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_DATA0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_data0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_DATA0_BIT_T;

typedef union {
	unsigned int            val;
	NX50_IO_REG_DATA0_BIT_T bf;
} NX50_IO_REG_DATA0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_reserved0 */
/* => reserved */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_reserved0                                     0x0000002CU
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_reserved0 0x1C00362CU
#define Adr_NX50_io_reg_reserved0                                         0x1C00362CU
#define DFLT_VAL_NX50_io_reg_reserved0                                    0x00000000U

#define MSK_NX50_io_reg_reserved0_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_reserved0_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_reserved0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_reserved0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_RESERVED0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_reserved0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_RESERVED0_BIT_T;

typedef union {
	unsigned int                val;
	NX50_IO_REG_RESERVED0_BIT_T bf;
} NX50_IO_REG_RESERVED0_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_mode1 */
/* => dpmas_io_mode1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_mode1                                     0x00000030U
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_mode1 0x1C003630U
#define Adr_NX50_io_reg_mode1                                         0x1C003630U
#define DFLT_VAL_NX50_io_reg_mode1                                    0x00000000U

#define MSK_NX50_io_reg_mode1_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_mode1_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_mode1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_mode1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_MODE1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_mode1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_MODE1_BIT_T;

typedef union {
	unsigned int            val;
	NX50_IO_REG_MODE1_BIT_T bf;
} NX50_IO_REG_MODE1_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_drv_en1 */
/* => dpmas_io_drv_en1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_drv_en1                                     0x00000034U
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_drv_en1 0x1C003634U
#define Adr_NX50_io_reg_drv_en1                                         0x1C003634U
#define DFLT_VAL_NX50_io_reg_drv_en1                                    0x00000000U

#define MSK_NX50_io_reg_drv_en1_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_drv_en1_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_drv_en1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_drv_en1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_DRV_EN1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_drv_en1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_DRV_EN1_BIT_T;

typedef union {
	unsigned int              val;
	NX50_IO_REG_DRV_EN1_BIT_T bf;
} NX50_IO_REG_DRV_EN1_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_data1 */
/* => dpmas_io_data1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_data1                                     0x00000038U
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_data1 0x1C003638U
#define Adr_NX50_io_reg_data1                                         0x1C003638U
#define DFLT_VAL_NX50_io_reg_data1                                    0x00000000U

#define MSK_NX50_io_reg_data1_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_data1_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_data1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_data1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_DATA1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_data1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_DATA1_BIT_T;

typedef union {
	unsigned int            val;
	NX50_IO_REG_DATA1_BIT_T bf;
} NX50_IO_REG_DATA1_T;

/* --------------------------------------------------------------------- */
/* Register io_reg_reserved1 */
/* => reserved */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_io_reg_reserved1                                     0x0000003CU
#define Adr_NX50_netx_controlled_global_register_block_2_io_reg_reserved1 0x1C00363CU
#define Adr_NX50_io_reg_reserved1                                         0x1C00363CU
#define DFLT_VAL_NX50_io_reg_reserved1                                    0x00000000U

#define MSK_NX50_io_reg_reserved1_keine_ahnung      0xffffffffU
#define SRT_NX50_io_reg_reserved1_keine_ahnung      0
#define DFLT_VAL_NX50_io_reg_reserved1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_io_reg_reserved1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_IO_REG_RESERVED1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_io_reg_reserved1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_IO_REG_RESERVED1_BIT_T;

typedef union {
	unsigned int                val;
	NX50_IO_REG_RESERVED1_BIT_T bf;
} NX50_IO_REG_RESERVED1_T;

/* --------------------------------------------------------------------- */
/* Register mb_ctrl */
/* => dpmas_db_end0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_mb_ctrl                                     0x00000040U
#define Adr_NX50_netx_controlled_global_register_block_2_mb_ctrl 0x1C003640U
#define Adr_NX50_mb_ctrl                                         0x1C003640U
#define DFLT_VAL_NX50_mb_ctrl                                    0x00000000U

#define MSK_NX50_mb_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_mb_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_mb_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_mb_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_MB_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_mb_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_MB_CTRL_BIT_T;

typedef union {
	unsigned int       val;
	NX50_MB_CTRL_BIT_T bf;
} NX50_MB_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping0 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping0                                     0x00000044U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping0 0x1C003644U
#define Adr_NX50_dpmas_db_mapping0                                         0x1C003644U
#define DFLT_VAL_NX50_dpmas_db_mapping0                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping0_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping0_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping0_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping0_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING0_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping0_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING0_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING0_BIT_T bf;
} NX50_DPMAS_DB_MAPPING0_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end1                                     0x00000048U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end1 0x1C003648U
#define Adr_NX50_dpmas_db_end1                                         0x1C003648U
#define DFLT_VAL_NX50_dpmas_db_end1                                    0x00000000U

#define MSK_NX50_dpmas_db_end1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END1_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END1_BIT_T bf;
} NX50_DPMAS_DB_END1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping1                                     0x0000004CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping1 0x1C00364CU
#define Adr_NX50_dpmas_db_mapping1                                         0x1C00364CU
#define DFLT_VAL_NX50_dpmas_db_mapping1                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING1_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING1_BIT_T bf;
} NX50_DPMAS_DB_MAPPING1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end2                                     0x00000050U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end2 0x1C003650U
#define Adr_NX50_dpmas_db_end2                                         0x1C003650U
#define DFLT_VAL_NX50_dpmas_db_end2                                    0x00000000U

#define MSK_NX50_dpmas_db_end2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END2_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END2_BIT_T bf;
} NX50_DPMAS_DB_END2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping2                                     0x00000054U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping2 0x1C003654U
#define Adr_NX50_dpmas_db_mapping2                                         0x1C003654U
#define DFLT_VAL_NX50_dpmas_db_mapping2                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING2_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING2_BIT_T bf;
} NX50_DPMAS_DB_MAPPING2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end3                                     0x00000058U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end3 0x1C003658U
#define Adr_NX50_dpmas_db_end3                                         0x1C003658U
#define DFLT_VAL_NX50_dpmas_db_end3                                    0x00000000U

#define MSK_NX50_dpmas_db_end3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END3_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END3_BIT_T bf;
} NX50_DPMAS_DB_END3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping3                                     0x0000005CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping3 0x1C00365CU
#define Adr_NX50_dpmas_db_mapping3                                         0x1C00365CU
#define DFLT_VAL_NX50_dpmas_db_mapping3                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING3_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING3_BIT_T bf;
} NX50_DPMAS_DB_MAPPING3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end4                                     0x00000060U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end4 0x1C003660U
#define Adr_NX50_dpmas_db_end4                                         0x1C003660U
#define DFLT_VAL_NX50_dpmas_db_end4                                    0x00000000U

#define MSK_NX50_dpmas_db_end4_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end4_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end4_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END4_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END4_BIT_T bf;
} NX50_DPMAS_DB_END4_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping4                                     0x00000064U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping4 0x1C003664U
#define Adr_NX50_dpmas_db_mapping4                                         0x1C003664U
#define DFLT_VAL_NX50_dpmas_db_mapping4                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping4_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping4_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping4_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING4_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING4_BIT_T bf;
} NX50_DPMAS_DB_MAPPING4_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end5                                     0x00000068U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end5 0x1C003668U
#define Adr_NX50_dpmas_db_end5                                         0x1C003668U
#define DFLT_VAL_NX50_dpmas_db_end5                                    0x00000000U

#define MSK_NX50_dpmas_db_end5_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end5_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end5_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END5_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END5_BIT_T bf;
} NX50_DPMAS_DB_END5_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping5                                     0x0000006CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping5 0x1C00366CU
#define Adr_NX50_dpmas_db_mapping5                                         0x1C00366CU
#define DFLT_VAL_NX50_dpmas_db_mapping5                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping5_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping5_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping5_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING5_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING5_BIT_T bf;
} NX50_DPMAS_DB_MAPPING5_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end6                                     0x00000070U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end6 0x1C003670U
#define Adr_NX50_dpmas_db_end6                                         0x1C003670U
#define DFLT_VAL_NX50_dpmas_db_end6                                    0x00000000U

#define MSK_NX50_dpmas_db_end6_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end6_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end6_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END6_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END6_BIT_T bf;
} NX50_DPMAS_DB_END6_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping6                                     0x00000074U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping6 0x1C003674U
#define Adr_NX50_dpmas_db_mapping6                                         0x1C003674U
#define DFLT_VAL_NX50_dpmas_db_mapping6                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping6_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping6_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping6_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING6_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING6_BIT_T bf;
} NX50_DPMAS_DB_MAPPING6_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_end7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_end7                                     0x00000078U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_end7 0x1C003678U
#define Adr_NX50_dpmas_db_end7                                         0x1C003678U
#define DFLT_VAL_NX50_dpmas_db_end7                                    0x00000000U

#define MSK_NX50_dpmas_db_end7_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_end7_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_end7_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_end7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_END7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_end7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_END7_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DPMAS_DB_END7_BIT_T bf;
} NX50_DPMAS_DB_END7_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_db_mapping7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_db_mapping7                                     0x0000007CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_db_mapping7 0x1C00367CU
#define Adr_NX50_dpmas_db_mapping7                                         0x1C00367CU
#define DFLT_VAL_NX50_dpmas_db_mapping7                                    0x00000000U

#define MSK_NX50_dpmas_db_mapping7_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_db_mapping7_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_db_mapping7_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_db_mapping7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_DB_MAPPING7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_db_mapping7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_DB_MAPPING7_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DPMAS_DB_MAPPING7_BIT_T bf;
} NX50_DPMAS_DB_MAPPING7_T;

/* --------------------------------------------------------------------- */
/* Register hs_ctrl */
/* => dpmas_hscr0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_hs_ctrl                                     0x00000080U
#define Adr_NX50_netx_controlled_global_register_block_2_hs_ctrl 0x1C003680U
#define Adr_NX50_hs_ctrl                                         0x1C003680U
#define DFLT_VAL_NX50_hs_ctrl                                    0x00000000U

#define MSK_NX50_hs_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_hs_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_hs_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_hs_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_HS_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_hs_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_HS_CTRL_BIT_T;

typedef union {
	unsigned int       val;
	NX50_HS_CTRL_BIT_T bf;
} NX50_HS_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr1                                     0x00000084U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr1 0x1C003684U
#define Adr_NX50_dpmas_hscr1                                         0x1C003684U
#define DFLT_VAL_NX50_dpmas_hscr1                                    0x00000000U

#define MSK_NX50_dpmas_hscr1_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr1_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr1_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr1_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR1_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr1_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR1_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR1_BIT_T bf;
} NX50_DPMAS_HSCR1_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr2                                     0x00000088U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr2 0x1C003688U
#define Adr_NX50_dpmas_hscr2                                         0x1C003688U
#define DFLT_VAL_NX50_dpmas_hscr2                                    0x00000000U

#define MSK_NX50_dpmas_hscr2_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr2_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr2_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr2_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR2_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr2_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR2_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR2_BIT_T bf;
} NX50_DPMAS_HSCR2_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr3                                     0x0000008CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr3 0x1C00368CU
#define Adr_NX50_dpmas_hscr3                                         0x1C00368CU
#define DFLT_VAL_NX50_dpmas_hscr3                                    0x00000000U

#define MSK_NX50_dpmas_hscr3_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr3_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr3_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr3_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR3_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr3_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR3_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR3_BIT_T bf;
} NX50_DPMAS_HSCR3_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr4                                     0x00000090U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr4 0x1C003690U
#define Adr_NX50_dpmas_hscr4                                         0x1C003690U
#define DFLT_VAL_NX50_dpmas_hscr4                                    0x00000000U

#define MSK_NX50_dpmas_hscr4_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr4_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr4_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr4_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR4_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr4_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR4_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR4_BIT_T bf;
} NX50_DPMAS_HSCR4_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr5                                     0x00000094U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr5 0x1C003694U
#define Adr_NX50_dpmas_hscr5                                         0x1C003694U
#define DFLT_VAL_NX50_dpmas_hscr5                                    0x00000000U

#define MSK_NX50_dpmas_hscr5_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr5_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr5_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr5_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR5_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr5_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR5_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR5_BIT_T bf;
} NX50_DPMAS_HSCR5_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr6                                     0x00000098U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr6 0x1C003698U
#define Adr_NX50_dpmas_hscr6                                         0x1C003698U
#define DFLT_VAL_NX50_dpmas_hscr6                                    0x00000000U

#define MSK_NX50_dpmas_hscr6_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr6_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr6_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr6_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR6_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr6_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR6_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR6_BIT_T bf;
} NX50_DPMAS_HSCR6_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr7                                     0x0000009CU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr7 0x1C00369CU
#define Adr_NX50_dpmas_hscr7                                         0x1C00369CU
#define DFLT_VAL_NX50_dpmas_hscr7                                    0x00000000U

#define MSK_NX50_dpmas_hscr7_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr7_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr7_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr7_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR7_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr7_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR7_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR7_BIT_T bf;
} NX50_DPMAS_HSCR7_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr8 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr8                                     0x000000A0U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr8 0x1C0036A0U
#define Adr_NX50_dpmas_hscr8                                         0x1C0036A0U
#define DFLT_VAL_NX50_dpmas_hscr8                                    0x00000000U

#define MSK_NX50_dpmas_hscr8_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr8_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr8_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr8_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR8_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr8_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR8_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR8_BIT_T bf;
} NX50_DPMAS_HSCR8_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr9 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr9                                     0x000000A4U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr9 0x1C0036A4U
#define Adr_NX50_dpmas_hscr9                                         0x1C0036A4U
#define DFLT_VAL_NX50_dpmas_hscr9                                    0x00000000U

#define MSK_NX50_dpmas_hscr9_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr9_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr9_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr9_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR9_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr9_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR9_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DPMAS_HSCR9_BIT_T bf;
} NX50_DPMAS_HSCR9_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr10 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr10                                     0x000000A8U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr10 0x1C0036A8U
#define Adr_NX50_dpmas_hscr10                                         0x1C0036A8U
#define DFLT_VAL_NX50_dpmas_hscr10                                    0x00000000U

#define MSK_NX50_dpmas_hscr10_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr10_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr10_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr10_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR10_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr10_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR10_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DPMAS_HSCR10_BIT_T bf;
} NX50_DPMAS_HSCR10_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr11 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr11                                     0x000000ACU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr11 0x1C0036ACU
#define Adr_NX50_dpmas_hscr11                                         0x1C0036ACU
#define DFLT_VAL_NX50_dpmas_hscr11                                    0x00000000U

#define MSK_NX50_dpmas_hscr11_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr11_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr11_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr11_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR11_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr11_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR11_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DPMAS_HSCR11_BIT_T bf;
} NX50_DPMAS_HSCR11_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr12 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr12                                     0x000000B0U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr12 0x1C0036B0U
#define Adr_NX50_dpmas_hscr12                                         0x1C0036B0U
#define DFLT_VAL_NX50_dpmas_hscr12                                    0x00000000U

#define MSK_NX50_dpmas_hscr12_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr12_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr12_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr12_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR12_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr12_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR12_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DPMAS_HSCR12_BIT_T bf;
} NX50_DPMAS_HSCR12_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr13 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr13                                     0x000000B4U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr13 0x1C0036B4U
#define Adr_NX50_dpmas_hscr13                                         0x1C0036B4U
#define DFLT_VAL_NX50_dpmas_hscr13                                    0x00000000U

#define MSK_NX50_dpmas_hscr13_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr13_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr13_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr13_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR13_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr13_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR13_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DPMAS_HSCR13_BIT_T bf;
} NX50_DPMAS_HSCR13_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr14 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr14                                     0x000000B8U
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr14 0x1C0036B8U
#define Adr_NX50_dpmas_hscr14                                         0x1C0036B8U
#define DFLT_VAL_NX50_dpmas_hscr14                                    0x00000000U

#define MSK_NX50_dpmas_hscr14_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr14_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr14_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr14_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR14_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr14_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR14_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DPMAS_HSCR14_BIT_T bf;
} NX50_DPMAS_HSCR14_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_hscr15 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_hscr15                                     0x000000BCU
#define Adr_NX50_netx_controlled_global_register_block_2_dpmas_hscr15 0x1C0036BCU
#define Adr_NX50_dpmas_hscr15                                         0x1C0036BCU
#define DFLT_VAL_NX50_dpmas_hscr15                                    0x00000000U

#define MSK_NX50_dpmas_hscr15_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_hscr15_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_hscr15_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_hscr15_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_HSCR15_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_hscr15_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_HSCR15_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DPMAS_HSCR15_BIT_T bf;
} NX50_DPMAS_HSCR15_T;


/* ===================================================================== */

/* Area of netx_controlled_pci_configuration_shadow_register_block */

/* ===================================================================== */

#define Addr_NX50_netx_controlled_pci_configuration_shadow_register_block 0x1C003700U

/* --------------------------------------------------------------------- */
/* Register pci_regs_addr */
/* => dpmas_pci_conf_rd_ctrl */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_pci_regs_addr                                                     0x00000000U
#define Adr_NX50_netx_controlled_pci_configuration_shadow_register_block_pci_regs_addr 0x1C003700U
#define Adr_NX50_pci_regs_addr                                                         0x1C003700U
#define DFLT_VAL_NX50_pci_regs_addr                                                    0x00000000U

#define MSK_NX50_pci_regs_addr_keine_ahnung      0xffffffffU
#define SRT_NX50_pci_regs_addr_keine_ahnung      0
#define DFLT_VAL_NX50_pci_regs_addr_keine_ahnung 0x00000000U

enum {
	BFW_NX50_pci_regs_addr_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_PCI_REGS_ADDR_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_pci_regs_addr_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_PCI_REGS_ADDR_BIT_T;

typedef union {
	unsigned int             val;
	NX50_PCI_REGS_ADDR_BIT_T bf;
} NX50_PCI_REGS_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_pci_conf_rd_data */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_pci_conf_rd_data                                                     0x00000004U
#define Adr_NX50_netx_controlled_pci_configuration_shadow_register_block_dpmas_pci_conf_rd_data 0x1C003704U
#define Adr_NX50_dpmas_pci_conf_rd_data                                                         0x1C003704U
#define DFLT_VAL_NX50_dpmas_pci_conf_rd_data                                                    0x00000000U

#define MSK_NX50_dpmas_pci_conf_rd_data_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_pci_conf_rd_data_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_pci_conf_rd_data_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_pci_conf_rd_data_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_PCI_CONF_RD_DATA_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_pci_conf_rd_data_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_PCI_CONF_RD_DATA_BIT_T;

typedef union {
	unsigned int                      val;
	NX50_DPMAS_PCI_CONF_RD_DATA_BIT_T bf;
} NX50_DPMAS_PCI_CONF_RD_DATA_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_pci_conf_wr_ctrl */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_pci_conf_wr_ctrl                                                     0x00000008U
#define Adr_NX50_netx_controlled_pci_configuration_shadow_register_block_dpmas_pci_conf_wr_ctrl 0x1C003708U
#define Adr_NX50_dpmas_pci_conf_wr_ctrl                                                         0x1C003708U
#define DFLT_VAL_NX50_dpmas_pci_conf_wr_ctrl                                                    0x00000000U

#define MSK_NX50_dpmas_pci_conf_wr_ctrl_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_pci_conf_wr_ctrl_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_pci_conf_wr_ctrl_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_pci_conf_wr_ctrl_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_PCI_CONF_WR_CTRL_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_pci_conf_wr_ctrl_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_PCI_CONF_WR_CTRL_BIT_T;

typedef union {
	unsigned int                      val;
	NX50_DPMAS_PCI_CONF_WR_CTRL_BIT_T bf;
} NX50_DPMAS_PCI_CONF_WR_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dpmas_pci_conf_wr_data */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dpmas_pci_conf_wr_data                                                     0x0000000CU
#define Adr_NX50_netx_controlled_pci_configuration_shadow_register_block_dpmas_pci_conf_wr_data 0x1C00370CU
#define Adr_NX50_dpmas_pci_conf_wr_data                                                         0x1C00370CU
#define DFLT_VAL_NX50_dpmas_pci_conf_wr_data                                                    0x00000000U

#define MSK_NX50_dpmas_pci_conf_wr_data_keine_ahnung      0xffffffffU
#define SRT_NX50_dpmas_pci_conf_wr_data_keine_ahnung      0
#define DFLT_VAL_NX50_dpmas_pci_conf_wr_data_keine_ahnung 0x00000000U

enum {
	BFW_NX50_dpmas_pci_conf_wr_data_keine_ahnung = 32  /* [31:0] */
};

typedef struct NX50_DPMAS_PCI_CONF_WR_DATA_BIT_Ttag {
	unsigned int keine_ahnung : BFW_NX50_dpmas_pci_conf_wr_data_keine_ahnung; /* HIF, ask Hilscher HIF specialists */
} NX50_DPMAS_PCI_CONF_WR_DATA_BIT_T;

typedef union {
	unsigned int                      val;
	NX50_DPMAS_PCI_CONF_WR_DATA_BIT_T bf;
} NX50_DPMAS_PCI_CONF_WR_DATA_T;


/* ===================================================================== */

/* Area of dmac */

/* ===================================================================== */

#define Addr_NX50_dmac      0x1C005000U
#define NX50_NETX_DMAC_AREA 0x1C005000U

/* ===================================================================== */

/* AREA dmac_ch */
/* Area of dmac_ch0, dmac_ch1, dmac_ch2, dmac_ch3 */

/* ===================================================================== */

#define Addr_NX50_dmac_ch0      0x1C005100U
#define NX50_NETX_DMAC_CH0_AREA 0x1C005100U
#define Addr_NX50_dmac_ch1      0x1C005120U
#define NX50_NETX_DMAC_CH1_AREA 0x1C005120U
#define Addr_NX50_dmac_ch2      0x1C005140U
#define NX50_NETX_DMAC_CH2_AREA 0x1C005140U
#define Addr_NX50_dmac_ch3      0x1C005160U
#define NX50_NETX_DMAC_CH3_AREA 0x1C005160U

/* --------------------------------------------------------------------- */
/* Register dmac_chsrc_ad */
/* => channel source address registers */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_chsrc_ad      0x00000000U
#define Adr_NX50_dmac_ch0_dmac_chsrc_ad 0x1C005100U
#define Adr_NX50_dmac_ch1_dmac_chsrc_ad 0x1C005120U
#define Adr_NX50_dmac_ch2_dmac_chsrc_ad 0x1C005140U
#define Adr_NX50_dmac_ch3_dmac_chsrc_ad 0x1C005160U
#define DFLT_VAL_NX50_dmac_chsrc_ad     0x00000000U

#define MSK_NX50_dmac_chsrc_ad_DMACCHSRCADDR      0xffffffffU
#define SRT_NX50_dmac_chsrc_ad_DMACCHSRCADDR      0
#define DFLT_VAL_NX50_dmac_chsrc_ad_DMACCHSRCADDR 0x00000000U

enum {
	BFW_NX50_dmac_chsrc_ad_DMACCHSRCADDR = 32  /* [31:0] */
};

typedef struct NX50_DMAC_CHSRC_AD_BIT_Ttag {
	unsigned int DMACCHSRCADDR : BFW_NX50_dmac_chsrc_ad_DMACCHSRCADDR; /* DMA source address */
} NX50_DMAC_CHSRC_AD_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DMAC_CHSRC_AD_BIT_T bf;
} NX50_DMAC_CHSRC_AD_T;

/* --------------------------------------------------------------------- */
/* Register dmac_chdest_ad */
/* => channel destination address registers */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_chdest_ad      0x00000004U
#define Adr_NX50_dmac_ch0_dmac_chdest_ad 0x1C005104U
#define Adr_NX50_dmac_ch1_dmac_chdest_ad 0x1C005124U
#define Adr_NX50_dmac_ch2_dmac_chdest_ad 0x1C005144U
#define Adr_NX50_dmac_ch3_dmac_chdest_ad 0x1C005164U
#define DFLT_VAL_NX50_dmac_chdest_ad     0x00000000U

#define MSK_NX50_dmac_chdest_ad_DMACCHDESTADDR      0xffffffffU
#define SRT_NX50_dmac_chdest_ad_DMACCHDESTADDR      0
#define DFLT_VAL_NX50_dmac_chdest_ad_DMACCHDESTADDR 0x00000000U

enum {
	BFW_NX50_dmac_chdest_ad_DMACCHDESTADDR = 32  /* [31:0] */
};

typedef struct NX50_DMAC_CHDEST_AD_BIT_Ttag {
	unsigned int DMACCHDESTADDR : BFW_NX50_dmac_chdest_ad_DMACCHDESTADDR; /* DMA destination address */
} NX50_DMAC_CHDEST_AD_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DMAC_CHDEST_AD_BIT_T bf;
} NX50_DMAC_CHDEST_AD_T;

/* --------------------------------------------------------------------- */
/* Register dmac_chlink */
/* => channel linked list item register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_chlink      0x00000008U
#define Adr_NX50_dmac_ch0_dmac_chlink 0x1C005108U
#define Adr_NX50_dmac_ch1_dmac_chlink 0x1C005128U
#define Adr_NX50_dmac_ch2_dmac_chlink 0x1C005148U
#define Adr_NX50_dmac_ch3_dmac_chlink 0x1C005168U
#define DFLT_VAL_NX50_dmac_chlink     0x00000000U

#define MSK_NX50_dmac_chlink_LLIADDR      0xfffffffcU
#define SRT_NX50_dmac_chlink_LLIADDR      2
#define DFLT_VAL_NX50_dmac_chlink_LLIADDR 0x00000000U

enum {
	BFW_NX50_dmac_chlink_reserved1 = 2,  /* [1:0] */
	BFW_NX50_dmac_chlink_LLIADDR   = 30  /* [31:2] */
};

typedef struct NX50_DMAC_CHLINK_BIT_Ttag {
	unsigned int reserved1 : BFW_NX50_dmac_chlink_reserved1; /* reserved                                                                                 */
	unsigned int LLIADDR   : BFW_NX50_dmac_chlink_LLIADDR;   /* Linked list item. Bits [31:2] of the address for the next LLI. Address bits [1:0] are 0. */
} NX50_DMAC_CHLINK_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DMAC_CHLINK_BIT_T bf;
} NX50_DMAC_CHLINK_T;

/* --------------------------------------------------------------------- */
/* Register dmac_chctrl */
/* => channel control registers */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_chctrl      0x0000000CU
#define Adr_NX50_dmac_ch0_dmac_chctrl 0x1C00510CU
#define Adr_NX50_dmac_ch1_dmac_chctrl 0x1C00512CU
#define Adr_NX50_dmac_ch2_dmac_chctrl 0x1C00514CU
#define Adr_NX50_dmac_ch3_dmac_chctrl 0x1C00516CU
#define DFLT_VAL_NX50_dmac_chctrl     0x00000000U

#define MSK_NX50_dmac_chctrl_TransferSize      0x00000fffU
#define SRT_NX50_dmac_chctrl_TransferSize      0
#define DFLT_VAL_NX50_dmac_chctrl_TransferSize 0x00000000U
#define MSK_NX50_dmac_chctrl_SBSize            0x00007000U
#define SRT_NX50_dmac_chctrl_SBSize            12
#define DFLT_VAL_NX50_dmac_chctrl_SBSize       0x00000000U
#define MSK_NX50_dmac_chctrl_DBSize            0x00038000U
#define SRT_NX50_dmac_chctrl_DBSize            15
#define DFLT_VAL_NX50_dmac_chctrl_DBSize       0x00000000U
#define MSK_NX50_dmac_chctrl_SWidth            0x001c0000U
#define SRT_NX50_dmac_chctrl_SWidth            18
#define DFLT_VAL_NX50_dmac_chctrl_SWidth       0x00000000U
#define MSK_NX50_dmac_chctrl_DWidth            0x00e00000U
#define SRT_NX50_dmac_chctrl_DWidth            21
#define DFLT_VAL_NX50_dmac_chctrl_DWidth       0x00000000U
#define MSK_NX50_dmac_chctrl_ARM_EQ            0x01000000U
#define SRT_NX50_dmac_chctrl_ARM_EQ            24
#define DFLT_VAL_NX50_dmac_chctrl_ARM_EQ       0x00000000U
#define MSK_NX50_dmac_chctrl_SI                0x04000000U
#define SRT_NX50_dmac_chctrl_SI                26
#define DFLT_VAL_NX50_dmac_chctrl_SI           0x00000000U
#define MSK_NX50_dmac_chctrl_DI                0x08000000U
#define SRT_NX50_dmac_chctrl_DI                27
#define DFLT_VAL_NX50_dmac_chctrl_DI           0x00000000U
#define MSK_NX50_dmac_chctrl_Prot              0x70000000U
#define SRT_NX50_dmac_chctrl_Prot              28
#define DFLT_VAL_NX50_dmac_chctrl_Prot         0x00000000U
#define MSK_NX50_dmac_chctrl_I                 0x80000000U
#define SRT_NX50_dmac_chctrl_I                 31
#define DFLT_VAL_NX50_dmac_chctrl_I            0x00000000U

enum {
	BFW_NX50_dmac_chctrl_TransferSize = 12, /* [11:0] */
	BFW_NX50_dmac_chctrl_SBSize       = 3,  /* [14:12] */
	BFW_NX50_dmac_chctrl_DBSize       = 3,  /* [17:15] */
	BFW_NX50_dmac_chctrl_SWidth       = 3,  /* [20:18] */
	BFW_NX50_dmac_chctrl_DWidth       = 3,  /* [23:21] */
	BFW_NX50_dmac_chctrl_ARM_EQ       = 1,  /* [24] */
	BFW_NX50_dmac_chctrl_reserved1    = 1,  /* [25] */
	BFW_NX50_dmac_chctrl_SI           = 1,  /* [26] */
	BFW_NX50_dmac_chctrl_DI           = 1,  /* [27] */
	BFW_NX50_dmac_chctrl_Prot         = 3,  /* [30:28] */
	BFW_NX50_dmac_chctrl_I            = 1   /* [31] */
};

typedef struct NX50_DMAC_CHCTRL_BIT_Ttag {
	unsigned int TransferSize : BFW_NX50_dmac_chctrl_TransferSize; /* Transfer size. For writes, this field indicates the number of (Source width) transfers to perform when the DMAC is the flow controller. */
	                                                               /* For reads, the transfer size indicates the number of transfers completed on the destination bus.                                        */
	unsigned int SBSize       : BFW_NX50_dmac_chctrl_SBSize;       /* Source burst size. Indicates the number of transfers which make up a source burst.                                                      */
	                                                               /* This value must be set to the burst size of the source peripheral, or if the source is memory, to the memory boundary size.             */
	unsigned int DBSize       : BFW_NX50_dmac_chctrl_DBSize;       /* Destination burst size. Indicates the number of transfers which make up a destination burst transfer request.                           */
	                                                               /* This value must be set to the burst size of the destination peripheral, or if the destination is memory, to the memory boundary size.   */
	unsigned int SWidth       : BFW_NX50_dmac_chctrl_SWidth;       /* Source transfer width. Transfers wider than the AHB master bus width are illegal.                                                       */
	                                                               /* The source and destination widths can be different from each other.                                                                     */
	unsigned int DWidth       : BFW_NX50_dmac_chctrl_DWidth;       /* Destination transfer width. Transfers wider than the AHB master bus width are illegal.                                                  */
	                                                               /* The source and destination widths can be different from each other.                                                                     */
	unsigned int ARM_EQ       : BFW_NX50_dmac_chctrl_ARM_EQ;       /* set equal behavior to arm implementation                                                                                                */
	unsigned int reserved1    : BFW_NX50_dmac_chctrl_reserved1;    /* reserved                                                                                                                                */
	unsigned int SI           : BFW_NX50_dmac_chctrl_SI;           /* Source increment. When set the source address is incremented after each transfer.                                                       */
	unsigned int DI           : BFW_NX50_dmac_chctrl_DI;           /* Destination increment. When set the destination address is incremented after each transfer.                                             */
	unsigned int Prot         : BFW_NX50_dmac_chctrl_Prot;         /* Protection.                                                                                                                             */
	unsigned int I            : BFW_NX50_dmac_chctrl_I;            /* Terminal count interrupt enable bit. It controls whether the current LLI is expected to trigger the terminal count interrupt.           */
} NX50_DMAC_CHCTRL_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DMAC_CHCTRL_BIT_T bf;
} NX50_DMAC_CHCTRL_T;

/* --------------------------------------------------------------------- */
/* Register dmac_chcfg */
/* => channel configuration registers */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_chcfg      0x00000010U
#define Adr_NX50_dmac_ch0_dmac_chcfg 0x1C005110U
#define Adr_NX50_dmac_ch1_dmac_chcfg 0x1C005130U
#define Adr_NX50_dmac_ch2_dmac_chcfg 0x1C005150U
#define Adr_NX50_dmac_ch3_dmac_chcfg 0x1C005170U
#define DFLT_VAL_NX50_dmac_chcfg     0x00000000U

#define MSK_NX50_dmac_chcfg_E                   0x00000001U
#define SRT_NX50_dmac_chcfg_E                   0
#define DFLT_VAL_NX50_dmac_chcfg_E              0x00000000U
#define MSK_NX50_dmac_chcfg_SrcPeripheral       0x0000001eU
#define SRT_NX50_dmac_chcfg_SrcPeripheral       1
#define DFLT_VAL_NX50_dmac_chcfg_SrcPeripheral  0x00000000U
#define MSK_NX50_dmac_chcfg_DestPeripheral      0x000003c0U
#define SRT_NX50_dmac_chcfg_DestPeripheral      6
#define DFLT_VAL_NX50_dmac_chcfg_DestPeripheral 0x00000000U
#define MSK_NX50_dmac_chcfg_FlowCntrl           0x00003800U
#define SRT_NX50_dmac_chcfg_FlowCntrl           11
#define DFLT_VAL_NX50_dmac_chcfg_FlowCntrl      0x00000000U
#define MSK_NX50_dmac_chcfg_IE                  0x00004000U
#define SRT_NX50_dmac_chcfg_IE                  14
#define DFLT_VAL_NX50_dmac_chcfg_IE             0x00000000U
#define MSK_NX50_dmac_chcfg_ITC                 0x00008000U
#define SRT_NX50_dmac_chcfg_ITC                 15
#define DFLT_VAL_NX50_dmac_chcfg_ITC            0x00000000U
#define MSK_NX50_dmac_chcfg_L                   0x00010000U
#define SRT_NX50_dmac_chcfg_L                   16
#define DFLT_VAL_NX50_dmac_chcfg_L              0x00000000U
#define MSK_NX50_dmac_chcfg_A                   0x00020000U
#define SRT_NX50_dmac_chcfg_A                   17
#define DFLT_VAL_NX50_dmac_chcfg_A              0x00000000U
#define MSK_NX50_dmac_chcfg_H                   0x00040000U
#define SRT_NX50_dmac_chcfg_H                   18
#define DFLT_VAL_NX50_dmac_chcfg_H              0x00000000U

enum {
	BFW_NX50_dmac_chcfg_E              = 1,  /* [0] */
	BFW_NX50_dmac_chcfg_SrcPeripheral  = 4,  /* [4:1] */
	BFW_NX50_dmac_chcfg_reserved1      = 1,  /* [5] */
	BFW_NX50_dmac_chcfg_DestPeripheral = 4,  /* [9:6] */
	BFW_NX50_dmac_chcfg_reserved2      = 1,  /* [10] */
	BFW_NX50_dmac_chcfg_FlowCntrl      = 3,  /* [13:11] */
	BFW_NX50_dmac_chcfg_IE             = 1,  /* [14] */
	BFW_NX50_dmac_chcfg_ITC            = 1,  /* [15] */
	BFW_NX50_dmac_chcfg_L              = 1,  /* [16] */
	BFW_NX50_dmac_chcfg_A              = 1,  /* [17] */
	BFW_NX50_dmac_chcfg_H              = 1,  /* [18] */
	BFW_NX50_dmac_chcfg_reserved3      = 13  /* [31:19] */
};

typedef struct NX50_DMAC_CHCFG_BIT_Ttag {
	unsigned int E              : BFW_NX50_dmac_chcfg_E;              /* Channel enable. Reading this bit indicates whether a channel is currently enabled or disabled: 0 = channel disabled 1 = channel enabled. */
	                                                                  /* The Channel Enable bit status can also be found by reading the DMACEnbldChns register.                                                   */
	unsigned int SrcPeripheral  : BFW_NX50_dmac_chcfg_SrcPeripheral;  /* Source peripheral. This value selects the DMA source request peripheral.                                                                 */
	                                                                  /* This field is ignored if the source of the transfer is from memory.                                                                      */
	unsigned int reserved1      : BFW_NX50_dmac_chcfg_reserved1;      /* reserved                                                                                                                                 */
	unsigned int DestPeripheral : BFW_NX50_dmac_chcfg_DestPeripheral; /* Destination peripheral. This value selects the DMA destination request peripheral.                                                       */
	                                                                  /* This field is ignored if the destination of the transfer is to memory.                                                                   */
	unsigned int reserved2      : BFW_NX50_dmac_chcfg_reserved2;      /* reserved                                                                                                                                 */
	unsigned int FlowCntrl      : BFW_NX50_dmac_chcfg_FlowCntrl;      /* Flow control and transfer type. This value is used to indicate the flow controller and transfer type.                                    */
	                                                                  /* The flow controller can be the DMAC, the source peripheral, or the destination peripheral.                                               */
	unsigned int IE             : BFW_NX50_dmac_chcfg_IE;             /* Interrupt error mask. When cleared this bit masks out the error interrupt of the relevant channel.                                       */
	unsigned int ITC            : BFW_NX50_dmac_chcfg_ITC;            /* Terminal count interrupt mask. When cleared this bit masks out the terminal count interrupt of the relevant channel.                     */
	unsigned int L              : BFW_NX50_dmac_chcfg_L;              /* Lock. When set this bit enables locked transfers.                                                                                        */
	unsigned int A              : BFW_NX50_dmac_chcfg_A;              /* Active: 0 = there is no data in the FIFO of the channel 1 = the FIFO of the channel has data. (ro)                                       */
	                                                                  /* This value can be used with the Halt and Channel Enable bits to cleanly disable a DMA channel.                                           */
	unsigned int H              : BFW_NX50_dmac_chcfg_H;              /* Halt: 0 = allow DMA requests 1 = ignore further source DMA requests. The contents of the channels FIFO are drained.                      */
	                                                                  /* This value can be used with the Active and Channel Enable bits to cleanly disable a DMA channel.                                         */
	unsigned int reserved3      : BFW_NX50_dmac_chcfg_reserved3;      /* reserved                                                                                                                                 */
} NX50_DMAC_CHCFG_BIT_T;

typedef union {
	unsigned int          val;
	NX50_DMAC_CHCFG_BIT_T bf;
} NX50_DMAC_CHCFG_T;


/* ===================================================================== */

/* Area of dmac_reg */

/* ===================================================================== */

#define Addr_NX50_dmac_reg      0x1C005800U
#define NX50_NETX_DMAC_REG_AREA 0x1C005800U

/* --------------------------------------------------------------------- */
/* Register dmac_int_status */
/* => interrupt status register */
/*    reset value 0x0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_int_status      0x00000000U
#define Adr_NX50_dmac_reg_dmac_int_status 0x1C005800U
#define Adr_NX50_dmac_int_status          0x1C005800U

#define MSK_NX50_dmac_int_status_DMACINT_ch0 0x00000001U
#define SRT_NX50_dmac_int_status_DMACINT_ch0 0
#define MSK_NX50_dmac_int_status_DMACINT_ch1 0x00000002U
#define SRT_NX50_dmac_int_status_DMACINT_ch1 1
#define MSK_NX50_dmac_int_status_DMACINT_ch2 0x00000004U
#define SRT_NX50_dmac_int_status_DMACINT_ch2 2
#define MSK_NX50_dmac_int_status_DMACINT_ch3 0x00000008U
#define SRT_NX50_dmac_int_status_DMACINT_ch3 3

enum {
	BFW_NX50_dmac_int_status_DMACINT_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_int_status_DMACINT_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_int_status_DMACINT_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_int_status_DMACINT_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_int_status_reserved1   = 28  /* [31:4] */
};

typedef struct NX50_DMAC_INT_STATUS_BIT_Ttag {
	unsigned int DMACINT_ch0 : BFW_NX50_dmac_int_status_DMACINT_ch0; /* Status of DMA channel 0 - interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINT_ch1 : BFW_NX50_dmac_int_status_DMACINT_ch1; /* Status of DMA channel 1 - interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINT_ch2 : BFW_NX50_dmac_int_status_DMACINT_ch2; /* Status of DMA channel 2 - interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINT_ch3 : BFW_NX50_dmac_int_status_DMACINT_ch3; /* Status of DMA channel 3 - interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int reserved1   : BFW_NX50_dmac_int_status_reserved1;   /* reserved                                                                                       */
} NX50_DMAC_INT_STATUS_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DMAC_INT_STATUS_BIT_T bf;
} NX50_DMAC_INT_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register dmac_inttc_status */
/* => interrupt terminal count status register */
/*    reset value 0x0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_inttc_status      0x00000004U
#define Adr_NX50_dmac_reg_dmac_inttc_status 0x1C005804U
#define Adr_NX50_dmac_inttc_status          0x1C005804U

#define MSK_NX50_dmac_inttc_status_DMACINTTC_ch0 0x00000001U
#define SRT_NX50_dmac_inttc_status_DMACINTTC_ch0 0
#define MSK_NX50_dmac_inttc_status_DMACINTTC_ch1 0x00000002U
#define SRT_NX50_dmac_inttc_status_DMACINTTC_ch1 1
#define MSK_NX50_dmac_inttc_status_DMACINTTC_ch2 0x00000004U
#define SRT_NX50_dmac_inttc_status_DMACINTTC_ch2 2
#define MSK_NX50_dmac_inttc_status_DMACINTTC_ch3 0x00000008U
#define SRT_NX50_dmac_inttc_status_DMACINTTC_ch3 3

enum {
	BFW_NX50_dmac_inttc_status_DMACINTTC_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_inttc_status_DMACINTTC_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_inttc_status_DMACINTTC_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_inttc_status_DMACINTTC_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_inttc_status_reserved1     = 28  /* [31:4] */
};

typedef struct NX50_DMAC_INTTC_STATUS_BIT_Ttag {
	unsigned int DMACINTTC_ch0 : BFW_NX50_dmac_inttc_status_DMACINTTC_ch0; /* Status of DMA channel 0 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINTTC_ch1 : BFW_NX50_dmac_inttc_status_DMACINTTC_ch1; /* Status of DMA channel 1 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINTTC_ch2 : BFW_NX50_dmac_inttc_status_DMACINTTC_ch2; /* Status of DMA channel 2 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINTTC_ch3 : BFW_NX50_dmac_inttc_status_DMACINTTC_ch3; /* Status of DMA channel 3 - terminal count interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int reserved1     : BFW_NX50_dmac_inttc_status_reserved1;     /* reserved                                                                                                      */
} NX50_DMAC_INTTC_STATUS_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DMAC_INTTC_STATUS_BIT_T bf;
} NX50_DMAC_INTTC_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register dmac_inttc_clear */
/* => interrupt terminal count clear register */
/*    reset value 0x0 */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_inttc_clear      0x00000008U
#define Adr_NX50_dmac_reg_dmac_inttc_clear 0x1C005808U
#define Adr_NX50_dmac_inttc_clear          0x1C005808U
#define DFLT_VAL_NX50_dmac_inttc_clear     0x00000000U

#define MSK_NX50_dmac_inttc_clear_DMACINTTCCLR_ch0      0x00000001U
#define SRT_NX50_dmac_inttc_clear_DMACINTTCCLR_ch0      0
#define DFLT_VAL_NX50_dmac_inttc_clear_DMACINTTCCLR_ch0 0x00000000U
#define MSK_NX50_dmac_inttc_clear_DMACINTTCCLR_ch1      0x00000002U
#define SRT_NX50_dmac_inttc_clear_DMACINTTCCLR_ch1      1
#define DFLT_VAL_NX50_dmac_inttc_clear_DMACINTTCCLR_ch1 0x00000000U
#define MSK_NX50_dmac_inttc_clear_DMACINTTCCLR_ch2      0x00000004U
#define SRT_NX50_dmac_inttc_clear_DMACINTTCCLR_ch2      2
#define DFLT_VAL_NX50_dmac_inttc_clear_DMACINTTCCLR_ch2 0x00000000U
#define MSK_NX50_dmac_inttc_clear_DMACINTTCCLR_ch3      0x00000008U
#define SRT_NX50_dmac_inttc_clear_DMACINTTCCLR_ch3      3
#define DFLT_VAL_NX50_dmac_inttc_clear_DMACINTTCCLR_ch3 0x00000000U

enum {
	BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_inttc_clear_reserved1        = 28  /* [31:4] */
};

typedef struct NX50_DMAC_INTTC_CLEAR_BIT_Ttag {
	unsigned int DMACINTTCCLR_ch0 : BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch0; /* Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 0 ,1'b0 have no effect. */
	unsigned int DMACINTTCCLR_ch1 : BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch1; /* Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 1 ,1'b0 have no effect. */
	unsigned int DMACINTTCCLR_ch2 : BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch2; /* Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 2 ,1'b0 have no effect. */
	unsigned int DMACINTTCCLR_ch3 : BFW_NX50_dmac_inttc_clear_DMACINTTCCLR_ch3; /* Writing a 1'b1 Bit clears the terminal count interrupt of the specific channel 3 ,1'b0 have no effect. */
	unsigned int reserved1        : BFW_NX50_dmac_inttc_clear_reserved1;        /* reserved                                                                                               */
} NX50_DMAC_INTTC_CLEAR_BIT_T;

typedef union {
	unsigned int                val;
	NX50_DMAC_INTTC_CLEAR_BIT_T bf;
} NX50_DMAC_INTTC_CLEAR_T;

/* --------------------------------------------------------------------- */
/* Register dmac_interr_status */
/* => interrupt error status register */
/*    reset value 0x0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_interr_status      0x0000000CU
#define Adr_NX50_dmac_reg_dmac_interr_status 0x1C00580CU
#define Adr_NX50_dmac_interr_status          0x1C00580CU

#define MSK_NX50_dmac_interr_status_DMACINTERR_ch0 0x00000001U
#define SRT_NX50_dmac_interr_status_DMACINTERR_ch0 0
#define MSK_NX50_dmac_interr_status_DMACINTERR_ch1 0x00000002U
#define SRT_NX50_dmac_interr_status_DMACINTERR_ch1 1
#define MSK_NX50_dmac_interr_status_DMACINTERR_ch2 0x00000004U
#define SRT_NX50_dmac_interr_status_DMACINTERR_ch2 2
#define MSK_NX50_dmac_interr_status_DMACINTERR_ch3 0x00000008U
#define SRT_NX50_dmac_interr_status_DMACINTERR_ch3 3

enum {
	BFW_NX50_dmac_interr_status_DMACINTERR_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_interr_status_DMACINTERR_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_interr_status_DMACINTERR_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_interr_status_DMACINTERR_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_interr_status_reserved1      = 28  /* [31:4] */
};

typedef struct NX50_DMAC_INTERR_STATUS_BIT_Ttag {
	unsigned int DMACINTERR_ch0 : BFW_NX50_dmac_interr_status_DMACINTERR_ch0; /* Status of DMA channel 0 - error interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINTERR_ch1 : BFW_NX50_dmac_interr_status_DMACINTERR_ch1; /* Status of DMA channel 1 - error interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINTERR_ch2 : BFW_NX50_dmac_interr_status_DMACINTERR_ch2; /* Status of DMA channel 2 - error interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACINTERR_ch3 : BFW_NX50_dmac_interr_status_DMACINTERR_ch3; /* Status of DMA channel 3 - error interrupt after masking. 1'b1 indicates an active interrupt request. */
	unsigned int reserved1      : BFW_NX50_dmac_interr_status_reserved1;      /* reserved                                                                                             */
} NX50_DMAC_INTERR_STATUS_BIT_T;

typedef union {
	unsigned int                  val;
	NX50_DMAC_INTERR_STATUS_BIT_T bf;
} NX50_DMAC_INTERR_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register dmac_interr_clear */
/* => interrupt error clear register */
/*    reset value 0x0 */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_interr_clear      0x00000010U
#define Adr_NX50_dmac_reg_dmac_interr_clear 0x1C005810U
#define Adr_NX50_dmac_interr_clear          0x1C005810U
#define DFLT_VAL_NX50_dmac_interr_clear     0x00000000U

#define MSK_NX50_dmac_interr_clear_DMACINTERRCLR_ch0      0x00000001U
#define SRT_NX50_dmac_interr_clear_DMACINTERRCLR_ch0      0
#define DFLT_VAL_NX50_dmac_interr_clear_DMACINTERRCLR_ch0 0x00000000U
#define MSK_NX50_dmac_interr_clear_DMACINTERRCLR_ch1      0x00000002U
#define SRT_NX50_dmac_interr_clear_DMACINTERRCLR_ch1      1
#define DFLT_VAL_NX50_dmac_interr_clear_DMACINTERRCLR_ch1 0x00000000U
#define MSK_NX50_dmac_interr_clear_DMACINTERRCLR_ch2      0x00000004U
#define SRT_NX50_dmac_interr_clear_DMACINTERRCLR_ch2      2
#define DFLT_VAL_NX50_dmac_interr_clear_DMACINTERRCLR_ch2 0x00000000U
#define MSK_NX50_dmac_interr_clear_DMACINTERRCLR_ch3      0x00000008U
#define SRT_NX50_dmac_interr_clear_DMACINTERRCLR_ch3      3
#define DFLT_VAL_NX50_dmac_interr_clear_DMACINTERRCLR_ch3 0x00000000U

enum {
	BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_interr_clear_reserved1         = 28  /* [31:4] */
};

typedef struct NX50_DMAC_INTERR_CLEAR_BIT_Ttag {
	unsigned int DMACINTERRCLR_ch0 : BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch0; /* Writing a 1'b1 Bit clears the error interrupt of the specific channel 0 ,1'b0 have no effect. */
	unsigned int DMACINTERRCLR_ch1 : BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch1; /* Writing a 1'b1 Bit clears the error interrupt of the specific channel 1 ,1'b0 have no effect. */
	unsigned int DMACINTERRCLR_ch2 : BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch2; /* Writing a 1'b1 Bit clears the error interrupt of the specific channel 2 ,1'b0 have no effect. */
	unsigned int DMACINTERRCLR_ch3 : BFW_NX50_dmac_interr_clear_DMACINTERRCLR_ch3; /* Writing a 1'b1 Bit clears the error interrupt of the specific channel 3 ,1'b0 have no effect. */
	unsigned int reserved1         : BFW_NX50_dmac_interr_clear_reserved1;         /* reserved                                                                                      */
} NX50_DMAC_INTERR_CLEAR_BIT_T;

typedef union {
	unsigned int                 val;
	NX50_DMAC_INTERR_CLEAR_BIT_T bf;
} NX50_DMAC_INTERR_CLEAR_T;

/* --------------------------------------------------------------------- */
/* Register dmac_rawinttc_status */
/* => raw interrupt terminal count status register */
/*    reset value 0x0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_rawinttc_status      0x00000014U
#define Adr_NX50_dmac_reg_dmac_rawinttc_status 0x1C005814U
#define Adr_NX50_dmac_rawinttc_status          0x1C005814U

#define MSK_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch0 0x00000001U
#define SRT_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch0 0
#define MSK_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch1 0x00000002U
#define SRT_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch1 1
#define MSK_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch2 0x00000004U
#define SRT_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch2 2
#define MSK_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch3 0x00000008U
#define SRT_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch3 3

enum {
	BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_rawinttc_status_reserved1        = 28  /* [31:4] */
};

typedef struct NX50_DMAC_RAWINTTC_STATUS_BIT_Ttag {
	unsigned int DMACRAWINTTC_ch0 : BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch0; /* Status of DMA channel 0 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACRAWINTTC_ch1 : BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch1; /* Status of DMA channel 1 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACRAWINTTC_ch2 : BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch2; /* Status of DMA channel 2 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACRAWINTTC_ch3 : BFW_NX50_dmac_rawinttc_status_DMACRAWINTTC_ch3; /* Status of DMA channel 3 - terminal count interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int reserved1        : BFW_NX50_dmac_rawinttc_status_reserved1;        /* reserved                                                                                                         */
} NX50_DMAC_RAWINTTC_STATUS_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DMAC_RAWINTTC_STATUS_BIT_T bf;
} NX50_DMAC_RAWINTTC_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register dmac_rawinterr_status */
/* => raw interrupt error status register */
/*    reset value 0x0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_rawinterr_status      0x00000018U
#define Adr_NX50_dmac_reg_dmac_rawinterr_status 0x1C005818U
#define Adr_NX50_dmac_rawinterr_status          0x1C005818U

#define MSK_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch0 0x00000001U
#define SRT_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch0 0
#define MSK_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch1 0x00000002U
#define SRT_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch1 1
#define MSK_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch2 0x00000004U
#define SRT_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch2 2
#define MSK_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch3 0x00000008U
#define SRT_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch3 3

enum {
	BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_rawinterr_status_reserved1         = 28  /* [31:4] */
};

typedef struct NX50_DMAC_RAWINTERR_STATUS_BIT_Ttag {
	unsigned int DMACRAWINTERR_ch0 : BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch0; /* Status of DMA channel 0 - error interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACRAWINTERR_ch1 : BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch1; /* Status of DMA channel 1 - error interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACRAWINTERR_ch2 : BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch2; /* Status of DMA channel 2 - error interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int DMACRAWINTERR_ch3 : BFW_NX50_dmac_rawinterr_status_DMACRAWINTERR_ch3; /* Status of DMA channel 3 - error interrupt prior to masking. 1'b1 indicates an active interrupt request. */
	unsigned int reserved1         : BFW_NX50_dmac_rawinterr_status_reserved1;         /* reserved                                                                                                */
} NX50_DMAC_RAWINTERR_STATUS_BIT_T;

typedef union {
	unsigned int                     val;
	NX50_DMAC_RAWINTERR_STATUS_BIT_T bf;
} NX50_DMAC_RAWINTERR_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register dmac_enabled_channel */
/* => channel enable register */
/*    reset value 0x0 */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_enabled_channel      0x0000001CU
#define Adr_NX50_dmac_reg_dmac_enabled_channel 0x1C00581CU
#define Adr_NX50_dmac_enabled_channel          0x1C00581CU

#define MSK_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch0 0x00000001U
#define SRT_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch0 0
#define MSK_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch1 0x00000002U
#define SRT_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch1 1
#define MSK_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch2 0x00000004U
#define SRT_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch2 2
#define MSK_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch3 0x00000008U
#define SRT_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch3 3

enum {
	BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch0 = 1,  /* [0] */
	BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch1 = 1,  /* [1] */
	BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch2 = 1,  /* [2] */
	BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch3 = 1,  /* [3] */
	BFW_NX50_dmac_enabled_channel_reserved1           = 28  /* [31:4] */
};

typedef struct NX50_DMAC_ENABLED_CHANNEL_BIT_Ttag {
	unsigned int DMACENABLEDCHNS_ch0 : BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch0; /* Status DMA channel 0 enable */
	unsigned int DMACENABLEDCHNS_ch1 : BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch1; /* Status DMA channel 1 enable */
	unsigned int DMACENABLEDCHNS_ch2 : BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch2; /* Status DMA channel 2 enable */
	unsigned int DMACENABLEDCHNS_ch3 : BFW_NX50_dmac_enabled_channel_DMACENABLEDCHNS_ch3; /* Status DMA channel 3 enable */
	unsigned int reserved1           : BFW_NX50_dmac_enabled_channel_reserved1;           /* reserved                    */
} NX50_DMAC_ENABLED_CHANNEL_BIT_T;

typedef union {
	unsigned int                    val;
	NX50_DMAC_ENABLED_CHANNEL_BIT_T bf;
} NX50_DMAC_ENABLED_CHANNEL_T;

/* --------------------------------------------------------------------- */
/* Register dmac_softb_req */
/* => software burst request register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_softb_req      0x00000020U
#define Adr_NX50_dmac_reg_dmac_softb_req 0x1C005820U
#define Adr_NX50_dmac_softb_req          0x1C005820U
#define DFLT_VAL_NX50_dmac_softb_req     0x00000000U

#define MSK_NX50_dmac_softb_req_DMACSoftBReq      0x0000ffffU
#define SRT_NX50_dmac_softb_req_DMACSoftBReq      0
#define DFLT_VAL_NX50_dmac_softb_req_DMACSoftBReq 0x00000000U

enum {
	BFW_NX50_dmac_softb_req_DMACSoftBReq = 16, /* [15:0] */
	BFW_NX50_dmac_softb_req_reserved1    = 16  /* [31:16] */
};

typedef struct NX50_DMAC_SOFTB_REQ_BIT_Ttag {
	unsigned int DMACSoftBReq : BFW_NX50_dmac_softb_req_DMACSoftBReq; /* Software burst request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit. */
	                                                                  /* Reading the register indicates which sources are requesting DMA burst transfers.                                            */
	unsigned int reserved1    : BFW_NX50_dmac_softb_req_reserved1;    /* reserved                                                                                                                    */
} NX50_DMAC_SOFTB_REQ_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DMAC_SOFTB_REQ_BIT_T bf;
} NX50_DMAC_SOFTB_REQ_T;

/* --------------------------------------------------------------------- */
/* Register dmac_softs_req */
/* => software single request register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_softs_req      0x00000024U
#define Adr_NX50_dmac_reg_dmac_softs_req 0x1C005824U
#define Adr_NX50_dmac_softs_req          0x1C005824U
#define DFLT_VAL_NX50_dmac_softs_req     0x00000000U

#define MSK_NX50_dmac_softs_req_DMACSoftSReq      0x0000ffffU
#define SRT_NX50_dmac_softs_req_DMACSoftSReq      0
#define DFLT_VAL_NX50_dmac_softs_req_DMACSoftSReq 0x00000000U

enum {
	BFW_NX50_dmac_softs_req_DMACSoftSReq = 16, /* [15:0] */
	BFW_NX50_dmac_softs_req_reserved1    = 16  /* [31:16] */
};

typedef struct NX50_DMAC_SOFTS_REQ_BIT_Ttag {
	unsigned int DMACSoftSReq : BFW_NX50_dmac_softs_req_DMACSoftSReq; /* Software single request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit. */
	                                                                  /* Reading the register indicates which sources are requesting DMA single transfers.                                            */
	unsigned int reserved1    : BFW_NX50_dmac_softs_req_reserved1;    /* reserved                                                                                                                     */
} NX50_DMAC_SOFTS_REQ_BIT_T;

typedef union {
	unsigned int              val;
	NX50_DMAC_SOFTS_REQ_BIT_T bf;
} NX50_DMAC_SOFTS_REQ_T;

/* --------------------------------------------------------------------- */
/* Register dmac_softlb_req */
/* => software last burst request register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_softlb_req      0x00000028U
#define Adr_NX50_dmac_reg_dmac_softlb_req 0x1C005828U
#define Adr_NX50_dmac_softlb_req          0x1C005828U
#define DFLT_VAL_NX50_dmac_softlb_req     0x00000000U

#define MSK_NX50_dmac_softlb_req_DMACSoftLBReq      0x0000ffffU
#define SRT_NX50_dmac_softlb_req_DMACSoftLBReq      0
#define DFLT_VAL_NX50_dmac_softlb_req_DMACSoftLBReq 0x00000000U

enum {
	BFW_NX50_dmac_softlb_req_DMACSoftLBReq = 16, /* [15:0] */
	BFW_NX50_dmac_softlb_req_reserved1     = 16  /* [31:16] */
};

typedef struct NX50_DMAC_SOFTLB_REQ_BIT_Ttag {
	unsigned int DMACSoftLBReq : BFW_NX50_dmac_softlb_req_DMACSoftLBReq; /* Software last burst request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit. */
	                                                                     /* Reading the register indicates which sources are requesting DMA last burst transfers.                                            */
	unsigned int reserved1     : BFW_NX50_dmac_softlb_req_reserved1;     /* reserved                                                                                                                         */
} NX50_DMAC_SOFTLB_REQ_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DMAC_SOFTLB_REQ_BIT_T bf;
} NX50_DMAC_SOFTLB_REQ_T;

/* --------------------------------------------------------------------- */
/* Register dmac_softls_req */
/* => software last single request register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_softls_req      0x0000002CU
#define Adr_NX50_dmac_reg_dmac_softls_req 0x1C00582CU
#define Adr_NX50_dmac_softls_req          0x1C00582CU
#define DFLT_VAL_NX50_dmac_softls_req     0x00000000U

#define MSK_NX50_dmac_softls_req_DMACSoftLSReq      0x0000ffffU
#define SRT_NX50_dmac_softls_req_DMACSoftLSReq      0
#define DFLT_VAL_NX50_dmac_softls_req_DMACSoftLSReq 0x00000000U

enum {
	BFW_NX50_dmac_softls_req_DMACSoftLSReq = 16, /* [15:0] */
	BFW_NX50_dmac_softls_req_reserved1     = 16  /* [31:16] */
};

typedef struct NX50_DMAC_SOFTLS_REQ_BIT_Ttag {
	unsigned int DMACSoftLSReq : BFW_NX50_dmac_softls_req_DMACSoftLSReq; /* Software last single request. A DMA request can be generated for each source by writing a 1'b1 to the corresponding register bit. */
	                                                                     /* Reading the register indicates which sources are requesting DMA last single transfers.                                            */
	unsigned int reserved1     : BFW_NX50_dmac_softls_req_reserved1;     /* reserved                                                                                                                          */
} NX50_DMAC_SOFTLS_REQ_BIT_T;

typedef union {
	unsigned int               val;
	NX50_DMAC_SOFTLS_REQ_BIT_T bf;
} NX50_DMAC_SOFTLS_REQ_T;

/* --------------------------------------------------------------------- */
/* Register dmac_config */
/* => configuration register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_config      0x00000030U
#define Adr_NX50_dmac_reg_dmac_config 0x1C005830U
#define Adr_NX50_dmac_config          0x1C005830U
#define DFLT_VAL_NX50_dmac_config     0x00000000U

#define MSK_NX50_dmac_config_DMACENABLE      0x00000001U
#define SRT_NX50_dmac_config_DMACENABLE      0
#define DFLT_VAL_NX50_dmac_config_DMACENABLE 0x00000000U

enum {
	BFW_NX50_dmac_config_DMACENABLE = 1,  /* [0] */
	BFW_NX50_dmac_config_reserved1  = 31  /* [31:1] */
};

typedef struct NX50_DMAC_CONFIG_BIT_Ttag {
	unsigned int DMACENABLE : BFW_NX50_dmac_config_DMACENABLE; /* DMAC enable: 0 = disabled 1 = enabled. This bit is reset to 0. Disabling the DMAC reduces power consumption. */
	unsigned int reserved1  : BFW_NX50_dmac_config_reserved1;  /* reserved                                                                                                     */
} NX50_DMAC_CONFIG_BIT_T;

typedef union {
	unsigned int           val;
	NX50_DMAC_CONFIG_BIT_T bf;
} NX50_DMAC_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register dmac_sync */
/* => sync register */
/*    DMA synchronization logic for DMA request signals enabled or disabled */
/*    A 1'b0 bit indicates that the synchronization logic for */
/*    the DMACBREQ[15:0], DMACSREQ[15:0], DMACLBREQ[15:0], and DMACLSREQ[15:0] request signals is enabled. */
/*    A HIGH bit indicates that the synchronization logic is disabled. */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_sync      0x00000034U
#define Adr_NX50_dmac_reg_dmac_sync 0x1C005834U
#define Adr_NX50_dmac_sync          0x1C005834U
#define DFLT_VAL_NX50_dmac_sync     0x00000000U

#define MSK_NX50_dmac_sync_DIS_SYNC_SPI0_RX       0x00000001U
#define SRT_NX50_dmac_sync_DIS_SYNC_SPI0_RX       0
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_SPI0_RX  0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_SPI0_TX       0x00000002U
#define SRT_NX50_dmac_sync_DIS_SYNC_SPI0_TX       1
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_SPI0_TX  0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_SPI1_RX       0x00000004U
#define SRT_NX50_dmac_sync_DIS_SYNC_SPI1_RX       2
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_SPI1_RX  0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_SPI1_TX       0x00000008U
#define SRT_NX50_dmac_sync_DIS_SYNC_SPI1_TX       3
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_SPI1_TX  0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_UART0_RX      0x00000010U
#define SRT_NX50_dmac_sync_DIS_SYNC_UART0_RX      4
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_UART0_RX 0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_UART0_TX      0x00000020U
#define SRT_NX50_dmac_sync_DIS_SYNC_UART0_TX      5
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_UART0_TX 0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_UART1_RX      0x00000040U
#define SRT_NX50_dmac_sync_DIS_SYNC_UART1_RX      6
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_UART1_RX 0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_UART1_TX      0x00000080U
#define SRT_NX50_dmac_sync_DIS_SYNC_UART1_TX      7
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_UART1_TX 0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_UART2_RX      0x00000100U
#define SRT_NX50_dmac_sync_DIS_SYNC_UART2_RX      8
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_UART2_RX 0x00000000U
#define MSK_NX50_dmac_sync_DIS_SYNC_UART2_TX      0x00000200U
#define SRT_NX50_dmac_sync_DIS_SYNC_UART2_TX      9
#define DFLT_VAL_NX50_dmac_sync_DIS_SYNC_UART2_TX 0x00000000U

enum {
	BFW_NX50_dmac_sync_DIS_SYNC_SPI0_RX  = 1,  /* [0] */
	BFW_NX50_dmac_sync_DIS_SYNC_SPI0_TX  = 1,  /* [1] */
	BFW_NX50_dmac_sync_DIS_SYNC_SPI1_RX  = 1,  /* [2] */
	BFW_NX50_dmac_sync_DIS_SYNC_SPI1_TX  = 1,  /* [3] */
	BFW_NX50_dmac_sync_DIS_SYNC_UART0_RX = 1,  /* [4] */
	BFW_NX50_dmac_sync_DIS_SYNC_UART0_TX = 1,  /* [5] */
	BFW_NX50_dmac_sync_DIS_SYNC_UART1_RX = 1,  /* [6] */
	BFW_NX50_dmac_sync_DIS_SYNC_UART1_TX = 1,  /* [7] */
	BFW_NX50_dmac_sync_DIS_SYNC_UART2_RX = 1,  /* [8] */
	BFW_NX50_dmac_sync_DIS_SYNC_UART2_TX = 1,  /* [9] */
	BFW_NX50_dmac_sync_reserved1         = 22  /* [31:10] */
};

typedef struct NX50_DMAC_SYNC_BIT_Ttag {
	unsigned int DIS_SYNC_SPI0_RX  : BFW_NX50_dmac_sync_DIS_SYNC_SPI0_RX;  /* disable sync register for SPI0 receive requests   */
	unsigned int DIS_SYNC_SPI0_TX  : BFW_NX50_dmac_sync_DIS_SYNC_SPI0_TX;  /* disable sync register for SPI0 transmit requests  */
	unsigned int DIS_SYNC_SPI1_RX  : BFW_NX50_dmac_sync_DIS_SYNC_SPI1_RX;  /* disable sync register for SPI1 receive requests   */
	unsigned int DIS_SYNC_SPI1_TX  : BFW_NX50_dmac_sync_DIS_SYNC_SPI1_TX;  /* disable sync register for SPI1 transmit requests  */
	unsigned int DIS_SYNC_UART0_RX : BFW_NX50_dmac_sync_DIS_SYNC_UART0_RX; /* disable sync register for UART0 receive requests  */
	unsigned int DIS_SYNC_UART0_TX : BFW_NX50_dmac_sync_DIS_SYNC_UART0_TX; /* disable sync register for UART0 transmit requests */
	unsigned int DIS_SYNC_UART1_RX : BFW_NX50_dmac_sync_DIS_SYNC_UART1_RX; /* disable sync register for UART1 receive requests  */
	unsigned int DIS_SYNC_UART1_TX : BFW_NX50_dmac_sync_DIS_SYNC_UART1_TX; /* disable sync register for UART1 transmit requests */
	unsigned int DIS_SYNC_UART2_RX : BFW_NX50_dmac_sync_DIS_SYNC_UART2_RX; /* disable sync register for UART2 receive requests  */
	unsigned int DIS_SYNC_UART2_TX : BFW_NX50_dmac_sync_DIS_SYNC_UART2_TX; /* disable sync register for UART2 transmit requests */
	unsigned int reserved1         : BFW_NX50_dmac_sync_reserved1;         /* reserved                                          */
} NX50_DMAC_SYNC_BIT_T;

typedef union {
	unsigned int         val;
	NX50_DMAC_SYNC_BIT_T bf;
} NX50_DMAC_SYNC_T;

/* --------------------------------------------------------------------- */
/* Register dmac_rng_ctrl */
/* => random number generation control register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_rng_ctrl      0x00000038U
#define Adr_NX50_dmac_reg_dmac_rng_ctrl 0x1C005838U
#define Adr_NX50_dmac_rng_ctrl          0x1C005838U
#define DFLT_VAL_NX50_dmac_rng_ctrl     0x00000000U

#define MSK_NX50_dmac_rng_ctrl_LOAD_SEED      0x00000001U
#define SRT_NX50_dmac_rng_ctrl_LOAD_SEED      0
#define DFLT_VAL_NX50_dmac_rng_ctrl_LOAD_SEED 0x00000000U

enum {
	BFW_NX50_dmac_rng_ctrl_LOAD_SEED = 1,  /* [0] */
	BFW_NX50_dmac_rng_ctrl_reserved1 = 31  /* [31:1] */
};

typedef struct NX50_DMAC_RNG_CTRL_BIT_Ttag {
	unsigned int LOAD_SEED : BFW_NX50_dmac_rng_ctrl_LOAD_SEED; /* reserved */
	unsigned int reserved1 : BFW_NX50_dmac_rng_ctrl_reserved1; /* reserved */
} NX50_DMAC_RNG_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DMAC_RNG_CTRL_BIT_T bf;
} NX50_DMAC_RNG_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register dmac_rng_seed */
/* => random number generation seed register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_rng_seed      0x0000003CU
#define Adr_NX50_dmac_reg_dmac_rng_seed 0x1C00583CU
#define Adr_NX50_dmac_rng_seed          0x1C00583CU
#define DFLT_VAL_NX50_dmac_rng_seed     0x00000000U

#define MSK_NX50_dmac_rng_seed_SEED      0xffffffffU
#define SRT_NX50_dmac_rng_seed_SEED      0
#define DFLT_VAL_NX50_dmac_rng_seed_SEED 0x00000000U

enum {
	BFW_NX50_dmac_rng_seed_SEED = 32  /* [31:0] */
};

typedef struct NX50_DMAC_RNG_SEED_BIT_Ttag {
	unsigned int SEED : BFW_NX50_dmac_rng_seed_SEED; /* reserved */
} NX50_DMAC_RNG_SEED_BIT_T;

typedef union {
	unsigned int             val;
	NX50_DMAC_RNG_SEED_BIT_T bf;
} NX50_DMAC_RNG_SEED_T;

/* --------------------------------------------------------------------- */
/* Register dmac_rng_num */
/* => random number generation data register */
/*    reset value 0x0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_dmac_rng_num      0x00000040U
#define Adr_NX50_dmac_reg_dmac_rng_num 0x1C005840U
#define Adr_NX50_dmac_rng_num          0x1C005840U
#define DFLT_VAL_NX50_dmac_rng_num     0x00000000U

#define MSK_NX50_dmac_rng_num_RNG_NUM      0xffffffffU
#define SRT_NX50_dmac_rng_num_RNG_NUM      0
#define DFLT_VAL_NX50_dmac_rng_num_RNG_NUM 0x00000000U

enum {
	BFW_NX50_dmac_rng_num_RNG_NUM = 32  /* [31:0] */
};

typedef struct NX50_DMAC_RNG_NUM_BIT_Ttag {
	unsigned int RNG_NUM : BFW_NX50_dmac_rng_num_RNG_NUM; /* reserved */
} NX50_DMAC_RNG_NUM_BIT_T;

typedef union {
	unsigned int            val;
	NX50_DMAC_RNG_NUM_BIT_T bf;
} NX50_DMAC_RNG_NUM_T;


/* ===================================================================== */

/* Area of usb_core */

/* ===================================================================== */

#define Addr_NX50_usb_core      0x1C020000U
#define NX50_NETX_USB_CORE_AREA 0x1C020000U

/* --------------------------------------------------------------------- */
/* Register ID */
/* => ID Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ID      0x00000000U
#define Adr_NX50_usb_core_ID 0x1C020000U
#define Adr_NX50_ID          0x1C020000U

/* --------------------------------------------------------------------- */
/* Register USB_CTRL */
/* => USB Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_USB_CTRL      0x00000004U
#define Adr_NX50_usb_core_USB_CTRL 0x1C020004U
#define Adr_NX50_USB_CTRL          0x1C020004U

/* --------------------------------------------------------------------- */
/* Register FRM_TIMER */
/* => Frame Timer Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_FRM_TIMER      0x00000008U
#define Adr_NX50_usb_core_FRM_TIMER 0x1C020008U
#define Adr_NX50_FRM_TIMER          0x1C020008U

/* --------------------------------------------------------------------- */
/* Register MAIN_EV */
/* => Main Event Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_MAIN_EV      0x0000000CU
#define Adr_NX50_usb_core_MAIN_EV 0x1C02000CU
#define Adr_NX50_MAIN_EV          0x1C02000CU

/* --------------------------------------------------------------------- */
/* Register MAIN_EM */
/* => Main Event Mask Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_MAIN_EM      0x00000010U
#define Adr_NX50_usb_core_MAIN_EM 0x1C020010U
#define Adr_NX50_MAIN_EM          0x1C020010U

/* --------------------------------------------------------------------- */
/* Register PIPE_EV */
/* => Pipe Event Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_EV      0x00000014U
#define Adr_NX50_usb_core_PIPE_EV 0x1C020014U
#define Adr_NX50_PIPE_EV          0x1C020014U

/* --------------------------------------------------------------------- */
/* Register PIPE_EM */
/* => Pipe Event Mask Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_EM      0x00000018U
#define Adr_NX50_usb_core_PIPE_EM 0x1C020018U
#define Adr_NX50_PIPE_EM          0x1C020018U

/* --------------------------------------------------------------------- */
/* Register PIPE_SEL */
/* => Pipe Select Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_SEL      0x00000024U
#define Adr_NX50_usb_core_PIPE_SEL 0x1C020024U
#define Adr_NX50_PIPE_SEL          0x1C020024U

/* --------------------------------------------------------------------- */
/* Register PORT_STAT */
/* => Port Statuus Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PORT_STAT      0x0000002CU
#define Adr_NX50_usb_core_PORT_STAT 0x1C02002CU
#define Adr_NX50_PORT_STAT          0x1C02002CU

/* --------------------------------------------------------------------- */
/* Register PORT_CTRL */
/* => Port Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PORT_CTRL      0x00000030U
#define Adr_NX50_usb_core_PORT_CTRL 0x1C020030U
#define Adr_NX50_PORT_CTRL          0x1C020030U

/* --------------------------------------------------------------------- */
/* Register PSC_EV */
/* => Port Status Change Event Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PSC_EV      0x00000034U
#define Adr_NX50_usb_core_PSC_EV 0x1C020034U
#define Adr_NX50_PSC_EV          0x1C020034U

/* --------------------------------------------------------------------- */
/* Register PSC_EM */
/* => Port Status Change Event Mask Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PSC_EM      0x00000038U
#define Adr_NX50_usb_core_PSC_EM 0x1C020038U
#define Adr_NX50_PSC_EM          0x1C020038U

/* --------------------------------------------------------------------- */
/* Register PIPE_CTRL */
/* => Pipe Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_CTRL      0x00000040U
#define Adr_NX50_usb_core_PIPE_CTRL 0x1C020040U
#define Adr_NX50_PIPE_CTRL          0x1C020040U

/* --------------------------------------------------------------------- */
/* Register PIPE_CFG */
/* => Pipe Configuration Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_CFG      0x00000044U
#define Adr_NX50_usb_core_PIPE_CFG 0x1C020044U
#define Adr_NX50_PIPE_CFG          0x1C020044U

/* --------------------------------------------------------------------- */
/* Register PIPE_ADDR */
/* => Pipe Address Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_ADDR      0x00000048U
#define Adr_NX50_usb_core_PIPE_ADDR 0x1C020048U
#define Adr_NX50_PIPE_ADDR          0x1C020048U

/* --------------------------------------------------------------------- */
/* Register PIPE_STAT */
/* => Pipe Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_STAT      0x0000004CU
#define Adr_NX50_usb_core_PIPE_STAT 0x1C02004CU
#define Adr_NX50_PIPE_STAT          0x1C02004CU

/* --------------------------------------------------------------------- */
/* Register PIPE_DATA_PTR */
/* => Pipe Data Pointer Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_DATA_PTR      0x00000050U
#define Adr_NX50_usb_core_PIPE_DATA_PTR 0x1C020050U
#define Adr_NX50_PIPE_DATA_PTR          0x1C020050U

/* --------------------------------------------------------------------- */
/* Register PIPE_DATA_TBYTES */
/* => Pipe Total Bytes Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_DATA_TBYTES      0x00000054U
#define Adr_NX50_usb_core_PIPE_DATA_TBYTES 0x1C020054U
#define Adr_NX50_PIPE_DATA_TBYTES          0x1C020054U

/* --------------------------------------------------------------------- */
/* Register PIPE_ADATA_PTR */
/* => Pipe Alternative Data Pointer Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_ADATA_PTR      0x00000058U
#define Adr_NX50_usb_core_PIPE_ADATA_PTR 0x1C020058U
#define Adr_NX50_PIPE_ADATA_PTR          0x1C020058U

/* --------------------------------------------------------------------- */
/* Register PIPE_ADATA_TBYTES */
/* => Pipe Altenative Data Total Bytes Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_PIPE_ADATA_TBYTES      0x0000005CU
#define Adr_NX50_usb_core_PIPE_ADATA_TBYTES 0x1C02005CU
#define Adr_NX50_PIPE_ADATA_TBYTES          0x1C02005CU

/* --------------------------------------------------------------------- */
/* Register DEBUG_CTRL */
/* => Debug Control Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_DEBUG_CTRL      0x00000060U
#define Adr_NX50_usb_core_DEBUG_CTRL 0x1C020060U
#define Adr_NX50_DEBUG_CTRL          0x1C020060U

/* --------------------------------------------------------------------- */
/* Register DEBUG_PID */
/* => Debug PID Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_DEBUG_PID      0x00000064U
#define Adr_NX50_usb_core_DEBUG_PID 0x1C020064U
#define Adr_NX50_DEBUG_PID          0x1C020064U

/* --------------------------------------------------------------------- */
/* Register DEBUG_STAT */
/* => Debug Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_DEBUG_STAT      0x00000068U
#define Adr_NX50_usb_core_DEBUG_STAT 0x1C020068U
#define Adr_NX50_DEBUG_STAT          0x1C020068U

/* --------------------------------------------------------------------- */
/* Register TEST */
/* => Test Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_TEST      0x0000006CU
#define Adr_NX50_usb_core_TEST 0x1C02006CU
#define Adr_NX50_TEST          0x1C02006CU

/* --------------------------------------------------------------------- */
/* Register MAIN_CFG */
/* => Main Configuration Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_MAIN_CFG      0x00000080U
#define Adr_NX50_usb_core_MAIN_CFG 0x1C020080U
#define Adr_NX50_MAIN_CFG          0x1C020080U

/* --------------------------------------------------------------------- */
/* Register MODE_CFG */
/* => Mode Configuration Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_MODE_CFG      0x00000084U
#define Adr_NX50_usb_core_MODE_CFG 0x1C020084U
#define Adr_NX50_MODE_CFG          0x1C020084U

/* --------------------------------------------------------------------- */
/* Register usb_core_ctrl */
/* => USB core control and status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_usb_core_ctrl      0x00000088U
#define Adr_NX50_usb_core_usb_core_ctrl 0x1C020088U
#define Adr_NX50_usb_core_ctrl          0x1C020088U
#define DFLT_VAL_NX50_usb_core_ctrl     0x0086b000U

#define MSK_NX50_usb_core_ctrl_reset                   0x00000001U
#define SRT_NX50_usb_core_ctrl_reset                   0
#define DFLT_VAL_NX50_usb_core_ctrl_reset              0x00000000U
#define MSK_NX50_usb_core_ctrl_dbg_support             0x00000002U
#define SRT_NX50_usb_core_ctrl_dbg_support             1
#define DFLT_VAL_NX50_usb_core_ctrl_dbg_support        0x00000000U
#define MSK_NX50_usb_core_ctrl_xtd_dbg_support         0x00000004U
#define SRT_NX50_usb_core_ctrl_xtd_dbg_support         2
#define DFLT_VAL_NX50_usb_core_ctrl_xtd_dbg_support    0x00000000U
#define MSK_NX50_usb_core_ctrl_soft_id_dig             0x00000008U
#define SRT_NX50_usb_core_ctrl_soft_id_dig             3
#define DFLT_VAL_NX50_usb_core_ctrl_soft_id_dig        0x00000000U
#define MSK_NX50_usb_core_ctrl_alt_buffer_support      0x00000ff0U
#define SRT_NX50_usb_core_ctrl_alt_buffer_support      4
#define DFLT_VAL_NX50_usb_core_ctrl_alt_buffer_support 0x00000000U
#define MSK_NX50_usb_core_ctrl_core_suspend_n          0x00001000U
#define SRT_NX50_usb_core_ctrl_core_suspend_n          12
#define DFLT_VAL_NX50_usb_core_ctrl_core_suspend_n     0x00001000U
#define MSK_NX50_usb_core_ctrl_xcvr_suspend_n          0x00002000U
#define SRT_NX50_usb_core_ctrl_xcvr_suspend_n          13
#define DFLT_VAL_NX50_usb_core_ctrl_xcvr_suspend_n     0x00002000U
#define MSK_NX50_usb_core_ctrl_over_current            0x00004000U
#define SRT_NX50_usb_core_ctrl_over_current            14
#define DFLT_VAL_NX50_usb_core_ctrl_over_current       0x00000000U
#define MSK_NX50_usb_core_ctrl_va_sess_vld             0x00008000U
#define SRT_NX50_usb_core_ctrl_va_sess_vld             15
#define DFLT_VAL_NX50_usb_core_ctrl_va_sess_vld        0x00008000U
#define MSK_NX50_usb_core_ctrl_vb_sess_end             0x00010000U
#define SRT_NX50_usb_core_ctrl_vb_sess_end             16
#define DFLT_VAL_NX50_usb_core_ctrl_vb_sess_end        0x00000000U
#define MSK_NX50_usb_core_ctrl_vb_sess_vld             0x00020000U
#define SRT_NX50_usb_core_ctrl_vb_sess_vld             17
#define DFLT_VAL_NX50_usb_core_ctrl_vb_sess_vld        0x00020000U
#define MSK_NX50_usb_core_ctrl_vbus_vld                0x00040000U
#define SRT_NX50_usb_core_ctrl_vbus_vld                18
#define DFLT_VAL_NX50_usb_core_ctrl_vbus_vld           0x00040000U
#define MSK_NX50_usb_core_ctrl_chrg_vbus               0x00080000U
#define SRT_NX50_usb_core_ctrl_chrg_vbus               19
#define DFLT_VAL_NX50_usb_core_ctrl_chrg_vbus          0x00000000U
#define MSK_NX50_usb_core_ctrl_dlp_active              0x00100000U
#define SRT_NX50_usb_core_ctrl_dlp_active              20
#define DFLT_VAL_NX50_usb_core_ctrl_dlp_active         0x00000000U
#define MSK_NX50_usb_core_ctrl_vb_on                   0x00200000U
#define SRT_NX50_usb_core_ctrl_vb_on                   21
#define DFLT_VAL_NX50_usb_core_ctrl_vb_on              0x00000000U
#define MSK_NX50_usb_core_ctrl_dischrg_vbus            0x00400000U
#define SRT_NX50_usb_core_ctrl_dischrg_vbus            22
#define DFLT_VAL_NX50_usb_core_ctrl_dischrg_vbus       0x00000000U
#define MSK_NX50_usb_core_ctrl_ucif_rdy                0x00800000U
#define SRT_NX50_usb_core_ctrl_ucif_rdy                23
#define DFLT_VAL_NX50_usb_core_ctrl_ucif_rdy           0x00800000U
#define MSK_NX50_usb_core_ctrl_usb_irq                 0x01000000U
#define SRT_NX50_usb_core_ctrl_usb_irq                 24
#define DFLT_VAL_NX50_usb_core_ctrl_usb_irq            0x00000000U

enum {
	BFW_NX50_usb_core_ctrl_reset              = 1, /* [0] */
	BFW_NX50_usb_core_ctrl_dbg_support        = 1, /* [1] */
	BFW_NX50_usb_core_ctrl_xtd_dbg_support    = 1, /* [2] */
	BFW_NX50_usb_core_ctrl_soft_id_dig        = 1, /* [3] */
	BFW_NX50_usb_core_ctrl_alt_buffer_support = 8, /* [11:4] */
	BFW_NX50_usb_core_ctrl_core_suspend_n     = 1, /* [12] */
	BFW_NX50_usb_core_ctrl_xcvr_suspend_n     = 1, /* [13] */
	BFW_NX50_usb_core_ctrl_over_current       = 1, /* [14] */
	BFW_NX50_usb_core_ctrl_va_sess_vld        = 1, /* [15] */
	BFW_NX50_usb_core_ctrl_vb_sess_end        = 1, /* [16] */
	BFW_NX50_usb_core_ctrl_vb_sess_vld        = 1, /* [17] */
	BFW_NX50_usb_core_ctrl_vbus_vld           = 1, /* [18] */
	BFW_NX50_usb_core_ctrl_chrg_vbus          = 1, /* [19] */
	BFW_NX50_usb_core_ctrl_dlp_active         = 1, /* [20] */
	BFW_NX50_usb_core_ctrl_vb_on              = 1, /* [21] */
	BFW_NX50_usb_core_ctrl_dischrg_vbus       = 1, /* [22] */
	BFW_NX50_usb_core_ctrl_ucif_rdy           = 1, /* [23] */
	BFW_NX50_usb_core_ctrl_usb_irq            = 1, /* [24] */
	BFW_NX50_usb_core_ctrl_reserved1          = 7  /* [31:25] */
};

typedef struct NX50_USB_CORE_CTRL_BIT_Ttag {
	unsigned int reset              : BFW_NX50_usb_core_ctrl_reset;              /* software reset (r/w)                 */
	unsigned int dbg_support        : BFW_NX50_usb_core_ctrl_dbg_support;        /* enables debug support (r/w)          */
	unsigned int xtd_dbg_support    : BFW_NX50_usb_core_ctrl_xtd_dbg_support;    /* enables extended debug support (r/w) */
	unsigned int soft_id_dig        : BFW_NX50_usb_core_ctrl_soft_id_dig;        /* to set id_dig via software (r/w)     */
	unsigned int alt_buffer_support : BFW_NX50_usb_core_ctrl_alt_buffer_support; /* alt buffer support (r/w)             */
	unsigned int core_suspend_n     : BFW_NX50_usb_core_ctrl_core_suspend_n;     /* reflects core_suspend_n (ro)         */
	unsigned int xcvr_suspend_n     : BFW_NX50_usb_core_ctrl_xcvr_suspend_n;     /* reflects xcvr_suspend_n (ro)         */
	unsigned int over_current       : BFW_NX50_usb_core_ctrl_over_current;       /* reflects over_current (ro)           */
	unsigned int va_sess_vld        : BFW_NX50_usb_core_ctrl_va_sess_vld;        /* reflects va_sess_vld (ro)            */
	unsigned int vb_sess_end        : BFW_NX50_usb_core_ctrl_vb_sess_end;        /* reflects vb_sess_end (ro)            */
	unsigned int vb_sess_vld        : BFW_NX50_usb_core_ctrl_vb_sess_vld;        /* reflects vb_sess_vld (ro)            */
	unsigned int vbus_vld           : BFW_NX50_usb_core_ctrl_vbus_vld;           /* reflects vbus_vld (ro)               */
	unsigned int chrg_vbus          : BFW_NX50_usb_core_ctrl_chrg_vbus;          /* reflects chrg_vbus (ro)              */
	unsigned int dlp_active         : BFW_NX50_usb_core_ctrl_dlp_active;         /* reflects dlp_active (ro)             */
	unsigned int vb_on              : BFW_NX50_usb_core_ctrl_vb_on;              /* reflects vb_on (ro)                  */
	unsigned int dischrg_vbus       : BFW_NX50_usb_core_ctrl_dischrg_vbus;       /* reflects dischrg_vbus (ro)           */
	unsigned int ucif_rdy           : BFW_NX50_usb_core_ctrl_ucif_rdy;           /* reflects ucif_rdy (ro)               */
	unsigned int usb_irq            : BFW_NX50_usb_core_ctrl_usb_irq;            /* reflects usb_irq (ro)                */
	unsigned int reserved1          : BFW_NX50_usb_core_ctrl_reserved1;          /* reserved                             */
} NX50_USB_CORE_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX50_USB_CORE_CTRL_BIT_T bf;
} NX50_USB_CORE_CTRL_T;


/* ===================================================================== */

/* Area of usb_fifo */

/* ===================================================================== */

#define Addr_NX50_usb_fifo      0x1C030000U
#define NX50_NETX_USB_FIFO_AREA 0x1C030000U

/* --------------------------------------------------------------------- */
/* Register USB_FIFO_BASE */
/* => USB End Point 0 (IN) Base Address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_USB_FIFO_BASE      0x00000000U
#define Adr_NX50_usb_fifo_USB_FIFO_BASE 0x1C030000U
#define Adr_NX50_USB_FIFO_BASE          0x1C030000U


/* ===================================================================== */

/* Area of xc */

/* ===================================================================== */

#define Addr_NX50_xc      0x1C040000U
#define NX50_NETX_XC_AREA 0x1C040000U

/* --------------------------------------------------------------------- */
/* Register xc_base */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xc_base 0x00000000U
#define Adr_NX50_xc_xc_base  0x1C040000U
#define Adr_NX50_xc_base     0x1C040000U


/* ===================================================================== */

/* AREA xpec */
/* Area of xpec0, xpec1 */

/* ===================================================================== */

#define Addr_NX50_xpec0    0x1C040000U
#define NX50_NETX_XP0_BASE 0x1C040000U
#define Addr_NX50_xpec1    0x1C048000U
#define NX50_NETX_XP1_BASE 0x1C048000U

/* --------------------------------------------------------------------- */
/* Register xpec_r0 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r0   0x00000000U
#define Adr_NX50_xpec0_xpec_r0 0x1C040000U
#define Adr_NX50_xpec1_xpec_r0 0x1C048000U
#define DFLT_VAL_NX50_xpec_r0  0x00000000U

#define MSK_NX50_xpec_r0_r0      0xffffffffU
#define SRT_NX50_xpec_r0_r0      0
#define DFLT_VAL_NX50_xpec_r0_r0 0x00000000U

enum {
	BFW_NX50_xpec_r0_r0 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R0_BIT_Ttag {
	unsigned int r0 : BFW_NX50_xpec_r0_r0; /* Work Register 0 */
} NX50_XPEC_R0_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R0_BIT_T bf;
} NX50_XPEC_R0_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r1 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r1   0x00000004U
#define Adr_NX50_xpec0_xpec_r1 0x1C040004U
#define Adr_NX50_xpec1_xpec_r1 0x1C048004U
#define DFLT_VAL_NX50_xpec_r1  0x00000000U

#define MSK_NX50_xpec_r1_r1      0xffffffffU
#define SRT_NX50_xpec_r1_r1      0
#define DFLT_VAL_NX50_xpec_r1_r1 0x00000000U

enum {
	BFW_NX50_xpec_r1_r1 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R1_BIT_Ttag {
	unsigned int r1 : BFW_NX50_xpec_r1_r1; /* Work Register 1 */
} NX50_XPEC_R1_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R1_BIT_T bf;
} NX50_XPEC_R1_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r2 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r2   0x00000008U
#define Adr_NX50_xpec0_xpec_r2 0x1C040008U
#define Adr_NX50_xpec1_xpec_r2 0x1C048008U
#define DFLT_VAL_NX50_xpec_r2  0x00000000U

#define MSK_NX50_xpec_r2_r2      0xffffffffU
#define SRT_NX50_xpec_r2_r2      0
#define DFLT_VAL_NX50_xpec_r2_r2 0x00000000U

enum {
	BFW_NX50_xpec_r2_r2 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R2_BIT_Ttag {
	unsigned int r2 : BFW_NX50_xpec_r2_r2; /* Work Register 2 */
} NX50_XPEC_R2_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R2_BIT_T bf;
} NX50_XPEC_R2_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r3 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r3   0x0000000CU
#define Adr_NX50_xpec0_xpec_r3 0x1C04000CU
#define Adr_NX50_xpec1_xpec_r3 0x1C04800CU
#define DFLT_VAL_NX50_xpec_r3  0x00000000U

#define MSK_NX50_xpec_r3_r3      0xffffffffU
#define SRT_NX50_xpec_r3_r3      0
#define DFLT_VAL_NX50_xpec_r3_r3 0x00000000U

enum {
	BFW_NX50_xpec_r3_r3 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R3_BIT_Ttag {
	unsigned int r3 : BFW_NX50_xpec_r3_r3; /* Work Register 3 */
} NX50_XPEC_R3_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R3_BIT_T bf;
} NX50_XPEC_R3_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r4 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r4   0x00000010U
#define Adr_NX50_xpec0_xpec_r4 0x1C040010U
#define Adr_NX50_xpec1_xpec_r4 0x1C048010U
#define DFLT_VAL_NX50_xpec_r4  0x00000000U

#define MSK_NX50_xpec_r4_r4      0xffffffffU
#define SRT_NX50_xpec_r4_r4      0
#define DFLT_VAL_NX50_xpec_r4_r4 0x00000000U

enum {
	BFW_NX50_xpec_r4_r4 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R4_BIT_Ttag {
	unsigned int r4 : BFW_NX50_xpec_r4_r4; /* Work Register 4 */
} NX50_XPEC_R4_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R4_BIT_T bf;
} NX50_XPEC_R4_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r5 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r5   0x00000014U
#define Adr_NX50_xpec0_xpec_r5 0x1C040014U
#define Adr_NX50_xpec1_xpec_r5 0x1C048014U
#define DFLT_VAL_NX50_xpec_r5  0x00000000U

#define MSK_NX50_xpec_r5_r5      0xffffffffU
#define SRT_NX50_xpec_r5_r5      0
#define DFLT_VAL_NX50_xpec_r5_r5 0x00000000U

enum {
	BFW_NX50_xpec_r5_r5 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R5_BIT_Ttag {
	unsigned int r5 : BFW_NX50_xpec_r5_r5; /* Work Register 5 */
} NX50_XPEC_R5_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R5_BIT_T bf;
} NX50_XPEC_R5_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r6 */
/* => xPEC work register for indirect addressing */
/*    Shared in xPEC fmmusm mode with fmmusm_read_addr_in (w mode). */
/*    Shared in xPEC fmmusm mode with sm_read_addr_out (r mode). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r6   0x00000018U
#define Adr_NX50_xpec0_xpec_r6 0x1C040018U
#define Adr_NX50_xpec1_xpec_r6 0x1C048018U
#define DFLT_VAL_NX50_xpec_r6  0x00000000U

#define MSK_NX50_xpec_r6_r6      0xffffffffU
#define SRT_NX50_xpec_r6_r6      0
#define DFLT_VAL_NX50_xpec_r6_r6 0x00000000U

enum {
	BFW_NX50_xpec_r6_r6 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R6_BIT_Ttag {
	unsigned int r6 : BFW_NX50_xpec_r6_r6; /* Work Register 6 */
} NX50_XPEC_R6_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R6_BIT_T bf;
} NX50_XPEC_R6_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r7 */
/* => xPEC work register for indirect addressing */
/*    Shared in xPEC fmmusm mode with fmmusm_write_addr_in (w mode). */
/*    Shared in xPEC fmmusm mode with sm_write_addr_out (r mode). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_r7   0x0000001CU
#define Adr_NX50_xpec0_xpec_r7 0x1C04001CU
#define Adr_NX50_xpec1_xpec_r7 0x1C04801CU
#define DFLT_VAL_NX50_xpec_r7  0x00000000U

#define MSK_NX50_xpec_r7_r7      0xffffffffU
#define SRT_NX50_xpec_r7_r7      0
#define DFLT_VAL_NX50_xpec_r7_r7 0x00000000U

enum {
	BFW_NX50_xpec_r7_r7 = 32  /* [31:0] */
};

typedef struct NX50_XPEC_R7_BIT_Ttag {
	unsigned int r7 : BFW_NX50_xpec_r7_r7; /* Work Register 7 */
} NX50_XPEC_R7_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_R7_BIT_T bf;
} NX50_XPEC_R7_T;

/* --------------------------------------------------------------------- */
/* Register range01 */
/* => xPEC Overflow Underflow register to limit stack and fifo buffer. */
/*    Generates range bits inside xPEC status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_range01   0x00000020U
#define Adr_NX50_xpec0_range01 0x1C040020U
#define Adr_NX50_xpec1_range01 0x1C048020U
#define DFLT_VAL_NX50_range01  0x00000000U

#define MSK_NX50_range01_range0       0x00001fffU
#define SRT_NX50_range01_range0       0
#define DFLT_VAL_NX50_range01_range0  0x00000000U
#define MSK_NX50_range01_bigger0      0x00002000U
#define SRT_NX50_range01_bigger0      13
#define DFLT_VAL_NX50_range01_bigger0 0x00000000U
#define MSK_NX50_range01_range1       0x1fff0000U
#define SRT_NX50_range01_range1       16
#define DFLT_VAL_NX50_range01_range1  0x00000000U
#define MSK_NX50_range01_bigger1      0x20000000U
#define SRT_NX50_range01_bigger1      29
#define DFLT_VAL_NX50_range01_bigger1 0x00000000U

enum {
	BFW_NX50_range01_range0    = 13, /* [12:0] */
	BFW_NX50_range01_bigger0   = 1,  /* [13] */
	BFW_NX50_range01_reserved1 = 2,  /* [15:14] */
	BFW_NX50_range01_range1    = 13, /* [28:16] */
	BFW_NX50_range01_bigger1   = 1,  /* [29] */
	BFW_NX50_range01_reserved2 = 2   /* [31:30] */
};

typedef struct NX50_RANGE01_BIT_Ttag {
	unsigned int range0    : BFW_NX50_range01_range0;    /* border for xpec_r0                                                                          */
	unsigned int bigger0   : BFW_NX50_range01_bigger0;   /* 0: generate range status bit, if r0 < range0; 1: generate range status bit, if r0 >= range0 */
	unsigned int reserved1 : BFW_NX50_range01_reserved1; /* reserved                                                                                    */
	unsigned int range1    : BFW_NX50_range01_range1;    /* border for xpec_r1                                                                          */
	unsigned int bigger1   : BFW_NX50_range01_bigger1;   /* 0: generate range status bit, if r1 < range1; 1: generate range status bit, if r1 >= range1 */
	unsigned int reserved2 : BFW_NX50_range01_reserved2; /* reserved                                                                                    */
} NX50_RANGE01_BIT_T;

typedef union {
	unsigned int       val;
	NX50_RANGE01_BIT_T bf;
} NX50_RANGE01_T;

/* --------------------------------------------------------------------- */
/* Register range23 */
/* => xPEC Overflow Underflow register to limit stack and fifo buffer. */
/*    Generates range bits inside xPEC status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_range23   0x00000024U
#define Adr_NX50_xpec0_range23 0x1C040024U
#define Adr_NX50_xpec1_range23 0x1C048024U
#define DFLT_VAL_NX50_range23  0x00000000U

#define MSK_NX50_range23_range2       0x00001fffU
#define SRT_NX50_range23_range2       0
#define DFLT_VAL_NX50_range23_range2  0x00000000U
#define MSK_NX50_range23_bigger2      0x00002000U
#define SRT_NX50_range23_bigger2      13
#define DFLT_VAL_NX50_range23_bigger2 0x00000000U
#define MSK_NX50_range23_range3       0x1fff0000U
#define SRT_NX50_range23_range3       16
#define DFLT_VAL_NX50_range23_range3  0x00000000U
#define MSK_NX50_range23_bigger3      0x20000000U
#define SRT_NX50_range23_bigger3      29
#define DFLT_VAL_NX50_range23_bigger3 0x00000000U

enum {
	BFW_NX50_range23_range2    = 13, /* [12:0] */
	BFW_NX50_range23_bigger2   = 1,  /* [13] */
	BFW_NX50_range23_reserved1 = 2,  /* [15:14] */
	BFW_NX50_range23_range3    = 13, /* [28:16] */
	BFW_NX50_range23_bigger3   = 1,  /* [29] */
	BFW_NX50_range23_reserved2 = 2   /* [31:30] */
};

typedef struct NX50_RANGE23_BIT_Ttag {
	unsigned int range2    : BFW_NX50_range23_range2;    /* border for xpec_r2                                                                          */
	unsigned int bigger2   : BFW_NX50_range23_bigger2;   /* 0: generate range status bit, if r2 < range2; 1: generate range status bit, if r2 >= range2 */
	unsigned int reserved1 : BFW_NX50_range23_reserved1; /* reserved                                                                                    */
	unsigned int range3    : BFW_NX50_range23_range3;    /* border for xpec_r3                                                                          */
	unsigned int bigger3   : BFW_NX50_range23_bigger3;   /* 0: generate range status bit, if r3 < range3; 1: generate range status bit, if r3 >= range3 */
	unsigned int reserved2 : BFW_NX50_range23_reserved2; /* reserved                                                                                    */
} NX50_RANGE23_BIT_T;

typedef union {
	unsigned int       val;
	NX50_RANGE23_BIT_T bf;
} NX50_RANGE23_T;

/* --------------------------------------------------------------------- */
/* Register range45 */
/* => xPEC Overflow Underflow register to limit stack and fifo buffer. */
/*    Generates range bits inside xPEC status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_range45   0x00000028U
#define Adr_NX50_xpec0_range45 0x1C040028U
#define Adr_NX50_xpec1_range45 0x1C048028U
#define DFLT_VAL_NX50_range45  0x00000000U

#define MSK_NX50_range45_range4       0x00001fffU
#define SRT_NX50_range45_range4       0
#define DFLT_VAL_NX50_range45_range4  0x00000000U
#define MSK_NX50_range45_bigger4      0x00002000U
#define SRT_NX50_range45_bigger4      13
#define DFLT_VAL_NX50_range45_bigger4 0x00000000U
#define MSK_NX50_range45_range5       0x1fff0000U
#define SRT_NX50_range45_range5       16
#define DFLT_VAL_NX50_range45_range5  0x00000000U
#define MSK_NX50_range45_bigger5      0x20000000U
#define SRT_NX50_range45_bigger5      29
#define DFLT_VAL_NX50_range45_bigger5 0x00000000U

enum {
	BFW_NX50_range45_range4    = 13, /* [12:0] */
	BFW_NX50_range45_bigger4   = 1,  /* [13] */
	BFW_NX50_range45_reserved1 = 2,  /* [15:14] */
	BFW_NX50_range45_range5    = 13, /* [28:16] */
	BFW_NX50_range45_bigger5   = 1,  /* [29] */
	BFW_NX50_range45_reserved2 = 2   /* [31:30] */
};

typedef struct NX50_RANGE45_BIT_Ttag {
	unsigned int range4    : BFW_NX50_range45_range4;    /* border for xpec_r4                                                                          */
	unsigned int bigger4   : BFW_NX50_range45_bigger4;   /* 0: generate range status bit, if r4 < range4; 1: generate range status bit, if r4 >= range4 */
	unsigned int reserved1 : BFW_NX50_range45_reserved1; /* reserved                                                                                    */
	unsigned int range5    : BFW_NX50_range45_range5;    /* border for xpec_r5                                                                          */
	unsigned int bigger5   : BFW_NX50_range45_bigger5;   /* 0: generate range status bit, if r5 < range5; 1: generate range status bit, if r5 >= range5 */
	unsigned int reserved2 : BFW_NX50_range45_reserved2; /* reserved                                                                                    */
} NX50_RANGE45_BIT_T;

typedef union {
	unsigned int       val;
	NX50_RANGE45_BIT_T bf;
} NX50_RANGE45_T;

/* --------------------------------------------------------------------- */
/* Register range67 */
/* => xPEC Overflow Underflow register to limit stack and fifo buffer. */
/*    Generates range bits inside xPEC status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_range67   0x0000002CU
#define Adr_NX50_xpec0_range67 0x1C04002CU
#define Adr_NX50_xpec1_range67 0x1C04802CU
#define DFLT_VAL_NX50_range67  0x00000000U

#define MSK_NX50_range67_range6       0x00001fffU
#define SRT_NX50_range67_range6       0
#define DFLT_VAL_NX50_range67_range6  0x00000000U
#define MSK_NX50_range67_bigger6      0x00002000U
#define SRT_NX50_range67_bigger6      13
#define DFLT_VAL_NX50_range67_bigger6 0x00000000U
#define MSK_NX50_range67_range7       0x1fff0000U
#define SRT_NX50_range67_range7       16
#define DFLT_VAL_NX50_range67_range7  0x00000000U
#define MSK_NX50_range67_bigger7      0x20000000U
#define SRT_NX50_range67_bigger7      29
#define DFLT_VAL_NX50_range67_bigger7 0x00000000U

enum {
	BFW_NX50_range67_range6    = 13, /* [12:0] */
	BFW_NX50_range67_bigger6   = 1,  /* [13] */
	BFW_NX50_range67_reserved1 = 2,  /* [15:14] */
	BFW_NX50_range67_range7    = 13, /* [28:16] */
	BFW_NX50_range67_bigger7   = 1,  /* [29] */
	BFW_NX50_range67_reserved2 = 2   /* [31:30] */
};

typedef struct NX50_RANGE67_BIT_Ttag {
	unsigned int range6    : BFW_NX50_range67_range6;    /* border for xpec_r6                                                                          */
	unsigned int bigger6   : BFW_NX50_range67_bigger6;   /* 0: generate range status bit, if r6 < range6; 1: generate range status bit, if r6 >= range6 */
	unsigned int reserved1 : BFW_NX50_range67_reserved1; /* reserved                                                                                    */
	unsigned int range7    : BFW_NX50_range67_range7;    /* border for xpec_r7                                                                          */
	unsigned int bigger7   : BFW_NX50_range67_bigger7;   /* 0: generate range status bit, if r7 < range7; 1: generate range status bit, if r7 >= range7 */
	unsigned int reserved2 : BFW_NX50_range67_reserved2; /* reserved                                                                                    */
} NX50_RANGE67_BIT_T;

typedef union {
	unsigned int       val;
	NX50_RANGE67_BIT_T bf;
} NX50_RANGE67_T;

/* --------------------------------------------------------------------- */
/* Register timer0 */
/* => xPEC Timer 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_timer0   0x00000030U
#define Adr_NX50_xpec0_timer0 0x1C040030U
#define Adr_NX50_xpec1_timer0 0x1C048030U
#define DFLT_VAL_NX50_timer0  0x00000000U

#define MSK_NX50_timer0_preload0      0xffffffffU
#define SRT_NX50_timer0_preload0      0
#define DFLT_VAL_NX50_timer0_preload0 0x00000000U

enum {
	BFW_NX50_timer0_preload0 = 32  /* [31:0] */
};

typedef struct NX50_TIMER0_BIT_Ttag {
	unsigned int preload0 : BFW_NX50_timer0_preload0; /* read: actual value of timer, write: timer and preload value */
} NX50_TIMER0_BIT_T;

typedef union {
	unsigned int      val;
	NX50_TIMER0_BIT_T bf;
} NX50_TIMER0_T;

/* --------------------------------------------------------------------- */
/* Register timer1 */
/* => xPEC Timer 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_timer1   0x00000034U
#define Adr_NX50_xpec0_timer1 0x1C040034U
#define Adr_NX50_xpec1_timer1 0x1C048034U
#define DFLT_VAL_NX50_timer1  0x00000000U

#define MSK_NX50_timer1_preload1      0xffffffffU
#define SRT_NX50_timer1_preload1      0
#define DFLT_VAL_NX50_timer1_preload1 0x00000000U

enum {
	BFW_NX50_timer1_preload1 = 32  /* [31:0] */
};

typedef struct NX50_TIMER1_BIT_Ttag {
	unsigned int preload1 : BFW_NX50_timer1_preload1; /* read: actual value of timer, write: timer and preload value */
} NX50_TIMER1_BIT_T;

typedef union {
	unsigned int      val;
	NX50_TIMER1_BIT_T bf;
} NX50_TIMER1_T;

/* --------------------------------------------------------------------- */
/* Register timer2 */
/* => xPEC Timer 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_timer2   0x00000038U
#define Adr_NX50_xpec0_timer2 0x1C040038U
#define Adr_NX50_xpec1_timer2 0x1C048038U
#define DFLT_VAL_NX50_timer2  0x00000000U

#define MSK_NX50_timer2_preload2      0xffffffffU
#define SRT_NX50_timer2_preload2      0
#define DFLT_VAL_NX50_timer2_preload2 0x00000000U

enum {
	BFW_NX50_timer2_preload2 = 32  /* [31:0] */
};

typedef struct NX50_TIMER2_BIT_Ttag {
	unsigned int preload2 : BFW_NX50_timer2_preload2; /* read: actual value of timer, write: timer and preload value */
} NX50_TIMER2_BIT_T;

typedef union {
	unsigned int      val;
	NX50_TIMER2_BIT_T bf;
} NX50_TIMER2_T;

/* --------------------------------------------------------------------- */
/* Register timer3 */
/* => xPEC Timer 3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_timer3   0x0000003CU
#define Adr_NX50_xpec0_timer3 0x1C04003CU
#define Adr_NX50_xpec1_timer3 0x1C04803CU
#define DFLT_VAL_NX50_timer3  0x00000000U

#define MSK_NX50_timer3_preload3      0xffffffffU
#define SRT_NX50_timer3_preload3      0
#define DFLT_VAL_NX50_timer3_preload3 0x00000000U

enum {
	BFW_NX50_timer3_preload3 = 32  /* [31:0] */
};

typedef struct NX50_TIMER3_BIT_Ttag {
	unsigned int preload3 : BFW_NX50_timer3_preload3; /* read: actual value of timer, write: timer and preload value */
} NX50_TIMER3_BIT_T;

typedef union {
	unsigned int      val;
	NX50_TIMER3_BIT_T bf;
} NX50_TIMER3_T;

/* --------------------------------------------------------------------- */
/* Register urx_count */
/* => xPEC urx counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_urx_count   0x00000040U
#define Adr_NX50_xpec0_urx_count 0x1C040040U
#define Adr_NX50_xpec1_urx_count 0x1C048040U
#define DFLT_VAL_NX50_urx_count  0x00000000U

#define MSK_NX50_urx_count_urx_count      0xffffffffU
#define SRT_NX50_urx_count_urx_count      0
#define DFLT_VAL_NX50_urx_count_urx_count 0x00000000U

enum {
	BFW_NX50_urx_count_urx_count = 32  /* [31:0] */
};

typedef struct NX50_URX_COUNT_BIT_Ttag {
	unsigned int urx_count : BFW_NX50_urx_count_urx_count; /* counts up received bytes (accesses of xPEC to any URX FIFO) */
} NX50_URX_COUNT_BIT_T;

typedef union {
	unsigned int         val;
	NX50_URX_COUNT_BIT_T bf;
} NX50_URX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register utx_count */
/* => xPEC utx counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_utx_count   0x00000044U
#define Adr_NX50_xpec0_utx_count 0x1C040044U
#define Adr_NX50_xpec1_utx_count 0x1C048044U
#define DFLT_VAL_NX50_utx_count  0x00000000U

#define MSK_NX50_utx_count_utx_count      0xffffffffU
#define SRT_NX50_utx_count_utx_count      0
#define DFLT_VAL_NX50_utx_count_utx_count 0x00000000U

enum {
	BFW_NX50_utx_count_utx_count = 32  /* [31:0] */
};

typedef struct NX50_UTX_COUNT_BIT_Ttag {
	unsigned int utx_count : BFW_NX50_utx_count_utx_count; /* counts up transmitted bytes (accesses of xPEC to any UTX FIFO) */
} NX50_UTX_COUNT_BIT_T;

typedef union {
	unsigned int         val;
	NX50_UTX_COUNT_BIT_T bf;
} NX50_UTX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xpec_pc */
/* => xPEC Program Counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_pc   0x00000048U
#define Adr_NX50_xpec0_xpec_pc 0x1C040048U
#define Adr_NX50_xpec1_xpec_pc 0x1C048048U
#define DFLT_VAL_NX50_xpec_pc  0x000007ffU

#define MSK_NX50_xpec_pc_pc      0x000007ffU
#define SRT_NX50_xpec_pc_pc      0
#define DFLT_VAL_NX50_xpec_pc_pc 0x000007ffU

enum {
	BFW_NX50_xpec_pc_pc        = 11, /* [10:0] */
	BFW_NX50_xpec_pc_reserved1 = 21  /* [31:11] */
};

typedef struct NX50_XPEC_PC_BIT_Ttag {
	unsigned int pc        : BFW_NX50_xpec_pc_pc;        /* Program Counter (dword address inside DPRAM) */
	unsigned int reserved1 : BFW_NX50_xpec_pc_reserved1; /* reserved                                     */
} NX50_XPEC_PC_BIT_T;

typedef union {
	unsigned int       val;
	NX50_XPEC_PC_BIT_T bf;
} NX50_XPEC_PC_T;

/* --------------------------------------------------------------------- */
/* Register zero */
/* => Zero Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_zero   0x0000004CU
#define Adr_NX50_xpec0_zero 0x1C04004CU
#define Adr_NX50_xpec1_zero 0x1C04804CU
#define DFLT_VAL_NX50_zero  0x00000000U

#define MSK_NX50_zero_zero      0xffffffffU
#define SRT_NX50_zero_zero      0
#define DFLT_VAL_NX50_zero_zero 0x00000000U

enum {
	BFW_NX50_zero_zero = 32  /* [31:0] */
};

typedef struct NX50_ZERO_BIT_Ttag {
	unsigned int zero : BFW_NX50_zero_zero; /* Always Zero */
} NX50_ZERO_BIT_T;

typedef union {
	unsigned int    val;
	NX50_ZERO_BIT_T bf;
} NX50_ZERO_T;

/* --------------------------------------------------------------------- */
/* Register xpec_statcfg */
/* => xPEC Config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_xpec_statcfg   0x00000050U
#define Adr_NX50_xpec0_xpec_statcfg 0x1C040050U
#define Adr_NX50_xpec1_xpec_statcfg 0x1C048050U
#define DFLT_VAL_NX50_xpec_statcfg  0x00000000U

#define MSK_NX50_xpec_statcfg_timer0                  0x00000003U
#define SRT_NX50_xpec_statcfg_timer0                  0
#define DFLT_VAL_NX50_xpec_statcfg_timer0             0x00000000U
#define MSK_NX50_xpec_statcfg_timer1                  0x0000000cU
#define SRT_NX50_xpec_statcfg_timer1                  2
#define DFLT_VAL_NX50_xpec_statcfg_timer1             0x00000000U
#define MSK_NX50_xpec_statcfg_timer2                  0x00000030U
#define SRT_NX50_xpec_statcfg_timer2                  4
#define DFLT_VAL_NX50_xpec_statcfg_timer2             0x00000000U
#define MSK_NX50_xpec_statcfg_timer3                  0x000000c0U
#define SRT_NX50_xpec_statcfg_timer3                  6
#define DFLT_VAL_NX50_xpec_statcfg_timer3             0x00000000U
#define MSK_NX50_xpec_statcfg_timer4                  0x00000300U
#define SRT_NX50_xpec_statcfg_timer4                  8
#define DFLT_VAL_NX50_xpec_statcfg_timer4             0x00000000U
#define MSK_NX50_xpec_statcfg_timer5                  0x00000c00U
#define SRT_NX50_xpec_statcfg_timer5                  10
#define DFLT_VAL_NX50_xpec_statcfg_timer5             0x00000000U
#define MSK_NX50_xpec_statcfg_reset_req               0x00001000U
#define SRT_NX50_xpec_statcfg_reset_req               12
#define DFLT_VAL_NX50_xpec_statcfg_reset_req          0x00000000U
#define MSK_NX50_xpec_statcfg_reset_dis               0x00002000U
#define SRT_NX50_xpec_statcfg_reset_dis               13
#define DFLT_VAL_NX50_xpec_statcfg_reset_dis          0x00000000U
#define MSK_NX50_xpec_statcfg_debug_mode              0x00004000U
#define SRT_NX50_xpec_statcfg_debug_mode              14
#define DFLT_VAL_NX50_xpec_statcfg_debug_mode         0x00000000U
#define MSK_NX50_xpec_statcfg_register_mode           0x00030000U
#define SRT_NX50_xpec_statcfg_register_mode           16
#define DFLT_VAL_NX50_xpec_statcfg_register_mode      0x00000000U
#define MSK_NX50_xpec_statcfg_run_dma_controller      0x80000000U
#define SRT_NX50_xpec_statcfg_run_dma_controller      31
#define DFLT_VAL_NX50_xpec_statcfg_run_dma_controller 0x00000000U

enum {
	BFW_NX50_xpec_statcfg_timer0             = 2,  /* [1:0] */
	BFW_NX50_xpec_statcfg_timer1             = 2,  /* [3:2] */
	BFW_NX50_xpec_statcfg_timer2             = 2,  /* [5:4] */
	BFW_NX50_xpec_statcfg_timer3             = 2,  /* [7:6] */
	BFW_NX50_xpec_statcfg_timer4             = 2,  /* [9:8] */
	BFW_NX50_xpec_statcfg_timer5             = 2,  /* [11:10] */
	BFW_NX50_xpec_statcfg_reset_req          = 1,  /* [12] */
	BFW_NX50_xpec_statcfg_reset_dis          = 1,  /* [13] */
	BFW_NX50_xpec_statcfg_debug_mode         = 1,  /* [14] */
	BFW_NX50_xpec_statcfg_reserved1          = 1,  /* [15] */
	BFW_NX50_xpec_statcfg_register_mode      = 2,  /* [17:16] */
	BFW_NX50_xpec_statcfg_reserved2          = 13, /* [30:18] */
	BFW_NX50_xpec_statcfg_run_dma_controller = 1   /* [31] */
};

typedef struct NX50_XPEC_STATCFG_BIT_Ttag {
	unsigned int timer0             : BFW_NX50_xpec_statcfg_timer0;             /* Timer0                                                  */
	                                                                            /*       2'b00 : Timer stops at 0                          */
	unsigned int timer1             : BFW_NX50_xpec_statcfg_timer1;             /* Timer1                                                  */
	unsigned int timer2             : BFW_NX50_xpec_statcfg_timer2;             /* Timer2                                                  */
	unsigned int timer3             : BFW_NX50_xpec_statcfg_timer3;             /* Timer3                                                  */
	unsigned int timer4             : BFW_NX50_xpec_statcfg_timer4;             /* Timer4                                                  */
	unsigned int timer5             : BFW_NX50_xpec_statcfg_timer5;             /* Timer5                                                  */
	unsigned int reset_req          : BFW_NX50_xpec_statcfg_reset_req;          /* System Reset                                            */
	unsigned int reset_dis          : BFW_NX50_xpec_statcfg_reset_dis;          /* disable own Reset                                       */
	unsigned int debug_mode         : BFW_NX50_xpec_statcfg_debug_mode;         /* in this mode XPEC gets debug data form sr14 and sr15    */
	unsigned int reserved1          : BFW_NX50_xpec_statcfg_reserved1;          /* reserved                                                */
	unsigned int register_mode      : BFW_NX50_xpec_statcfg_register_mode;      /* Register Mode default 0                                 */
	                                                                            /*       2'b00 : normal mode (shared register and statcfg) */
	unsigned int reserved2          : BFW_NX50_xpec_statcfg_reserved2;          /* reserved                                                */
	unsigned int run_dma_controller : BFW_NX50_xpec_statcfg_run_dma_controller; /* 0: stop dma_controller, 1: start dma_controller         */
	                                                                            /* stop / start the polling                                */
} NX50_XPEC_STATCFG_BIT_T;

typedef union {
	unsigned int            val;
	NX50_XPEC_STATCFG_BIT_T bf;
} NX50_XPEC_STATCFG_T;

/* --------------------------------------------------------------------- */
/* Register ec_maska */
/* => JMP-Mask a */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ec_maska   0x00000054U
#define Adr_NX50_xpec0_ec_maska 0x1C040054U
#define Adr_NX50_xpec1_ec_maska 0x1C048054U
#define DFLT_VAL_NX50_ec_maska  0x0000ffffU

#define MSK_NX50_ec_maska_sel0                   0x000000ffU
#define SRT_NX50_ec_maska_sel0                   0
#define DFLT_VAL_NX50_ec_maska_sel0              0x000000ffU
#define MSK_NX50_ec_maska_sel1                   0x0000ff00U
#define SRT_NX50_ec_maska_sel1                   8
#define DFLT_VAL_NX50_ec_maska_sel1              0x0000ff00U
#define MSK_NX50_ec_maska_jmp_adr                0x07ff0000U
#define SRT_NX50_ec_maska_jmp_adr                16
#define DFLT_VAL_NX50_ec_maska_jmp_adr           0x00000000U
#define MSK_NX50_ec_maska_level_edge_event0      0x18000000U
#define SRT_NX50_ec_maska_level_edge_event0      27
#define DFLT_VAL_NX50_ec_maska_level_edge_event0 0x00000000U
#define MSK_NX50_ec_maska_level_edge_event1      0x60000000U
#define SRT_NX50_ec_maska_level_edge_event1      29
#define DFLT_VAL_NX50_ec_maska_level_edge_event1 0x00000000U
#define MSK_NX50_ec_maska_and_or                 0x80000000U
#define SRT_NX50_ec_maska_and_or                 31
#define DFLT_VAL_NX50_ec_maska_and_or            0x00000000U

enum {
	BFW_NX50_ec_maska_sel0              = 8,  /* [7:0] */
	BFW_NX50_ec_maska_sel1              = 8,  /* [15:8] */
	BFW_NX50_ec_maska_jmp_adr           = 11, /* [26:16] */
	BFW_NX50_ec_maska_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX50_ec_maska_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX50_ec_maska_and_or            = 1   /* [31] */
};

typedef struct NX50_EC_MASKA_BIT_Ttag {
	unsigned int sel0              : BFW_NX50_ec_maska_sel0;              /* Select of event 0:                               */
	                                                                      /*     0-15    : XMAC status reg 0 (statcfg0 16:31) */
	unsigned int sel1              : BFW_NX50_ec_maska_sel1;              /* Select of event 1                                */
	unsigned int jmp_adr           : BFW_NX50_ec_maska_jmp_adr;           /* jmp address (0-2047)                             */
	unsigned int level_edge_event0 : BFW_NX50_ec_maska_level_edge_event0; /* for event 0 : level / edge sensitive:            */
	                                                                      /*               2'b00 sensitve to 1 level          */
	unsigned int level_edge_event1 : BFW_NX50_ec_maska_level_edge_event1; /* for event 1 : level / edge sensitive:            */
	                                                                      /*               2'b00 sensitve to 1 level          */
	unsigned int and_or            : BFW_NX50_ec_maska_and_or;            /* and/or bit:                                      */
	                                                                      /* 0 - All bits of mask must fit with events,       */
} NX50_EC_MASKA_BIT_T;

typedef union {
	unsigned int        val;
	NX50_EC_MASKA_BIT_T bf;
} NX50_EC_MASKA_T;

/* --------------------------------------------------------------------- */
/* Register ec_maskb */
/* => JMP-Mask b */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ec_maskb   0x00000058U
#define Adr_NX50_xpec0_ec_maskb 0x1C040058U
#define Adr_NX50_xpec1_ec_maskb 0x1C048058U
#define DFLT_VAL_NX50_ec_maskb  0x0000ffffU

#define MSK_NX50_ec_maskb_sel0                   0x000000ffU
#define SRT_NX50_ec_maskb_sel0                   0
#define DFLT_VAL_NX50_ec_maskb_sel0              0x000000ffU
#define MSK_NX50_ec_maskb_sel1                   0x0000ff00U
#define SRT_NX50_ec_maskb_sel1                   8
#define DFLT_VAL_NX50_ec_maskb_sel1              0x0000ff00U
#define MSK_NX50_ec_maskb_jmp_adr                0x07ff0000U
#define SRT_NX50_ec_maskb_jmp_adr                16
#define DFLT_VAL_NX50_ec_maskb_jmp_adr           0x00000000U
#define MSK_NX50_ec_maskb_level_edge_event0      0x18000000U
#define SRT_NX50_ec_maskb_level_edge_event0      27
#define DFLT_VAL_NX50_ec_maskb_level_edge_event0 0x00000000U
#define MSK_NX50_ec_maskb_level_edge_event1      0x60000000U
#define SRT_NX50_ec_maskb_level_edge_event1      29
#define DFLT_VAL_NX50_ec_maskb_level_edge_event1 0x00000000U
#define MSK_NX50_ec_maskb_and_or                 0x80000000U
#define SRT_NX50_ec_maskb_and_or                 31
#define DFLT_VAL_NX50_ec_maskb_and_or            0x00000000U

enum {
	BFW_NX50_ec_maskb_sel0              = 8,  /* [7:0] */
	BFW_NX50_ec_maskb_sel1              = 8,  /* [15:8] */
	BFW_NX50_ec_maskb_jmp_adr           = 11, /* [26:16] */
	BFW_NX50_ec_maskb_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX50_ec_maskb_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX50_ec_maskb_and_or            = 1   /* [31] */
};

typedef struct NX50_EC_MASKB_BIT_Ttag {
	unsigned int sel0              : BFW_NX50_ec_maskb_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX50_ec_maskb_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX50_ec_maskb_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX50_ec_maskb_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX50_ec_maskb_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX50_ec_maskb_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX50_EC_MASKB_BIT_T;

typedef union {
	unsigned int        val;
	NX50_EC_MASKB_BIT_T bf;
} NX50_EC_MASKB_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask0 */
/* => JMP-Mask 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX50_ec_mask0   0x0000005CU
#defin